/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.database;

import com.nxp.tagxplorer.database.IDatabase;
import com.nxp.tagxplorer.database.UserRecord;
import com.nxp.tagxplorer.ndef.models.RecordsHistory;
import com.nxp.tagxplorer.utility.gson.GsonUtil;
import com.nxp.tagxplorer.utility.gson.IRecord;
import java.sql.SQLException;
import java.util.List;

public enum DBManager {
    INS;

    private IDatabase db;

    public void initialize(IDatabase database) throws SQLException {
        if (this.db == null) {
            this.db = database;
            this.db.initializeDatabase();
        }
    }

    public List<RecordsHistory> readAllRecords() throws SQLException {
        return this.db.readAllRecords();
    }

    public void insertRecord(IRecord record) throws SQLException {
        this.db.insertRecord(this.getRecordHistory(record));
    }

    public void insertRecord(UserRecord record) throws SQLException {
        this.db.insertUserRecord(record);
    }

    public void insertRecords(List<IRecord> records) throws SQLException {
        if (records == null || records.isEmpty()) {
            return;
        }
        for (IRecord record : records) {
            this.insertRecord(record);
        }
    }

    public void updateRecord(IRecord record) throws SQLException {
        this.db.updateRecord(this.getRecordHistory(record));
    }

    public void deleteRecord(int identifier) throws SQLException {
        this.db.deleteRecord(identifier);
    }

    public void truncateRecords() throws SQLException {
        this.db.truncateRecords();
    }

    public boolean isUserRegistered() throws SQLException {
        return this.db.isUserRegistered();
    }

    private RecordsHistory getRecordHistory(IRecord record) {
        String gsonRaw = GsonUtil.toGson(record);
        RecordsHistory history = new RecordsHistory();
        history.setRecordData(gsonRaw);
        history.setType(record.getType());
        history.setSize(record.getSize());
        history.setTimeStamp(System.currentTimeMillis());
        return history;
    }
}

