/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller.presenter;

import b.b;
import b.e;
import com.nxp.nfclib.ndef.NdefMessageWrapper;
import com.nxp.tagxplorer.controller.contract.IWriteNdefContract;
import com.nxp.tagxplorer.controller.view.BasePresenter;
import com.nxp.tagxplorer.database.DBManager;
import com.nxp.tagxplorer.ndef.models.ApplicationRecord;
import com.nxp.tagxplorer.ndef.models.BluetoothRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.ndef.models.TextRecord;
import com.nxp.tagxplorer.ndef.models.VCardRecord;
import com.nxp.tagxplorer.ndef.models.WifiRecord;
import com.nxp.tagxplorer.utility.HEXUtils;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.g;
import f.i;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import javafx.scene.control.Alert;
import t.c;
import t.d;

public class WriteNdefPresenter
extends BasePresenter<IWriteNdefContract.IScene>
implements e,
IWriteNdefContract.IPresenter {
    private static final c LOG = d.a(i.class.getSimpleName());

    protected b.d newServiceCall() {
        b.d service = new b.d();
        service.a(this);
        return service;
    }

    @Override
    public void writeNDEFRecord(IRecord iRecord) {
        try {
            DBManager.INS.insertRecord(iRecord);
        }
        catch (SQLException e2) {
            LOG.d("Error writing db write ndef record", e2);
        }
        this.newServiceCall().a(iRecord).a(2004);
    }

    @Override
    public void importNDEFMessage(File fileToRead) {
        new b().a(fileToRead).a(this).a(2002);
    }

    @Override
    public void exportNDEFContent(File fileToWrite, IRecord iRecord) {
        NdefMessageWrapper generateNDEFMessageFromIRecords = g.a(iRecord);
        new b().b(HEXUtils.convertByteArrayToString(generateNDEFMessageFromIRecords.toByteArray())).a(fileToWrite).a(this).a(2001);
    }

    @Override
    public void addMoreRecord() {
    }

    @Override
    public void onSuccess(int operationType, Object response) {
        if (this.getSceneT() != null) {
            if (operationType == 2004) {
                ((IWriteNdefContract.IScene)this.getSceneT()).onWriteNDEFSuccess();
            } else if (operationType == 2001) {
                ((IWriteNdefContract.IScene)this.getSceneT()).showExportSuccessfullMessage();
            } else if (operationType == 2002) {
                ((IWriteNdefContract.IScene)this.getSceneT()).showImportSuccessfullMessage((List)response);
            }
        }
    }

    @Override
    public void onFailed(int operationType) {
        if (this.getSceneT() != null) {
            if (operationType == 2004) {
                ((IWriteNdefContract.IScene)this.getSceneT()).onWriteNDEFFailure();
            } else if (operationType == 2001) {
                ((IWriteNdefContract.IScene)this.getSceneT()).showExportFailedMessage();
            } else if (operationType == 2002) {
                ((IWriteNdefContract.IScene)this.getSceneT()).showImportFailedMessage();
            }
        }
    }

    @Override
    public void onError(int operationType, Throwable e2) {
        if (this.getSceneT() != null) {
            if (operationType == 2004) {
                String errorMessage = e2.getMessage();
                if (errorMessage != null && (errorMessage.contains("Card is Write Restricted") || errorMessage.contains("is Locked") || errorMessage.contains("Requires Authentication"))) {
                    errorMessage = "Tag is write protected, cannot store NDEF message";
                }
                if (this.getSceneT() != null) {
                    ((IWriteNdefContract.IScene)this.getSceneT()).onError(errorMessage);
                }
            } else if (operationType == 2001) {
                ((IWriteNdefContract.IScene)this.getSceneT()).showExportErrorMessage();
            } else if (operationType == 2002) {
                ((IWriteNdefContract.IScene)this.getSceneT()).showImportErrorMessage();
            }
        }
    }

    @Override
    public String validateRecord(IRecord record) {
        switch (record.getType()) {
            case TEXT_RECORD: {
                TextRecord textRecord = (TextRecord)record;
                if (null != textRecord.getInputText() && !textRecord.getInputText().isEmpty()) break;
                TagXplorerUtility.createErrorAlert("Please enter valid data and proceed...");
                return "INVALID_RECORD";
            }
            case BLUETOOTH_RECORD: {
                BluetoothRecord bluetoothRecord = (BluetoothRecord)record;
                if (bluetoothRecord.getMacAddress() != null && !bluetoothRecord.getMacAddress().isEmpty()) break;
                TagXplorerUtility.createErrorAlert("Please enter valid data and proceed...");
                return "INVALID_RECORD";
            }
            case WIFI_RECORD: {
                WifiRecord wifiRecord = (WifiRecord)record;
                if (wifiRecord.getMacAddress() != null && !wifiRecord.getMacAddress().isEmpty()) break;
                TagXplorerUtility.createErrorAlert("Please enter valid data and proceed...");
                return "INVALID_RECORD";
            }
            case EMAIL_RECORD: {
                LinkRecord linkRecord = (LinkRecord)record;
                if (f.d.o(f.d.g(linkRecord.getInputUriString()))) break;
                TagXplorerUtility.createErrorAlert("Please enter valid email id");
                return "INVALID_RECORD";
            }
            case GEO_LOCATION: 
            case SMS_RECORD: 
            case TELEPHONE_RECORD: 
            case LINK_RECORD: {
                LinkRecord linkRecord = (LinkRecord)record;
                if (linkRecord.getInputUriString() == null || linkRecord.getInputUriString().isEmpty()) {
                    TagXplorerUtility.createErrorAlert("Please enter valid data and proceed...");
                    return "INVALID_RECORD";
                }
                if (f.d.a(linkRecord.getUri()) || f.d.f(linkRecord.getUri()) || !f.d.p(linkRecord.getInputUriString()) && !f.d.q(linkRecord.getInputUriString())) break;
                TagXplorerUtility.createAlert("Please enter valid URI", Alert.AlertType.ERROR, "Error");
                return "INVALID_RECORD";
            }
            case SMART_POSTER_RECORD: {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                String inputUriString = posterRecord.getLinkRecord().getInputUriString();
                if (posterRecord.getTextRecord() == null || inputUriString == null || inputUriString.isEmpty()) {
                    TagXplorerUtility.createErrorAlert("Please enter valid data and proceed...");
                    return "INVALID_RECORD";
                }
                if (!f.d.a(posterRecord.getLinkRecord().getUri()) && !f.d.f(posterRecord.getLinkRecord().getUri()) && (f.d.p(inputUriString) || f.d.q(inputUriString))) {
                    TagXplorerUtility.createErrorAlert("Please enter valid URI");
                    return "INVALID_RECORD";
                }
                if (!f.d.c(posterRecord.getLinkRecord().getUri()) || f.d.o(f.d.g(inputUriString))) break;
                TagXplorerUtility.createErrorAlert("Please enter valid email id");
                return "INVALID_RECORD";
            }
            case AAR_RECORD: {
                ApplicationRecord appRecord = (ApplicationRecord)record;
                if (appRecord.getPackageName() != null && !appRecord.getPackageName().isEmpty()) break;
                TagXplorerUtility.createErrorAlert("Please enter valid data and proceed...");
                return "INVALID_RECORD";
            }
            case VCARD_RECORD: {
                VCardRecord vcardRecord = (VCardRecord)record;
                if (!vcardRecord.getName().isEmpty() || !vcardRecord.getFullName().isEmpty() || !vcardRecord.getMobile().isEmpty() || !vcardRecord.getHomePhone().isEmpty() || !vcardRecord.getWorkPhone().isEmpty() || !vcardRecord.getVoiceMail().isEmpty() || !vcardRecord.getFax().isEmpty() || !vcardRecord.getHomeEmail().isEmpty() || !vcardRecord.getWorkEmail().isEmpty()) break;
                TagXplorerUtility.createErrorAlert("Please enter valid data and proceed...");
                return "INVALID_RECORD";
            }
            default: {
                return "Unknown record";
            }
        }
        return "VALID_RECORD";
    }

    @Override
    public void calculateNdefMessageSize(IRecord record) {
        if (record == null) {
            throw new IllegalArgumentException();
        }
        NdefMessageWrapper message = g.a(record);
        if (message != null) {
            NdefMessageWrapper response = message;
            ((IWriteNdefContract.IScene)this.getSceneT()).setMessageSize(String.valueOf(response.toByteArray().length));
        }
    }

    @Override
    public NDEFRecordType getActualRecordType(IRecord record) {
        return g.b(record);
    }
}

