/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller.presenter;

import b.d;
import b.e;
import com.nxp.tagxplorer.controller.contract.INTagOperationContract;
import com.nxp.tagxplorer.controller.view.BasePresenter;
import com.nxp.tagxplorer.database.DBManager;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.IRecord;
import java.sql.SQLException;
import javafx.scene.control.Alert;

public class NTagOperationPresenter
extends BasePresenter<INTagOperationContract.IScene>
implements e,
INTagOperationContract.IPresenter {
    @Override
    public void onSuccess(int operationType, Object response) {
        if (this.getSceneT() != null) {
            ((INTagOperationContract.IScene)this.getSceneT()).onSuccess();
        }
    }

    @Override
    public void onFailed(int operationType) {
        if (this.getSceneT() != null) {
            ((INTagOperationContract.IScene)this.getSceneT()).onFailure();
        }
    }

    @Override
    public void onError(int operationType, Throwable e2) {
        if (this.getSceneT() != null) {
            ((INTagOperationContract.IScene)this.getSceneT()).onError(e2.getMessage());
        }
    }

    @Override
    public String validateRecord(IRecord record) {
        switch (record.getType()) {
            case LINK_RECORD: {
                LinkRecord linkRecord = (LinkRecord)record;
                if (linkRecord.getInputUriString() == null || linkRecord.getInputUriString().isEmpty()) {
                    TagXplorerUtility.createAlert("Please enter valid data and proceed...", Alert.AlertType.ERROR, "Error");
                    return "INVALID_RECORD";
                }
                if (!f.d.p(linkRecord.getInputUriString()) && !f.d.q(linkRecord.getInputUriString())) break;
                TagXplorerUtility.createAlert("Please enter valid URI", Alert.AlertType.ERROR, "Error");
                return "INVALID_RECORD";
            }
            case SMART_POSTER_RECORD: {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                String inputUriString = posterRecord.getLinkRecord().getInputUriString();
                if (posterRecord.getTextRecord() == null || inputUriString == null || inputUriString.isEmpty()) {
                    TagXplorerUtility.createAlert("Please enter valid data and proceed...", Alert.AlertType.ERROR, "Error");
                    return "INVALID_RECORD";
                }
                if (f.d.p(inputUriString) || f.d.q(inputUriString)) {
                    TagXplorerUtility.createAlert("Please enter valid URI", Alert.AlertType.ERROR, "Error");
                    return "INVALID_RECORD";
                }
                if (!f.d.c(posterRecord.getLinkRecord().getUri()) || f.d.o(f.d.g(inputUriString))) break;
                TagXplorerUtility.createAlert("Please enter valid email id", Alert.AlertType.ERROR, "Error");
                return "INVALID_RECORD";
            }
            default: {
                return "INVALID_RECORD";
            }
        }
        return "VALID_RECORD";
    }

    @Override
    public void writeNDEFRecord(IRecord iRecord) {
        try {
            DBManager.INS.insertRecord(iRecord);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        new d().a(iRecord).a(this).a(2004);
    }
}

