/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller.mirror;

public class MirrorUriBuilder {
    private String uri;
    private String baseUri;
    private String placeholderString;

    public MirrorUriBuilder(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.uri = uri;
        this.baseUri = this.getBaseUri();
        this.placeholderString = "";
    }

    public MirrorUriBuilder add(Placeholder placeholder) {
        this.placeholderString = this.placeholderString + (this.placeholderString.isEmpty() ? placeholder.getSetValue() : placeholder.getAppendValue());
        return this;
    }

    private String getBaseUri() {
        return this.uri.split("\\?", 2)[0];
    }

    public String getMirrorUri() {
        return this.baseUri + this.placeholderString;
    }

    public static MirrorUriBuilder forUri(String uri) {
        return new MirrorUriBuilder(uri);
    }

    public static interface Placeholder {
        public String getSetValue();

        public String getAppendValue();
    }
}

