/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.NdefOperationsController;
import com.nxp.tagxplorer.controller.WriteNDEFEventHandler;
import com.nxp.tagxplorer.controller.contract.IWriteNdefContract;
import com.nxp.tagxplorer.controller.presenter.WriteNdefPresenter;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.BTTypes;
import com.nxp.tagxplorer.ndef.models.BluetoothRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.res.RLoader;
import com.nxp.tagxplorer.utility.Preference;
import com.nxp.tagxplorer.utility.PreferenceStore;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.IRecord;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import s.f;

public class WriteNdefController
extends AbstractController
implements IWriteNdefContract.IScene {
    private static final NDEFRecordType NDEF_INIT_RECORD_TYPE = NDEFRecordType.LINK_RECORD;
    @FXML
    private Button telephoneButton;
    @FXML
    private HBox centerNDEFRecordContainerPane;
    @FXML
    private Button geoLocationButton;
    @FXML
    private Button bluetoothButton;
    @FXML
    private Button wifiButton;
    @FXML
    private HBox bottomContainerHBox;
    @FXML
    private VBox rightContainerVBox;
    @FXML
    private TextField messageSizeTextField;
    @FXML
    private TextField numberOfRecordsTextField;
    @FXML
    private Button writeToTagButton;
    @FXML
    private Button exportButton;
    @FXML
    private Button vCardButton;
    @FXML
    private HBox topContainerHBox;
    @FXML
    private Button addMoreRecordButton;
    @FXML
    private Button smsButton;
    @FXML
    private Button uriButton;
    @FXML
    private Button launchAppButton;
    @FXML
    private Button importButton;
    @FXML
    private Button plainTextButton;
    @FXML
    private Button emailButton;
    @FXML
    private VBox writeNDEFMainBorderPane;
    private IWriteNdefContract.IPresenter presenter;
    private WriteNDEFEventHandler eventHandler;
    private IRecordGenerator recordGenerator;
    private boolean isRecordempty;
    private NdefOperationsController mParentController;

    private static void initializeViewWithData(IRecordGenerator recordGenerator) {
        Object value;
        Preference preference = PreferenceStore.INS.getPreference("DB_WRITE_NDEF_PREFERENCE");
        if (preference != null && preference.containsKey("WRITE_NDEF_FROM_DB") && (value = preference.getValue("WRITE_NDEF_FROM_DB")) != null && value instanceof IRecord) {
            recordGenerator.initializeWith((IRecord)value);
            preference.remove("WRITE_NDEF_FROM_DB");
        }
    }

    @Override
    public void initializeViewDependencies() {
        this.presenter = new WriteNdefPresenter();
        this.presenter.onSceneActive(this);
        this.eventHandler = new WriteNDEFEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        this.plainTextButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.uriButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.vCardButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.wifiButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.bluetoothButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.emailButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.telephoneButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.geoLocationButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.launchAppButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.smsButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.writeToTagButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.importButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.exportButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.addMoreRecordButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
    }

    @Override
    public void initializeDefaults() {
        Object value;
        Preference preference = PreferenceStore.INS.getPreference("DB_WRITE_NDEF_PREFERENCE");
        if (preference != null && preference.containsKey("WRITE_NDEF_FROM_DB") && (value = preference.getValue("WRITE_NDEF_FROM_DB")) != null && value instanceof IRecord) {
            this.setRecordType(this.presenter.getActualRecordType((IRecord)value));
            return;
        }
        this.setRecordType(NDEF_INIT_RECORD_TYPE);
    }

    private void setRecordType(NDEFRecordType recordType) {
        switch (recordType) {
            case TEXT_RECORD: {
                this.plainTextButton.fire();
                break;
            }
            case VCARD_RECORD: {
                this.vCardButton.fire();
                break;
            }
            case WIFI_RECORD: {
                this.wifiButton.fire();
                break;
            }
            case BLUETOOTH_RECORD: {
                this.bluetoothButton.fire();
                break;
            }
            case AAR_RECORD: {
                this.launchAppButton.fire();
                break;
            }
            case EMAIL_RECORD: {
                this.emailButton.fire();
                break;
            }
            case TELEPHONE_RECORD: {
                this.telephoneButton.fire();
                break;
            }
            case GEO_LOCATION: {
                this.geoLocationButton.fire();
                break;
            }
            case SMS_RECORD: {
                this.smsButton.fire();
                break;
            }
            case SMART_POSTER_RECORD: 
            case LINK_RECORD: {
                this.uriButton.fire();
                break;
            }
        }
    }

    @Override
    public void writeNDEFRecord() {
        String status;
        if (!TagXplorerUtility.checkIfTagPresentAndConnected() && !TagXplorerUtility.isDisconnectedFromTag()) {
            this.mParentController.disconnectFromTag();
        }
        IRecord generatedRecord = this.recordGenerator.generateRecord();
        String defaultValue = "0";
        if (!this.messageSizeTextField.getText().isEmpty()) {
            defaultValue = this.messageSizeTextField.getText();
        }
        generatedRecord.setSize(Integer.parseInt(defaultValue));
        if (null != generatedRecord && (status = this.validateRecord(generatedRecord)).equalsIgnoreCase("VALID_RECORD")) {
            this.writeToTagButton.setDisable(true);
            this.mParentController.toggleWriteNdef(true);
            this.writeToTagButton.getStyleClass().add((Object)"ripple_background");
            this.presenter.writeNDEFRecord(generatedRecord);
            f.a().a("Record to be Written :" + generatedRecord.toString());
        }
    }

    @Override
    public void importNDEFMessage() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("NDEF files (*.ndef)", new String[]{"*.ndef"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File fileToRead = fileChooser.showOpenDialog(this.writeNDEFMainBorderPane.getScene().getWindow());
        if (fileToRead == null) {
            return;
        }
        if (!"ndef".equals(TagXplorerUtility.getFileExtension(fileToRead))) {
            TagXplorerUtility.createInfoAlert("Invalid file type.", "Error");
            return;
        }
        this.presenter.importNDEFMessage(fileToRead);
    }

    @Override
    public void exportNDEFContent() {
        String status;
        IRecord generatedRecord = this.recordGenerator.generateRecord();
        String defaultValue = "0";
        if (!this.messageSizeTextField.getText().isEmpty()) {
            defaultValue = this.messageSizeTextField.getText();
        }
        generatedRecord.setSize(Integer.parseInt(defaultValue));
        if (null != generatedRecord && (status = this.validateRecord(generatedRecord)).equalsIgnoreCase("VALID_RECORD")) {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("NDEF files (*.ndef)", new String[]{"*.ndef"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File fileToWrite = fileChooser.showSaveDialog(this.writeNDEFMainBorderPane.getScene().getWindow());
            if (fileToWrite == null) {
                return;
            }
            this.presenter.exportNDEFContent(fileToWrite, generatedRecord);
        }
    }

    @Override
    public void addMoreRecord() {
    }

    @Override
    public void showCardNotNDEFFormatted() {
    }

    @Override
    public void showErrorWhileComminicatingWithSmartCard() {
    }

    @Override
    public void showPlainTextNDEFView() {
        this.makeButtonSelected("plainTextButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-492559362L));
        try {
            VBox mainVBox = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)mainVBox);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showURINDEFView() {
        this.makeButtonSelected("uriButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-1055359811L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showvCardNDEFView() {
        this.makeButtonSelected("vCardButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(2105200287L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void showWifiNDEFView() {
        this.makeButtonSelected("wifiButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(2094563302L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showBluethoothNDEFView() {
        this.makeButtonSelected("bluetoothButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(1299945599L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showEmailNDEFView() {
        this.makeButtonSelected("emailButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-788584723L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showPhoneNumberNDEFView() {
        this.makeButtonSelected("telephoneButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-104783795L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showGEOLocationNDEFView() {
        this.makeButtonSelected("geoLocationButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(1799182854L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showAndroidApplicationNDEFView() {
        this.makeButtonSelected("launchAppButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-1507095683L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showSMSNDEFView() {
        this.makeButtonSelected("smsButton");
        this.initializeMessageSizeTextField();
        this.centerNDEFRecordContainerPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(154864362L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.centerNDEFRecordContainerPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.recordGenerator.setParentController(this);
            WriteNdefController.initializeViewWithData(this.recordGenerator);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String validateRecord(IRecord record) {
        return this.presenter.validateRecord(record);
    }

    @Override
    public void onWriteNDEFSuccess() {
        this.writeToTagButton.setDisable(false);
        this.mParentController.toggleWriteNdef(false);
        this.writeToTagButton.getStyleClass().remove((Object)"ripple_background");
        TagXplorerUtility.createAlert("NDEF message written successfully!", Alert.AlertType.INFORMATION, "Success");
        f.a().c("NDEF message written successfully!");
    }

    @Override
    public void onWriteNDEFFailure() {
        this.writeToTagButton.setDisable(false);
        this.mParentController.toggleWriteNdef(false);
        this.writeToTagButton.getStyleClass().remove((Object)"ripple_background");
        TagXplorerUtility.createAlert("Failed to write NDEF message...", Alert.AlertType.ERROR, "Failure");
    }

    @Override
    public void onError(String errorMessage) {
        this.writeToTagButton.setDisable(false);
        this.mParentController.toggleWriteNdef(false);
        this.writeToTagButton.getStyleClass().remove((Object)"ripple_background");
        if (errorMessage != null) {
            if (errorMessage.contains("Tag has been removed, please reconnect and try again")) {
                this.mParentController.disconnectFromTag();
            }
        } else {
            errorMessage = "Operation failed with unknown error";
        }
        TagXplorerUtility.createAlert(errorMessage, Alert.AlertType.ERROR, "Error");
        f.a().d(errorMessage);
    }

    @Override
    public void calculateNdefMessageSize(boolean isEmty) {
        IRecord generatedRecord = this.recordGenerator.generateRecord();
        if (null != generatedRecord) {
            this.presenter.calculateNdefMessageSize(generatedRecord);
        }
        this.isRecordempty = isEmty;
    }

    @Override
    public void setMessageSize(String size) {
        try {
            if (this.isRecordempty) {
                this.messageSizeTextField.setText(String.valueOf(0));
            } else {
                this.messageSizeTextField.setText(String.valueOf(size));
            }
            this.numberOfRecordsTextField.setText(String.valueOf(1));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void initializeMessageSizeTextField() {
        this.messageSizeTextField.clear();
    }

    @Override
    public void showExportSuccessfullMessage() {
        TagXplorerUtility.createAlert("DataSet messsage saved successfully.", Alert.AlertType.INFORMATION, "Success");
    }

    @Override
    public void showExportFailedMessage() {
        TagXplorerUtility.createAlert("Failure while saving DataSet to File.", Alert.AlertType.INFORMATION, "Failure");
    }

    @Override
    public void showExportErrorMessage() {
        TagXplorerUtility.createAlert("Error While saving DataSet to File.", Alert.AlertType.INFORMATION, "Error");
    }

    @Override
    public void showImportSuccessfullMessage(List<IRecord> response) {
        if (response != null && response.size() > 0) {
            IRecord record2;
            BluetoothRecord bluetoothRecord;
            IRecord record = response.get(0);
            if (record instanceof BluetoothRecord && (bluetoothRecord = (BluetoothRecord)record).getBluetoothNdefVersion() == BTTypes.Hs && response.size() > 1 && (record2 = response.get(1)) instanceof BluetoothRecord) {
                bluetoothRecord = (BluetoothRecord)record2;
                bluetoothRecord.setHandoverSelectMessageAvailable(true);
                record = bluetoothRecord;
            }
            Preference createPreference = PreferenceStore.INS.createPreference("DB_WRITE_NDEF_PREFERENCE");
            AbstractRecord abstractRecord = (AbstractRecord)record;
            abstractRecord.setType(record.getType());
            createPreference.put("WRITE_NDEF_FROM_DB", abstractRecord);
            this.setRecordType(this.presenter.getActualRecordType(record));
        } else {
            TagXplorerUtility.createAlert("Failure while saving DataSet to File.", Alert.AlertType.INFORMATION, "Failure");
        }
    }

    @Override
    public void showImportFailedMessage() {
        TagXplorerUtility.createAlert("Failure while saving DataSet to File.", Alert.AlertType.INFORMATION, "Failure");
    }

    @Override
    public void showImportErrorMessage() {
        TagXplorerUtility.createAlert("Invalid file type.", Alert.AlertType.INFORMATION, "Error");
    }

    private void makeButtonSelected(String id) {
        switch (id) {
            case "plainTextButton": {
                this.plainTextButton.setStyle("-fx-background-color:#F9B500;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "uriButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#F9B500;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "vCardButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#F9B500;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "wifiButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#F9B500;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "bluetoothButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#F9B500;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "emailButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#F9B500;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "telephoneButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#F9B500;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "geoLocationButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#F9B500;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "launchAppButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#F9B500;");
                this.smsButton.setStyle("-fx-background-color:#35989E;");
                break;
            }
            case "smsButton": {
                this.plainTextButton.setStyle("-fx-background-color:#35989E;");
                this.uriButton.setStyle("-fx-background-color:#35989E;");
                this.vCardButton.setStyle("-fx-background-color:#35989E;");
                this.wifiButton.setStyle("-fx-background-color:#35989E;");
                this.bluetoothButton.setStyle("-fx-background-color:#35989E;");
                this.emailButton.setStyle("-fx-background-color:#35989E;");
                this.telephoneButton.setStyle("-fx-background-color:#35989E;");
                this.geoLocationButton.setStyle("-fx-background-color:#35989E;");
                this.launchAppButton.setStyle("-fx-background-color:#35989E;");
                this.smsButton.setStyle("-fx-background-color:#F9B500;");
                break;
            }
        }
    }

    private void fadeInTransition() {
        FadeTransition ft = TagXplorerUtility.getFadeInTransitionInstance();
        ft.setNode((Node)this.centerNDEFRecordContainerPane);
        ft.play();
    }

    @Override
    public void setParentController(NdefOperationsController obj) {
        this.mParentController = obj;
    }

    @Override
    public void disableWriteButtons(boolean value) {
        this.writeToTagButton.setDisable(value);
    }
}

