/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.WifiRecordEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IWifiRecordContract;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.WifiRecord;
import com.nxp.tagxplorer.utility.Model;
import com.nxp.tagxplorer.utility.WifiConstant;
import com.nxp.tagxplorer.utility.gson.IRecord;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class WifiRecordController
extends AbstractController
implements IRecordGenerator,
IWifiRecordContract.IScene {
    ObservableList<Model> wifiAuthenticationTypeList = FXCollections.observableArrayList((Object[])WifiConstant.WIFI_AUTH_MODELS);
    ObservableList<Model> wifiEncryptionTypeList = FXCollections.observableArrayList((Object[])WifiConstant.WIFI_ENCRYPTION_MODELS);
    @FXML
    private GridPane wifiDataGridPane;
    @FXML
    private VBox wifiRecordMainVBox;
    @FXML
    private Label wlanMacLabel;
    @FXML
    private TextField wlanMacTextField;
    @FXML
    private Button wlanMacClearButton;
    @FXML
    private TextField networkSSDTextField;
    @FXML
    private TextField wifiPasswordTextField;
    @FXML
    private ComboBox<Model> authTypeComboBox;
    @FXML
    private ComboBox<Model> encryptionTypeComboBox;
    @FXML
    private Button networdSSDClearButton;
    @FXML
    private Button wifiPasswordClearButton;
    private String ssdEmpty = "";
    private String macEmpty = "";
    private String passwordEmpty = "";
    private WriteNdefController mWriteNdefController;

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        WifiRecordEventHandler eventHandler = new WifiRecordEventHandler(this);
        this.networdSSDClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.wifiPasswordClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.wlanMacClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        StringConverter<Model> stringConverter = new StringConverter<Model>(){

            public String toString(Model object) {
                if (object == null) {
                    return null;
                }
                return object.getModelAsString();
            }

            public Model fromString(String string) {
                return null;
            }
        };
        this.authTypeComboBox.setConverter((StringConverter)stringConverter);
        this.encryptionTypeComboBox.setConverter((StringConverter)stringConverter);
        this.wlanMacTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                WifiRecordController.this.macEmpty = newValue;
                WifiRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                WifiRecordController.this.isRecordEmpty();
            }
        });
        this.networkSSDTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                WifiRecordController.this.ssdEmpty = newValue;
                WifiRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                WifiRecordController.this.isRecordEmpty();
            }
        });
        this.wifiPasswordTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                WifiRecordController.this.passwordEmpty = newValue;
                WifiRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                WifiRecordController.this.isRecordEmpty();
            }
        });
    }

    @Override
    public void initializeDefaults() {
        this.authTypeComboBox.setItems(this.wifiAuthenticationTypeList);
        this.authTypeComboBox.getSelectionModel().selectFirst();
        this.encryptionTypeComboBox.setItems(this.wifiEncryptionTypeList);
        this.encryptionTypeComboBox.getSelectionModel().selectFirst();
    }

    private void isRecordEmpty() {
        if (this.ssdEmpty.length() == 0 && this.macEmpty.length() == 0 && this.passwordEmpty.length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        }
    }

    @Override
    public IRecord generateRecord() {
        String networkSsid = this.networkSSDTextField.getText();
        String wlanMacAddress = this.wlanMacTextField.getText();
        String password = this.wifiPasswordTextField.getText();
        WifiRecord wifiRecord = new WifiRecord(networkSsid, wlanMacAddress, password, ((Model)this.authTypeComboBox.getSelectionModel().getSelectedItem()).getModel(), ((Model)this.encryptionTypeComboBox.getSelectionModel().getSelectedItem()).getModel());
        wifiRecord.setType(NDEFRecordType.WIFI_RECORD);
        return wifiRecord;
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public void clearNetworkSSIDDescription() {
        this.networkSSDTextField.clear();
    }

    @Override
    public void clearWLANMacDescription() {
        this.wlanMacTextField.clear();
    }

    @Override
    public void clearPassword() {
        this.wifiPasswordTextField.clear();
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null && record instanceof WifiRecord) {
            WifiRecord wifiRecord = (WifiRecord)record;
            this.networkSSDTextField.setText(wifiRecord.getNetworkSsid());
            this.wlanMacTextField.setText(wifiRecord.getMacAddress());
            this.authTypeComboBox.setValue((Object)WifiConstant.getSelectedAuthModel(wifiRecord.getAuthType()));
            this.encryptionTypeComboBox.setValue((Object)WifiConstant.getSelectedEncModel(wifiRecord.getEncType()));
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }
}

