/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.VCardEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IVCardRecordContract;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.VCardRecord;
import com.nxp.tagxplorer.utility.gson.IRecord;
import java.time.LocalDate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public class VCardRecordController
extends AbstractController
implements IRecordGenerator,
IVCardRecordContract.IScene {
    @FXML
    private VBox vcardMainVBox;
    @FXML
    private ScrollPane vCardScrollPane;
    @FXML
    private GridPane vCardGridPane;
    @FXML
    private TextField vCardName;
    @FXML
    private TextField vCardFullName;
    @FXML
    private TextField vCardMobileNumber;
    @FXML
    private TextField vCardHomePhoneNumber;
    @FXML
    private TextField vCardWorkPhoneNumber;
    @FXML
    private TextField vCardFax;
    @FXML
    private TextField vCardVoiceMail;
    @FXML
    private TextField vCardHomeEmail;
    @FXML
    private TextField vCardWorkEmail;
    @FXML
    private TextArea vCardHomeAddress;
    @FXML
    private TextArea vCardWorkAddress;
    @FXML
    private TextField vCardCompany;
    @FXML
    private TextField vCardTitle;
    @FXML
    private TextField vCardWebSite;
    @FXML
    private DatePicker vCardBirthDay;
    @FXML
    private TextArea vCardNote;
    @FXML
    private Button nameClearButton;
    @FXML
    private Button fullnameClearButton;
    @FXML
    private Button mobileNumberClearButton;
    @FXML
    private Button workNumberClearButton;
    @FXML
    private Button homeNumberClearButton;
    @FXML
    private Button faxNumberClearButton;
    @FXML
    private Button workMailClearButton;
    @FXML
    private Button homeMailClearButton;
    @FXML
    private Button addressHomeClearButton;
    @FXML
    private Button addressWorkClearButton;
    @FXML
    private Button companyClearButton;
    @FXML
    private Button webSiteClearButton;
    @FXML
    private Button birthDayClearButton;
    @FXML
    private Button titleClearButton;
    @FXML
    private Button voiceMailNumberClearButton;
    @FXML
    private Button notesNumberClearButton;
    private WriteNdefController mWriteNdefController;
    private String cardName = "";
    private String fullName = "";
    private String mobileNumber = "";
    private String homePhoneNumber = "";
    private String workPhoneNumber = "";
    private String fax = "";
    private String voiceMail = "";
    private String homeEmail = "";
    private String workEmail = "";
    private String homeAddress = "";
    private String workAddress = "";
    private String company = "";
    private String title = "";
    private String webSite = "";
    private String birthDay = "";
    private String note = "";

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        VCardEventHandler eventHandler = new VCardEventHandler(this);
        this.fullnameClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.nameClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.mobileNumberClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.homeNumberClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.workNumberClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.faxNumberClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.workMailClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.homeMailClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.addressHomeClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.addressWorkClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.companyClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.webSiteClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.birthDayClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.notesNumberClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.voiceMailNumberClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.titleClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.vCardName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.cardName = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardFullName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.fullName = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardMobileNumber.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.mobileNumber = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardHomePhoneNumber.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.homePhoneNumber = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardWorkPhoneNumber.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.workPhoneNumber = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardFax.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.fax = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardVoiceMail.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.voiceMail = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardHomeEmail.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.homeEmail = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardWorkEmail.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.workEmail = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardHomeAddress.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.homeAddress = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardWorkAddress.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.workAddress = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardCompany.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.company = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardTitle.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.title = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardWebSite.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.webSite = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardBirthDay.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                if (newValue != null) {
                    VCardRecordController.this.birthDay = newValue.toString();
                }
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
        this.vCardNote.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                VCardRecordController.this.note = newValue;
                VCardRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                VCardRecordController.this.isRecordEmpty();
            }
        });
    }

    @Override
    public void initializeDefaults() {
    }

    private void isRecordEmpty() {
        if (this.cardName.length() == 0 && this.fullName.length() == 0 && this.mobileNumber.length() == 0 && this.homePhoneNumber.length() == 0 && this.workPhoneNumber.length() == 0 && this.fax.length() == 0 && this.voiceMail.length() == 0 && this.homeEmail.length() == 0 && this.workEmail.length() == 0 && this.homeAddress.length() == 0 && this.workAddress.length() == 0 && this.company.length() == 0 && this.title.length() == 0 && this.webSite.length() == 0 && this.birthDay.length() == 0 && this.note.length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        }
    }

    @Override
    public IRecord generateRecord() {
        VCardRecord vcardData = new VCardRecord();
        vcardData.setName(this.getvCardName());
        vcardData.setFullName(this.getvCardFullName());
        vcardData.setMobile(this.getvCardMobileNumber());
        vcardData.setHomePhone(this.getvCardHomePhoneNumber());
        vcardData.setWorkPhone(this.getvCardWorkPhoneNumber());
        vcardData.setFax(this.getvCardFax());
        vcardData.setVoiceMail(this.getvCardVoiceEmail());
        vcardData.setHomeEmail(this.getvCardHomeEmail());
        vcardData.setWorkEmail(this.getvCardWorkEmail());
        vcardData.setHomeAddress(this.getvCardHomeAddress());
        vcardData.setWorkAddress(this.getvCardWorkAddress());
        vcardData.setCompany(this.getvCardCompany());
        vcardData.setTitle(this.getvCardTitle());
        vcardData.setWebSite(this.getvCardWebSite());
        if (this.getvCardBirthDay() != null && !this.getvCardBirthDay().toString().isEmpty()) {
            vcardData.setBirthDate(this.getvCardBirthDay());
        }
        vcardData.setNotes(this.getvCardNote());
        vcardData.setType(NDEFRecordType.VCARD_RECORD);
        return vcardData;
    }

    @Override
    public void updateMessageSize(int size) {
    }

    public String getvCardName() {
        return this.vCardName.getText();
    }

    public String getvCardFullName() {
        return this.vCardFullName.getText();
    }

    public String getvCardMobileNumber() {
        return this.vCardMobileNumber.getText();
    }

    public String getvCardHomePhoneNumber() {
        return this.vCardHomePhoneNumber.getText();
    }

    public String getvCardWorkPhoneNumber() {
        return this.vCardWorkPhoneNumber.getText();
    }

    public String getvCardFax() {
        return this.vCardFax.getText();
    }

    public String getvCardVoiceEmail() {
        return this.vCardVoiceMail.getText();
    }

    public String getvCardHomeEmail() {
        return this.vCardHomeEmail.getText();
    }

    public String getvCardWorkEmail() {
        return this.vCardWorkEmail.getText();
    }

    public String getvCardHomeAddress() {
        return this.vCardHomeAddress.getText();
    }

    public String getvCardWorkAddress() {
        return this.vCardWorkAddress.getText();
    }

    public String getvCardCompany() {
        return this.vCardCompany.getText();
    }

    public String getvCardTitle() {
        return this.vCardTitle.getText();
    }

    public String getvCardWebSite() {
        return this.vCardWebSite.getText();
    }

    public LocalDate getvCardBirthDay() {
        return (LocalDate)this.vCardBirthDay.getValue();
    }

    public String getvCardNote() {
        return this.vCardNote.getText();
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null && record instanceof VCardRecord) {
            VCardRecord vCardRecord = (VCardRecord)record;
            this.vCardName.setText(vCardRecord.getName() == null ? "" : vCardRecord.getName());
            this.vCardFullName.setText(vCardRecord.getFullName() == null ? "" : vCardRecord.getFullName());
            this.vCardMobileNumber.setText(vCardRecord.getMobile() == null ? "" : vCardRecord.getMobile());
            this.vCardHomePhoneNumber.setText(vCardRecord.getHomePhone() == null ? "" : vCardRecord.getHomePhone());
            this.vCardWorkPhoneNumber.setText(vCardRecord.getWorkPhone() == null ? "" : vCardRecord.getWorkPhone());
            this.vCardFax.setText(vCardRecord.getFax() == null ? "" : vCardRecord.getFax());
            this.vCardVoiceMail.setText(vCardRecord.getVoiceMail() == null ? "" : vCardRecord.getVoiceMail());
            this.vCardHomeEmail.setText(vCardRecord.getHomeEmail() == null ? "" : vCardRecord.getHomeEmail());
            this.vCardWorkEmail.setText(vCardRecord.getWorkEmail() == null ? "" : vCardRecord.getWorkEmail());
            this.vCardHomeAddress.setText(vCardRecord.getHomeAddress() == null ? "" : vCardRecord.getHomeAddress());
            this.vCardWorkAddress.setText(vCardRecord.getWorkAddress() == null ? "" : vCardRecord.getWorkAddress());
            this.vCardCompany.setText(vCardRecord.getCompany() == null ? "" : vCardRecord.getCompany());
            this.vCardTitle.setText(vCardRecord.getTitle() == null ? "" : vCardRecord.getTitle());
            this.vCardWebSite.setText(vCardRecord.getWebSite() == null ? "" : vCardRecord.getWebSite());
            this.vCardBirthDay.setValue((Object)vCardRecord.getBirthDate());
            this.vCardNote.setText(vCardRecord.getNotes() == null ? "" : vCardRecord.getNotes());
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }

    @Override
    public void clearName() {
        this.vCardName.clear();
    }

    @Override
    public void clearFullName() {
        this.vCardFullName.clear();
    }

    @Override
    public void clearMobileNumber() {
        this.vCardMobileNumber.clear();
    }

    @Override
    public void clearHomeNumber() {
        this.vCardHomePhoneNumber.clear();
    }

    @Override
    public void clearWorkHomeNumber() {
        this.vCardWorkPhoneNumber.clear();
    }

    @Override
    public void clearVoiceMail() {
        this.vCardVoiceMail.clear();
    }

    @Override
    public void clearHomeMail() {
        this.vCardHomeEmail.clear();
    }

    @Override
    public void clearWorkMail() {
        this.vCardWorkEmail.clear();
    }

    @Override
    public void clearHomeAddress() {
        this.vCardHomeAddress.clear();
    }

    @Override
    public void clearWorkAddress() {
        this.vCardWorkAddress.clear();
    }

    @Override
    public void clearTitle() {
        this.vCardTitle.clear();
    }

    @Override
    public void clearCompany() {
        this.vCardCompany.clear();
    }

    @Override
    public void clearWebsite() {
        this.vCardWebSite.clear();
    }

    @Override
    public void clearNotes() {
        this.vCardNote.clear();
    }

    @Override
    public void clearBirthDay() {
        this.vCardBirthDay.setValue(null);
    }

    @Override
    public void clearFax() {
        this.vCardFax.clear();
    }
}

