/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.UriEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IURIRecordContract;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.d;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class UriRecordController
extends AbstractController
implements IRecordGenerator,
IURIRecordContract.IScene {
    ObservableList<String> uriList = FXCollections.observableArrayList((Object[])TagXplorerConstants.URI_TYPES);
    @FXML
    private VBox uriRecordMainVBox;
    @FXML
    private TextField descTextField;
    @FXML
    private Button descriptionClearButton;
    @FXML
    private ComboBox<String> uriTypeComboBox;
    @FXML
    private TextField writeNdefUriTextField;
    @FXML
    private Button uriClearButton;
    @FXML
    private Label invalidPrefixLabel;
    private WriteNdefController mWriteNdefController;

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        UriEventHandler eventHandler = new UriEventHandler(this);
        this.descriptionClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.uriClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.descTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                UriRecordController.this.isRecordEmpty();
            }
        });
        this.writeNdefUriTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                UriRecordController.this.isRecordEmpty();
                UriRecordController.this.invalidPrefixLabel.setVisible(d.p(newValue));
            }
        });
        this.uriTypeComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String oldValue, String newValue) {
                if (newValue.equals(TagXplorerConstants.URI_TYPES[0])) {
                    UriRecordController.this.writeNdefUriTextField.setText(TagXplorerConstants.uriProtoMap.get((byte)1));
                } else if (newValue.equals(TagXplorerConstants.URI_TYPES[1])) {
                    UriRecordController.this.writeNdefUriTextField.setText(TagXplorerConstants.uriProtoMap.get((byte)29));
                } else {
                    UriRecordController.this.writeNdefUriTextField.setText("");
                    UriRecordController.this.writeNdefUriTextField.setPromptText("type URI data...");
                }
            }
        });
    }

    @Override
    public void initializeDefaults() {
        this.uriTypeComboBox.setItems(this.uriList);
        this.uriTypeComboBox.setValue((Object)"URL(Website)");
    }

    private void isRecordEmpty() {
        if (this.descTextField.getText().length() == 0 && this.writeNdefUriTextField.getText().length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        } else {
            this.mWriteNdefController.calculateNdefMessageSize(false);
        }
    }

    @Override
    public IRecord generateRecord() {
        String uriString;
        String desc = this.descTextField.getText();
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString = this.writeNdefUriTextField.getText());
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.LINK_RECORD);
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
        }
        return generateRecord;
    }

    public void log(String data) {
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public void enableUIDMirroring() {
    }

    @Override
    public void enableCounterMirroring() {
    }

    @Override
    public void enableSDMMirroring() {
    }

    @Override
    public void enableTTMessageMirroring() {
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null) {
            LinkRecord linkRecord = null;
            if (record instanceof SmartPosterRecord) {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                this.descTextField.setText(posterRecord.getTextRecord().getInputText());
                linkRecord = posterRecord.getLinkRecord();
            } else if (record instanceof LinkRecord) {
                linkRecord = (LinkRecord)record;
            }
            if (linkRecord == null) {
                return;
            }
            this.writeNdefUriTextField.setText(linkRecord.getInputUriString());
            if (d.d(linkRecord.getUri())) {
                this.uriTypeComboBox.setValue((Object)TagXplorerConstants.URI_TYPES[0]);
            } else if (d.e(linkRecord.getUri())) {
                this.uriTypeComboBox.setValue((Object)TagXplorerConstants.URI_TYPES[1]);
            } else {
                this.uriTypeComboBox.setValue((Object)TagXplorerConstants.URI_TYPES[2]);
            }
        }
    }

    @Override
    public void clearURIDescriptionFromTextArea() {
        this.descTextField.clear();
    }

    @Override
    public void clearURIFromTextField() {
        this.writeNdefUriTextField.clear();
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }
}

