/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.PlainTextEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.ITextRecordContract;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.TextRecord;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import com.nxp.tagxplorer.utility.gson.IRecord;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;

public class TextRecordController
extends AbstractController
implements IRecordGenerator,
ITextRecordContract.IScene {
    boolean isrecordEmpty;
    ObservableList<String> list = FXCollections.observableArrayList((Object[])TagXplorerConstants.LANGUAGE_CODES);
    @FXML
    private Button plainTextAreaClearButton;
    @FXML
    private VBox plainTextMainVBox;
    @FXML
    private TextArea plainTextArea;
    @FXML
    private ComboBox<String> languageCodeList;
    private WriteNdefController mWriteNdefController;

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        PlainTextEventHandler eventHandler = new PlainTextEventHandler(this);
        this.plainTextAreaClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.plainTextArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TextRecordController.this.isrecordEmpty = newValue.length() == 0;
                TextRecordController.this.mWriteNdefController.calculateNdefMessageSize(TextRecordController.this.isrecordEmpty);
            }
        });
    }

    @Override
    public void clearPlainText() {
        this.plainTextArea.setText("");
    }

    @Override
    public void initializeDefaults() {
        this.languageCodeList.setItems(this.list);
        this.languageCodeList.setValue((Object)"en");
    }

    @Override
    public IRecord generateRecord() {
        TextRecord textRecord = new TextRecord();
        textRecord.setInputText(this.plainTextArea.getText());
        textRecord.setLanguageCode((String)this.languageCodeList.getSelectionModel().getSelectedItem());
        textRecord.setType(NDEFRecordType.TEXT_RECORD);
        return textRecord;
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record instanceof TextRecord) {
            TextRecord textRecord = (TextRecord)record;
            this.plainTextArea.setText(textRecord.getInputText());
            this.languageCodeList.setValue((Object)textRecord.getLanguageCode());
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }
}

