/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.TelephoneRecordEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.ITelephoneNumberRecordContract;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.d;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class TelephoneRecordController
extends AbstractController
implements IRecordGenerator,
ITelephoneNumberRecordContract.IScene {
    @FXML
    private VBox telephoneRecordMainVBox;
    @FXML
    private TextField telephoneTitleTextField;
    @FXML
    private TextField telephoneNumberTextField;
    @FXML
    private Button clearTitleButton;
    @FXML
    private Button clearNumberButton;
    private WriteNdefController mWriteNdefController;
    private String titleEmpty = "";
    private String numberEmpty = "";

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        TelephoneRecordEventHandler eventHandler = new TelephoneRecordEventHandler(this);
        this.clearTitleButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.clearNumberButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.telephoneTitleTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TelephoneRecordController.this.titleEmpty = newValue;
                TelephoneRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                TelephoneRecordController.this.isRecordEmpty();
            }
        });
        this.telephoneNumberTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                TelephoneRecordController.this.numberEmpty = newValue;
                TelephoneRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                TelephoneRecordController.this.isRecordEmpty();
            }
        });
    }

    @Override
    public void initializeDefaults() {
    }

    private void isRecordEmpty() {
        if (this.titleEmpty.length() == 0 && this.numberEmpty.length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        }
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public IRecord generateRecord() {
        String telephoneAddressField;
        String uriString;
        String desc = this.telephoneTitleTextField.getText();
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString = (telephoneAddressField = this.telephoneNumberTextField.getText()).isEmpty() ? "" : String.format("tel:%s", telephoneAddressField));
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.TELEPHONE_RECORD);
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
        }
        return generateRecord;
    }

    public String getTelephoneTitle() {
        return this.telephoneTitleTextField.getText();
    }

    public String getTelephoneNumber() {
        return this.telephoneNumberTextField.getText();
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null) {
            String description = null;
            String number = null;
            if (record instanceof LinkRecord) {
                LinkRecord linkRecord = (LinkRecord)record;
                number = linkRecord.getInputUriString();
            } else if (record instanceof SmartPosterRecord) {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                description = posterRecord.getTextRecord().getInputText();
                number = posterRecord.getLinkRecord().getInputUriString();
            }
            if (description != null) {
                this.telephoneTitleTextField.setText(description);
            }
            if (number != null) {
                this.telephoneNumberTextField.setText(d.b(number));
            }
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }

    @Override
    public void clearTitleText() {
        this.telephoneTitleTextField.setText("");
    }

    @Override
    public void clearNumber() {
        this.telephoneNumberTextField.setText("");
    }
}

