/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.contract.ITagXplorerMainSceneContract;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;

public class TagXplorerMainSceneEventHandler
implements EventHandler<Event> {
    private final ITagXplorerMainSceneContract.IScene iScene;

    public TagXplorerMainSceneEventHandler(ITagXplorerMainSceneContract.IScene scene) {
        this.iScene = scene;
    }

    public void handle(Event event) {
        String id = ((Control)event.getSource()).getId();
        if (event.getEventType() == ActionEvent.ACTION) {
            switch (id) {
                case "connectToReaderButton": {
                    this.iScene.initializeSmartCardReader();
                    break;
                }
                case "connectToTagButton": {
                    this.iScene.connectDisconnectSmartCard();
                    break;
                }
                case "ndefOperationRadioButton": {
                    this.iScene.showNDEFOperationScreen();
                    break;
                }
                case "ntagOperationRadioButton": {
                    this.iScene.showNTAGOperationView();
                    break;
                }
                case "showHideLog": {
                    this.iScene.showHideLogArea();
                    break;
                }
                case "aboutButton": {
                    this.iScene.showAbout();
                    break;
                }
                case "showLog": {
                    this.iScene.showHideLogArea();
                    break;
                }
            }
        } else if (event.getEventType() == ComboBoxBase.ON_SHOWN) {
            switch (id) {
                case "chooseReader": {
                    this.iScene.readerComboBoxIsShown();
                    break;
                }
            }
        }
    }
}

