/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import a.f;
import com.nxp.nfclib.CardType;
import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.LogController;
import com.nxp.tagxplorer.controller.NdefOperationsController;
import com.nxp.tagxplorer.controller.ScreenDimenstion;
import com.nxp.tagxplorer.controller.TagXplorerMainSceneEventHandler;
import com.nxp.tagxplorer.controller.contract.ITagXplorerMainSceneContract;
import com.nxp.tagxplorer.controller.presenter.TagXplorerMainScenePresenter;
import com.nxp.tagxplorer.res.RLoader;
import com.nxp.tagxplorer.utility.Preference;
import com.nxp.tagxplorer.utility.PreferenceStore;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import f.g;
import i.h;
import j.j;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Callback;
import k.r;
import l.T;
import m.U;
import o.p;
import p.t;
import r.k;
import r.l;
import t.c;
import t.d;

public class TagXplorerController
extends AbstractController
implements ITagXplorerMainSceneContract.IScene {
    private static final c LOG = d.a(TagXplorerController.class.getSimpleName());
    @FXML
    private ComboBox<String> chooseReader;
    @FXML
    private Button clearLog;
    @FXML
    private ToggleButton connectToReaderButton;
    @FXML
    private ToggleButton connectToTagButton;
    @FXML
    private RadioButton ndefOperationRadioButton;
    @FXML
    private RadioButton ntagOperationRadioButton;
    @FXML
    private Button formatTagButton;
    @FXML
    private Button aboutButton;
    @FXML
    private ToggleButton showLog;
    @FXML
    private VBox parentCenterContainerVBox;
    @FXML
    private ImageView nxpLogoImageView;
    @FXML
    private HBox topContainerHBox;
    @FXML
    private VBox leftContainerVBox;
    @FXML
    private BorderPane mainBorderPane;
    @FXML
    private HBox appLabelHBox;
    @FXML
    private HBox readerButtonPanelHBox;
    @FXML
    private ToggleGroup operationtypesToggleGroup;
    @FXML
    private VBox ndefOperationContainerVBox;
    @FXML
    private ImageView tagXplorerAppLabelIcon;
    @FXML
    private Label connectedTagStatusLabel;
    @FXML
    private Label icTypeLabel;
    @FXML
    private Label tagTypeLabel;
    @FXML
    private Label userMemoryLabel;
    private TagXplorerMainScenePresenter mPresenter;
    private TagXplorerMainSceneEventHandler eventHandler;
    private LogController mLogController;
    private NdefOperationsController mNdefOperationsController;
    private g.d mNTagSpecificOperationsController;

    public g.d getNTagSpecificOperationsController() {
        return this.mNTagSpecificOperationsController;
    }

    @Override
    public void initializeViewDependencies() {
        this.mPresenter = new TagXplorerMainScenePresenter();
        this.mPresenter.onSceneActive(this);
        this.eventHandler = new TagXplorerMainSceneEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
        this.parentCenterContainerVBox.setPrefSize(ScreenDimenstion.INS.getApplicationContainerWidth(), ScreenDimenstion.INS.getApplicationContainerHeight());
        this.topContainerHBox.setPrefSize(ScreenDimenstion.INS.getApplicationReaderPanelHBoxWidth(), ScreenDimenstion.INS.getApplicationReaderPanelHBoxHeight());
        this.leftContainerVBox.setPrefSize(ScreenDimenstion.INS.getApplicationOperationPanelVBoxWidth(), ScreenDimenstion.INS.getApplicationOperationPanelVBoxHeight());
        this.appLabelHBox.setPrefSize(ScreenDimenstion.INS.getApplicationReaderPanelHBoxWidth() * 0.15, ScreenDimenstion.INS.getApplicationReaderPanelHBoxHeight());
        this.readerButtonPanelHBox.setPrefSize(ScreenDimenstion.INS.getApplicationReaderPanelHBoxWidth() * 0.75, ScreenDimenstion.INS.getApplicationReaderPanelHBoxHeight());
        this.mainBorderPane.setRight(null);
    }

    @Override
    public void initializeListeners() {
        this.connectToTagButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.connectToReaderButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.ndefOperationRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.ntagOperationRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.aboutButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.showLog.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.chooseReader.setOnShown((EventHandler)this.eventHandler);
        this.ndefOperationRadioButton.fire();
    }

    @Override
    public void initializeDefaults() {
        this.ndefOperationRadioButton.getStyleClass().remove((Object)"radio-button");
        this.ndefOperationRadioButton.getStyleClass().add((Object)"toggle-button");
        this.ntagOperationRadioButton.getStyleClass().remove((Object)"radio-button");
        this.ntagOperationRadioButton.getStyleClass().add((Object)"toggle-button");
        this.ndefOperationRadioButton.fire();
        Image nxpLogo = new Image(RLoader.loadImage(-611283809L));
        this.nxpLogoImageView.setImage(nxpLogo);
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        if (primaryScreenBounds.getWidth() <= 1366.0 && primaryScreenBounds.getHeight() <= 768.0) {
            Image appLabel = new Image(RLoader.loadImage(-1094197672L));
            this.tagXplorerAppLabelIcon.setImage(appLabel);
        } else if (primaryScreenBounds.getWidth() <= 1600.0 && primaryScreenBounds.getHeight() <= 900.0) {
            Image appLabel = new Image(RLoader.loadImage(-2061192709L));
            this.tagXplorerAppLabelIcon.setImage(appLabel);
        } else {
            Image appLabel = new Image(RLoader.loadImage(369719146L));
            this.tagXplorerAppLabelIcon.setImage(appLabel);
        }
        this.chooseReader.setVisibleRowCount(5);
        this.disableButton();
        this.clearConnectedTagDetails();
        this.refreshSmartCardReaderList();
    }

    @Override
    public void refreshSmartCardReaderList() {
        List<String> readerList;
        List<AvailableReader> availableReaderList;
        this.chooseReader.setVisibleRowCount(5);
        if (this.connectToReaderButton.getUserData() == Boolean.TRUE) {
            this.mPresenter.disconnectFromSmartCard();
            this.mPresenter.disconnectSmartCardReader();
        }
        if (this.chooseReader.getItems() != null) {
            this.chooseReader.getItems().clear();
        }
        if ((availableReaderList = this.filterReaderList(readerList = this.mPresenter.refreshSmartCardReaderList())).isEmpty()) {
            this.chooseReader.setPromptText("No reader connected");
            this.chooseReader.setItems(null);
            s.f.a().d();
            return;
        }
        readerList = availableReaderList.stream().map(availableReader -> availableReader.getName()).collect(Collectors.toList());
        for (String readerName : readerList) {
            s.f.a().b(readerName);
        }
        this.chooseReader.setPromptText("Select reader");
        this.chooseReader.setItems(FXCollections.observableArrayList(readerList));
        for (AvailableReader availableReader2 : availableReaderList) {
            if (!availableReader2.isSupported()) continue;
            this.chooseReader.setValue((Object)availableReader2.getName());
            break;
        }
        this.chooseReader.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> param) {
                ListCell<String> cell = new ListCell<String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        List<String> supportedReadersList = TagXplorerController.this.mPresenter.getSupportedReadersList();
                        if (item != null) {
                            this.setText(item);
                            for (String reader : supportedReadersList) {
                                if (reader == null || reader.length() == 0) continue;
                                if (item.contains(reader)) {
                                    this.setTextFill((Paint)Color.DARKGREEN);
                                    this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.PALEGREEN, CornerRadii.EMPTY, Insets.EMPTY)}));
                                    break;
                                }
                                this.setTextFill((Paint)Color.BLACK);
                                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, CornerRadii.EMPTY, Insets.EMPTY)}));
                            }
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
    }

    private List<AvailableReader> filterReaderList(List<String> readerList) {
        if (readerList == null) {
            return new ArrayList<AvailableReader>();
        }
        ArrayList<AvailableReader> availableReaderList = new ArrayList<AvailableReader>();
        ArrayList<AvailableReader> nonSupportReaderList = new ArrayList<AvailableReader>();
        List<String> supportedReaderList = this.mPresenter.getSupportedReadersList();
        for (String reader : readerList) {
            if (supportedReaderList.contains(reader)) {
                availableReaderList.add(new AvailableReader(reader, true));
                continue;
            }
            nonSupportReaderList.add(new AvailableReader(reader, false));
        }
        availableReaderList.addAll(nonSupportReaderList);
        return availableReaderList;
    }

    @Override
    public void initializeSmartCardReader() {
        int selectedIndex = this.chooseReader.getSelectionModel().getSelectedIndex();
        if (selectedIndex == -1) {
            try {
                this.connectToReaderButton.setSelected(false);
                if (l.a(k.a.a())) {
                    TagXplorerUtility.createAlert("Please select reader first.", Alert.AlertType.WARNING, "Warning");
                } else {
                    TagXplorerUtility.createAlert("No supported reader available.", Alert.AlertType.WARNING, "Warning");
                }
            }
            catch (d.c e2) {
                this.showReaderNotSelectedError();
            }
            return;
        }
        if (this.connectToReaderButton.getUserData() == Boolean.TRUE) {
            this.mPresenter.disconnectFromSmartCard();
            this.mPresenter.disconnectSmartCardReader();
        } else {
            this.mPresenter.initializeSmartCardReader((String)this.chooseReader.getValue());
        }
    }

    @Override
    public void showHideLogArea() {
        if (this.mLogController == null) {
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(76580L));
                Parent root = (Parent)fxmlLoader.load();
                this.mLogController = (LogController)fxmlLoader.getController();
                s.f.a().a(this.mLogController);
                root.getStylesheets().clear();
                root.getStylesheets().add((Object)RLoader.loadCSS(145956185L).toExternalForm());
                Stage stage = new Stage();
                stage.setX(ScreenDimenstion.INS.getApplicationContainerWidth() - 1335.0);
                stage.setY(ScreenDimenstion.INS.getApplicationReaderPanelHBoxHeight() + 650.0);
                stage.setWidth(ScreenDimenstion.INS.getApplicationReaderPanelHBoxWidth() - 300.0);
                stage.setHeight(300.0);
                stage.setTitle("Log");
                stage.setScene(new Scene(root));
                this.showLog.setDisable(true);
                this.showLog.setStyle("-fx-background-color: #F9B500; ");
                stage.setOnCloseRequest(event -> {
                    this.mLogController = null;
                    this.showLog.setDisable(false);
                    this.showLog.setStyle("-fx-background-color: #4181DE; ");
                });
                stage.initOwner(this.mainBorderPane.getScene().getWindow());
                stage.show();
                this.mLogController.showLog();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void showNDEFOperationScreen() {
        this.parentCenterContainerVBox.getChildren().clear();
        if (PreferenceStore.INS.containsPreference("DB_WRITE_NDEF_PREFERENCE")) {
            Preference preference = PreferenceStore.INS.getPreference("DB_WRITE_NDEF_PREFERENCE");
            preference.remove("WRITE_NDEF_FROM_DB");
        }
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-804707261L));
        try {
            VBox ndefOperationParentVBox = (VBox)fxmlLoader.load();
            this.mNdefOperationsController = (NdefOperationsController)fxmlLoader.getController();
            this.mNdefOperationsController.setParentController(this);
            this.parentCenterContainerVBox.getChildren().add((Object)ndefOperationParentVBox);
        }
        catch (IOException e2) {
            LOG.b("", e2);
        }
    }

    @Override
    public void showNTAGOperationView() {
        this.parentCenterContainerVBox.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(1180630090L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.mNTagSpecificOperationsController = (g.d)fxmlLoader.getController();
            this.mNTagSpecificOperationsController.a(this);
            this.parentCenterContainerVBox.getChildren().add((Object)load);
        }
        catch (IOException e2) {
            LOG.b("", e2);
        }
    }

    @Override
    public void showCardNotSupportedError() {
        this.connectToTagButton.setSelected(false);
        TagXplorerUtility.createAlert("Tag is not supported.", Alert.AlertType.INFORMATION, "Information");
        s.f.a().d("Tag is not supported.");
    }

    @Override
    public void showReaderNotSupportedError() {
        this.connectToReaderButton.setSelected(false);
        TagXplorerUtility.createAlert("Reader is not supported.", Alert.AlertType.INFORMATION, "Information");
        s.f.a().d("Reader is not supported.");
    }

    @Override
    public void showReaderNotSelectedError() {
        this.connectToReaderButton.setSelected(false);
        this.connectToTagButton.setSelected(false);
        TagXplorerUtility.createAlert("No supported reader available.", Alert.AlertType.WARNING, "Warning");
        s.f.a().d("No supported reader available.");
    }

    @Override
    public void showErrorWhileComminicatingWithSmartCard() {
        TagXplorerUtility.createAlert("Operation failed with unknown error", Alert.AlertType.ERROR, "Error");
    }

    @Override
    public void showTagNotPresentError() {
        this.connectToTagButton.setSelected(false);
        TagXplorerUtility.createAlert("Tag is not available.", Alert.AlertType.WARNING, "Warning");
        s.f.a().d("Tag is not available.");
        this.disableButton();
    }

    @Override
    public void showAbout() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("About");
        alert.setHeaderText("TagXplorer by NXP");
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.getStylesheets().add((Object)RLoader.loadCSS(-479659884L).toExternalForm());
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        stage.initOwner(this.aboutButton.getScene().getWindow());
        stage.getIcons().add((Object)new Image(RLoader.loadImage(1167501271L)));
        ImageView icon = new ImageView();
        icon.setImage(new Image(RLoader.loadImage(402450084L)));
        alert.setGraphic((Node)icon);
        alert.setContentText(TagXplorerConstants.TAGXPLORER_ABOUT_CONTENT);
        alert.show();
    }

    @Override
    public void readerInitializedSuccessfully() {
        this.connectToReaderButton.setText("Disconnect Reader");
        this.connectToReaderButton.setUserData((Object)Boolean.TRUE);
        s.f.a().c("Reader Connected Successfully");
    }

    @Override
    public void readerDisconnectedSuccessfully() {
        this.connectToReaderButton.setText("Connect Reader");
        this.connectToReaderButton.setUserData((Object)Boolean.FALSE);
        this.connectToReaderButton.setSelected(false);
        s.f.a().c("Reader Disconnected Successfully");
    }

    @Override
    public void cardConnectedSuccessfully() {
        this.connectToTagButton.setText("Disconnect Tag");
        this.connectToTagButton.setUserData((Object)Boolean.TRUE);
        s.f.a().c("Tag Connected Successfully");
        this.enablebutton();
        this.showConnectedTagDetails(f.a.y());
    }

    @Override
    public void cardDisconnectedSuccessfully() {
        this.connectToTagButton.setText("Connect Tag");
        this.connectToTagButton.setUserData((Object)Boolean.FALSE);
        this.connectToTagButton.setSelected(false);
        s.f.a().c("Tag Disconnected Successfully");
        this.disableButton();
        this.clearOperationManagers();
        this.clearConnectedTagDetails();
    }

    private void clearOperationManagers() {
        h.f.c();
        r.f();
        h.d();
        j.g();
        p.e();
        t.g();
        T.d();
        U.b();
    }

    @Override
    public void connectDisconnectSmartCard() {
        if (this.connectToTagButton.getUserData() == Boolean.TRUE) {
            this.mPresenter.disconnectFromSmartCard();
        } else if (this.connectToReaderButton.getUserData() == Boolean.TRUE) {
            this.mPresenter.connectToSmartCard();
        } else {
            this.connectToTagButton.setSelected(false);
            TagXplorerUtility.createAlert("Please connect to the reader before connecting to the tag.", Alert.AlertType.WARNING, "Warning");
        }
        if (null != this.mNTagSpecificOperationsController) {
            this.mNTagSpecificOperationsController.k();
        }
    }

    @Override
    public void readerComboBoxIsShown() {
        this.chooseReader.setVisibleRowCount(5);
        this.refreshSmartCardReaderList();
    }

    @Override
    public void disconnectFromTag() {
        this.connectToTagButton.fire();
    }

    private void enablebutton() {
        CardType cardType = f.a.y();
        boolean isNTagFamilyTag = CardType.NTag203X == cardType || CardType.NTag210 == cardType || CardType.NTag210u == cardType || CardType.NTag213 == cardType || CardType.NTag215 == cardType || CardType.NTag216 == cardType || CardType.NTagI2C1K == cardType || CardType.NTagI2C2K == cardType || CardType.NTagI2CPlus1K == cardType || CardType.NTagI2CPlus2K == cardType || CardType.NTag413DNA == cardType || CardType.NTag213TagTamper == cardType || CardType.NTAG424DNA == cardType || CardType.NTAG424DNATagTamper == cardType;
        this.ndefOperationRadioButton.setDisable(false);
        if (null != this.mNdefOperationsController) {
            this.mNdefOperationsController.disableButtons(false);
        }
        if (isNTagFamilyTag) {
            this.ntagOperationRadioButton.setDisable(false);
        } else {
            this.ndefOperationRadioButton.fire();
        }
        ObservableList nodes = this.parentCenterContainerVBox.getChildren();
        for (Node node : nodes) {
            node.setDisable(false);
        }
    }

    private void disableButton() {
        this.ntagOperationRadioButton.setDisable(true);
        this.ndefOperationRadioButton.setDisable(true);
        if (null != this.mNdefOperationsController) {
            this.mNdefOperationsController.disableButtons(true);
        }
        ObservableList nodes = this.parentCenterContainerVBox.getChildren();
        for (Node node : nodes) {
            node.setDisable(true);
        }
    }

    private void showConnectedTagDetails(CardType connectedTag) {
        String icType = TagXplorerConstants.brandNameOfIcType.get((Object)connectedTag);
        g.a tagType = TagXplorerConstants.tagType.get((Object)connectedTag);
        Integer userMemory = TagXplorerConstants.userMemoryMap.get((Object)connectedTag);
        this.connectedTagStatusLabel.setText("Connected");
        this.icTypeLabel.setText(icType);
        this.tagTypeLabel.setText(tagType != null ? tagType.a() : "-");
        this.userMemoryLabel.setText(userMemory != null ? Integer.toString(userMemory) : "-");
    }

    private void clearConnectedTagDetails() {
        this.connectedTagStatusLabel.setText("Disconnected");
        this.icTypeLabel.setText("");
        this.tagTypeLabel.setText("");
        this.userMemoryLabel.setText("");
    }

    private static class AvailableReader {
        private final String name;
        private final boolean supported;

        public AvailableReader(String name, boolean supported) {
            this.name = name;
            this.supported = supported;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }
}

