/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.contract.ISplashSceneContract;
import com.nxp.tagxplorer.controller.presenter.SplashScenePresenter;
import com.nxp.tagxplorer.controller.view.BaseScene;
import com.nxp.tagxplorer.res.RLoader;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class SplashFXMLController
extends BaseScene
implements ISplashSceneContract.IScene,
Initializable {
    @FXML
    private StackPane rootPane;
    @FXML
    private ProgressBar splashProgressBar;
    @FXML
    private Label initStatus;
    private ISplashSceneContract.IPresenter presenter;

    public void initialize(URL url, ResourceBundle rb) {
        this.presenter = new SplashScenePresenter();
        this.presenter.onSceneActive(this);
        this.loadApplicationConfiguration();
    }

    @Override
    public void loadApplicationConfiguration() {
        this.presenter.loadApplicationConfiguration();
    }

    @Override
    public void showEULAScreen() {
        try {
            Parent root = (Parent)FXMLLoader.load((URL)RLoader.loadFXML(2139685L));
            root.getStylesheets().clear();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)RLoader.loadCSS(-1911323688L).toExternalForm());
            Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
            this.rootPane.getScene().getWindow().hide();
            Stage stage = new Stage();
            stage.setWidth(primaryScreenBounds.getWidth());
            stage.setHeight(primaryScreenBounds.getHeight());
            stage.setTitle("TagXplorer v" + TagXplorerConstants.APP_VERSION + " by NXP");
            stage.setResizable(true);
            stage.centerOnScreen();
            stage.getIcons().add((Object)new Image(RLoader.loadImage(1167501271L)));
            stage.setScene(scene);
            stage.initOwner(this.rootPane.getScene().getWindow());
            stage.show();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showTagXplorerMainScreen() {
        try {
            Parent root = (Parent)FXMLLoader.load((URL)RLoader.loadFXML(2079700600L));
            root.getStylesheets().clear();
            Scene scene = new Scene(root);
            Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
            if (primaryScreenBounds.getWidth() <= 1366.0 && primaryScreenBounds.getHeight() <= 768.0) {
                scene.getStylesheets().add((Object)RLoader.loadCSS(928652472L).toExternalForm());
            } else if (primaryScreenBounds.getWidth() <= 1600.0 && primaryScreenBounds.getHeight() <= 900.0) {
                scene.getStylesheets().add((Object)RLoader.loadCSS(-881118085L).toExternalForm());
            } else {
                scene.getStylesheets().add((Object)RLoader.loadCSS(287673610L).toExternalForm());
            }
            this.rootPane.getScene().getWindow().hide();
            Stage stage = new Stage();
            stage.setResizable(true);
            stage.setWidth(primaryScreenBounds.getWidth());
            stage.setTitle("TagXplorer v" + TagXplorerConstants.APP_VERSION + " by NXP");
            stage.setHeight(primaryScreenBounds.getHeight());
            stage.centerOnScreen();
            stage.getIcons().add((Object)new Image(RLoader.loadImage(1167501271L)));
            stage.setScene(scene);
            stage.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void updateProgerssBar(double value, final String message) {
        this.splashProgressBar.setProgress(value);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SplashFXMLController.this.initStatus.setText(null != message ? message : "");
            }
        });
    }
}

