/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.SMSRecordEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.ISMSRecordContract;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.d;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class SMSRecordController
extends AbstractController
implements IRecordGenerator,
ISMSRecordContract.IScene {
    @FXML
    private TextField smsDescription;
    @FXML
    private TextField smsMobileNumber;
    @FXML
    private VBox smsMainVBox;
    @FXML
    private TextArea smsMessage;
    @FXML
    private Button clearDescriptionButton;
    @FXML
    private Button clearNumberButton;
    @FXML
    private Button clearMessageButton;
    private WriteNdefController mWriteNdefController;
    private String descEmpty = "";
    private String mobileEmpty = "";
    private String msgEmtpty = "";

    public String getSMSDescriptionText() {
        return this.smsDescription.getText();
    }

    public String getSMSPhoneNumber() {
        return this.smsMobileNumber.getText();
    }

    public String getSMSMessage() {
        return this.smsMessage.getText();
    }

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        SMSRecordEventHandler eventHandler = new SMSRecordEventHandler(this);
        this.clearDescriptionButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.clearNumberButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.clearMessageButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.smsDescription.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SMSRecordController.this.descEmpty = newValue;
                SMSRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                SMSRecordController.this.isRecordEmpty();
            }
        });
        this.smsMobileNumber.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SMSRecordController.this.mobileEmpty = newValue;
                SMSRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                SMSRecordController.this.isRecordEmpty();
            }
        });
        this.smsMessage.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SMSRecordController.this.msgEmtpty = newValue;
                SMSRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                SMSRecordController.this.isRecordEmpty();
            }
        });
    }

    @Override
    public void initializeDefaults() {
    }

    @Override
    public void clearDescription() {
        this.smsDescription.setText("");
    }

    @Override
    public void clearNumber() {
        this.smsMobileNumber.setText("");
    }

    @Override
    public void clearMessage() {
        this.smsMessage.setText("");
    }

    private void isRecordEmpty() {
        if (this.descEmpty.length() == 0 && this.mobileEmpty.length() == 0 && this.msgEmtpty.length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        }
    }

    @Override
    public IRecord generateRecord() {
        String desc = this.smsDescription.getText();
        String smsAddress = this.smsMobileNumber.getText();
        String smsBody = this.smsMessage.getText();
        String uriString = smsAddress.isEmpty() ? "" : String.format("sms:%s?body=%s", smsAddress, smsBody);
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString);
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.SMS_RECORD);
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
        }
        return generateRecord;
    }

    @Override
    public void initializeListener() {
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null) {
            String description = null;
            LinkRecord linkRecord = null;
            if (record instanceof SmartPosterRecord) {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                description = posterRecord.getTextRecord().getInputText();
                linkRecord = posterRecord.getLinkRecord();
            } else if (record instanceof LinkRecord) {
                linkRecord = (LinkRecord)record;
            }
            if (description != null) {
                this.smsDescription.setText(description);
            }
            if (linkRecord != null) {
                this.smsMobileNumber.setText(d.a(linkRecord.getInputUriString()));
                this.smsMessage.setText(d.c(linkRecord.getInputUriString()));
            }
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }
}

