/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import b.b;
import b.e;
import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.NdefOperationsController;
import com.nxp.tagxplorer.controller.RecordHistoryEventHandler;
import com.nxp.tagxplorer.controller.ScreenDimenstion;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IRecordHistoryContract;
import com.nxp.tagxplorer.database.DBManager;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.RecordsHistory;
import com.nxp.tagxplorer.res.RLoader;
import com.nxp.tagxplorer.utility.Preference;
import com.nxp.tagxplorer.utility.PreferenceStore;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.GsonUtil;
import com.nxp.tagxplorer.utility.gson.IRecord;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.Callback;

public class RecordsHistoryController
extends AbstractController
implements e,
IRecordHistoryContract.IScene {
    @FXML
    private TableView<RecordsHistory> recordView;
    @FXML
    private TableColumn<Integer, Integer> slNum;
    @FXML
    private TableColumn<RecordsHistory, String> recordType;
    @FXML
    private TableColumn<RecordsHistory, Integer> size;
    @FXML
    private TableColumn<RecordsHistory, String> recordData;
    @FXML
    private TableColumn<RecordsHistory, RecordsHistory> edit;
    @FXML
    private TableColumn<RecordsHistory, RecordsHistory> delete;
    @FXML
    private TableColumn<RecordsHistory, String> timeStamp;
    @FXML
    private VBox recordHistoryMainVBox;
    @FXML
    private HBox buttonHBox;
    @FXML
    private Button exportRecordButton;
    @FXML
    private Button clearRecordButton;
    private Button editButton;
    private ObservableList<RecordsHistory> oRecordList = FXCollections.observableArrayList();
    private ArrayList<RecordsHistory> recHistoryList = null;
    private RecordHistoryEventHandler eventHandler;
    private NdefOperationsController mParentController;

    @Override
    public void initializeViewDependencies() {
        this.eventHandler = new RecordHistoryEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
        double parentPaneWidth = ScreenDimenstion.INS.getNdefOperationContainerWidth();
        double parentPaneHeight = ScreenDimenstion.INS.getNdefOperationContainerHeight();
        this.recordHistoryMainVBox.setPrefSize(parentPaneWidth, parentPaneHeight);
        this.recordView.setPrefWidth(parentPaneWidth);
        this.recordView.setPrefHeight(parentPaneHeight * 0.7);
        this.recordData.setPrefWidth(parentPaneWidth * 0.4);
    }

    @Override
    public void initializeListeners() {
        this.exportRecordButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.clearRecordButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.slNum.setCellValueFactory((Callback)new PropertyValueFactory("slNum"));
        this.recordType.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.timeStamp.setCellFactory(col -> {
            TableCell<RecordsHistory, String> timestampCell = new TableCell<RecordsHistory, String>(){

                public void updateItem(String value, boolean empty) {
                    super.updateItem((Object)value, empty);
                    if (empty) {
                        this.setText("");
                    } else {
                        RecordsHistory recordsHistory = (RecordsHistory)RecordsHistoryController.this.recHistoryList.get(this.getIndex());
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String format = sdf.format(new Date(recordsHistory.getTimeStamp()));
                        this.setText(format);
                    }
                }
            };
            return timestampCell;
        });
        this.recordData.setCellValueFactory((Callback)new PropertyValueFactory("recordData"));
        this.size.setCellValueFactory((Callback)new PropertyValueFactory("size"));
        this.edit.setCellFactory(col -> {
            TableCell<RecordsHistory, RecordsHistory> writecell = new TableCell<RecordsHistory, RecordsHistory>(){

                public void updateItem(RecordsHistory recordHistory, boolean empty) {
                    super.updateItem((Object)recordHistory, empty);
                    if (empty) {
                        this.setGraphic(null);
                    } else {
                        Image imageEdit = new Image(RLoader.loadImage(-1960550726L));
                        RecordsHistoryController.this.editButton = new Button();
                        RecordsHistoryController.this.editButton.setGraphic((Node)new ImageView(imageEdit));
                        RecordsHistoryController.this.editButton.setStyle("-fx-background-color: null; -fx-text-fill: white;");
                        RecordsHistoryController.this.editButton.setOnAction(e2 -> {
                            Preference createPreference = PreferenceStore.INS.createPreference("DB_WRITE_NDEF_PREFERENCE");
                            RecordsHistory rec = (RecordsHistory)RecordsHistoryController.this.recHistoryList.get(this.getIndex());
                            IRecord iRecord = GsonUtil.fromJson(rec.getRecordData(), rec.getType());
                            if (iRecord == null) {
                                return;
                            }
                            AbstractRecord abstractRecord = (AbstractRecord)iRecord;
                            abstractRecord.setType(rec.getType());
                            createPreference.put("WRITE_NDEF_FROM_DB", abstractRecord);
                            Pane parentPane = (Pane)RecordsHistoryController.this.recordHistoryMainVBox.getParent();
                            parentPane.getChildren().clear();
                            try {
                                FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(597453110L));
                                Pane anchorPane = (Pane)fxmlLoader.load();
                                WriteNdefController writeNdefController = (WriteNdefController)fxmlLoader.getController();
                                writeNdefController.setParentController(RecordsHistoryController.this.mParentController);
                                parentPane.getChildren().add((Object)anchorPane);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        this.setGraphic((Node)RecordsHistoryController.this.editButton);
                    }
                }
            };
            return writecell;
        });
        this.delete.setCellFactory(col -> {
            Image imageDelete = new Image(RLoader.loadImage(-538642362L));
            final Button deleteButton = new Button();
            deleteButton.setGraphic((Node)new ImageView(imageDelete));
            deleteButton.setStyle("-fx-background-color: null; -fx-text-fill: white;");
            TableCell<RecordsHistory, RecordsHistory> deleteCell = new TableCell<RecordsHistory, RecordsHistory>(){

                public void updateItem(RecordsHistory recordHistory, boolean empty) {
                    super.updateItem((Object)recordHistory, empty);
                    if (empty) {
                        this.setGraphic(null);
                    } else {
                        this.setGraphic((Node)deleteButton);
                        deleteButton.setOnAction(e2 -> {
                            RecordsHistory rec = (RecordsHistory)this.getTableView().getItems().get(this.getIndex());
                            try {
                                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                                alert.setTitle("Confirmation");
                                alert.setHeaderText(null);
                                alert.setContentText("Do you really want to delete the record?");
                                DialogPane dialogPane = alert.getDialogPane();
                                dialogPane.getStylesheets().add((Object)RLoader.loadCSS(-479659884L).toExternalForm());
                                dialogPane.getStyleClass().add((Object)"myDialog");
                                Image conformImage = new Image(RLoader.loadImage(531447225L));
                                ImageView imageView = new ImageView(conformImage);
                                alert.setGraphic((Node)imageView);
                                Optional result = alert.showAndWait();
                                if (result.get() == ButtonType.OK) {
                                    DBManager.INS.deleteRecord(rec.getID());
                                    RecordsHistoryController.this.oRecordList = FXCollections.observableArrayList();
                                    RecordsHistoryController.this.initializeDefaults();
                                    TagXplorerUtility.createAlert("Record deleted successfully", Alert.AlertType.INFORMATION, "Information");
                                } else {
                                    alert.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        });
                    }
                }
            };
            return deleteCell;
        });
    }

    @Override
    public void initializeDefaults() {
        try {
            this.recHistoryList = (ArrayList)DBManager.INS.readAllRecords();
            this.oRecordList = FXCollections.observableArrayList(this.recHistoryList);
            this.recordView.setItems(this.oRecordList);
            this.clearRecordButton.setDisable(this.recHistoryList.size() <= 0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getData() {
        return null;
    }

    @Override
    public void exportAsCSV() {
        if (this.recordView.getItems().isEmpty()) {
            TagXplorerUtility.createAlert("No record available to save.", Alert.AlertType.INFORMATION, "Failure");
            return;
        }
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File fileToWrite = fileChooser.showSaveDialog(this.recordHistoryMainVBox.getScene().getWindow());
        if (fileToWrite == null) {
            return;
        }
        b service = new b();
        service.b(this.recHistoryList);
        service.a(fileToWrite);
        service.a(this);
        service.a(2003);
    }

    @Override
    public void onSuccess(int operationType, Object Response2) {
        TagXplorerUtility.createAlert("DataSet messsage saved successfully.", Alert.AlertType.INFORMATION, "Success");
    }

    @Override
    public void onFailed(int operationType) {
        TagXplorerUtility.createAlert("Failure while saving DataSet to File.", Alert.AlertType.INFORMATION, "Failure");
    }

    @Override
    public void onError(int operationType, Throwable e2) {
        TagXplorerUtility.createAlert("Error While saving DataSet to File.", Alert.AlertType.INFORMATION, "Error");
    }

    @Override
    public void clearMyDataSet() {
        try {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Confirmation");
            alert.setHeaderText(null);
            alert.setContentText("Do you really want to clear record history?");
            DialogPane dialogPane = alert.getDialogPane();
            dialogPane.getStylesheets().add((Object)RLoader.loadCSS(-479659884L).toExternalForm());
            dialogPane.getStyleClass().add((Object)"myDialog");
            Image conformImage = new Image(RLoader.loadImage(531447225L));
            ImageView imageView = new ImageView(conformImage);
            alert.setGraphic((Node)imageView);
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                DBManager.INS.truncateRecords();
                this.initializeDefaults();
            } else {
                alert.close();
            }
        }
        catch (SQLException e2) {
            TagXplorerUtility.createAlert("Unable to clear history", Alert.AlertType.ERROR, "Error");
        }
    }

    @Override
    public void setParentController(NdefOperationsController parentController) {
        this.mParentController = parentController;
    }
}

