/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.NdefOperationsController;
import com.nxp.tagxplorer.controller.ReadNDEFEventHandler;
import com.nxp.tagxplorer.controller.ScreenDimenstion;
import com.nxp.tagxplorer.controller.contract.IReadNdefContract;
import com.nxp.tagxplorer.controller.presenter.ReadNdefPresenter;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.g;
import java.io.File;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import s.f;

public class ReadNdefController
extends AbstractController
implements IReadNdefContract.IScene {
    @FXML
    private VBox readNDEFMainVBox;
    @FXML
    private TitledPane tagDetailsTitlePane;
    @FXML
    private TitledPane ccContentTitlePane;
    @FXML
    private TitledPane ndefContentTitlePane;
    @FXML
    private TitledPane ndefContentHEXTitlePane;
    @FXML
    private TextArea tagDetailsTextArea;
    @FXML
    private TextArea ccContentTextArea;
    @FXML
    private TextArea ndefContentTextArea;
    @FXML
    private TextArea ndefContentHEXTextArea;
    @FXML
    private Button readNDEFButton;
    @FXML
    private Button exportNDEFButton;
    @FXML
    private HBox firstPanelHBox;
    @FXML
    private HBox secondPanelHBox;
    @FXML
    private HBox thirdPanelHBox;
    private NdefOperationsController mParentController;
    private IReadNdefContract.IPresenter mPresenter;

    @Override
    public void initializeViewDependencies() {
        this.mPresenter = new ReadNdefPresenter();
        this.mPresenter.onSceneActive(this);
    }

    @Override
    public void initializeLayoutDimensions() {
        double parentPanePrefHeight = ScreenDimenstion.INS.getNdefOperationContainerHeight();
        double parentPanePrefWidth = ScreenDimenstion.INS.getNdefOperationContainerWidth();
        this.readNDEFMainVBox.setPrefWidth(ScreenDimenstion.INS.getNdefOperationContainerWidth());
        this.readNDEFMainVBox.setPrefHeight(ScreenDimenstion.INS.getNdefOperationContainerHeight());
        this.firstPanelHBox.prefWidthProperty().bind((ObservableValue)this.readNDEFMainVBox.prefWidthProperty());
        this.secondPanelHBox.prefWidthProperty().bind((ObservableValue)this.readNDEFMainVBox.prefWidthProperty());
        this.thirdPanelHBox.prefWidthProperty().bind((ObservableValue)this.readNDEFMainVBox.prefWidthProperty());
        this.firstPanelHBox.setPrefHeight(parentPanePrefHeight * 0.45);
        this.secondPanelHBox.setPrefHeight(parentPanePrefHeight * 0.45);
        this.thirdPanelHBox.setPrefHeight(parentPanePrefHeight * 0.1);
        this.tagDetailsTitlePane.setPrefWidth(parentPanePrefWidth * 0.5);
        this.tagDetailsTitlePane.setPrefHeight(this.firstPanelHBox.getPrefHeight());
        this.ccContentTitlePane.setPrefWidth(parentPanePrefWidth * 0.5);
        this.ccContentTitlePane.setPrefHeight(this.firstPanelHBox.getPrefHeight());
        this.ndefContentTitlePane.setPrefWidth(parentPanePrefWidth * 0.5);
        this.ndefContentTitlePane.setPrefHeight(this.firstPanelHBox.getPrefHeight());
        this.ndefContentHEXTitlePane.setPrefWidth(parentPanePrefWidth * 0.5);
        this.ndefContentHEXTitlePane.setPrefHeight(this.firstPanelHBox.getPrefHeight());
    }

    @Override
    public void initializeListeners() {
        ReadNDEFEventHandler eventHandler = new ReadNDEFEventHandler(this);
        this.readNDEFButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.exportNDEFButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
    }

    @Override
    public void initializeDefaults() {
    }

    @Override
    public void readNDEFRecord() {
        this.clearPreviousDataIfAny();
        if (!TagXplorerUtility.checkIfTagPresentAndConnected() && !TagXplorerUtility.isDisconnectedFromTag()) {
            this.mParentController.disconnectFromTag();
            return;
        }
        this.mParentController.toggleReadNdef(true);
        this.readNDEFButton.getStyleClass().add((Object)"ripple_background");
        this.readNDEFButton.setDisable(true);
        this.mPresenter.readNDEFRecord();
    }

    private void clearPreviousDataIfAny() {
        if (this.tagDetailsTextArea != null) {
            this.tagDetailsTextArea.clear();
        }
        if (this.ccContentTextArea != null) {
            this.ccContentTextArea.clear();
        }
        if (this.ndefContentTextArea != null) {
            this.ndefContentTextArea.clear();
        }
        if (this.ndefContentHEXTextArea != null) {
            this.ndefContentHEXTextArea.clear();
        }
    }

    @Override
    public void exportNDEFContent() {
        if (!(this.tagDetailsTextArea.getText().isEmpty() || this.ccContentTextArea.getText().isEmpty() || this.ndefContentTextArea.getText().isEmpty() || this.ndefContentHEXTextArea.getText().isEmpty())) {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("NDEF files (*.ndef)", new String[]{"*.ndef"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File fileToWrite = fileChooser.showSaveDialog(this.readNDEFMainVBox.getScene().getWindow());
            if (fileToWrite == null) {
                return;
            }
            this.mPresenter.exportNDEFContent(fileToWrite);
        }
    }

    @Override
    public void showCardNotNDEFFormatted() {
    }

    @Override
    public void showErrorWhileComminicatingWithSmartCard() {
    }

    @Override
    public void showReadNdefSuccessfull(List<IRecord> records) {
        this.readNDEFButton.getStyleClass().remove((Object)"ripple_background");
        this.readNDEFButton.setDisable(false);
        this.mParentController.toggleReadNdef(false);
        this.ndefContentTextArea.setText(g.a(records));
        this.tagDetailsTextArea.setText(g.m());
        this.ccContentTextArea.setText(g.n());
        this.ndefContentHEXTextArea.setText(g.k());
        f.a().a(records);
    }

    @Override
    public void showReadNdefFailed() {
        this.readNDEFButton.getStyleClass().remove((Object)"ripple_background");
        this.readNDEFButton.setDisable(false);
        this.mParentController.toggleReadNdef(false);
        TagXplorerUtility.createFailureAlert("Failed to read NDEF message...");
    }

    @Override
    public void showReadNdefError(String errorMessage) {
        this.readNDEFButton.getStyleClass().remove((Object)"ripple_background");
        this.readNDEFButton.setDisable(false);
        this.mParentController.toggleReadNdef(false);
        if (errorMessage != null) {
            if (errorMessage.contains("Tag has been removed, please reconnect and try again")) {
                this.mParentController.disconnectFromTag();
            }
        } else {
            errorMessage = "Operation failed with unknown error";
        }
        TagXplorerUtility.createErrorAlert(errorMessage);
        f.a().d(errorMessage);
    }

    @Override
    public void showExportSuccessfullMessage() {
        TagXplorerUtility.createInfoAlert("DataSet messsage saved successfully.", "Success");
    }

    @Override
    public void showExportFailedMessage() {
        TagXplorerUtility.createInfoAlert("Failure while saving DataSet to File.", "Failure");
    }

    @Override
    public void showExportErrorMessage() {
        TagXplorerUtility.createInfoAlert("Error While saving DataSet to File.", "Error");
    }

    @Override
    public void setParentController(NdefOperationsController obj) {
        this.mParentController = obj;
    }

    @Override
    public void disableReadButtons(boolean value) {
        this.readNDEFButton.setDisable(value);
    }
}

