/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.ProtectTagEventHandler;
import com.nxp.tagxplorer.controller.contract.IProtectTagContract;
import com.nxp.tagxplorer.controller.presenter.ProtectTagPresenter;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import s.f;

public class ProtectTagController
extends AbstractController
implements IProtectTagContract.IScene {
    @FXML
    private HBox chengeStateMainHBox;
    @FXML
    private Button readOnlyButton;
    @FXML
    private Button readWriteButton;
    private ProtectTagPresenter mPresenter;

    @Override
    public void initializeViewDependencies() {
        this.mPresenter = new ProtectTagPresenter();
        this.mPresenter.onSceneActive(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        ProtectTagEventHandler eventHandler = new ProtectTagEventHandler(this);
        this.readOnlyButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.readWriteButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
    }

    @Override
    public void initializeDefaults() {
    }

    @Override
    public void changeTagStateToReadWrite() {
        if (TagXplorerUtility.checkIfTagPresentAndConnected()) {
            this.readWriteButton.getStyleClass().add((Object)"ripple_background");
            this.mPresenter.onClickReadWrite();
        }
    }

    @Override
    public void changeTagStateToReadOnly() {
        if (TagXplorerUtility.checkIfTagPresentAndConnected()) {
            this.readOnlyButton.getStyleClass().add((Object)"ripple_background");
            this.mPresenter.onClickReadOnly();
        }
    }

    @Override
    public void onProtectSuccessful(String result) {
        this.removeRipple();
        TagXplorerUtility.createAlert(result, Alert.AlertType.INFORMATION, "Success");
        f.a().c("Success");
    }

    @Override
    public void onProtectFailure(String result) {
        this.removeRipple();
        TagXplorerUtility.createAlert(result, Alert.AlertType.ERROR, "Failure");
        f.a().e("Failure");
    }

    @Override
    public void onError(String errorMessage) {
        this.removeRipple();
        TagXplorerUtility.createAlert(errorMessage, Alert.AlertType.ERROR, "Error");
        f.a().d("Error");
    }

    @Override
    public void removeRipple() {
        this.readOnlyButton.getStyleClass().remove((Object)"ripple_background");
        this.readWriteButton.getStyleClass().remove((Object)"ripple_background");
    }
}

