/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.NDEFOperationSceneEventHandler;
import com.nxp.tagxplorer.controller.ReadNdefController;
import com.nxp.tagxplorer.controller.RecordsHistoryController;
import com.nxp.tagxplorer.controller.ScreenDimenstion;
import com.nxp.tagxplorer.controller.TagXplorerController;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.INdefOperationsContract;
import com.nxp.tagxplorer.controller.presenter.NdefOperationPresenter;
import com.nxp.tagxplorer.res.RLoader;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import java.io.IOException;
import java.net.URL;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import s.f;

public class NdefOperationsController
extends AbstractController
implements INdefOperationsContract.IScene {
    @FXML
    private Button readNDEFRadioButton;
    @FXML
    private Button writeNDEFRadioButton;
    @FXML
    private Button formatTagRadioButton;
    @FXML
    private Button changeStateRadioButton;
    @FXML
    private Button showHistoryRadioButton;
    @FXML
    private VBox ndefOperationParentVBox;
    @FXML
    private ImageView readTagImageView;
    @FXML
    private ImageView writeTagImageView;
    @FXML
    private ImageView changeStateImageView;
    @FXML
    private ImageView formatTagImageView;
    @FXML
    private ImageView historyImageView;
    @FXML
    private Pane datasetPane;
    @FXML
    private GridPane ndefOperationButtonGridPane;
    @FXML
    private VBox ndefOperationContainerVBox;
    @FXML
    private HBox ndefOperationButtonPanelHBox;
    @FXML
    private ToggleGroup ndefOperationToggleGroup;
    private TagXplorerController mParentController;
    private NdefOperationPresenter presenter = null;
    private ReadNdefController mReadNdefIns;
    private WriteNdefController mWriteNdefIns;

    @Override
    public void initializeViewDependencies() {
        this.presenter = new NdefOperationPresenter();
        this.presenter.onSceneActive(this);
    }

    @Override
    public void initializeLayoutDimensions() {
        this.ndefOperationParentVBox.setPrefWidth(ScreenDimenstion.INS.getNdefOperationParentVBoxWidth());
        this.ndefOperationParentVBox.setPrefHeight(ScreenDimenstion.INS.getNdefOperationParentVBoxHeight());
        this.ndefOperationButtonPanelHBox.setPrefWidth(ScreenDimenstion.INS.getNdefOperationButtonPanelWidth());
        this.ndefOperationButtonPanelHBox.setPrefHeight(ScreenDimenstion.INS.getNdefOperationButtonPanelHeight());
        this.ndefOperationContainerVBox.setPrefHeight(ScreenDimenstion.INS.getNdefOperationContainerHeight());
        this.ndefOperationContainerVBox.setPrefWidth(ScreenDimenstion.INS.getNdefOperationContainerWidth());
    }

    @Override
    public void initializeListeners() {
        NDEFOperationSceneEventHandler eventHandler = new NDEFOperationSceneEventHandler(this);
        this.readNDEFRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.writeNDEFRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.formatTagRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.changeStateRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.showHistoryRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
    }

    @Override
    public void initializeDefaults() {
        Image readTagImage = new Image(RLoader.loadImage(-867201679L));
        Image writeTagImage = new Image(RLoader.loadImage(-1405993158L));
        Image formatTagImage = new Image(RLoader.loadImage(2064331979L));
        Image changeStateImage = new Image(RLoader.loadImage(1216985755L));
        Image historyImage = new Image(RLoader.loadImage(926934164L));
        this.readTagImageView.setImage(readTagImage);
        this.writeTagImageView.setImage(writeTagImage);
        this.formatTagImageView.setImage(formatTagImage);
        this.changeStateImageView.setImage(changeStateImage);
        this.historyImageView.setImage(historyImage);
        this.showHistoryRadioButton.fire();
        if (TagXplorerUtility.isDisconnectedFromTag()) {
            this.disableButtons(true);
        }
    }

    @Override
    public void showReadNDEFView() {
        this.resetBtnBgColor();
        this.readNDEFRadioButton.setStyle("-fx-background-color:#F9B500;");
        this.ndefOperationContainerVBox.getChildren().clear();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-803111027L));
            VBox node = (VBox)fxmlLoader.load();
            node.getStylesheets().clear();
            this.mReadNdefIns = (ReadNdefController)fxmlLoader.getController();
            this.mReadNdefIns.setParentController(this);
            node.getStylesheets().add((Object)RLoader.loadCSS(-796828611L).toExternalForm());
            this.ndefOperationContainerVBox.getChildren().add((Object)node);
            f.a().f("Read NDEF");
            if (null != this.mParentController.getNTagSpecificOperationsController()) {
                this.mParentController.getNTagSpecificOperationsController().k();
            }
            this.mReadNdefIns.readNDEFRecord();
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showWriteNDEFView() {
        this.resetBtnBgColor();
        this.writeNDEFRadioButton.setStyle("-fx-background-color:#F9B500;");
        this.ndefOperationContainerVBox.getChildren().clear();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(597453110L));
            VBox borderPane = (VBox)fxmlLoader.load();
            this.mWriteNdefIns = (WriteNdefController)fxmlLoader.getController();
            this.mWriteNdefIns.setParentController(this);
            this.ndefOperationContainerVBox.getChildren().add((Object)borderPane);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showFormatTagView() {
        this.resetBtnBgColor();
        this.formatTagRadioButton.setStyle("-fx-background-color:#F9B500;");
        if (TagXplorerUtility.checkIfTagPresentAndConnected()) {
            this.formatTagRadioButton.getStyleClass().add((Object)"ripple_background");
            this.presenter.formatAsNDEF();
        }
    }

    @Override
    public void showChangeTagStateView() {
        this.resetBtnBgColor();
        this.changeStateRadioButton.setStyle("-fx-background-color:#F9B500;");
        this.ndefOperationContainerVBox.getChildren().clear();
        try {
            Node load = (Node)FXMLLoader.load((URL)RLoader.loadFXML(308586091L));
            this.ndefOperationContainerVBox.getChildren().add((Object)load);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showHistoryView() {
        this.resetBtnBgColor();
        this.showHistoryRadioButton.setStyle("-fx-background-color:#F9B500;");
        this.ndefOperationContainerVBox.getChildren().clear();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-207094766L));
            Node load = (Node)fxmlLoader.load();
            this.ndefOperationContainerVBox.getChildren().add((Object)load);
            RecordsHistoryController controller = (RecordsHistoryController)fxmlLoader.getController();
            controller.setParentController(this);
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onFormatSuccess() {
        this.removeRipple();
        TagXplorerUtility.createAlert("Format as NDEF successful", Alert.AlertType.INFORMATION, "Success");
        f.a().c("Format as NDEF successful");
    }

    @Override
    public void onFormatFailed() {
        this.removeRipple();
        TagXplorerUtility.createAlert("Format as NDEF failed", Alert.AlertType.ERROR, "Error");
        f.a().d("Format as NDEF failed");
    }

    @Override
    public void onError(Throwable e2) {
        this.removeRipple();
        String errorMessage = e2.getMessage();
        if (errorMessage != null && (errorMessage.contains("Card is Write Restricted") || errorMessage.contains("is Locked") || errorMessage.contains("Requires Authentication"))) {
            errorMessage = "Format protected";
        }
        TagXplorerUtility.createAlert(errorMessage, Alert.AlertType.ERROR, "Error");
        f.a().d(errorMessage);
    }

    @Override
    public void removeRipple() {
        this.formatTagRadioButton.getStyleClass().remove((Object)"ripple_background");
    }

    private void fadeInTransition() {
        FadeTransition ft = TagXplorerUtility.getFadeInTransitionInstance();
        ft.setNode((Node)this.ndefOperationContainerVBox);
        ft.play();
    }

    @Override
    public void setParentController(TagXplorerController obj) {
        this.mParentController = obj;
    }

    @Override
    public void disconnectFromTag() {
        this.mParentController.disconnectFromTag();
    }

    @Override
    public void toggleReadNdef(boolean toggleBtn) {
        this.readNDEFRadioButton.setDisable(toggleBtn);
    }

    @Override
    public void toggleWriteNdef(boolean toggleBtn) {
        this.writeNDEFRadioButton.setDisable(toggleBtn);
    }

    @Override
    public void disableButtons(boolean value) {
        this.writeNDEFRadioButton.setDisable(value);
        this.readNDEFRadioButton.setDisable(value);
        this.changeStateRadioButton.setDisable(value);
        this.formatTagRadioButton.setDisable(value);
        this.showHistoryRadioButton.setDisable(value);
        if (null != this.mWriteNdefIns) {
            this.mWriteNdefIns.disableWriteButtons(value);
        }
        if (null != this.mReadNdefIns) {
            this.mReadNdefIns.disableReadButtons(value);
        }
    }

    private void resetBtnBgColor() {
        this.readNDEFRadioButton.setStyle("-fx-background-color:#35989E;");
        this.writeNDEFRadioButton.setStyle("-fx-background-color:#35989E;");
        this.formatTagRadioButton.setStyle("-fx-background-color:#35989E;");
        this.changeStateRadioButton.setStyle("-fx-background-color:#35989E;");
        this.showHistoryRadioButton.setStyle("-fx-background-color:#35989E;");
    }
}

