/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import a.f;
import com.nxp.nfclib.CardType;
import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.NTagOperationEventHandler;
import com.nxp.tagxplorer.controller.TagXplorerController;
import com.nxp.tagxplorer.controller.contract.INTagOperationContract;
import com.nxp.tagxplorer.controller.presenter.NTagOperationPresenter;
import com.nxp.tagxplorer.res.RLoader;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.IRecord;
import java.io.IOException;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import t.c;
import t.d;

public class NTagOperationsController
extends AbstractController
implements INTagOperationContract.IScene {
    private static final c LOG = d.a(NTagOperationsController.class.getSimpleName());
    @FXML
    private RadioButton ntag210Button;
    @FXML
    private RadioButton ntag21xButton;
    @FXML
    private RadioButton ntag213ttButton;
    @FXML
    private RadioButton ntag413DnaButton;
    @FXML
    private RadioButton ntag424DnaButton;
    @FXML
    private RadioButton ntag424DnaTTButton;
    @FXML
    private Pane ntagOperationPane;
    @FXML
    private Button submitButton;
    @FXML
    private VBox ntagOperationMainVBox;
    @FXML
    private HBox ntagOperationButtonPanelHBox;
    private IRecordGenerator recordGenerator;
    private NTagOperationPresenter presenter;
    private NTagOperationEventHandler eventHandler;
    private TagXplorerController mParentController;
    private CardType mCardExpected;

    @Override
    public void initializeViewDependencies() {
        this.presenter = new NTagOperationPresenter();
        this.presenter.onSceneActive(this);
        this.eventHandler = new NTagOperationEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        this.ntag210Button.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.ntag21xButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.ntag213ttButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.ntag413DnaButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.ntag424DnaButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.ntag424DnaTTButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.submitButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
    }

    @Override
    public void initializeDefaults() {
        this.ntag210Button.getStyleClass().remove((Object)"radio-button");
        this.ntag210Button.getStyleClass().add((Object)"toggle-button");
        this.ntag21xButton.getStyleClass().remove((Object)"radio-button");
        this.ntag21xButton.getStyleClass().add((Object)"toggle-button");
        this.ntag213ttButton.getStyleClass().remove((Object)"radio-button");
        this.ntag213ttButton.getStyleClass().add((Object)"toggle-button");
        this.ntag413DnaButton.getStyleClass().remove((Object)"radio-button");
        this.ntag413DnaButton.getStyleClass().add((Object)"toggle-button");
        this.ntag424DnaButton.getStyleClass().remove((Object)"radio-button");
        this.ntag424DnaButton.getStyleClass().add((Object)"toggle-button");
        this.ntag424DnaTTButton.getStyleClass().remove((Object)"radio-button");
        this.ntag424DnaTTButton.getStyleClass().add((Object)"toggle-button");
        switch (f.a.y()) {
            case NTag210: {
                this.ntag210Button.fire();
                break;
            }
            case NTag213: 
            case NTag215: 
            case NTag216: {
                this.ntag21xButton.fire();
                break;
            }
            case NTag213TagTamper: {
                this.ntag213ttButton.fire();
                break;
            }
            case NTag413DNA: {
                this.ntag413DnaButton.fire();
                break;
            }
            case NTAG424DNA: {
                this.ntag424DnaButton.fire();
                break;
            }
            case NTAG424DNATagTamper: {
                this.ntag424DnaTTButton.fire();
                break;
            }
            default: {
                this.ntag21xButton.fire();
            }
        }
    }

    @Override
    public void showNTag210View() {
        this.mCardExpected = CardType.NTag210;
        this.setDefaultColorsToButton();
        this.ntag210Button.setStyle("-fx-background-color:#F9B500;");
        this.ntagOperationPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-1911960336L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.ntagOperationPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showNTag21xView() {
        this.mCardExpected = CardType.NTag213;
        this.setDefaultColorsToButton();
        this.ntag21xButton.setStyle("-fx-background-color:#F9B500;");
        this.ntagOperationPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-954760404L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.ntagOperationPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showNTag213TTView() {
        this.mCardExpected = CardType.NTag213TagTamper;
        this.setDefaultColorsToButton();
        this.ntag213ttButton.setStyle("-fx-background-color:#F9B500;");
        this.ntagOperationPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(59134669L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.ntagOperationPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showNTag413DNAView() {
        this.mCardExpected = CardType.NTag413DNA;
        this.setDefaultColorsToButton();
        this.ntag413DnaButton.setStyle("-fx-background-color:#F9B500;");
        this.ntagOperationPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(-410618744L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.ntagOperationPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.fadeInTransition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void showNTag424DnaView() {
        this.mCardExpected = CardType.NTAG424DNA;
        this.setDefaultColorsToButton();
        this.ntag424DnaButton.setStyle("-fx-background-color:#F9B500;");
        this.ntagOperationPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(2057643176L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.ntagOperationPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.fadeInTransition();
        }
        catch (IOException e2) {
            LOG.e("", e2);
        }
    }

    @Override
    public void showNTag424DnaTTView() {
        this.mCardExpected = CardType.NTAG424DNATagTamper;
        this.setDefaultColorsToButton();
        this.ntag424DnaTTButton.setStyle("-fx-background-color:#F9B500;");
        this.ntagOperationPane.getChildren().clear();
        FXMLLoader fxmlLoader = new FXMLLoader(RLoader.loadFXML(80516075L));
        try {
            VBox load = (VBox)fxmlLoader.load();
            this.ntagOperationPane.getChildren().add((Object)load);
            this.recordGenerator = (IRecordGenerator)fxmlLoader.getController();
            this.fadeInTransition();
        }
        catch (IOException e2) {
            LOG.e("", e2);
        }
    }

    @Override
    public void enableMirroring() {
        String status;
        if (this.mCardExpected == CardType.NTag213 ? !TagXplorerUtility.verifyIfTagPresentAndTypesAndhandleError("Tag is not of type NTAG 21x ", CardType.NTag213F, CardType.NTag213, CardType.NTag215, CardType.NTag216, CardType.NTag216F) : !TagXplorerUtility.verifyIfTagPresentAndTypeAndhandleError(this.mCardExpected)) {
            return;
        }
        IRecord generatedRecord = this.recordGenerator.generateRecord();
        if (null != generatedRecord && (status = this.validateRecord(generatedRecord)).equalsIgnoreCase("VALID_RECORD")) {
            this.enableRippleEffect();
            this.presenter.writeNDEFRecord(generatedRecord);
        }
    }

    @Override
    public String validateRecord(IRecord record) {
        return this.presenter.validateRecord(record);
    }

    @Override
    public void onSuccess() {
        TagXplorerUtility.createAlert("NDEF message written successfully!", Alert.AlertType.INFORMATION, "Success");
        this.disableRippleEffect();
    }

    @Override
    public void onFailure() {
        TagXplorerUtility.createAlert("Failed to write NDEF message...", Alert.AlertType.ERROR, "Failure");
        this.disableRippleEffect();
    }

    @Override
    public void onError(String errorMessage) {
        if (errorMessage != null && (errorMessage.contains("No response bytes") || errorMessage.contains("Card has been removed") || errorMessage.contains("frame cannot be null"))) {
            errorMessage = "Tag has been removed, please reconnect and try again";
        } else if (errorMessage == null || errorMessage.isEmpty()) {
            errorMessage = "Operation failed with unknown error";
        }
        TagXplorerUtility.createAlert(errorMessage, Alert.AlertType.ERROR, "Error");
        this.disableRippleEffect();
    }

    private void disableRippleEffect() {
        this.submitButton.getStyleClass().remove((Object)"ripple_background");
    }

    private void enableRippleEffect() {
        this.submitButton.getStyleClass().add((Object)"ripple_background");
    }

    private void fadeInTransition() {
        FadeTransition ft = TagXplorerUtility.getFadeInTransitionInstance();
        ft.setNode((Node)this.ntagOperationPane);
        ft.play();
    }

    @Override
    public void setParentTagXplorerController(TagXplorerController controller) {
        this.mParentController = controller;
    }

    @Override
    public void disableNtagButtons(boolean value) {
        this.submitButton.setDisable(value);
    }

    private void setDefaultColorsToButton() {
        this.ntag210Button.setStyle("-fx-background-color:#35989E;");
        this.ntag21xButton.setStyle("-fx-background-color:#35989E;");
        this.ntag213ttButton.setStyle("-fx-background-color:#35989E;");
        this.ntag413DnaButton.setStyle("-fx-background-color:#35989E;");
        this.ntag424DnaButton.setStyle("-fx-background-color:#35989E;");
        this.ntag424DnaTTButton.setStyle("-fx-background-color:#35989E;");
    }
}

