/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import c.d;
import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.NTag424DnaTTEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.INTag424DnaTTContract;
import com.nxp.tagxplorer.controller.mirror.MirrorUriBuilder;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.MirrorFlags;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.CommonMirrorPlaceholder;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.k;
import java.util.function.UnaryOperator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import q.b;
import t.c;

public class NTag424DnaTTController
extends AbstractController
implements IRecordGenerator,
INTag424DnaTTContract.IScene {
    private static final c LOG = t.d.a(NTag424DnaTTController.class.getSimpleName());
    private static final String PROTOCOL_TYPE = "Please select protocol type from dropdown";
    private static final int DEFAULT_MAC_INPUT_OFFSET = 7;
    @FXML
    private CheckBox sunMessageCheckBox;
    @FXML
    private CheckBox uidCheckBox;
    @FXML
    private ComboBox<String> uriPrefixComboBox;
    @FXML
    private TextField descriptionTextField;
    @FXML
    private GridPane gridPane;
    @FXML
    private TextField uriTextField;
    @FXML
    private CheckBox interationCntrCheckBox;
    @FXML
    private TextField offsetIndexTextField;
    @FXML
    private CheckBox tagTamperStatusCheckBox;
    @FXML
    private RadioButton aesAuthModeRadioButton;
    @FXML
    private RadioButton lrpAuthModeRadioButton;
    @FXML
    private CheckBox piccDataCheckBox;
    @FXML
    private CheckBox encFileDataCheckBox;
    @FXML
    private TextField encFileDataInput;
    @FXML
    private Label encFileDataLengthLabel;
    @FXML
    private Label uriLengthLabel;
    private NTag424DnaTTEventHandler eventHandler;

    @Override
    public void initializeViewDependencies() {
        this.eventHandler = new NTag424DnaTTEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        this.uidCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.interationCntrCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.piccDataCheckBox.addEventFilter(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.tagTamperStatusCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.encFileDataCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.sunMessageCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.aesAuthModeRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.lrpAuthModeRadioButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.uriPrefixComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                NTag424DnaTTController.this.offsetIndexTextField.setText(String.valueOf(7 + NTag424DnaTTController.this.uriTextField.getCaretPosition()));
                NTag424DnaTTController.this.uriPrefixComboBox.setStyle("-fx-border-color:lightgray;");
            }
        });
        this.uriTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                NTag424DnaTTController.this.updateUriLength();
            }
        });
        this.uriTextField.setOnMouseClicked(e2 -> this.offsetIndexTextField.setText(String.valueOf(7 + this.uriTextField.getCaretPosition())));
        this.encFileDataInput.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                NTag424DnaTTController.this.updateEncFileDataLength();
                NTag424DnaTTController.this.updateUriTextField();
            }
        });
        this.piccDataCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isSelected) {
                NTag424DnaTTController.this.uidCheckBox.setDisable(isSelected.booleanValue());
                NTag424DnaTTController.this.interationCntrCheckBox.setDisable(isSelected.booleanValue());
            }
        });
        this.uidCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isSelected) {
                boolean disablePiccData = isSelected != false || NTag424DnaTTController.this.interationCntrCheckBox.isSelected();
                NTag424DnaTTController.this.piccDataCheckBox.setDisable(disablePiccData);
            }
        });
        this.interationCntrCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean isSelected) {
                boolean disablePiccData = isSelected != false || NTag424DnaTTController.this.uidCheckBox.isSelected();
                NTag424DnaTTController.this.piccDataCheckBox.setDisable(disablePiccData);
            }
        });
    }

    @Override
    public void initializeDefaults() {
        this.uriPrefixComboBox.setItems(b.d());
        this.encFileDataInput.setTextFormatter(new TextFormatter((UnaryOperator)new d()));
        this.updateEncFileDataLength();
        this.updateUriLength();
    }

    @Override
    public IRecord generateRecord() {
        String desc = this.descriptionTextField.getText();
        String uriPreFix = (String)this.uriPrefixComboBox.getValue();
        if (uriPreFix == null || uriPreFix.isEmpty()) {
            TagXplorerUtility.createAlert(PROTOCOL_TYPE, Alert.AlertType.WARNING, "Warning");
            this.uriPrefixComboBox.setStyle("-fx-border-color:red;-fx-border-width:2px;");
            return null;
        }
        String uriString = uriPreFix + this.uriTextField.getText();
        MirrorFlags mirrorFlags = new MirrorFlags();
        mirrorFlags.setUidMirror(this.uidCheckBox.isSelected());
        mirrorFlags.setCounterMirror(this.interationCntrCheckBox.isSelected());
        mirrorFlags.setCmacMirror(this.sunMessageCheckBox.isSelected());
        mirrorFlags.setTtStatusMirror(this.tagTamperStatusCheckBox.isSelected());
        mirrorFlags.setPiccDataMirror(this.piccDataCheckBox.isSelected());
        mirrorFlags.setEncryptedFileDataMirror(this.encFileDataCheckBox.isSelected());
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString);
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.LINK_RECORD);
            LinkRecord linkRecord = (LinkRecord)generateRecord;
            linkRecord.setMirrorFlags(mirrorFlags);
            generateRecord = linkRecord;
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
            SmartPosterRecord smartPosterRecord = (SmartPosterRecord)generateRecord;
            smartPosterRecord.getLinkRecord().setMirrorFlags(mirrorFlags);
            generateRecord = smartPosterRecord;
        }
        return generateRecord;
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null) {
            LinkRecord linkRecord = null;
            if (record instanceof SmartPosterRecord) {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                this.descriptionTextField.setText(posterRecord.getTextRecord().getInputText());
                linkRecord = posterRecord.getLinkRecord();
            } else if (record instanceof LinkRecord) {
                linkRecord = (LinkRecord)record;
            }
            if (linkRecord == null) {
                return;
            }
            this.uriTextField.setText(linkRecord.getInputUriString());
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
    }

    @Override
    public void updateUriTextField() {
        MirrorUriBuilder mirrorUriBuilder = MirrorUriBuilder.forUri(this.uriTextField.getText());
        if (this.piccDataCheckBox.isSelected()) {
            mirrorUriBuilder.add(this.isAesMode() ? CommonMirrorPlaceholder.PICCDATA_AES : CommonMirrorPlaceholder.PICCDATA_LRP);
        } else {
            if (this.uidCheckBox.isSelected()) {
                mirrorUriBuilder.add(CommonMirrorPlaceholder.UID);
            }
            if (this.interationCntrCheckBox.isSelected()) {
                mirrorUriBuilder.add(CommonMirrorPlaceholder.COUNTER);
            }
        }
        if (this.tagTamperStatusCheckBox.isSelected()) {
            mirrorUriBuilder.add(CommonMirrorPlaceholder.TAG_TAMPER_STATUS);
        }
        if (this.encFileDataCheckBox.isSelected()) {
            mirrorUriBuilder.add(CommonMirrorPlaceholder.encryptedFileDataPlaceholder(this.encFileDataInput.getText()));
        }
        if (this.sunMessageCheckBox.isSelected()) {
            mirrorUriBuilder.add(CommonMirrorPlaceholder.MAC);
        }
        LOG.a("Set uri to {}", (Object)mirrorUriBuilder.getMirrorUri());
        this.uriTextField.setText(mirrorUriBuilder.getMirrorUri());
    }

    private void updateUriLength() {
        this.uriLengthLabel.setText("" + this.uriTextField.getText().length());
    }

    private void updateEncFileDataLength() {
        this.encFileDataLengthLabel.setText("" + this.encFileDataInput.getText().length());
    }

    private boolean isAesMode() {
        return this.aesAuthModeRadioButton.isSelected();
    }
}

