/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.NTag413DnaEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.INTag413DNAContract;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.MirrorFlags;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import q.b;

public class NTag413DNAController
extends AbstractController
implements IRecordGenerator,
INTag413DNAContract.IScene {
    private static final String PROTOCOL_TYPE = "Please select protocol type from dropdown";
    ObservableList<String> sdmCtrKeyList = FXCollections.observableArrayList((Object[])new String[]{"0", "1", "2", "E", "F"});
    ObservableList<String> sdmFileReadKeyList = FXCollections.observableArrayList((Object[])new String[]{"0", "1", "2", "F"});
    @FXML
    private CheckBox sunMessageCheckBox;
    @FXML
    private CheckBox uidCheckBox;
    @FXML
    private ComboBox<String> uriPrefixComboBox;
    @FXML
    private TextField descriptionTextField;
    @FXML
    private GridPane gridPane;
    @FXML
    private TextField uriTextField;
    @FXML
    private VBox ntag413OpMainVBox;
    @FXML
    private CheckBox interationCntrCheckBox;
    @FXML
    private TextField offsetIndexTextField;
    private NTag413DnaEventHandler eventHandler;

    @Override
    public void initializeViewDependencies() {
        this.eventHandler = new NTag413DnaEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        this.uidCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.interationCntrCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.sunMessageCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.uriPrefixComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String oldValue, String newValue) {
                NTag413DNAController.this.offsetIndexTextField.setText(String.valueOf(7 + NTag413DNAController.this.uriTextField.getCaretPosition()));
                NTag413DNAController.this.uriPrefixComboBox.setStyle("-fx-border-color:lightgray;");
            }
        });
        this.uriTextField.setOnMouseClicked(e2 -> this.offsetIndexTextField.setText(String.valueOf(7 + this.uriTextField.getCaretPosition())));
    }

    @Override
    public void initializeDefaults() {
        this.uriPrefixComboBox.setItems(b.d());
        this.showSDMAndCtrMirroringOptions(false, false);
    }

    @Override
    public IRecord generateRecord() {
        String desc = this.descriptionTextField.getText();
        String uriPreFix = (String)this.uriPrefixComboBox.getValue();
        if (null == uriPreFix || uriPreFix.isEmpty()) {
            TagXplorerUtility.createAlert(PROTOCOL_TYPE, Alert.AlertType.WARNING, "Warning");
            this.uriPrefixComboBox.setStyle("-fx-border-color:red;-fx-border-width:2px;");
            return null;
        }
        String uriString = uriPreFix + this.uriTextField.getText();
        MirrorFlags mirrorFlags = new MirrorFlags();
        mirrorFlags.setUidMirror(this.uidCheckBox.isSelected());
        mirrorFlags.setCounterMirror(this.interationCntrCheckBox.isSelected());
        mirrorFlags.setCmacMirror(this.sunMessageCheckBox.isSelected());
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString);
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.LINK_RECORD);
            LinkRecord linkRecord = (LinkRecord)generateRecord;
            linkRecord.setMirrorFlags(mirrorFlags);
            generateRecord = linkRecord;
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
            SmartPosterRecord smartPosterRecord = (SmartPosterRecord)generateRecord;
            smartPosterRecord.getLinkRecord().setMirrorFlags(mirrorFlags);
            generateRecord = smartPosterRecord;
        }
        return generateRecord;
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null) {
            LinkRecord linkRecord = null;
            if (record instanceof SmartPosterRecord) {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                this.descriptionTextField.setText(posterRecord.getTextRecord().getInputText());
                linkRecord = posterRecord.getLinkRecord();
            } else if (record instanceof LinkRecord) {
                linkRecord = (LinkRecord)record;
            }
            if (linkRecord == null) {
                return;
            }
            this.uriTextField.setText(linkRecord.getInputUriString());
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
    }

    @Override
    public void updateUriTextField() {
        String value = this.uriTextField.getText().toString().split("\\?", 2)[0];
        if (this.uidCheckBox.isSelected() && this.interationCntrCheckBox.isSelected() && this.sunMessageCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?m=00000000000000x000000x0000000000000000");
            this.showSDMAndCtrMirroringOptions(true, true);
        } else if (this.uidCheckBox.isSelected() && this.interationCntrCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?m=00000000000000x000000");
            this.showSDMAndCtrMirroringOptions(false, true);
        } else if (this.uidCheckBox.isSelected() && this.sunMessageCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?m=00000000000000x0000000000000000");
            this.showSDMAndCtrMirroringOptions(true, false);
        } else if (this.interationCntrCheckBox.isSelected() && this.sunMessageCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?c=000000x0000000000000000");
            this.showSDMAndCtrMirroringOptions(true, true);
        } else if (this.uidCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?m=00000000000000");
            this.showSDMAndCtrMirroringOptions(false, false);
        } else if (this.interationCntrCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?c=000000");
            this.showSDMAndCtrMirroringOptions(false, true);
        } else if (this.sunMessageCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?p=0000000000000000");
            this.showSDMAndCtrMirroringOptions(true, false);
        } else {
            this.uriTextField.setText(value);
            this.showSDMAndCtrMirroringOptions(false, false);
        }
    }

    private void showSDMAndCtrMirroringOptions(boolean sdmEnable, boolean ctrEnable) {
    }
}

