/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.INTag213215216Contract;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.NTag213215216MirrorEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.MirrorFlags;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.d;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class NTag213215216Controller
extends AbstractController
implements INTag213215216Contract.IScene,
IRecordGenerator {
    ObservableList<String> uriList = FXCollections.observableArrayList((Object[])TagXplorerConstants.URI_TYPES);
    @FXML
    private CheckBox uidCheckBox;
    @FXML
    private CheckBox interationCntrCheckBox;
    @FXML
    private ComboBox<String> uriTypeComboBox;
    @FXML
    private TextField uriTextField;
    @FXML
    private TextField descriptionTextField;
    @FXML
    private VBox ntag21XOpMainVBox;
    private NTag213215216MirrorEventHandler eventHandler;

    @Override
    public void initializeViewDependencies() {
        this.eventHandler = new NTag213215216MirrorEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        this.uidCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.interationCntrCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.uriTypeComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String oldValue, String newValue) {
                if (newValue.equals(TagXplorerConstants.URI_TYPES[0])) {
                    NTag213215216Controller.this.uriTextField.setText(TagXplorerConstants.uriProtoMap.get((byte)1));
                } else if (newValue.equals(TagXplorerConstants.URI_TYPES[1])) {
                    NTag213215216Controller.this.uriTextField.setText(TagXplorerConstants.uriProtoMap.get((byte)29));
                } else {
                    NTag213215216Controller.this.uriTextField.setText("");
                    NTag213215216Controller.this.uriTextField.setPromptText("type URI data...");
                }
            }
        });
    }

    @Override
    public void initializeDefaults() {
        this.uriTypeComboBox.setItems(this.uriList);
        this.uriTypeComboBox.setValue((Object)"URL(Website)");
    }

    @Override
    public IRecord generateRecord() {
        String desc = this.descriptionTextField.getText();
        String uriString = this.uriTextField.getText();
        MirrorFlags mirrorFlags = new MirrorFlags();
        mirrorFlags.setUidMirror(this.uidCheckBox.isSelected());
        mirrorFlags.setCounterMirror(this.interationCntrCheckBox.isSelected());
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString);
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.LINK_RECORD);
            LinkRecord linkRecord = (LinkRecord)generateRecord;
            linkRecord.setMirrorFlags(mirrorFlags);
            generateRecord = linkRecord;
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
            SmartPosterRecord smartPosterRecord = (SmartPosterRecord)generateRecord;
            smartPosterRecord.getLinkRecord().setMirrorFlags(mirrorFlags);
            generateRecord = smartPosterRecord;
        }
        return generateRecord;
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record != null) {
            LinkRecord linkRecord = null;
            if (record instanceof SmartPosterRecord) {
                SmartPosterRecord posterRecord = (SmartPosterRecord)record;
                this.descriptionTextField.setText(posterRecord.getTextRecord().getInputText());
                linkRecord = posterRecord.getLinkRecord();
            } else if (record instanceof LinkRecord) {
                linkRecord = (LinkRecord)record;
            }
            if (linkRecord == null) {
                return;
            }
            this.uriTextField.setText(linkRecord.getInputUriString());
            if (d.d(linkRecord.getUri())) {
                this.uriTypeComboBox.setValue((Object)TagXplorerConstants.URI_TYPES[0]);
            } else if (d.e(linkRecord.getUri())) {
                this.uriTypeComboBox.setValue((Object)TagXplorerConstants.URI_TYPES[1]);
            } else {
                this.uriTypeComboBox.setValue((Object)TagXplorerConstants.URI_TYPES[2]);
            }
        }
    }

    @Override
    public void updateUriTextField() {
        String value = this.uriTextField.getText().toString().split("\\?", 2)[0];
        if (this.uidCheckBox.isSelected() && this.interationCntrCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?m=00000000000000x000000");
        } else if (this.interationCntrCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?c=000000");
        } else if (this.uidCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?m=00000000000000");
        } else {
            this.uriTextField.setText(value);
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
    }
}

