/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.NTag210MirrorEventHandler;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.INTag210Contract;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.MirrorFlags;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class NTag210Controller
extends AbstractController
implements IRecordGenerator,
INTag210Contract.IScene {
    ObservableList<String> uriList = FXCollections.observableArrayList((Object[])TagXplorerConstants.URI_TYPES);
    @FXML
    private CheckBox uidCheckBox;
    @FXML
    private ComboBox<String> uriTypeComboBox;
    @FXML
    private TextField uriTextField;
    @FXML
    private TextField descriptionTextField;
    @FXML
    private VBox ntag210OpMainVBox;
    private NTag210MirrorEventHandler eventHandler;

    @Override
    public void initializeViewDependencies() {
        this.eventHandler = new NTag210MirrorEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        this.uidCheckBox.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.uriTypeComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String oldValue, String newValue) {
                if (newValue.equals(TagXplorerConstants.URI_TYPES[0])) {
                    NTag210Controller.this.uriTextField.setText(TagXplorerConstants.uriProtoMap.get((byte)1));
                } else if (newValue.equals(TagXplorerConstants.URI_TYPES[1])) {
                    NTag210Controller.this.uriTextField.setText(TagXplorerConstants.uriProtoMap.get((byte)29));
                } else {
                    NTag210Controller.this.uriTextField.setText("");
                    NTag210Controller.this.uriTextField.setPromptText("type URI data...");
                }
            }
        });
    }

    @Override
    public void initializeDefaults() {
        this.uriTypeComboBox.setItems(this.uriList);
        this.uriTypeComboBox.setValue((Object)"URL(Website)");
    }

    @Override
    public IRecord generateRecord() {
        String desc = this.descriptionTextField.getText();
        String uriString = this.uriTextField.getText();
        MirrorFlags mirrorFlags = new MirrorFlags();
        mirrorFlags.setUidMirror(this.uidCheckBox.isSelected());
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString);
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.LINK_RECORD);
            LinkRecord linkRecord = (LinkRecord)generateRecord;
            linkRecord.setMirrorFlags(mirrorFlags);
            generateRecord = linkRecord;
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
            SmartPosterRecord smartPosterRecord = (SmartPosterRecord)generateRecord;
            smartPosterRecord.getLinkRecord().setMirrorFlags(mirrorFlags);
            generateRecord = smartPosterRecord;
        }
        return generateRecord;
    }

    @Override
    public void initializeWith(IRecord record) {
    }

    @Override
    public void enableUidMirroing() {
    }

    @Override
    public void onUidCheckBoxChanged() {
        String value = this.uriTextField.getText().toString().split("\\?", 2)[0];
        if (this.uidCheckBox.isSelected()) {
            this.uriTextField.setText(value + "?m=00000000000000");
        } else {
            this.uriTextField.setText(value);
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
    }
}

