/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import b.b;
import b.e;
import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.ILogListener;
import com.nxp.tagxplorer.controller.LogEventHandler;
import com.nxp.tagxplorer.controller.contract.ILogController;
import com.nxp.tagxplorer.controller.presenter.LogScreenPresenter;
import com.nxp.tagxplorer.utility.TagXplorerUtility;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;

public class LogController
extends AbstractController
implements e,
ILogListener,
ILogController.IScene {
    @FXML
    private TextArea logArea;
    @FXML
    private Button clearButton;
    @FXML
    private Button saveButton;
    @FXML
    private VBox buttonVBox;
    private LogScreenPresenter mPresenter;
    private LogEventHandler eventHandler;

    @Override
    public void initializeViewDependencies() {
        this.mPresenter = new LogScreenPresenter();
        this.mPresenter.onSceneActive(this);
        this.eventHandler = new LogEventHandler(this);
    }

    @Override
    public void initializeLayoutDimensions() {
        this.logArea.setPrefSize(Double.MAX_VALUE, Double.MAX_VALUE);
    }

    @Override
    public void initializeListeners() {
        this.clearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
        this.saveButton.addEventHandler(ActionEvent.ACTION, (EventHandler)this.eventHandler);
    }

    @Override
    public void initializeDefaults() {
    }

    @Override
    public void displayLog(String log) {
        this.logArea.setText(log);
        this.logArea.selectPositionCaret(this.logArea.getLength());
        this.logArea.deselect();
    }

    @Override
    public void clearLog() {
        this.mPresenter.clearAndDisplayLog();
    }

    @Override
    public void saveLog() {
        this.mPresenter.fetchAndSaveLog();
    }

    @Override
    public void saveLogAsTextFile(String log) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Text files (*.txt)", new String[]{"*.txt"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File fileToWrite = fileChooser.showSaveDialog(this.buttonVBox.getScene().getWindow());
        if (fileToWrite == null) {
            return;
        }
        b service = new b();
        service.b(log);
        service.a(fileToWrite);
        service.a(this);
        service.a(2010);
    }

    @Override
    public void onSuccess(int operationType, Object response) {
        TagXplorerUtility.createAlert("Log File saved successfully.", Alert.AlertType.INFORMATION, "Success");
    }

    @Override
    public void onFailed(int operationType) {
        TagXplorerUtility.createAlert("Failure while saving Log to File.", Alert.AlertType.INFORMATION, "Failure");
    }

    @Override
    public void onError(int operationType, Throwable throwable) {
        TagXplorerUtility.createAlert("Error While saving Log to File.", Alert.AlertType.INFORMATION, "Error");
    }

    @Override
    public void showLog() {
        this.mPresenter.fetchAndDisplayLog();
    }

    @Override
    public void publishLog() {
        this.showLog();
    }
}

