/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.GeoLocationEventHandler;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IGeoLocationRecordContract;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.GeoLocationConstant;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.d;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class GeoLocationController
extends AbstractController
implements IRecordGenerator,
IGeoLocationRecordContract.IScene {
    @FXML
    private VBox geoLocationMainVBox;
    @FXML
    private Button longitudeTextClearButton;
    @FXML
    private TextField degdecDescriptionTextField;
    @FXML
    private TextField latitudeTextField;
    @FXML
    private Button latitudeTextClearButton;
    @FXML
    private Button degdecDescriptionClearButton;
    @FXML
    private TextField longtitudeTextField;
    private ObservableList<String> latitudeModels = FXCollections.observableArrayList((Object[])GeoLocationConstant.LATITUDE_MODELS);
    private ObservableList<String> logitudeModels = FXCollections.observableArrayList((Object[])GeoLocationConstant.LOGITUDE_MODELS);
    private WriteNdefController mWriteNdefController;
    private String descEmpty = "";
    private String latitudeEmpty = "";
    private String longitudeEmpty = "";

    private static String dmsToDecimal(String hemisphereOUmeridien, double degrees, double minutes, double secondes) {
        double LatOrLon = 0.0;
        double signe = 1.0;
        if (hemisphereOUmeridien.equals("W") || hemisphereOUmeridien.equals("S")) {
            signe = -1.0;
        }
        LatOrLon = signe * (Math.floor(degrees) + Math.floor(minutes) / 60.0 + secondes / 3600.0);
        return String.valueOf(LatOrLon);
    }

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        GeoLocationEventHandler eventHandler = new GeoLocationEventHandler(this);
        this.degdecDescriptionClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.latitudeTextClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.longitudeTextClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.degdecDescriptionTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GeoLocationController.this.descEmpty = newValue;
                GeoLocationController.this.mWriteNdefController.calculateNdefMessageSize(false);
                GeoLocationController.this.isRecordEmpty();
            }
        });
        this.latitudeTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GeoLocationController.this.latitudeEmpty = newValue;
                GeoLocationController.this.mWriteNdefController.calculateNdefMessageSize(false);
                GeoLocationController.this.isRecordEmpty();
            }
        });
        this.longtitudeTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                GeoLocationController.this.longitudeEmpty = newValue;
                GeoLocationController.this.mWriteNdefController.calculateNdefMessageSize(false);
                GeoLocationController.this.isRecordEmpty();
            }
        });
    }

    @Override
    public void initializeDefaults() {
    }

    private void isRecordEmpty() {
        if (this.descEmpty.length() == 0 && this.latitudeEmpty.length() == 0 && this.longitudeEmpty.length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        }
    }

    @Override
    public IRecord generateRecord() {
        String desc = null;
        String lat = null;
        String longitude = null;
        desc = this.degdecDescriptionTextField.getText();
        lat = this.latitudeTextField.getText();
        longitude = this.longtitudeTextField.getText();
        String uriString = lat.isEmpty() || longitude.isEmpty() ? "" : String.format("geo:%s,%s", lat, longitude);
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString);
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.GEO_LOCATION);
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
        }
        return generateRecord;
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public void initializeWith(IRecord record) {
        String description = null;
        LinkRecord linkRecord = null;
        if (record instanceof SmartPosterRecord) {
            SmartPosterRecord posterRecord = (SmartPosterRecord)record;
            description = posterRecord.getTextRecord().getInputText();
            linkRecord = posterRecord.getLinkRecord();
        } else if (record instanceof LinkRecord) {
            linkRecord = (LinkRecord)record;
        }
        if (description != null) {
            this.degdecDescriptionTextField.setText(description);
        }
        if (linkRecord != null) {
            this.latitudeTextField.setText(d.d(linkRecord.getInputUriString()));
            this.longtitudeTextField.setText(d.e(linkRecord.getInputUriString()));
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }

    @Override
    public void clearLatitude() {
        this.latitudeTextField.setText("");
    }

    @Override
    public void clearLongitude() {
        this.longtitudeTextField.setText("");
    }

    @Override
    public void clearDescription() {
        this.degdecDescriptionTextField.setText("");
    }
}

