/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.EULASceneEventHandler;
import com.nxp.tagxplorer.controller.contract.IEulaContract;
import com.nxp.tagxplorer.controller.presenter.EULAScenePresenter;
import com.nxp.tagxplorer.res.RLoader;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;

public class EulaController
extends AbstractController
implements IEulaContract.IScene {
    @FXML
    private BorderPane eulaBorderPane;
    @FXML
    private GridPane eulaGridPane;
    @FXML
    private Button declineButton;
    @FXML
    private ImageView appLabelImageView;
    @FXML
    private VBox eulaContentVbox;
    @FXML
    private ImageView eulaNxpLogo;
    @FXML
    private TextFlow eulaContentTextFlow;
    @FXML
    private Button acceptButton;
    private EULAScenePresenter mPresenter;

    @Override
    public void initializeViewDependencies() {
        this.mPresenter = new EULAScenePresenter();
        this.mPresenter.onSceneActive(this);
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        EULASceneEventHandler eventHandler = new EULASceneEventHandler(this);
        this.acceptButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.declineButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
    }

    @Override
    public void initializeDefaults() {
        Image appLabelImage = new Image(RLoader.loadImage(2120369529L));
        this.appLabelImageView.setImage(appLabelImage);
        Image nxpLogo = new Image(RLoader.loadImage(-611283809L));
        this.eulaNxpLogo.setImage(nxpLogo);
        String family = "Century-Gothic";
        Text eulaContentHeader = new Text("END USER LICENSE AGREEMENT \r\nIMPORTANT INFORMATION: THIS END USER LICENSE AGREEMENT (THE \"LICENSE\") IS A LEGAL AGREEMENT BETWEEN YOU (EITHER AN INDIVIDUAL OR AN ENTITY) AND NXP SEMICONDUCTORS NETHERLANDS B.V., A PRIVATE COMPANY WITH LIMITED LIABILITY INCORPORATED UNDER THE LAWS OF THE NETHERLANDS, HAVING ITS REGISTERED OFFICE AT HIGH TECH CAMPUS 60, 5656 AG EINDHOVEN, THE NETHERLANDS (\"NXP\") FOR THE USE OF THE SOFTWARE AND DOCUMENTATION REFERRED TO IN THIS LICENSE. NXP IS ONLY WILLING TO LICENSE THE SOFTWARE TO YOU ON CONDITION THAT YOU ACCEPT ALL OF THE TERMS IN THIS LICENSE. BY INSTALLINGOR EXECUTING THE APP \"NFC TAGXPLORER BY NXP\" (AS DEFINED HEREAFTER) ON ANY DESKTOP OR DEVICE, YOU INDICATE THAT YOU AGREE TO BE BOUND BY ALL THE TERMS OF THIS LICENSE. IF YOU DO NOT AGREE TO THE TERMS OF THIS LICENSE, NXP IS UNWILLING TO LICENSE THE SOFTWARE TO YOU; DO NOT DOWNLOAD, INSTALL, USE, OR COPY THE DESKTOP APP \"NFC TAGXPLORER BY NXP\".\r\n\n\n");
        Text eulaContentBody = new Text("1. License. Subject to the terms and conditions of this License, NXP hereby grants you for the term of this License a non-exclusive, worldwide, personal, non-transferable, royalty-free license, without the right to sublicense, to use the software and documentation, and all upgrades, updates, information and/or other materials relating thereto that NXP may (in its sole discretion) provide to you under this License (collectively the \"NFC TagXplorer by NXP\") in object code executable only form on a single computer controlled by you for the limited purpose of developing an application and to distribute this application for non commercial or commercial and/or revenue generating purposes (the \"Authorized Purpose\"). \r\n\n2. License Restrictions. You shall not, and shall not permit any third party to: (i) use the \"NFC TagXplorer by NXP\" as a stand-alone product. for commercial or revenue generating purposes; (ii) copy, translate, modify or make derivative works of any portion of the \"NFC TagXplorer by NXP\"; (iii) rent, disclose, publish, sell, assign, lease, lend, sublicense, market, transfer, distribute or otherwise provide third parties access to any portion of the \"NFC TagXplorer by NXP\"; (iv) reverse engineer, decompile or disassemble the \"NFC TagXplorer by NXP\" or derive or attempt to derive the source code, algorithmic nature or structure of any object code portions of the \"NFC TagXplorer by NXP\" (v) use the \"NFC TagXplorer by NXP\" app to create any product that competes with \"NFC TagXplorer by NXP\"; (vi) otherwise use any portion of the \"NFC TagXplorer by NXP\" in any manner not expressly authorized in Section 1. Notwithstanding the above, you are allowed to use and distribute your application with the \"NFC TagXplorer by NXP\" incorporated therein to third parties to achieve the Authorized Purpose. \r\n\n3. Ownership. Except for those rights specifically granted in Section 1: (i) NXP, its affiliates and their suppliers reserve all right, title and interest in and to the \"NFC TagXplorer by NXP\", and (ii) no other express or implied license, right or interest in any patent, patent application, copyright, trade secret, trademark or any other intellectual property right are granted hereunder. This License does not transfer any ownership interest in the \"NFC TagXplorer by NXP\". You agree that any feedback provided by you to NXP and any intellectual property rights and other proprietary rights therein or thereto shall vest in NXP. \r\n\n4. Confidentiality. The \"NFC TagXplorer by NXP\" app contains confidential and proprietary information and materials and may include trade secrets. You agree to: (i) hold the \"NFC TagXplorer by NXP\" in confidence, and (iii) use the \"NFC TagXplorer by NXP\" app only for the Authorized Purpose. You shall notify NXP immediately if you learn of any misappropriation, or unauthorized use or disclosure of the \"NFC TagXplorer by NXP\" app. \r\n\n5. Term; Termination; Effects. This License shall commence upon the earlier of your acceptance of this License or your installation of the \"NFC TagXplorer by NXP\" app and shall continue until terminated in accordance with this License. This License will terminate automatically if you fail to comply with any term or conditions of this License or if you uninstall/destroy or voluntarily return the \"NFC TagXplorer by NXP\" app to NXP. Upon termination of this License: (i) all rights and licenses granted to you under this License shall immediately terminate; (ii) you shall promptly return to NXP or, at NXP\"s discretion, destroy the \"NFC TagXplorer by NXP\" app and all whole and partial copies thereof; (iii) within thirty (30) days after such termination, you will furnish to NXP at the address above a written certification that the \"NFC TagXplorer by NXP\" app and all whole and partial copies thereof, have been (a) destroyed or returned to NXP, and (b) erased from all of your storage elements and devices. All defined terms and Sections 2 through 12 shall survive the termination of this License. \r\n\n6. Remedies. You acknowledge and agree that, if NXP is required to bring an action to enforce the provisions of this License, the damages may be irreparable and difficult to measure and NXP shall be entitled to seek equitable relief including a preliminary injunction in addition to any other relief available. \r\n\n7. Disclaimer. THE APP IS PROVIDED ON AN \"AS IS\" AND \"WITH ALL FAULTS\" BASIS. NXP, ITS AFFILIATES AND THEIR SUPPLIERS EXPRESSLY DISCLAIM ALL WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY, OR ARISING OUT OF THE USE OR PERFORMANCE, OF THE LICENSED MATERIALS REMAINS WITH YOU. \r\n\n8. Limitation of Liability. IN NO EVENT SHALL NXP, ITS AFFILIATES OR THEIR SUPPLIERS BE LIABLE TO YOU FOR ANY SPECIAL, INDIRECT, CONSEQUENTIAL, PUNITIVE, OR INCIDENTAL DAMAGES (INCLUDING WITHOUT LIMITATION DAMAGES FOR LOSS OF BUSINESS, BUSINESS INTERRUPTION, LOSS OF USE, LOSS OF DATA OR INFORMATION, AND THE LIKE) ARISING OUT OF THIS LICENSE OR THE USE OF OR INABILITY TO USE THE \", WHETHER OR NOT BASED ON TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY, BREACH OF CONTRACT, BREACH OF WARRANTY OR ANY OTHER THEORY, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. NOTWITHSTANDING ANY DAMAGES THAT COMPANY MIGHT INCUR FOR ANY REASON WHATSOEVER (INCLUDING, WITHOUT LIMITATION, ALL DAMAGES REFERENCED ABOVE AND ALL DIRECT OR GENERAL DAMAGES), THE ENTIRE LIABILITY OF NXP, ITS AFFILIATES AND THEIR SUPPLIERS UNDER ANY PROVISION OF THIS LICENSE AND YOU EXCLUSIVE REMEDY FOR ALL OF THE FOREGOING SHALL BE LIMITED TO ACTUAL DAMAGES INCURRED BY YOU BASED ON REASONABLE RELIANCE UP TO THE GREATER OF THE AMOUNT ACTUALLY PAID BY COMPANY UNDER THIS LICENSE OR FIVE EUROS (\"5). THE FOREGOING LIMITATIONS, EXCLUSIONS AND DISCLAIMERS SHALL APPLY TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, EVEN IF ANY REMEDY FAILS OF ITS ESSENTIAL PURPOSE. \r\n\n9. Governing Law; Disputes. This License shall be governed by and construed in accordance with the laws of the Netherlands without regard to any principle of conflicts of law. Any dispute arising hereunder shall be resolved by the competent courts in Amsterdam, the Netherlands, and the parties hereby agree that venue and jurisdiction for any related proceedings arising hereunder shall lie exclusively with such courts. NXP however retains the right to bring disputes in any other court of competent jurisdiction and you irrevocably waive any objection to, and agree to submit to, the jurisdiction of such other courts. \r\n\n10. Export Laws. Insofar as these relate to the activities under this License, You will comply with all applicable national and international export control laws and regulations. In particular, You will not directly or indirectly export, re-export, transfer or release the \"NFC TagXplorer by NXP\" app or direct product thereof to any destination, person, entity or end use restricted or prohibited by applicable laws, without obtaining prior authorization from the applicable competent government authorities to the extent required by those laws. \r\n\n11. Miscellaneous. (A) Nothing in this License shall create a joint venture, partnership or principal/agent relationship between the parties. (B) You shall not assign or transfer any of its rights or obligations hereunder without the prior written consent of NXP. However, NXP may assign this Agreement, in whole or in part, or any of its rights, interests, duties or obligations, (i) to an affiliate or (ii) in connection with a corporate reorganization, acquisition, merger, or sale of all or substantially all of the assets of a division or business unit. For clarity, the proposed acquisition transaction involving Qualcomm Inc. (\"Qualcomm\"), which was publicly announced on October 27, 2016, shall not constitute an assignment by operation of law, and NXP may assign this Agreement to Qualcomm or any subsidiary thereof in connection with or following completion of the acquisition. Any attempted assignment other than in strict compliance with this section shall be void. (C) A waiver of any right hereunder shall in no way waive any other rights. No waiver, alteration, modification or amendment of this License shall be effective unless in writing and signed by both parties. (D) In the event that any provision of this License is held to be invalid, illegal or unenforceable, such provision shall be deemed amended to achieve the economic effect of the intent of the parties in a valid, lawful and enforceable manner, or if not possible, then deleted and ineffective to the extent thereof, without affecting any other provision of this License. (E) This License constitutes the entire License regarding the subject matter hereof and supersedes all prior Licenses, understandings and communications, oral and written, between the parties regarding the subject matter here of. (F) NXP reserves the right to revise the terms of this License by updating the License on its website. You are advised to check this License periodically for notices concerning revisions. Your continued use of the \"NFC TagXplorer by NXP\" App shall be deemed to constitute acceptance of any revised terms.\r\n\n\n");
        eulaContentHeader.setFont(Font.font((String)family, (FontWeight)FontWeight.BOLD, (double)18.0));
        eulaContentBody.setFont(Font.font((String)family, (FontWeight)FontWeight.NORMAL, (double)16.0));
        this.eulaContentTextFlow.getChildren().addAll((Object[])new Node[]{eulaContentHeader, eulaContentBody});
    }

    @Override
    public void onAgreementAccepted() {
        this.mPresenter.onAgreementAccepted();
    }

    @Override
    public void onAgreementDeclined() {
        this.mPresenter.onAgreementDeclined();
    }

    @Override
    public void showTagXplorerMainScreen() {
        try {
            Parent root = (Parent)FXMLLoader.load((URL)RLoader.loadFXML(2079700600L));
            root.getStylesheets().clear();
            Scene scene = new Scene(root);
            scene.getStylesheets().add((Object)RLoader.loadCSS(287673610L).toExternalForm());
            Stage stage = (Stage)this.eulaBorderPane.getScene().getWindow();
            stage.centerOnScreen();
            stage.setScene(scene);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void closeApplication() {
        Platform.exit();
    }
}

