/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.EmailRecordEventHandler;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IEmailRecordContract;
import com.nxp.tagxplorer.ndef.models.AbstractRecord;
import com.nxp.tagxplorer.ndef.models.LinkRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.ndef.models.SmartPosterRecord;
import com.nxp.tagxplorer.utility.gson.IRecord;
import f.d;
import f.k;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class EmailRecordController
extends AbstractController
implements IRecordGenerator,
IEmailRecordContract.IScene {
    String titleEmpty = "";
    String subEmpty = "";
    String recEmpty = "";
    String bodyEmpty = "";
    @FXML
    private VBox emailMainVBox;
    @FXML
    private TextField emailTitleDescriptionTextField;
    @FXML
    private TextField emailSubjectTextField;
    @FXML
    private TextField recipientEmailAddressTextField;
    @FXML
    private TextArea emailMessageBodyTextArea;
    @FXML
    private HBox titleLabelHBox;
    @FXML
    private HBox recipientEmailLabelHBox;
    @FXML
    private HBox subjectLabelHBox;
    @FXML
    private HBox messageLabelHBox;
    @FXML
    private Button clearTitleButton;
    @FXML
    private Button clearEmailButton;
    @FXML
    private Button clearSubjectButton;
    @FXML
    private Button clearMessageButton;
    @FXML
    private Label invalidEmailLabel;
    private WriteNdefController mWriteNdefController;

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        EmailRecordEventHandler eventHandler = new EmailRecordEventHandler(this);
        this.clearTitleButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.clearEmailButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.clearSubjectButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.clearMessageButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.emailTitleDescriptionTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                EmailRecordController.this.titleEmpty = newValue;
                EmailRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                EmailRecordController.this.isRecordEmpty();
            }
        });
        this.emailSubjectTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                EmailRecordController.this.subEmpty = newValue;
                EmailRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                EmailRecordController.this.isRecordEmpty();
            }
        });
        this.recipientEmailAddressTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                EmailRecordController.this.recEmpty = newValue;
                EmailRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                EmailRecordController.this.isRecordEmpty();
                EmailRecordController.this.invalidEmailLabel.setVisible(!d.o(newValue));
            }
        });
        this.emailMessageBodyTextArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                EmailRecordController.this.bodyEmpty = newValue;
                EmailRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                EmailRecordController.this.isRecordEmpty();
            }
        });
    }

    @Override
    public void initializeDefaults() {
    }

    private void isRecordEmpty() {
        if (this.bodyEmpty.length() == 0 && this.recEmpty.length() == 0 && this.subEmpty.length() == 0 && this.titleEmpty.length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        }
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public IRecord generateRecord() {
        String uriString;
        String desc = this.emailTitleDescriptionTextField.getText();
        String to = this.recipientEmailAddressTextField.getText();
        String subject = this.emailSubjectTextField.getText();
        String body = this.emailMessageBodyTextArea.getText();
        if (to.isEmpty()) {
            uriString = "";
        } else {
            uriString = "mailto:" + to;
            if (subject.length() > 0 & body.length() > 0) {
                uriString = uriString + "?subject=" + subject + "&body=" + body;
            } else if (subject.length() > 0) {
                uriString = uriString + "?subject=" + subject;
            } else if (body.length() > 0) {
                uriString = uriString + "?body=" + body;
            }
        }
        AbstractRecord generateRecord = (AbstractRecord)k.a(desc, uriString);
        if (generateRecord instanceof LinkRecord) {
            generateRecord.setType(NDEFRecordType.EMAIL_RECORD);
        } else {
            generateRecord.setType(NDEFRecordType.SMART_POSTER_RECORD);
        }
        return generateRecord;
    }

    public String getEmailMessage() {
        return this.emailMessageBodyTextArea.getText();
    }

    public String getEmailSubject() {
        return this.emailSubjectTextField.getText();
    }

    public String getEmailAddress() {
        return this.recipientEmailAddressTextField.getText();
    }

    public String getEmailTitleDescription() {
        return this.emailTitleDescriptionTextField.getText();
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record == null) {
            return;
        }
        String description = null;
        Object to = null;
        Object subject = null;
        Object body = null;
        LinkRecord linkRecord = null;
        if (record instanceof SmartPosterRecord) {
            SmartPosterRecord posterRecord = (SmartPosterRecord)record;
            description = posterRecord.getTextRecord().getInputText();
            linkRecord = posterRecord.getLinkRecord();
        } else if (record instanceof LinkRecord) {
            linkRecord = (LinkRecord)record;
        }
        if (description != null) {
            this.emailTitleDescriptionTextField.setText(description);
        }
        if (linkRecord != null) {
            this.recipientEmailAddressTextField.setText(d.g(linkRecord.getInputUriString()));
            this.emailSubjectTextField.setText(d.i(linkRecord.getInputUriString()));
            this.emailMessageBodyTextArea.setText(d.h(linkRecord.getInputUriString()));
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }

    @Override
    public void clearTitle() {
        this.emailTitleDescriptionTextField.setText("");
    }

    @Override
    public void clearEmail() {
        this.recipientEmailAddressTextField.setText("");
    }

    @Override
    public void clearSubject() {
        this.emailSubjectTextField.setText("");
    }

    @Override
    public void clearMessage() {
        this.emailMessageBodyTextArea.setText("");
    }
}

