/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.BluetoothEventHandler;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IBluetoothRecordContract;
import com.nxp.tagxplorer.ndef.models.BTTypes;
import com.nxp.tagxplorer.ndef.models.BluetoothRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.utility.TagXplorerConstants;
import com.nxp.tagxplorer.utility.gson.IRecord;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class BluetoothRecordController
extends AbstractController
implements IRecordGenerator,
IBluetoothRecordContract.IScene {
    ObservableList<String> bluetoothNdefVersionList = FXCollections.observableArrayList((Object[])TagXplorerConstants.BLUETOOTH_NDEF_VERSIONS);
    ObservableList<String> deviceCLassList = FXCollections.observableArrayList((Object[])TagXplorerConstants.DEVICE_CLASS);
    @FXML
    private VBox bluetoothRecordMainVBox;
    @FXML
    private Button createBluethoothRecordButton;
    @FXML
    private TextField deviceNameTextField;
    @FXML
    private TextField bluethoothMACAddressTextField;
    @FXML
    private ComboBox<String> bluethoothDeviceClassComboBox;
    @FXML
    private Button deviceNameClearButton;
    @FXML
    private Button macAddressClearButton;
    @FXML
    private ComboBox<String> bluethoothNDEFVersionComboBox;
    @FXML
    private CheckBox bluethoothHandoverCheckBox;
    @FXML
    private Label passwordLabel;
    @FXML
    private TextField bluetoothPasswordTextField;
    @FXML
    private Button passwordClearButton;
    private WriteNdefController mWriteNdefController;
    private String nameEmpty = "";
    private String macaddressEmpty = "";

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        BluetoothEventHandler eventHandler = new BluetoothEventHandler(this);
        this.bluethoothNDEFVersionComboBox.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.deviceNameClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.macAddressClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.passwordClearButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.deviceNameTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                BluetoothRecordController.this.nameEmpty = newValue;
                BluetoothRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                BluetoothRecordController.this.isRecordEmpty();
            }
        });
        this.bluethoothMACAddressTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                BluetoothRecordController.this.macaddressEmpty = newValue;
                BluetoothRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
                BluetoothRecordController.this.isRecordEmpty();
            }
        });
        this.bluethoothHandoverCheckBox.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                BluetoothRecordController.this.mWriteNdefController.calculateNdefMessageSize(false);
            }
        });
    }

    @Override
    public void initializeDefaults() {
        this.bluethoothNDEFVersionComboBox.setItems(this.bluetoothNdefVersionList);
        this.bluethoothNDEFVersionComboBox.setValue((Object)TagXplorerConstants.BLUETOOTH_NDEF_VERSIONS[1]);
        this.bluethoothDeviceClassComboBox.setItems(this.deviceCLassList);
        this.bluethoothDeviceClassComboBox.setValue((Object)"Not Set");
        this.passwordLabel.setVisible(false);
        this.bluetoothPasswordTextField.setVisible(false);
        this.passwordClearButton.setVisible(false);
    }

    private void isRecordEmpty() {
        if (this.macaddressEmpty.length() == 0 && this.nameEmpty.length() == 0) {
            this.mWriteNdefController.calculateNdefMessageSize(true);
        }
    }

    @Override
    public IRecord generateRecord() {
        String password = "0000";
        String deviceName = this.deviceNameTextField.getText();
        String macAddress = this.bluethoothMACAddressTextField.getText();
        int deviceClass = this.bluethoothDeviceClassComboBox.getSelectionModel().getSelectedIndex();
        int bluetoothVerIndex = this.bluethoothNDEFVersionComboBox.getSelectionModel().getSelectedIndex();
        BTTypes version = BTTypes.application_vnd_bluetooth_ep_oob;
        switch (bluetoothVerIndex) {
            case 0: {
                version = BTTypes.nokia_com_bt;
                password = this.bluetoothPasswordTextField.getText();
                break;
            }
            case 1: {
                version = BTTypes.application_vnd_bluetooth_ep_oob;
                break;
            }
        }
        BluetoothRecord bluetoothRecord = new BluetoothRecord(deviceName, macAddress, password, version, deviceClass, this.bluethoothHandoverCheckBox.isSelected());
        bluetoothRecord.setType(NDEFRecordType.BLUETOOTH_RECORD);
        return bluetoothRecord;
    }

    public String getDeviceName() {
        return this.deviceNameTextField.getText();
    }

    public String getMacAddress() {
        return this.bluethoothMACAddressTextField.getText();
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public void clearDeviceName() {
        this.deviceNameTextField.setText("");
    }

    @Override
    public void clearMacAddress() {
        this.bluethoothMACAddressTextField.setText("");
    }

    @Override
    public void clearPassword() {
        this.bluetoothPasswordTextField.setText("");
    }

    @Override
    public void showPasswordField() {
        if (this.bluethoothNDEFVersionComboBox.getSelectionModel().getSelectedIndex() == 0) {
            this.passwordLabel.setVisible(true);
            this.bluetoothPasswordTextField.setVisible(true);
            this.passwordClearButton.setVisible(true);
            this.bluethoothHandoverCheckBox.setVisible(false);
        } else {
            this.passwordLabel.setVisible(false);
            this.bluetoothPasswordTextField.setVisible(false);
            this.passwordClearButton.setVisible(false);
            this.bluethoothHandoverCheckBox.setVisible(true);
        }
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record == null) {
            return;
        }
        if (record instanceof BluetoothRecord) {
            BluetoothRecord bluetoothRecord = (BluetoothRecord)record;
            this.deviceNameTextField.setText(bluetoothRecord.getDeviceName());
            this.bluethoothMACAddressTextField.setText(bluetoothRecord.getMacAddress());
            this.bluethoothDeviceClassComboBox.setValue(this.deviceCLassList.get(bluetoothRecord.getDeviceClass()));
            switch (bluetoothRecord.getBluetoothNdefVersion()) {
                case application_vnd_bluetooth_ep_oob: {
                    this.bluethoothNDEFVersionComboBox.setValue((Object)TagXplorerConstants.BLUETOOTH_NDEF_VERSIONS[1]);
                    break;
                }
            }
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }
}

