/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import com.nxp.tagxplorer.controller.AbstractController;
import com.nxp.tagxplorer.controller.ApplicationRecordEventHandler;
import com.nxp.tagxplorer.controller.IRecordGenerator;
import com.nxp.tagxplorer.controller.WriteNdefController;
import com.nxp.tagxplorer.controller.contract.IApplicationRecordContract;
import com.nxp.tagxplorer.ndef.models.ApplicationRecord;
import com.nxp.tagxplorer.ndef.models.NDEFRecordType;
import com.nxp.tagxplorer.utility.gson.IRecord;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class ApplicationRecordController
extends AbstractController
implements IRecordGenerator,
IApplicationRecordContract.IScene {
    @FXML
    private TextField applicationPackageNameTextField;
    @FXML
    private VBox launchAppMainVBox;
    @FXML
    private Button clearPackageNameButton;
    private WriteNdefController mWriteNdefController;
    private boolean isRecordEmpty;

    @Override
    public void initializeViewDependencies() {
    }

    @Override
    public void initializeLayoutDimensions() {
    }

    @Override
    public void initializeListeners() {
        ApplicationRecordEventHandler eventHandler = new ApplicationRecordEventHandler(this);
        this.clearPackageNameButton.addEventHandler(ActionEvent.ACTION, (EventHandler)eventHandler);
        this.applicationPackageNameTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.length() == 0) {
                    ApplicationRecordController.this.isRecordEmpty = true;
                } else {
                    ApplicationRecordController.this.isRecordEmpty = false;
                }
                ApplicationRecordController.this.mWriteNdefController.calculateNdefMessageSize(ApplicationRecordController.this.isRecordEmpty);
            }
        });
    }

    @Override
    public void initializeDefaults() {
    }

    @Override
    public IRecord generateRecord() {
        return new ApplicationRecord(this.applicationPackageNameTextField.getText(), NDEFRecordType.AAR_RECORD);
    }

    @Override
    public void updateMessageSize(int size) {
    }

    @Override
    public void initializeWith(IRecord record) {
        if (record == null) {
            return;
        }
        if (record instanceof ApplicationRecord) {
            this.applicationPackageNameTextField.setText(((ApplicationRecord)record).getPackageName());
        }
    }

    @Override
    public void setParentController(WriteNdefController writeNdefController) {
        this.mWriteNdefController = writeNdefController;
    }

    @Override
    public void clearPackageName() {
        this.applicationPackageNameTextField.setText("");
    }
}

