/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.tagxplorer.controller;

import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;

public abstract class AbstractController {
    private final double screenWidth;
    private final double screenHeight;

    public AbstractController() {
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        this.screenHeight = primaryScreenBounds.getHeight();
        this.screenWidth = primaryScreenBounds.getWidth();
    }

    public final void initialize() {
        this.initializeViewDependencies();
        this.initializeLayoutDimensions();
        this.initializeListeners();
        this.initializeDefaults();
    }

    public abstract void initializeViewDependencies();

    public abstract void initializeLayoutDimensions();

    public abstract void initializeListeners();

    public abstract void initializeDefaults();

    public double getScreenWidth() {
        return this.screenWidth;
    }

    public double getScreenHeight() {
        return this.screenHeight;
    }
}

