/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.SingleMemberInjector;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import java.lang.reflect.Field;

final class SingleFieldInjector
implements SingleMemberInjector {
    final Field field;
    final InjectionPoint injectionPoint;
    final Dependency<?> dependency;
    final BindingImpl<?> binding;

    public SingleFieldInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        this.field = (Field)injectionPoint.getMember();
        this.dependency = injectionPoint.getDependencies().get(0);
        this.field.setAccessible(true);
        this.binding = injector.getBindingOrThrow(this.dependency.getKey(), errors, InjectorImpl.JitLimitation.NO_JIT);
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(Errors errors, InternalContext context, Object o2) {
        errors = errors.withSource(this.dependency);
        Dependency<?> previous = context.pushDependency(this.dependency, this.binding.getSource());
        try {
            Object value = this.binding.getInternalFactory().get(errors, context, this.dependency, false);
            this.field.set(o2, value);
        }
        catch (ErrorsException e2) {
            errors.withSource(this.injectionPoint).merge(e2.getErrors());
        }
        catch (IllegalAccessException e3) {
            throw new AssertionError((Object)e3);
        }
        finally {
            context.popStateAndSetDependency(previous);
        }
    }
}

