/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableSet;
import com.google.inject.internal.ConstructionContext;
import com.google.inject.internal.ConstructionProxy;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.MembersInjectorImpl;
import com.google.inject.internal.ProvisionListenerStackCallback;
import com.google.inject.internal.SingleParameterInjector;
import com.google.inject.spi.InjectionPoint;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

final class ConstructorInjector<T> {
    private final ImmutableSet<InjectionPoint> injectableMembers;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(Set<InjectionPoint> injectableMembers, ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] parameterInjectors, MembersInjectorImpl<T> membersInjector) {
        this.injectableMembers = ImmutableSet.copyOf(injectableMembers);
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = parameterInjectors;
        this.membersInjector = membersInjector;
    }

    public ImmutableSet<InjectionPoint> getInjectableMembers() {
        return this.injectableMembers;
    }

    ConstructionProxy<T> getConstructionProxy() {
        return this.constructionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(final Errors errors, final InternalContext context, Class<?> expectedType, ProvisionListenerStackCallback<T> provisionCallback) throws ErrorsException {
        final ConstructionContext constructionContext = context.getConstructionContext(this);
        InjectorImpl.InjectorOptions options = context.getInjectorOptions();
        if (constructionContext.isConstructing()) {
            return constructionContext.createProxy(errors, options, expectedType);
        }
        Object t2 = constructionContext.getCurrentReference();
        if (t2 != null) {
            if (options.disableCircularProxies) {
                throw errors.circularDependenciesDisabled(expectedType).toException();
            }
            return t2;
        }
        constructionContext.startConstruction();
        try {
            if (!provisionCallback.hasListeners()) {
                Object t3 = this.provision(errors, context, constructionContext);
                return t3;
            }
            T t4 = provisionCallback.provision(errors, context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() throws ErrorsException {
                    return ConstructorInjector.this.provision(errors, context, constructionContext);
                }
            });
            return t4;
        }
        finally {
            constructionContext.finishConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T provision(Errors errors, InternalContext context, ConstructionContext<T> constructionContext) throws ErrorsException {
        try {
            T t2;
            Object parameters;
            try {
                parameters = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
                t2 = this.constructionProxy.newInstance(parameters);
                constructionContext.setProxyDelegates(t2);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t2);
            this.membersInjector.injectMembers(t2, errors, context, false);
            this.membersInjector.notifyListeners(t2, errors);
            parameters = t2;
            return (T)parameters;
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw errors.withSource(this.constructionProxy.getInjectionPoint()).errorInjectingConstructor(cause).toException();
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }
}

