/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Equivalences;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableSoftReference;
import com.google.common.base.FinalizableWeakReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ForwardingConcurrentMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.MapEvictionListener;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    static final int RECENCY_THRESHOLD = 64;
    final transient int segmentMask;
    final transient int segmentShift;
    final transient Segment[] segments;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final int maximumSize;
    final Queue<ReferenceEntry<K, V>> pendingEvictionNotifications;
    final MapEvictionListener<? super K, ? super V> evictionListener;
    final int concurrencyLevel;
    final transient EntryFactory entryFactory;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public ValueReference<Object, Object> copyFor(ReferenceEntry<Object, Object> entry) {
            throw new AssertionError();
        }

        @Override
        public Object waitForValue() {
            throw new AssertionError();
        }

        @Override
        public void clear() {
        }
    };
    static final Queue<Object> discardingQueue = new AbstractQueue<Object>(){

        @Override
        public boolean offer(Object o2) {
            return true;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }
    };
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 4L;

    CustomConcurrentHashMap(MapMaker builder) {
        int segmentSize;
        int segmentCount;
        this.keyStrength = builder.getKeyStrength();
        this.valueStrength = builder.getValueStrength();
        this.keyEquivalence = builder.getKeyEquivalence();
        this.valueEquivalence = builder.getValueEquivalence();
        this.expireAfterAccessNanos = builder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = builder.getExpireAfterWriteNanos();
        this.maximumSize = builder.maximumSize;
        boolean evictsBySize = this.evictsBySize();
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.expires(), evictsBySize);
        MapEvictionListener evictionListener = builder.evictionListener;
        if (evictionListener == null || evictionListener.equals(NullListener.INSTANCE)) {
            NullListener defaultListener;
            Queue<Object> defaultQueue = discardingQueue;
            this.pendingEvictionNotifications = defaultQueue;
            this.evictionListener = defaultListener = NullListener.INSTANCE;
        } else {
            this.pendingEvictionNotifications = new ConcurrentLinkedQueue<ReferenceEntry<K, V>>();
            this.evictionListener = evictionListener;
        }
        this.concurrencyLevel = CustomConcurrentHashMap.filterConcurrencyLevel(builder.getConcurrencyLevel());
        int initialCapacity = builder.getInitialCapacity();
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        int segmentShift = 0;
        for (segmentCount = 1; !(segmentCount >= this.concurrencyLevel || evictsBySize && segmentCount * 2 > this.maximumSize); segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        this.segments = this.newSegmentArray(segmentCount);
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * segmentCount < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        if (evictsBySize) {
            int maximumSegmentSize = this.maximumSize / segmentCount + 1;
            int remainder = this.maximumSize % segmentCount;
            for (int i2 = 0; i2 < this.segments.length; ++i2) {
                if (i2 == remainder) {
                    --maximumSegmentSize;
                }
                this.segments[i2] = this.createSegment(segmentSize, maximumSegmentSize);
            }
        } else {
            for (int i3 = 0; i3 < this.segments.length; ++i3) {
                this.segments[i3] = this.createSegment(segmentSize, -1);
            }
        }
    }

    boolean evictsBySize() {
        return this.maximumSize != -1;
    }

    boolean expires() {
        return this.expiresAfterWrite() || this.expiresAfterAccess();
    }

    boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    static int filterConcurrencyLevel(int concurrenyLevel) {
        return Math.min(concurrenyLevel, 65536);
    }

    private static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    private static int rehash(int h2) {
        h2 += h2 << 15 ^ 0xFFFFCD7D;
        h2 ^= h2 >>> 10;
        h2 += h2 << 3;
        h2 ^= h2 >>> 6;
        h2 += (h2 << 2) + (h2 << 14);
        return h2 ^ h2 >>> 16;
    }

    void setValueReference(ReferenceEntry<K, V> entry, ValueReference<K, V> valueReference) {
        entry.setValueReference(valueReference);
    }

    @GuardedBy(value="Segment.this")
    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
        ValueReference<K, V> valueReference = original.getValueReference();
        ReferenceEntry<K, V> newEntry = this.entryFactory.copyEntry(this, original, newNext);
        newEntry.setValueReference(valueReference.copyFor(newEntry));
        return newEntry;
    }

    int hash(Object key) {
        int h2 = this.keyEquivalence.hash(Preconditions.checkNotNull(key));
        return CustomConcurrentHashMap.rehash(h2);
    }

    void reclaimValue(ReferenceEntry<K, V> entry) {
        int hash = entry.getHash();
        if (this.segmentFor(hash).reclaimValue(entry, hash)) {
            this.pendingEvictionNotifications.offer(entry);
        }
    }

    boolean removeEntry(ReferenceEntry<K, V> entry) {
        int hash = entry.getHash();
        return this.segmentFor(hash).removeEntry(entry, hash);
    }

    @GuardedBy(value="Segment.this")
    static void connectExpirables(Expirable previous, Expirable next) {
        previous.setNextExpirable(next);
        next.setPreviousExpirable(previous);
    }

    @GuardedBy(value="Segment.this")
    static void nullifyExpirable(Expirable nulled) {
        nulled.setNextExpirable(NullExpirable.INSTANCE);
        nulled.setPreviousExpirable(NullExpirable.INSTANCE);
    }

    boolean isExpired(ReferenceEntry<K, V> entry) {
        return this.isExpired((Expirable)((Object)entry), System.nanoTime());
    }

    boolean isExpired(Expirable expirable, long now) {
        return now - expirable.getExpirationTime() > 0L;
    }

    V getUnexpiredValue(ReferenceEntry<K, V> e2) {
        V value = e2.getValueReference().get();
        return (V)(this.expires() && this.isExpired(e2) ? null : value);
    }

    void processPendingNotifications() {
        ReferenceEntry<K, V> entry;
        while ((entry = this.pendingEvictionNotifications.poll()) != null) {
            this.evictionListener.onEviction(entry.getKey(), entry.getValueReference().get());
        }
    }

    @GuardedBy(value="Segment.this")
    static void connectEvictables(Evictable previous, Evictable next) {
        previous.setNextEvictable(next);
        next.setPreviousEvictable(previous);
    }

    @GuardedBy(value="Segment.this")
    static void nullifyEvictable(Evictable nulled) {
        nulled.setNextEvictable(NullEvictable.INSTANCE);
        nulled.setPreviousEvictable(NullEvictable.INSTANCE);
    }

    final Segment[] newSegmentArray(int ssize) {
        return (Segment[])Array.newInstance(Segment.class, ssize);
    }

    Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    Segment createSegment(int initialCapacity, int maxSegmentSize) {
        return new Segment(initialCapacity, maxSegmentSize);
    }

    @Override
    public boolean isEmpty() {
        int i2;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i2 = 0; i2 < segments.length; ++i2) {
            if (segments[i2].count != 0) {
                return false;
            }
            mc[i2] = segments[i2].modCount;
            mcsum += mc[i2];
        }
        if (mcsum != 0) {
            for (i2 = 0; i2 < segments.length; ++i2) {
                if (segments[i2].count == 0 && mc[i2] == segments[i2].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k2 = 0; k2 < 2; ++k2) {
            int i2;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i2 = 0; i2 < segments.length; ++i2) {
                sum += (long)segments[i2].count;
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
            }
            if (mcsum != 0) {
                for (i2 = 0; i2 < segments.length; ++i2) {
                    check += (long)segments[i2].count;
                    if (mc[i2] == segments[i2].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            sum = 0L;
            for (Segment segment : segments) {
                segment.lock();
            }
            for (Segment segment : segments) {
                sum += (long)segment.count;
            }
            for (Segment segment : segments) {
                segment.unlock();
            }
        }
        return Ints.saturatedCast(sum);
    }

    @Override
    public V get(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, "value");
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k2 = 0; k2 < 2; ++k2) {
            int mcsum = 0;
            for (int i2 = 0; i2 < segments.length; ++i2) {
                int c2 = segments[i2].count;
                mc[i2] = segments[i2].modCount;
                mcsum += mc[i2];
                if (!segments[i2].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i3 = 0; i3 < segments.length; ++i3) {
                    int c3 = segments[i3].count;
                    if (mc[i3] == segments[i3].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment segment : segments) {
            segment.lock();
        }
        try {
            for (Segment segment : segments) {
                if (!segment.containsValue(value)) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            for (Segment segment : segments) {
                segment.unlock();
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        for (Map.Entry<K, V> e2 : m2.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash, this.expires());
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    Object writeReplace() {
        return new SerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expireAfterWriteNanos, this.expireAfterAccessNanos, this.maximumSize, this.concurrencyLevel, this.evictionListener, this);
    }

    static /* synthetic */ ValueReference access$200() {
        return CustomConcurrentHashMap.unset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<K, V>
    extends AbstractSerializationProxy<K, V> {
        private static final long serialVersionUID = 2L;

        SerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, MapEvictionListener<? super K, ? super V> evictionListener, ConcurrentMap<K, V> delegate) {
            super(keyStrength, valueStrength, keyEquivalence, valueEquivalence, expireAfterWriteNanos, expireAfterAccessNanos, maximumSize, concurrencyLevel, evictionListener, delegate);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.writeMapTo(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.delegate = mapMaker.makeMap();
            this.readEntries(in);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractSerializationProxy<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 2L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final long expireAfterWriteNanos;
        final long expireAfterAccessNanos;
        final int maximumSize;
        final int concurrencyLevel;
        final MapEvictionListener<? super K, ? super V> evictionListener;
        transient ConcurrentMap<K, V> delegate;

        AbstractSerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expireAfterWriteNanos, long expireAfterAccessNanos, int maximumSize, int concurrencyLevel, MapEvictionListener<? super K, ? super V> evictionListener, ConcurrentMap<K, V> delegate) {
            this.keyStrength = keyStrength;
            this.valueStrength = valueStrength;
            this.keyEquivalence = keyEquivalence;
            this.valueEquivalence = valueEquivalence;
            this.expireAfterWriteNanos = expireAfterWriteNanos;
            this.expireAfterAccessNanos = expireAfterAccessNanos;
            this.maximumSize = maximumSize;
            this.concurrencyLevel = concurrencyLevel;
            this.evictionListener = evictionListener;
            this.delegate = delegate;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        void writeMapTo(ObjectOutputStream out) throws IOException {
            out.writeInt(this.delegate.size());
            for (Map.Entry entry : this.delegate.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
            out.writeObject(null);
        }

        MapMaker readMapMaker(ObjectInputStream in) throws IOException {
            int size = in.readInt();
            MapMaker mapMaker = new MapMaker().initialCapacity(size).setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).privateKeyEquivalence(this.keyEquivalence).privateValueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel);
            mapMaker.evictionListener(this.evictionListener);
            if (this.expireAfterWriteNanos > 0L) {
                mapMaker.expireAfterWrite(this.expireAfterWriteNanos, TimeUnit.NANOSECONDS);
            }
            if (this.expireAfterAccessNanos > 0L) {
                mapMaker.expireAfterAccess(this.expireAfterAccessNanos, TimeUnit.NANOSECONDS);
            }
            if (this.maximumSize != -1) {
                mapMaker.maximumSize(this.maximumSize);
            }
            return mapMaker;
        }

        void readEntries(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object key;
            while ((key = in.readObject()) != null) {
                Object value = in.readObject();
                this.delegate.put(key, value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object key = e2.getKey();
            if (key == null) {
                return false;
            }
            Object v2 = CustomConcurrentHashMap.this.get(key);
            return v2 != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(e2.getValue(), v2);
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object key = e2.getKey();
            return key != null && CustomConcurrentHashMap.this.remove(key, e2.getValue());
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return CustomConcurrentHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return CustomConcurrentHashMap.this.containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            return CustomConcurrentHashMap.this.remove(o2) != null;
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V newValue) {
            Object oldValue = CustomConcurrentHashMap.this.put(this.key, newValue);
            this.value = newValue;
            return oldValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        ReferenceEntry<K, V> nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = CustomConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = CustomConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        boolean advanceTo(ReferenceEntry<K, V> entry) {
            Object key = entry.getKey();
            Object value = CustomConcurrentHashMap.this.getUnexpiredValue(entry);
            if (key != null && value != null) {
                this.nextExternal = new WriteThroughEntry(key, value);
                return true;
            }
            return false;
        }

        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            Preconditions.checkState(this.lastReturned != null);
            CustomConcurrentHashMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Segment
    extends ReentrantLock {
        volatile int count;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        final int maxSegmentSize;
        final Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger recencyQueueLength;
        @GuardedBy(value="Segment.this")
        final Evictable evictionHead = new Evictable(){
            @GuardedBy(value="Segment.this")
            Evictable nextEvictable = this;
            @GuardedBy(value="Segment.this")
            Evictable previousEvictable = this;

            public Evictable getNextEvictable() {
                return this.nextEvictable;
            }

            public void setNextEvictable(Evictable next) {
                this.nextEvictable = next;
            }

            public Evictable getPreviousEvictable() {
                return this.previousEvictable;
            }

            public void setPreviousEvictable(Evictable previous) {
                this.previousEvictable = previous;
            }
        };
        final Expirable expirationHead = new Expirable(){
            @GuardedBy(value="Segment.this")
            Expirable nextExpirable = this;
            @GuardedBy(value="Segment.this")
            Expirable previousExpirable = this;

            public long getExpirationTime() {
                return Long.MAX_VALUE;
            }

            public void setExpirationTime(long time) {
            }

            public Expirable getNextExpirable() {
                return this.nextExpirable;
            }

            public void setNextExpirable(Expirable next) {
                this.nextExpirable = next;
            }

            public Expirable getPreviousExpirable() {
                return this.previousExpirable;
            }

            public void setPreviousExpirable(Expirable previous) {
                this.previousExpirable = previous;
            }
        };

        Segment(int initialCapacity, int maxSegmentSize) {
            this.initTable(this.newEntryArray(initialCapacity));
            this.maxSegmentSize = maxSegmentSize;
            if (CustomConcurrentHashMap.this.evictsBySize() || CustomConcurrentHashMap.this.expires()) {
                this.recencyQueue = new ConcurrentLinkedQueue();
                this.recencyQueueLength = new AtomicInteger();
            } else {
                this.recencyQueue = null;
                this.recencyQueueLength = null;
            }
        }

        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            return new AtomicReferenceArray(size);
        }

        void initTable(AtomicReferenceArray<ReferenceEntry<K, V>> newTable) {
            this.threshold = newTable.length() * 3 / 4;
            if (this.threshold == this.maxSegmentSize) {
                ++this.threshold;
            }
            this.table = newTable;
        }

        @GuardedBy(value="Segment.this")
        void setValue(ReferenceEntry<K, V> entry, V value) {
            if (CustomConcurrentHashMap.this.evictsBySize() || CustomConcurrentHashMap.this.expires()) {
                Preconditions.checkState(this.isLocked());
                this.recordWrite(entry);
            }
            CustomConcurrentHashMap.this.setValueReference(entry, CustomConcurrentHashMap.this.valueStrength.referenceValue(entry, value));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recordRead(ReferenceEntry<K, V> entry) {
            if (CustomConcurrentHashMap.this.expiresAfterAccess()) {
                this.recordExpirationTime((Expirable)((Object)entry), CustomConcurrentHashMap.this.expireAfterAccessNanos);
            }
            this.recencyQueue.add(entry);
            if (this.recencyQueueLength.incrementAndGet() > 64 && this.tryLock()) {
                try {
                    this.drainRecencyQueue();
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        void recordWrite(ReferenceEntry<K, V> entry) {
            Preconditions.checkState(this.isLocked());
            this.drainRecencyQueue();
            if (entry instanceof Evictable) {
                this.addEvictable((Evictable)((Object)entry));
            }
            if (entry instanceof Expirable) {
                long expiration = CustomConcurrentHashMap.this.expiresAfterAccess() ? CustomConcurrentHashMap.this.expireAfterAccessNanos : CustomConcurrentHashMap.this.expireAfterWriteNanos;
                Expirable expirable = (Expirable)((Object)entry);
                this.recordExpirationTime(expirable, expiration);
                this.addExpirable(expirable);
            }
        }

        @GuardedBy(value="Segment.this")
        void drainRecencyQueue() {
            ReferenceEntry entry;
            Preconditions.checkState(this.isLocked());
            int drained = 0;
            while ((entry = this.recencyQueue.poll()) != null) {
                Expirable expirable;
                Evictable evictable;
                if (entry instanceof Evictable && this.inEvictionList(evictable = (Evictable)((Object)entry))) {
                    this.addEvictable(evictable);
                }
                if (entry instanceof Expirable && this.inExpirationList(expirable = (Expirable)((Object)entry))) {
                    this.addExpirable(expirable);
                }
                ++drained;
            }
            this.recencyQueueLength.addAndGet(-drained);
        }

        @GuardedBy(value="Segment.this")
        void addExpirable(Expirable expirable) {
            Preconditions.checkState(this.isLocked());
            CustomConcurrentHashMap.connectExpirables(expirable.getPreviousExpirable(), expirable.getNextExpirable());
            CustomConcurrentHashMap.connectExpirables(this.expirationHead.getPreviousExpirable(), expirable);
            CustomConcurrentHashMap.connectExpirables(expirable, this.expirationHead);
        }

        void recordExpirationTime(Expirable expirable, long expirationNanos) {
            expirable.setExpirationTime(System.nanoTime() + expirationNanos);
        }

        @GuardedBy(value="Segment.this")
        void removeExpirable(Expirable expirable) {
            Preconditions.checkState(this.isLocked());
            CustomConcurrentHashMap.connectExpirables(expirable.getPreviousExpirable(), expirable.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(expirable);
        }

        @GuardedBy(value="Segment.this")
        boolean inExpirationList(Expirable expirable) {
            return expirable.getNextExpirable() != NullExpirable.INSTANCE;
        }

        @GuardedBy(value="Segment.this")
        void expireEntries() {
            Preconditions.checkState(this.isLocked());
            this.drainRecencyQueue();
            Expirable expirable = this.expirationHead.getNextExpirable();
            if (expirable == this.expirationHead) {
                return;
            }
            long now = System.nanoTime();
            while (expirable != this.expirationHead && CustomConcurrentHashMap.this.isExpired(expirable, now)) {
                ReferenceEntry entry = (ReferenceEntry)((Object)expirable);
                if (this.removeEntry(entry, entry.getHash())) {
                    CustomConcurrentHashMap.this.pendingEvictionNotifications.offer(entry);
                }
                this.removeExpirable(expirable);
                expirable = this.expirationHead.getNextExpirable();
            }
        }

        @GuardedBy(value="Segment.this")
        void clearExpirationQueue() {
            Preconditions.checkState(this.isLocked());
            Expirable expirable = this.expirationHead.getNextExpirable();
            while (expirable != this.expirationHead) {
                Expirable next = expirable.getNextExpirable();
                CustomConcurrentHashMap.nullifyExpirable(expirable);
                expirable = next;
            }
            this.expirationHead.setNextExpirable(this.expirationHead);
            this.expirationHead.setPreviousExpirable(this.expirationHead);
        }

        @GuardedBy(value="Segment.this")
        void evictEntry() {
            Preconditions.checkState(this.isLocked());
            this.drainRecencyQueue();
            Evictable evictable = this.evictionHead.getNextEvictable();
            Preconditions.checkState(evictable != this.evictionHead);
            ReferenceEntry entry = (ReferenceEntry)((Object)evictable);
            if (!this.removeEntry(entry, entry.getHash())) {
                throw new AssertionError();
            }
            CustomConcurrentHashMap.this.pendingEvictionNotifications.offer(entry);
        }

        @GuardedBy(value="Segment.this")
        void addEvictable(Evictable evictable) {
            Preconditions.checkState(this.isLocked());
            if (evictable.getNextEvictable() != this.evictionHead) {
                CustomConcurrentHashMap.connectEvictables(evictable.getPreviousEvictable(), evictable.getNextEvictable());
                CustomConcurrentHashMap.connectEvictables(this.evictionHead.getPreviousEvictable(), evictable);
                CustomConcurrentHashMap.connectEvictables(evictable, this.evictionHead);
            }
        }

        @GuardedBy(value="Segment.this")
        void removeEvictable(Evictable evictable) {
            Preconditions.checkState(this.isLocked());
            CustomConcurrentHashMap.connectEvictables(evictable.getPreviousEvictable(), evictable.getNextEvictable());
            CustomConcurrentHashMap.nullifyEvictable(evictable);
        }

        @GuardedBy(value="Segment.this")
        boolean inEvictionList(Evictable evictable) {
            return evictable.getNextEvictable() != NullEvictable.INSTANCE;
        }

        @GuardedBy(value="Segment.this")
        void clearEvictionQueue() {
            Preconditions.checkState(this.isLocked());
            Evictable evictable = this.evictionHead.getNextEvictable();
            while (evictable != this.evictionHead) {
                Evictable next = evictable.getNextEvictable();
                CustomConcurrentHashMap.nullifyEvictable(evictable);
                evictable = next;
            }
            this.evictionHead.setNextEvictable(this.evictionHead);
            this.evictionHead.setPreviousEvictable(this.evictionHead);
        }

        ReferenceEntry<K, V> getFirst(int hash) {
            AtomicReferenceArray table = this.table;
            return table.get(hash & table.length() - 1);
        }

        public ReferenceEntry<K, V> getEntry(Object key, int hash) {
            if (this.count != 0) {
                for (ReferenceEntry e2 = this.getFirst(hash); e2 != null; e2 = e2.getNext()) {
                    Object entryKey;
                    if (e2.getHash() != hash || (entryKey = e2.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey) || CustomConcurrentHashMap.this.expires() && CustomConcurrentHashMap.this.isExpired(e2)) continue;
                    if (CustomConcurrentHashMap.this.evictsBySize() || CustomConcurrentHashMap.this.expiresAfterAccess()) {
                        this.recordRead(e2);
                    }
                    return e2;
                }
            }
            return null;
        }

        V get(Object key, int hash) {
            ReferenceEntry entry = this.getEntry(key, hash);
            if (entry == null) {
                return null;
            }
            return entry.getValueReference().get();
        }

        boolean containsKey(Object key, int hash) {
            if (this.count != 0) {
                for (ReferenceEntry e2 = this.getFirst(hash); e2 != null; e2 = e2.getNext()) {
                    Object entryKey;
                    if (e2.getHash() != hash || (entryKey = e2.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    return CustomConcurrentHashMap.this.getUnexpiredValue(e2) != null;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                AtomicReferenceArray table = this.table;
                int length = table.length();
                for (int i2 = 0; i2 < length; ++i2) {
                    for (ReferenceEntry e2 = table.get(i2); e2 != null; e2 = e2.getNext()) {
                        Object entryValue = CustomConcurrentHashMap.this.getUnexpiredValue(e2);
                        if (entryValue == null || !CustomConcurrentHashMap.this.valueEquivalence.equivalent(value, entryValue)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            Preconditions.checkNotNull(oldValue);
            Preconditions.checkNotNull(newValue);
            this.lock();
            try {
                if (CustomConcurrentHashMap.this.expires()) {
                    this.expireEntries();
                }
                for (ReferenceEntry e2 = this.getFirst(hash); e2 != null; e2 = e2.getNext()) {
                    Object entryKey = e2.getKey();
                    if (e2.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e2.getValueReference().get();
                    if (entryValue == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (CustomConcurrentHashMap.this.valueEquivalence.equivalent(oldValue, entryValue)) {
                        this.setValue(e2, newValue);
                        boolean bl3 = true;
                        return bl3;
                    }
                    if (!CustomConcurrentHashMap.this.evictsBySize() && !CustomConcurrentHashMap.this.expires()) continue;
                    this.recordWrite(e2);
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K key, int hash, V newValue) {
            Preconditions.checkNotNull(newValue);
            this.lock();
            try {
                if (CustomConcurrentHashMap.this.expires()) {
                    this.expireEntries();
                }
                for (ReferenceEntry e2 = this.getFirst(hash); e2 != null; e2 = e2.getNext()) {
                    Object entryKey = e2.getKey();
                    if (e2.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e2.getValueReference().get();
                    if (entryValue == null) {
                        Object v2 = null;
                        return v2;
                    }
                    this.setValue(e2, newValue);
                    Object v3 = entryValue;
                    return v3;
                }
                Object v4 = null;
                return v4;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) {
            Preconditions.checkNotNull(value);
            this.lock();
            try {
                ReferenceEntry first;
                int newCount;
                if (CustomConcurrentHashMap.this.expires()) {
                    this.expireEntries();
                }
                if ((newCount = this.count + 1) > this.threshold) {
                    this.expand();
                }
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e2 = first = table.get(index); e2 != null; e2 = e2.getNext()) {
                    boolean absent;
                    Object entryKey = e2.getKey();
                    if (e2.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e2.getValueReference().get();
                    boolean bl2 = absent = entryValue == null;
                    if (onlyIfAbsent && !absent) {
                        if (CustomConcurrentHashMap.this.evictsBySize() || CustomConcurrentHashMap.this.expires()) {
                            this.recordWrite(e2);
                        }
                        Object v2 = entryValue;
                        return v2;
                    }
                    if (absent) {
                        ReferenceEntry notifyEntry = CustomConcurrentHashMap.this.entryFactory.newEntry(CustomConcurrentHashMap.this, key, hash, null);
                        CustomConcurrentHashMap.this.pendingEvictionNotifications.offer(notifyEntry);
                    }
                    this.setValue(e2, value);
                    Object v3 = entryValue;
                    return v3;
                }
                if (CustomConcurrentHashMap.this.evictsBySize() && newCount > this.maxSegmentSize) {
                    this.evictEntry();
                    newCount = this.count + 1;
                    first = table.get(index);
                }
                ++this.modCount;
                ReferenceEntry newEntry = CustomConcurrentHashMap.this.entryFactory.newEntry(CustomConcurrentHashMap.this, key, hash, first);
                this.setValue(newEntry, value);
                table.set(index, newEntry);
                this.count = newCount;
                Object v4 = null;
                return v4;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        @GuardedBy(value="Segment.this")
        void expand() {
            Preconditions.checkState(this.isLocked());
            AtomicReferenceArray oldTable = this.table;
            int oldCapacity = oldTable.length();
            if (oldCapacity >= 0x40000000) {
                return;
            }
            AtomicReferenceArray newTable = this.newEntryArray(oldCapacity << 1);
            this.threshold = newTable.length() * 3 / 4;
            int newMask = newTable.length() - 1;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                ReferenceEntry e2;
                ReferenceEntry head = oldTable.get(oldIndex);
                if (head == null) continue;
                ReferenceEntry next = head.getNext();
                int headIndex = head.getHash() & newMask;
                if (next == null) {
                    newTable.set(headIndex, head);
                    continue;
                }
                ReferenceEntry tail = head;
                int tailIndex = headIndex;
                for (e2 = next; e2 != null; e2 = e2.getNext()) {
                    int newIndex = e2.getHash() & newMask;
                    if (newIndex == tailIndex) continue;
                    tailIndex = newIndex;
                    tail = e2;
                }
                newTable.set(tailIndex, tail);
                for (e2 = head; e2 != tail; e2 = e2.getNext()) {
                    Object key = e2.getKey();
                    if (key == null) continue;
                    int newIndex = e2.getHash() & newMask;
                    ReferenceEntry newNext = newTable.get(newIndex);
                    newTable.set(newIndex, CustomConcurrentHashMap.this.copyEntry(e2, newNext));
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash, boolean expire) {
            this.lock();
            try {
                ReferenceEntry first;
                if (expire) {
                    this.expireEntries();
                }
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e2 = first = table.get(index); e2 != null; e2 = e2.getNext()) {
                    Object entryKey = e2.getKey();
                    if (e2.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e2.getValueReference().get();
                    ++this.modCount;
                    ReferenceEntry newFirst = this.removeFromTable(first, e2);
                    table.set(index, newFirst);
                    this.count = newCount;
                    Object v2 = entryValue;
                    return v2;
                }
                Object v3 = null;
                return v3;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(Object key, int hash, Object value) {
            Preconditions.checkNotNull(value);
            this.lock();
            try {
                ReferenceEntry first;
                if (CustomConcurrentHashMap.this.expires()) {
                    this.expireEntries();
                }
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e2 = first = table.get(index); e2 != null; e2 = e2.getNext()) {
                    Object entryKey = e2.getKey();
                    if (e2.getHash() != hash || entryKey == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e2.getValueReference().get();
                    if (value == entryValue || value != null && entryValue != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(value, entryValue)) {
                        ++this.modCount;
                        ReferenceEntry newFirst = this.removeFromTable(first, e2);
                        table.set(index, newFirst);
                        this.count = newCount;
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reclaimValue(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry first;
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e2 = first = table.get(index); e2 != null; e2 = e2.getNext()) {
                    if (e2 != entry) continue;
                    Object entryValue = e2.getValueReference().get();
                    if (entryValue == null) {
                        ++this.modCount;
                        ReferenceEntry newFirst = this.removeFromTable(first, e2);
                        table.set(index, newFirst);
                        this.count = newCount;
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeEntry(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry first;
                int newCount = this.count - 1;
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e2 = first = table.get(index); e2 != null; e2 = e2.getNext()) {
                    if (e2 != entry) continue;
                    ++this.modCount;
                    ReferenceEntry newFirst = this.removeFromTable(first, e2);
                    table.set(index, newFirst);
                    this.count = newCount;
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.unlock();
            }
        }

        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> removeFromTable(ReferenceEntry<K, V> first, ReferenceEntry<K, V> removed) {
            Preconditions.checkState(this.isLocked());
            if (CustomConcurrentHashMap.this.expires()) {
                this.removeExpirable((Expirable)((Object)removed));
            }
            if (CustomConcurrentHashMap.this.evictsBySize()) {
                this.removeEvictable((Evictable)((Object)removed));
            }
            ReferenceEntry newFirst = removed.getNext();
            for (ReferenceEntry p2 = first; p2 != removed; p2 = p2.getNext()) {
                Object pKey = p2.getKey();
                if (pKey == null) continue;
                newFirst = CustomConcurrentHashMap.this.copyEntry(p2, newFirst);
            }
            return newFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    AtomicReferenceArray table = this.table;
                    for (int i2 = 0; i2 < table.length(); ++i2) {
                        table.set(i2, null);
                    }
                    this.clearExpirationQueue();
                    this.clearEvictionQueue();
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V referent) {
            this.referent = referent;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValueReference<K, V>
    extends FinalizableSoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(V referent, ReferenceEntry<K, V> entry) {
            super(referent, QueueHolder.queue);
            this.entry = entry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return new SoftValueReference(this.get(), entry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakValueReference<K, V>
    extends FinalizableWeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(V referent, ReferenceEntry<K, V> entry) {
            super(referent, QueueHolder.queue);
            this.entry = entry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> entry) {
            return new WeakValueReference(this.get(), entry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements Evictable,
    Expirable {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        WeakExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.nextExpirable = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previousExpirable = previous;
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable next) {
            this.nextEvictable = next;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements Evictable {
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        WeakEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable next) {
            this.nextEvictable = next;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEntry<K, V>
    extends WeakEntry<K, V>
    implements Expirable {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;

        WeakExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.nextExpirable = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previousExpirable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEntry<K, V>
    extends FinalizableWeakReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        WeakEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, QueueHolder.queue);
            this.map = map;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            if (this.map.removeEntry(this)) {
                this.map.pendingEvictionNotifications.offer(this);
            }
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            if (this.valueReference != null) {
                this.valueReference.clear();
            }
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements Evictable,
    Expirable {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        SoftExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.nextExpirable = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previousExpirable = previous;
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable next) {
            this.nextEvictable = next;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements Evictable {
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        SoftEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable next) {
            this.nextEvictable = next;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEntry<K, V>
    extends SoftEntry<K, V>
    implements Expirable {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;

        SoftExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.nextExpirable = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previousExpirable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEntry<K, V>
    extends FinalizableSoftReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        SoftEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, QueueHolder.queue);
            this.map = map;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            if (this.map.removeEntry(this)) {
                this.map.pendingEvictionNotifications.offer(this);
            }
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            if (this.valueReference != null) {
                this.valueReference.clear();
            }
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements Evictable,
    Expirable {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        StrongExpirableEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.nextExpirable = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previousExpirable = previous;
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable next) {
            this.nextEvictable = next;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements Evictable {
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        StrongEvictableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable next) {
            this.nextEvictable = next;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable previous) {
            this.previousEvictable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEntry<K, V>
    extends StrongEntry<K, V>
    implements Expirable {
        volatile long time = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;

        StrongExpirableEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(map, key, hash, next);
        }

        @Override
        public long getExpirationTime() {
            return this.time;
        }

        @Override
        public void setExpirationTime(long time) {
            this.time = time;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable next) {
            this.nextExpirable = next;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
            this.previousExpirable = previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        final K key;
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        StrongEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            this.map = map;
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            if (this.valueReference != null) {
                this.valueReference.clear();
            }
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NullListener implements MapEvictionListener
    {
        INSTANCE;


        public void onEviction(Object key, Object value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NullEvictable implements Evictable
    {
        INSTANCE;


        @Override
        public Evictable getNextEvictable() {
            return this;
        }

        @Override
        public void setNextEvictable(Evictable next) {
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this;
        }

        @Override
        public void setPreviousEvictable(Evictable previous) {
        }
    }

    static interface Evictable {
        public Evictable getNextEvictable();

        public void setNextEvictable(Evictable var1);

        public Evictable getPreviousEvictable();

        public void setPreviousEvictable(Evictable var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NullExpirable implements Expirable
    {
        INSTANCE;


        @Override
        public long getExpirationTime() {
            return 0L;
        }

        @Override
        public void setExpirationTime(long time) {
        }

        @Override
        public Expirable getNextExpirable() {
            return this;
        }

        @Override
        public void setNextExpirable(Expirable next) {
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this;
        }

        @Override
        public void setPreviousExpirable(Expirable previous) {
        }
    }

    static interface Expirable {
        public long getExpirationTime();

        public void setExpirationTime(long var1);

        public Expirable getNextExpirable();

        public void setNextExpirable(Expirable var1);

        public Expirable getPreviousExpirable();

        public void setPreviousExpirable(Expirable var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public void valueReclaimed();

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();
    }

    private static class QueueHolder {
        static final FinalizableReferenceQueue queue = new FinalizableReferenceQueue();

        private QueueHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ValueReference<K, V> {
        public V get();

        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> var1);

        public V waitForValue() throws InterruptedException;

        public void clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryFactory {
        STRONG{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        STRONG_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        STRONG_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        STRONG_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        SOFT_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        SOFT_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new SoftExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEntry<K, V>(map, key, hash, next);
            }
        }
        ,
        WEAK_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        }
        ,
        WEAK_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> map, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakExpirableEvictableEntry<K, V>(map, key, hash, next);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(map, original, newNext);
                this.copyExpirableEntry(original, newEntry);
                this.copyEvictableEntry(original, newEntry);
                return newEntry;
            }
        };

        static final int EXPIRABLE_MASK = 1;
        static final int EVICTABLE_MASK = 2;
        static final EntryFactory[][] factories;

        static EntryFactory getFactory(Strength keyStrength, boolean expireAfterWrite, boolean evictsBySize) {
            int flags = (expireAfterWrite ? 1 : 0) | (evictsBySize ? 2 : 0);
            return factories[keyStrength.ordinal()][flags];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        @GuardedBy(value="Segment.this")
        <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> map, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            return this.newEntry(map, original.getKey(), original.getHash(), newNext);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyExpirableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            Expirable originalExpirable = (Expirable)((Object)original);
            Expirable newExpirable = (Expirable)((Object)newEntry);
            newExpirable.setExpirationTime(originalExpirable.getExpirationTime());
            CustomConcurrentHashMap.connectExpirables(originalExpirable.getPreviousExpirable(), newExpirable);
            CustomConcurrentHashMap.connectExpirables(newExpirable, originalExpirable.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(originalExpirable);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyEvictableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            Evictable originalEvictable = (Evictable)((Object)original);
            Evictable newEvictable = (Evictable)((Object)newEntry);
            CustomConcurrentHashMap.connectEvictables(originalEvictable.getPreviousEvictable(), newEvictable);
            CustomConcurrentHashMap.connectEvictables(newEvictable, originalEvictable.getNextEvictable());
            CustomConcurrentHashMap.nullifyEvictable(originalEvictable);
        }

        static {
            factories = new EntryFactory[][]{{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE}, {SOFT, SOFT_EXPIRABLE, SOFT_EVICTABLE, SOFT_EXPIRABLE_EVICTABLE}, {WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE}};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Strength {
        STRONG{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new StrongValueReference(value);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.equals();
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new SoftValueReference<K, V>(value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> entry, V value) {
                return new WeakValueReference<K, V>(value, entry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        };


        abstract <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> var1, V var2);

        abstract Equivalence<Object> defaultEquivalence();
    }
}

