/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    @Deprecated
    public static Equivalence<Object> nullAwareEquals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            public boolean equivalent(@Nullable Object a10, @Nullable Object b2) {
                return a10 == null ? b2 == null : a10.equals(b2);
            }

            public int hash(@Nullable Object o2) {
                return o2 == null ? 0 : o2.hashCode();
            }
        }
        ,
        IDENTITY{

            public boolean equivalent(@Nullable Object a10, @Nullable Object b2) {
                return a10 == b2;
            }

            public int hash(@Nullable Object o2) {
                return System.identityHashCode(o2);
            }
        };

    }
}

