/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.validate;

import java.util.BitSet;

public class AllowedCharacters {
    private static final int LENGTH = 128;
    private final BitSet bitSet;
    private final boolean allowNonAscii;

    public AllowedCharacters(BitSet bitSet, boolean allowNonAscii) {
        this.bitSet = bitSet;
        this.allowNonAscii = allowNonAscii;
    }

    public BitSet bitSet() {
        return this.bitSet;
    }

    public boolean isNonAsciiAllowed() {
        return this.allowNonAscii;
    }

    public boolean check(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!(c2 >= '\u0080' ? !this.allowNonAscii : !this.bitSet.get(c2))) continue;
            return false;
        }
        return true;
    }

    public AllowedCharacters flip() {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.flip(0, 128);
        return new AllowedCharacters(bitSet, !this.allowNonAscii);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean printableOnly) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        block6: for (int i2 = 0; i2 < 128; ++i2) {
            if (!this.bitSet.get(i2)) continue;
            String toPrint = null;
            char c2 = (char)i2;
            switch (c2) {
                case ' ': {
                    toPrint = "<space>";
                    break;
                }
                case '\r': {
                    toPrint = "\\r";
                    break;
                }
                case '\n': {
                    toPrint = "\\n";
                    break;
                }
                case '\t': {
                    toPrint = "\\t";
                    break;
                }
                default: {
                    if (i2 >= 32 && i2 != 127) break;
                    if (printableOnly) continue block6;
                    toPrint = "(" + i2 + ")";
                }
            }
            sb.append(' ');
            if (toPrint == null) {
                sb.append(c2);
                continue;
            }
            sb.append(toPrint);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static class Builder {
        private final BitSet bitSet;
        private boolean allowNonAscii;

        public Builder() {
            this.bitSet = new BitSet(128);
            this.allowNonAscii = false;
        }

        public Builder(AllowedCharacters original) {
            this.bitSet = (BitSet)original.bitSet.clone();
            this.allowNonAscii = original.allowNonAscii;
        }

        public Builder allowAll() {
            this.bitSet.set(0, 128);
            this.allowNonAscii = true;
            return this;
        }

        public Builder allow(int from, int to) {
            this.bitSet.set(from, to + 1);
            return this;
        }

        public Builder allow(String characters) {
            this.setAll(characters, true);
            return this;
        }

        public Builder allow(char c2) {
            this.bitSet.set(c2);
            return this;
        }

        public Builder allowPrintable() {
            return this.allow(32, 126);
        }

        public Builder allowNonAscii() {
            this.allowNonAscii = true;
            return this;
        }

        public Builder except(String characters) {
            this.setAll(characters, false);
            return this;
        }

        public Builder except(char c2) {
            this.bitSet.set((int)c2, false);
            return this;
        }

        public AllowedCharacters build() {
            return new AllowedCharacters(this.bitSet, this.allowNonAscii);
        }

        private void setAll(String characters, boolean value) {
            for (int i2 = 0; i2 < characters.length(); ++i2) {
                char c2 = characters.charAt(i2);
                this.bitSet.set((int)c2, value);
            }
        }
    }
}

