/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VObjectPropertyValues {
    private static final String NEWLINE = System.getProperty("line.separator");

    public static String unescape(String value) {
        return VObjectPropertyValues.unescape(value, 0, value.length());
    }

    private static String unescape(String string, int start, int end) {
        StringBuilder sb = null;
        boolean escaped = false;
        block6: for (int i2 = start; i2 < end; ++i2) {
            char c2 = string.charAt(i2);
            if (escaped) {
                escaped = false;
                if (sb == null) {
                    sb = new StringBuilder(end - start);
                    sb.append(string.substring(start, i2 - 1));
                }
                switch (c2) {
                    case 'N': 
                    case 'n': {
                        sb.append(NEWLINE);
                        break;
                    }
                    default: {
                        sb.append(c2);
                        break;
                    }
                }
                continue;
            }
            switch (c2) {
                case '\\': {
                    escaped = true;
                    continue block6;
                }
                default: {
                    if (sb == null) continue block6;
                    sb.append(c2);
                }
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        if (start == 0 && end == string.length()) {
            return string;
        }
        return string.substring(start, end);
    }

    public static String escape(String value) {
        StringBuilder sb = null;
        block3: for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            switch (c2) {
                case ',': 
                case ';': 
                case '\\': {
                    if (sb == null) {
                        sb = new StringBuilder(value.length() * 2);
                        sb.append(value.substring(0, i2));
                    }
                    sb.append('\\').append(c2);
                    continue block3;
                }
                default: {
                    if (sb == null) continue block3;
                    sb.append(c2);
                }
            }
        }
        return sb == null ? value : sb.toString();
    }

    private static void escape(String string, boolean escapeCommas, StringBuilder sb) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\' || c2 == ';' || escapeCommas && c2 == ',') {
                sb.append('\\');
            }
            sb.append(c2);
        }
    }

    public static List<String> parseList(String value) {
        return VObjectPropertyValues.split(value, ',', -1);
    }

    public static String writeList(Collection<?> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                sb.append(',');
            }
            if (value == null) {
                sb.append("null");
            } else {
                VObjectPropertyValues.escape(value.toString(), true, sb);
            }
            first = false;
        }
        return sb.toString();
    }

    public static List<String> parseSemiStructured(String value) {
        return VObjectPropertyValues.parseSemiStructured(value, -1);
    }

    public static List<String> parseSemiStructured(String value, int limit) {
        return VObjectPropertyValues.split(value, ';', limit);
    }

    public static String writeSemiStructured(List<?> values, boolean escapeCommas, boolean includeTrailingSemicolons) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object value : values) {
            if (!first) {
                sb.append(';');
            }
            if (value == null) {
                sb.append("null");
            } else {
                VObjectPropertyValues.escape(value.toString(), escapeCommas, sb);
            }
            first = false;
        }
        if (!includeTrailingSemicolons) {
            VObjectPropertyValues.trimTrailingSemicolons(sb);
        }
        return sb.toString();
    }

    public static List<List<String>> parseStructured(String value) {
        if (value.length() == 0) {
            return new ArrayList<List<String>>(0);
        }
        ArrayList<List<String>> components = new ArrayList<List<String>>();
        ArrayList<String> curComponent = new ArrayList<String>();
        components.add(curComponent);
        boolean escaped = false;
        int cursor = 0;
        block5: for (int i2 = 0; i2 < value.length(); ++i2) {
            if (escaped) {
                escaped = false;
                continue;
            }
            char c2 = value.charAt(i2);
            switch (c2) {
                case ';': {
                    String v2 = VObjectPropertyValues.unescape(value, cursor, i2);
                    if (!curComponent.isEmpty() || v2.length() != 0) {
                        curComponent.add(v2);
                    }
                    curComponent = new ArrayList();
                    components.add(curComponent);
                    cursor = i2 + 1;
                    continue block5;
                }
                case ',': {
                    String v2 = VObjectPropertyValues.unescape(value, cursor, i2);
                    curComponent.add(v2);
                    cursor = i2 + 1;
                    continue block5;
                }
                case '\\': {
                    escaped = true;
                    continue block5;
                }
            }
        }
        String v3 = VObjectPropertyValues.unescape(value, cursor, value.length());
        if (!curComponent.isEmpty() || v3.length() != 0) {
            curComponent.add(v3);
        }
        return components;
    }

    public static String writeStructured(List<? extends List<?>> components, boolean includeTrailingSemicolons) {
        StringBuilder sb = new StringBuilder();
        boolean firstComponent = true;
        for (List<?> component : components) {
            if (!firstComponent) {
                sb.append(';');
            }
            boolean firstValue = true;
            for (Object value : component) {
                if (!firstValue) {
                    sb.append(',');
                }
                if (value == null) {
                    sb.append("null");
                } else {
                    VObjectPropertyValues.escape(value.toString(), true, sb);
                }
                firstValue = false;
            }
            firstComponent = false;
        }
        if (!includeTrailingSemicolons) {
            VObjectPropertyValues.trimTrailingSemicolons(sb);
        }
        return sb.toString();
    }

    public static Map<String, List<String>> parseMultimap(String value) {
        if (value.length() == 0) {
            return new HashMap<String, List<String>>(0);
        }
        LinkedHashMap<String, List<String>> multimap = new LinkedHashMap<String, List<String>>();
        String curName = null;
        ArrayList<String> curValues = new ArrayList<String>();
        boolean escaped = false;
        int cursor = 0;
        block6: for (int i2 = 0; i2 < value.length(); ++i2) {
            if (escaped) {
                escaped = false;
                continue;
            }
            char c2 = value.charAt(i2);
            switch (c2) {
                case ';': {
                    if (curName == null) {
                        curName = VObjectPropertyValues.unescape(value, cursor, i2).toUpperCase();
                    } else {
                        curValues.add(VObjectPropertyValues.unescape(value, cursor, i2));
                    }
                    if (curName.length() > 0) {
                        List existing;
                        if (curValues.isEmpty()) {
                            curValues.add("");
                        }
                        if ((existing = (List)multimap.get(curName)) == null) {
                            multimap.put(curName, curValues);
                        } else {
                            existing.addAll(curValues);
                        }
                    }
                    curName = null;
                    curValues = new ArrayList();
                    cursor = i2 + 1;
                    continue block6;
                }
                case '=': {
                    if (curName != null) continue block6;
                    curName = VObjectPropertyValues.unescape(value, cursor, i2).toUpperCase();
                    cursor = i2 + 1;
                    continue block6;
                }
                case ',': {
                    curValues.add(VObjectPropertyValues.unescape(value, cursor, i2));
                    cursor = i2 + 1;
                    continue block6;
                }
                case '\\': {
                    escaped = true;
                }
            }
        }
        if (curName == null) {
            curName = VObjectPropertyValues.unescape(value, cursor, value.length()).toUpperCase();
        } else {
            curValues.add(VObjectPropertyValues.unescape(value, cursor, value.length()));
        }
        if (curName.length() > 0) {
            List existing;
            if (curValues.isEmpty()) {
                curValues.add("");
            }
            if ((existing = (List)multimap.get(curName)) == null) {
                multimap.put(curName, curValues);
            } else {
                existing.addAll(curValues);
            }
        }
        return multimap;
    }

    public static String writeMultimap(Map<String, ? extends List<?>> multimap) {
        StringBuilder sb = new StringBuilder();
        boolean firstKey = true;
        for (Map.Entry<String, List<?>> entry : multimap.entrySet()) {
            if (!firstKey) {
                sb.append(';');
            }
            String key = entry.getKey().toUpperCase();
            VObjectPropertyValues.escape(key, true, sb);
            List<?> values = entry.getValue();
            if (values.isEmpty()) continue;
            sb.append('=');
            boolean firstValue = true;
            for (Object value : values) {
                if (!firstValue) {
                    sb.append(',');
                }
                if (value == null) {
                    sb.append("null");
                } else {
                    VObjectPropertyValues.escape(value.toString(), true, sb);
                }
                firstValue = false;
            }
            firstKey = false;
        }
        return sb.toString();
    }

    private static void trimTrailingSemicolons(StringBuilder sb) {
        int index = -1;
        for (int i2 = sb.length() - 1; i2 >= 0; --i2) {
            char c2 = sb.charAt(i2);
            if (c2 == ';') continue;
            index = i2;
            break;
        }
        sb.setLength(index + 1);
    }

    private static List<String> split(String string, char delimiter, int limit) {
        if (string.length() == 0) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean escaped = false;
        int cursor = 0;
        block3: for (int i2 = 0; i2 < string.length(); ++i2) {
            char ch = string.charAt(i2);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (ch == delimiter) {
                String value = VObjectPropertyValues.unescape(string, cursor, i2);
                list.add(value);
                cursor = i2 + 1;
                if (limit <= 0 || list.size() != limit - 1) continue;
                break;
            }
            switch (ch) {
                case '\\': {
                    escaped = true;
                    continue block3;
                }
            }
        }
        String value = VObjectPropertyValues.unescape(string, cursor, string.length());
        list.add(value);
        return list;
    }

    private VObjectPropertyValues() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StructuredValueBuilder {
        private final List<List<?>> components = new ArrayList();

        public StructuredValueBuilder append(Object value) {
            List<Object> component = value == null ? Arrays.asList(new Object[0]) : Arrays.asList(value);
            return this.append(component);
        }

        public StructuredValueBuilder append(List<?> component) {
            if (component == null) {
                component = Arrays.asList(new Object[0]);
            }
            this.components.add(component);
            return this;
        }

        public String build() {
            return this.build(true);
        }

        public String build(boolean includeTrailingSemicolons) {
            return VObjectPropertyValues.writeStructured(this.components, includeTrailingSemicolons);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StructuredValueIterator {
        private final Iterator<List<String>> it;

        public StructuredValueIterator(String string) {
            this(VObjectPropertyValues.parseStructured(string));
        }

        public StructuredValueIterator(List<List<String>> components) {
            this.it = components.iterator();
        }

        public String nextValue() {
            if (!this.hasNext()) {
                return null;
            }
            List<String> list = this.it.next();
            return list.isEmpty() ? null : list.get(0);
        }

        public List<String> nextComponent() {
            if (!this.hasNext()) {
                return new ArrayList<String>(0);
            }
            return this.it.next();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }

    public static class SemiStructuredValueBuilder {
        private final List<Object> values = new ArrayList<Object>();

        public SemiStructuredValueBuilder append(Object value) {
            if (value == null) {
                value = "";
            }
            this.values.add(value);
            return this;
        }

        public String build(boolean escapeCommas, boolean includeTrailingSemicolons) {
            return VObjectPropertyValues.writeSemiStructured(this.values, escapeCommas, includeTrailingSemicolons);
        }
    }

    public static class SemiStructuredValueIterator {
        private final Iterator<String> it;

        public SemiStructuredValueIterator(String value) {
            this(value, -1);
        }

        public SemiStructuredValueIterator(String value, int limit) {
            this.it = VObjectPropertyValues.parseSemiStructured(value, limit).iterator();
        }

        public String next() {
            if (!this.hasNext()) {
                return null;
            }
            String next = this.it.next();
            return next.length() == 0 ? null : next;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }
    }
}

