/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.io;

import com.github.mangstadt.vinnie.codec.EncoderException;
import com.github.mangstadt.vinnie.codec.QuotedPrintableCodec;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;

public class FoldedLineWriter
extends Writer {
    private static final String CRLF = "\r\n";
    private final Writer writer;
    private Integer lineLength = 75;
    private String indent = " ";
    private int curLineLength = 0;

    public FoldedLineWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeln() throws IOException {
        this.write(CRLF);
    }

    public void write(CharSequence str, boolean quotedPrintable, Charset charset) throws IOException {
        this.write(str.toString().toCharArray(), 0, str.length(), quotedPrintable, charset);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(cbuf, off, len, false, null);
    }

    public void write(char[] cbuf, int off, int len, boolean quotedPrintable, Charset charset) throws IOException {
        if (quotedPrintable) {
            String encoded;
            String str = new String(cbuf, off, len);
            QuotedPrintableCodec codec = new QuotedPrintableCodec(charset.name());
            try {
                encoded = codec.encode(str);
            }
            catch (EncoderException e2) {
                throw new IOException(e2);
            }
            cbuf = encoded.toCharArray();
            off = 0;
            len = cbuf.length;
        }
        if (this.lineLength == null) {
            this.writer.write(cbuf, off, len);
            return;
        }
        int effectiveLineLength = this.lineLength;
        if (quotedPrintable) {
            --effectiveLineLength;
        }
        int encodedCharPos = -1;
        int start = off;
        int end = off + len;
        for (int i2 = start; i2 < end; ++i2) {
            char c2 = cbuf[i2];
            if (encodedCharPos >= 0 && ++encodedCharPos == 3) {
                encodedCharPos = -1;
            }
            if (c2 == '\n') {
                this.writer.write(cbuf, start, i2 - start + 1);
                this.curLineLength = 0;
                start = i2 + 1;
                continue;
            }
            if (c2 == '\r') {
                if (i2 == end - 1 || cbuf[i2 + 1] != '\n') {
                    this.writer.write(cbuf, start, i2 - start + 1);
                    this.curLineLength = 0;
                    start = i2 + 1;
                    continue;
                }
                ++this.curLineLength;
                continue;
            }
            if (c2 == '=' && quotedPrintable) {
                encodedCharPos = 0;
            }
            if (this.curLineLength >= effectiveLineLength) {
                if (Character.isWhitespace(c2)) {
                    while (Character.isWhitespace(c2) && i2 < end - 1) {
                        c2 = cbuf[++i2];
                    }
                    if (i2 >= end - 1) break;
                }
                if (encodedCharPos > 0 && (i2 += 3 - encodedCharPos) >= end - 1 || Character.isLowSurrogate(c2) && ++i2 >= end - 1) break;
                this.writer.write(cbuf, start, i2 - start);
                if (quotedPrintable) {
                    this.writer.write(61);
                }
                this.writer.write(CRLF);
                this.writer.write(this.indent);
                this.curLineLength = this.indent.length() + 1;
                start = i2;
                continue;
            }
            ++this.curLineLength;
        }
        this.writer.write(cbuf, start, end - start);
    }

    public Integer getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(Integer lineLength) {
        if (lineLength != null) {
            if (lineLength <= 0) {
                throw new IllegalArgumentException("Line length must be greater than 0.");
            }
            if (lineLength <= this.indent.length()) {
                throw new IllegalArgumentException("Line length must be greater than indent string length.");
            }
        }
        this.lineLength = lineLength;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        if (indent.length() == 0) {
            throw new IllegalArgumentException("Indent string cannot be empty.");
        }
        if (this.lineLength != null && indent.length() >= this.lineLength) {
            throw new IllegalArgumentException("Indent string length must be less than the line length.");
        }
        block3: for (int i2 = 0; i2 < indent.length(); ++i2) {
            char c2 = indent.charAt(i2);
            switch (c2) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Indent string can only contain tabs and spaces.");
                }
            }
        }
        this.indent = indent;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

