/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.codec;

import com.github.mangstadt.vinnie.codec.DecoderException;
import com.github.mangstadt.vinnie.codec.EncoderException;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class QuotedPrintableCodec {
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final BitSet PRINTABLE_CHARS;
    private final String charset;

    public QuotedPrintableCodec(String charset) {
        this.charset = charset;
    }

    public String encode(String string) throws EncoderException {
        byte[] bytes;
        try {
            bytes = string.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e2) {
            throw new EncoderException(e2);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int n2 : bytes) {
            int b2 = n2;
            if (b2 < 0) {
                b2 = 256 + b2;
            }
            if (PRINTABLE_CHARS.get(b2)) {
                buffer.write(b2);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(b2, buffer);
        }
        try {
            return new String(buffer.toByteArray(), "US-ASCII");
        }
        catch (UnsupportedEncodingException e3) {
            throw new EncoderException(e3);
        }
    }

    public String decode(String string) throws DecoderException {
        byte[] bytes;
        try {
            bytes = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e2) {
            throw new DecoderException(e2);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b2 = bytes[i2];
            if (b2 == 61) {
                try {
                    int u2 = QuotedPrintableCodec.digit16(bytes[++i2]);
                    int l2 = QuotedPrintableCodec.digit16(bytes[++i2]);
                    buffer.write((char)((u2 << 4) + l2));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e3) {
                    throw new DecoderException("Invalid quoted-printable encoding", e3);
                }
            }
            buffer.write(b2);
        }
        try {
            return new String(buffer.toByteArray(), this.charset);
        }
        catch (UnsupportedEncodingException e4) {
            throw new DecoderException(e4);
        }
    }

    private static int digit16(byte b2) throws DecoderException {
        int i2 = Character.digit((char)b2, 16);
        if (i2 == -1) {
            throw new DecoderException("Invalid URL encoding: not a valid digit (radix 16): " + b2);
        }
        return i2;
    }

    private static void encodeQuotedPrintable(int b2, ByteArrayOutputStream buffer) {
        buffer.write(61);
        char hex1 = Character.toUpperCase(Character.forDigit(b2 >> 4 & 0xF, 16));
        char hex2 = Character.toUpperCase(Character.forDigit(b2 & 0xF, 16));
        buffer.write(hex1);
        buffer.write(hex2);
    }

    static {
        int i2;
        PRINTABLE_CHARS = new BitSet(256);
        for (i2 = 33; i2 <= 60; ++i2) {
            PRINTABLE_CHARS.set(i2);
        }
        for (i2 = 62; i2 <= 126; ++i2) {
            PRINTABLE_CHARS.set(i2);
        }
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
    }
}

