# Manufacturing Line Scripts

Scripts intended to serve as examples for production line programming

## Enable High Assurance Boot (HAB)

Required once for each device

**NOTE:** Should only be performed once per device. Should only be performed with known PKI (crts, keys)

With module unpowered, place boot jumper in BOOT_MODE_0. Apply power to vizn module

```
(env) user@host:~/sln_imx_rt_prog_and_test/Scripts/sln_viznas_iot_secure_boot/oem $ cd ../manf
(env) user@host:~/sln_imx_rt_prog_and_test/Scripts/sln_viznas_iot_secure_boot/manf $ python enable_hab.py
Establishing connection...
SUCCESS: Communication established with device.
Loading flashloader...
SUCCESS: Flashloader loaded successfully.
Jumping to flashloader entry point...
SUCCESS: Device jumped to execute flashloader.
Waiting for device to be ready for blhost...
get-property
SUCCESS: Device is ready for blhost!
Reading device unique ID...
get-property
SUCCESS: Device serial number is Rin4ZdJBFg4=
Writing memory config option block...
fill-memory
SUCCESS: Config option block loaded into RAM.
Configuring FlexSPI...
configure-memory
SUCCESS: FlexSPI configured.
Erasing flash...
flash-erase-region
SUCCESS: Flash erased.
Loading secure boot file...
SUCCESS: Loaded secure boot file.
Resetting device...
reset
SUCCESS: Device Permanently Locked with HAB!
```

## Enable encrypted XIP and permanently lock the boot mode

Required once for each device

**NOTE:** Should only be performed once per device

With module unpowered, place boot jumper in BOOT_MODE_0. Apply power to vizn module

```
(env) user@host:~/sln_imx_rt_prog_and_test/Scripts/sln_viznas_iot_secure_boot/manf $ python lock_boot_mode.py
Warning!
This operation will burn the boot fuses and permanently lock the device boot mode.
Continue? [y,n]
y
Establishing connection...
SUCCESS: Communication established with device.
Loading flashloader...
SUCCESS: Flashloader loaded successfully.
Jumping to flashloader entry point...
SUCCESS: Device jumped to execute flashloader.
Waiting for device to be ready for blhost...
get-property
SUCCESS: Device is ready for blhost!
Reading device unique ID...
get-property
SUCCESS: Device serial number is Rin4ZdJBFg4=
Programming efuse CFG5...
efuse-program-once
SUCCESS: Programmed efuse CFG5.
Programming efuse CFG4...
efuse-program-once
SUCCESS: Programmed efuse CFG4.
Resetting device...
reset
SUCCESS: Device Boot Mode Permanently Configured!
```

## Program Device with Encrypted Application

Required for each version of Encrypted Application

With module unpowered, place boot jumper in BOOT_MODE_0. Apply power to vizn module

```
(env) user@host:~/sln_imx_rt_prog_and_test/Scripts/sln_viznas_iot_secure_boot/manf $ python prog_sec_app.py

NOTE: Top jumper must be installed towards interior of the module

Establishing connection...
SUCCESS: Communication established with device.
Loading flashloader...
SUCCESS: Flashloader loaded successfully.
Jumping to flashloader entry point...
SUCCESS: Device jumped to execute flashloader.
Waiting for device to be ready for blhost...
get-property
SUCCESS: Device is ready for blhost!
Reading device unique ID...
get-property
SUCCESS: Device serial number is SS...
Writing memory config option block...
fill-memory
SUCCESS: Config option block loaded into RAM.
Configuring FlexSPI...
configure-memory
SUCCESS: FlexSPI configured.
Erasing flash...
flash-erase-region
SUCCESS: Flash erased.
Programming flash with root cert...
write-memory
SUCCESS: Programmed flash with certificates for this "thing".
Programming flash with app cert application A...
write-memory
SUCCESS: Programmed flash with certificates for this "thing".
Programming flash with app cert for bootloader...
write-memory
SUCCESS: Programmed flash with certificates for this "thing".
SUCCESS: sign_package succeeded.
Programming FICA table...
write-memory
SUCCESS: Programmed flash with certificates for this "thing".
Programming flash with secure app file...
receive-sb-file
SUCCESS: Programmed flash with secure app file.

```

Unpower module, move the boot jumper in BOOT_MODE_1 and restore power
