#!/usr/bin/env python3

'''

Copyright 2019 NXP.

This software is owned or controlled by NXP and may only be used strictly in accordance with the
license terms that accompany it. By expressly accepting such terms or by downloading, installing,
activating and/or otherwise using the software, you are agreeing that you have read, and that you
agree to comply with and are bound by, such license terms. If you do not agree to be bound by the
applicable license terms, then you may not retain, install, activate or otherwise use the software.

'''
import os
import binascii
import sys
import Ivaldi.helpers as helpers

def main():
    if len(sys.argv) < 2:
        print("Usage:")
        print("       generate_image_crt_files.py ca_name")
        print("")
        print("       ca_name: The name of the CA chain used to sign images.")
        print("")
        sys.exit(1)
    else:
        print("Generating CA and app crt binaries for entity %s" % sys.argv[1])

        CA_NAME = sys.argv[1]

        # Add a file exists check to make sure it's not failing hard

        helpers.file_format('ca/certs/' + CA_NAME + '.root.ca.crt.pem', CA_NAME + '.root.ca.bin')
        helpers.file_format('ca/certs/' + CA_NAME + '.app.a.crt.pem', CA_NAME + '.app.a.bin')

if __name__ == '__main__':
    main()
