/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     bemf_Observer.h
*
* @author   b35258
*
* @version  0.0.1.0
*
* @date     Apr-27-2015
*
* @brief    Bemf_Observer - Observer of Rotor position in d/q reference frame
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of Bemf Observer of 
* Rotor position in d/q reference frame.
*
******************************************************************************/

#ifndef BEMF_OBSERVER_H_
#define BEMF_OBSERVER_H_

#include "mc9s12zvml128.h"
#include "S12ZVM_devconfig.h"
#include "mlib.h"
#include "gflib.h"
#include "gmclib.h"
#include "gdflib.h"


/******************************************************************************
* Type definition
******************************************************************************/
typedef struct
{
	GFLIB_INTEGRATOR_TR_T		Ki_IntAto;
	GFLIB_CONTROLLER_PIAW_P_T 	PI_Pospe_Obs;
	GFLIB_CONTROLLER_PIAW_R_T 	PI_Pospe_Obs_Rec;
	GDFLIB_FILTER_MA_T          filterMA;
}ACLIB_TRACK_OBSRV_T;

typedef struct
{
	//Extended BEMF - d/q
	SWLIBS_2Syst_F16 				udtEObsrv;
	//Accumulators - d/q
	SWLIBS_2Syst_F16 				udtIObsrv;
	//Observer parameters for controllers
	GFLIB_CONTROLLER_PIAW_R_T 		PI_De_Emf;
	GFLIB_CONTROLLER_PIAW_R_T		PI_Ga_Emf;
	//misalignment error of reference frame
	tFrac16							DQtoGaDeError;
	//Configuration parameters
	tFrac16 				K1n;
    tFrac16					K2n;
	tFrac16					K3n;
	tFrac16					K4n;
	tS16					Kscale_n;

	ACLIB_TRACK_OBSRV_T 	TrackObsrv;
} ACLIB_BEMF_OBSRV_DQ_T;


/******************************************************************************
* MACRO definitions
******************************************************************************/




/******************************************************************************
* Exported functions
*******************************************************************************/
extern void ACLIB_PMSMBemfObsrvDQ(tFrac16 *f16SpeedEst, tFrac16 *PosEst, SWLIBS_2Syst_F16 *pudtCurrentAlbe, SWLIBS_2Syst_F16 *pudtVoltageAlbe, ACLIB_BEMF_OBSRV_DQ_T *pudtCtrl);
extern void ACLIB_TrackObsrv(tFrac16 *f16SpeedEst, tFrac16 *PosEst, tFrac16 DQtoGaDeError, ACLIB_TRACK_OBSRV_T *pudtCtrl);

#endif /* #ifndef BEMF_OBSERVER_H__ */
