/*******************************************************************************
 * This software is provided AS IS and without warranty of any kind. 
 * Your right to use this software is subject to separate terms and conditions entered between you and NXP.
 * If you have not entered into such terms, you have no license rights to use the code.
 * Copyright 2015~2019 NXP.
 * All rights reserved.
*******************************************************************************/

#ifndef __PD_PTN5110_REGISTER_H__
#define __PD_PTN5110_REGISTER_H__

/*******************************************************************************
 * Definitions
 ******************************************************************************/

#define TCPC_VERSION_MAJOR 1
#define TCPC_VERSION_MINOR 0

/* VENDOR_ID : */
#define TCPC_VENDOR_ID_IDX 0x00

/* PRODUCT_ID : */
#define TCPC_PRODUCT_ID_IDX 0x02

/* DEVICE_ID : */
#define TCPC_DEVICE_ID_IDX 0x04

/* USBTYPEC_REV : */
#define TCPC_USBTYPEC_REV_IDX 0x06
#define TCPC_USBTYPEC_REV_USB_TYPE_C_REVISION_MSB 7
#define TCPC_USBTYPEC_REV_USB_TYPE_C_REVISION_LSB 0
#define TCPC_USBTYPEC_REV_USB_TYPE_C_REVISION_MASK 0x00ff

/* USBPD_REV_VER : */
#define TCPC_USBPD_REV_VER_IDX 0x08
#define TCPC_USBPD_REV_VER_BCD_USBPD_REVISION_MSB 15
#define TCPC_USBPD_REV_VER_BCD_USBPD_REVISION_LSB 8
#define TCPC_USBPD_REV_VER_BCD_USBPD_REVISION_MASK 0xff00
#define TCPC_USBPD_REV_VER_BCD_USBPD_VERSION_MSB 7
#define TCPC_USBPD_REV_VER_BCD_USBPD_VERSION_LSB 0
#define TCPC_USBPD_REV_VER_BCD_USBPD_VERSION_MASK 0x00ff

/* PD_INTERFACE_REV : */
#define TCPC_PD_INTERFACE_REV_IDX 0x0a
#define TCPC_PD_INTERFACE_REV_BCD_USBPD_INTER_BLOCK_SPECIFICATION_REVISION_MSB 15
#define TCPC_PD_INTERFACE_REV_BCD_USBPD_INTER_BLOCK_SPECIFICATION_REVISION_LSB 8
#define TCPC_PD_INTERFACE_REV_BCD_USBPD_INTER_BLOCK_SPECIFICATION_REVISION_MASK 0xff00
#define TCPC_PD_INTERFACE_REV_BCD_USBPD_INTER_BLOCK_SPECIFICATION_VERSION_MSB 7
#define TCPC_PD_INTERFACE_REV_BCD_USBPD_INTER_BLOCK_SPECIFICATION_VERSION_LSB 0
#define TCPC_PD_INTERFACE_REV_BCD_USBPD_INTER_BLOCK_SPECIFICATION_VERSION_MASK 0x00ff

/* ALERT : */
#define TCPC_ALERT_IDX 0x10
#define TCPC_ALERT_VENDOR_DEFINED_EXTENDED_MSB 15
#define TCPC_ALERT_VENDOR_DEFINED_EXTENDED_LSB 15
#define TCPC_ALERT_VENDOR_DEFINED_EXTENDED_MASK 0x8000
#define TCPC_ALERT_ALERT_EXTENDED_MSB 14
#define TCPC_ALERT_ALERT_EXTENDED_LSB 14
#define TCPC_ALERT_ALERT_EXTENDED_MASK 0x4000
#define TCPC_ALERT_EXTENDED_STATUS_MSB 13
#define TCPC_ALERT_EXTENDED_STATUS_LSB 13
#define TCPC_ALERT_EXTENDED_STATUS_MASK 0x2000
#define TCPC_ALERT_BEGINNING_SOP_MESSAGE_STATUS_MSB 12
#define TCPC_ALERT_BEGINNING_SOP_MESSAGE_STATUS_LSB 12
#define TCPC_ALERT_BEGINNING_SOP_MESSAGE_STATUS_MASK 0x1000
#define TCPC_ALERT_VBUS_SINK_DISCONNECT_DETECTED_MSB 11
#define TCPC_ALERT_VBUS_SINK_DISCONNECT_DETECTED_LSB 11
#define TCPC_ALERT_VBUS_SINK_DISCONNECT_DETECTED_MASK 0x0800
#define TCPC_ALERT_RX_BUFFER_OVERFLOW_MSB 10
#define TCPC_ALERT_RX_BUFFER_OVERFLOW_LSB 10
#define TCPC_ALERT_RX_BUFFER_OVERFLOW_MASK 0x0400
#define TCPC_ALERT_FAULT_MSB 9
#define TCPC_ALERT_FAULT_LSB 9
#define TCPC_ALERT_FAULT_MASK 0x0200
#define TCPC_ALERT_VBUS_VOLTAGE_ALARM_LO_MSB 8
#define TCPC_ALERT_VBUS_VOLTAGE_ALARM_LO_LSB 8
#define TCPC_ALERT_VBUS_VOLTAGE_ALARM_LO_MASK 0x0100
#define TCPC_ALERT_VBUS_VOLTAGE_ALARM_HI_MSB 7
#define TCPC_ALERT_VBUS_VOLTAGE_ALARM_HI_LSB 7
#define TCPC_ALERT_VBUS_VOLTAGE_ALARM_HI_MASK 0x0080
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_SUCCESSFUL_MSB 6
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_SUCCESSFUL_LSB 6
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_SUCCESSFUL_MASK 0x0040
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_DISCARDED_MSB 5
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_DISCARDED_LSB 5
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_DISCARDED_MASK 0x0020
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_FAILED_MSB 4
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_FAILED_LSB 4
#define TCPC_ALERT_TRANSMIT_SOP_MESSAGE_FAILED_MASK 0x0010
#define TCPC_ALERT_RECEIVED_HARD_RESET_MSB 3
#define TCPC_ALERT_RECEIVED_HARD_RESET_LSB 3
#define TCPC_ALERT_RECEIVED_HARD_RESET_MASK 0x0008
#define TCPC_ALERT_RECEIVE_SOP_MESSAGE_STATUS_MSB 2
#define TCPC_ALERT_RECEIVE_SOP_MESSAGE_STATUS_LSB 2
#define TCPC_ALERT_RECEIVE_SOP_MESSAGE_STATUS_MASK 0x0004
#define TCPC_ALERT_PORT_POWER_STATUS_MSB 1
#define TCPC_ALERT_PORT_POWER_STATUS_LSB 1
#define TCPC_ALERT_PORT_POWER_STATUS_MASK 0x0002
#define TCPC_ALERT_CC_STATUS_ALERT_MSB 0
#define TCPC_ALERT_CC_STATUS_ALERT_LSB 0
#define TCPC_ALERT_CC_STATUS_ALERT_MASK 0x0001

/* ALERT_MASK : */
#define TCPC_ALERT_MASK_IDX 0x12
#define TCPC_ALERT_MASK_VENDOR_DEFINED_EXTENDED_MASK_MSB 15
#define TCPC_ALERT_MASK_VENDOR_DEFINED_EXTENDED_MASK_LSB 15
#define TCPC_ALERT_MASK_VENDOR_DEFINED_EXTENDED_MASK_MASK 0x8000
#define TCPC_ALERT_MASK_ALERT_EXTENDED_MASK_MSB 14
#define TCPC_ALERT_MASK_ALERT_EXTENDED_MASK_LSB 14
#define TCPC_ALERT_MASK_ALERT_EXTENDED_MASK_MASK 0x4000
#define TCPC_ALERT_MASK_EXTENDED_STATUS_MASK_MSB 13
#define TCPC_ALERT_MASK_EXTENDED_STATUS_MASK_LSB 13
#define TCPC_ALERT_MASK_EXTENDED_STATUS_MASK_MASK 0x2000
#define TCPC_ALERT_MASK_BEGINNING_SOP_MESSAGE_STATUS_MASK_MSB 12
#define TCPC_ALERT_MASK_BEGINNING_SOP_MESSAGE_STATUS_MASK_LSB 12
#define TCPC_ALERT_MASK_BEGINNING_SOP_MESSAGE_STATUS_MASK_MASK 0x1000
#define TCPC_ALERT_MASK_VBUS_SINK_DISCONNECT_DETECTED_MASKED_MSB 11
#define TCPC_ALERT_MASK_VBUS_SINK_DISCONNECT_DETECTED_MASKED_LSB 11
#define TCPC_ALERT_MASK_VBUS_SINK_DISCONNECT_DETECTED_MASKED_MASK 0x0800
#define TCPC_ALERT_MASK_RX_BUFFER_OVERFLOW_MASKED_MSB 10
#define TCPC_ALERT_MASK_RX_BUFFER_OVERFLOW_MASKED_LSB 10
#define TCPC_ALERT_MASK_RX_BUFFER_OVERFLOW_MASKED_MASK 0x0400
#define TCPC_ALERT_MASK_FAULT_MASKED_MSB 9
#define TCPC_ALERT_MASK_FAULT_MASKED_LSB 9
#define TCPC_ALERT_MASK_FAULT_MASKED_MASK 0x0200
#define TCPC_ALERT_MASK_VBUS_VOLTAGE_ALARM_LO_MASKED_MSB 8
#define TCPC_ALERT_MASK_VBUS_VOLTAGE_ALARM_LO_MASKED_LSB 8
#define TCPC_ALERT_MASK_VBUS_VOLTAGE_ALARM_LO_MASKED_MASK 0x0100
#define TCPC_ALERT_MASK_VBUS_VOLTAGE_ALARM_HI_MASKED_MSB 7
#define TCPC_ALERT_MASK_VBUS_VOLTAGE_ALARM_HI_MASKED_LSB 7
#define TCPC_ALERT_MASK_VBUS_VOLTAGE_ALARM_HI_MASKED_MASK 0x0080
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_SUCCESSFUL_INTERRUPT_MASK_MSB 6
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_SUCCESSFUL_INTERRUPT_MASK_LSB 6
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_SUCCESSFUL_INTERRUPT_MASK_MASK 0x0040
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_DISCARDED_INTERRUPT_MASK_MSB 5
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_DISCARDED_INTERRUPT_MASK_LSB 5
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_DISCARDED_INTERRUPT_MASK_MASK 0x0020
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_FAILED_INTERRUPT_MASK_MSB 4
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_FAILED_INTERRUPT_MASK_LSB 4
#define TCPC_ALERT_MASK_TRANSMIT_SOP_MESSAGE_FAILED_INTERRUPT_MASK_MASK 0x0010
#define TCPC_ALERT_MASK_RECEIVED_HARD_RESET_MESSAGE_STATUS_INTERRUPT_MASK_MSB 3
#define TCPC_ALERT_MASK_RECEIVED_HARD_RESET_MESSAGE_STATUS_INTERRUPT_MASK_LSB 3
#define TCPC_ALERT_MASK_RECEIVED_HARD_RESET_MESSAGE_STATUS_INTERRUPT_MASK_MASK 0x0008
#define TCPC_ALERT_MASK_RECEIVE_SOP_MESSAGE_STATUS_INTERRUPT_MASK_MSB 2
#define TCPC_ALERT_MASK_RECEIVE_SOP_MESSAGE_STATUS_INTERRUPT_MASK_LSB 2
#define TCPC_ALERT_MASK_RECEIVE_SOP_MESSAGE_STATUS_INTERRUPT_MASK_MASK 0x0004
#define TCPC_ALERT_MASK_PORT_POWER_STATUS_INTERRUPT_MASK_MSB 1
#define TCPC_ALERT_MASK_PORT_POWER_STATUS_INTERRUPT_MASK_LSB 1
#define TCPC_ALERT_MASK_PORT_POWER_STATUS_INTERRUPT_MASK_MASK 0x0002
#define TCPC_ALERT_MASK_CC_STATUS_INTERRUPT_MASK_MSB 0
#define TCPC_ALERT_MASK_CC_STATUS_INTERRUPT_MASK_LSB 0
#define TCPC_ALERT_MASK_CC_STATUS_INTERRUPT_MASK_MASK 0x0001

/* POWER_STATUS_MASK : */
#define TCPC_POWER_STATUS_MASK_IDX 0x14
#define TCPC_POWER_STATUS_MASK_DEBUG_ACCESSORY_CONNECTED_INTERRUPT_MASK_MSB 7
#define TCPC_POWER_STATUS_MASK_DEBUG_ACCESSORY_CONNECTED_INTERRUPT_MASK_LSB 7
#define TCPC_POWER_STATUS_MASK_DEBUG_ACCESSORY_CONNECTED_INTERRUPT_MASK_MASK 0x0080
#define TCPC_POWER_STATUS_MASK_TCPC_INITIALIZATION_STATUS_INTERRUPT_MASK_MSB 6
#define TCPC_POWER_STATUS_MASK_TCPC_INITIALIZATION_STATUS_INTERRUPT_MASK_LSB 6
#define TCPC_POWER_STATUS_MASK_TCPC_INITIALIZATION_STATUS_INTERRUPT_MASK_MASK 0x0040
#define TCPC_POWER_STATUS_MASK_SOURCE_HIGH_VOLTAGE_STATUS_INTERRUPT_MASK_MSB 5
#define TCPC_POWER_STATUS_MASK_SOURCE_HIGH_VOLTAGE_STATUS_INTERRUPT_MASK_LSB 5
#define TCPC_POWER_STATUS_MASK_SOURCE_HIGH_VOLTAGE_STATUS_INTERRUPT_MASK_MASK 0x0020
#define TCPC_POWER_STATUS_MASK_SOURCE_VBUS_STATUS_INTERRUPT_MASK_MSB 4
#define TCPC_POWER_STATUS_MASK_SOURCE_VBUS_STATUS_INTERRUPT_MASK_LSB 4
#define TCPC_POWER_STATUS_MASK_SOURCE_VBUS_STATUS_INTERRUPT_MASK_MASK 0x0010
#define TCPC_POWER_STATUS_MASK_VBUS_PRESENT_DETECTION_STATUS_INTERRUPT_MASK_MSB 3
#define TCPC_POWER_STATUS_MASK_VBUS_PRESENT_DETECTION_STATUS_INTERRUPT_MASK_LSB 3
#define TCPC_POWER_STATUS_MASK_VBUS_PRESENT_DETECTION_STATUS_INTERRUPT_MASK_MASK 0x0008
#define TCPC_POWER_STATUS_MASK_VBUS_PRESENT_STATUS_INTERRUPT_MASK_MSB 2
#define TCPC_POWER_STATUS_MASK_VBUS_PRESENT_STATUS_INTERRUPT_MASK_LSB 2
#define TCPC_POWER_STATUS_MASK_VBUS_PRESENT_STATUS_INTERRUPT_MASK_MASK 0x0004
#define TCPC_POWER_STATUS_MASK_VCONN_PRESENT_STATUS_INTERRUPT_MASK_MSB 1
#define TCPC_POWER_STATUS_MASK_VCONN_PRESENT_STATUS_INTERRUPT_MASK_LSB 1
#define TCPC_POWER_STATUS_MASK_VCONN_PRESENT_STATUS_INTERRUPT_MASK_MASK 0x0002
#define TCPC_POWER_STATUS_MASK_SINK_VBUS_CONNECTED_STATUS_INTERRUPT_MASK_MSB 0
#define TCPC_POWER_STATUS_MASK_SINK_VBUS_CONNECTED_STATUS_INTERRUPT_MASK_LSB 0
#define TCPC_POWER_STATUS_MASK_SINK_VBUS_CONNECTED_STATUS_INTERRUPT_MASK_MASK 0x0001

/* FAULT_STATUS_MASK : */
#define TCPC_FAULT_STATUS_MASK_IDX 0x15
#define TCPC_FAULT_STATUS_MASK_ALL_REGISTERS_RESET_TO_DEFAULT_INTERRUPT_STATUS_MASK_MSB 7
#define TCPC_FAULT_STATUS_MASK_ALL_REGISTERS_RESET_TO_DEFAULT_INTERRUPT_STATUS_MASK_LSB 7
#define TCPC_FAULT_STATUS_MASK_ALL_REGISTERS_RESET_TO_DEFAULT_INTERRUPT_STATUS_MASK_MASK 0x0080
#define TCPC_FAULT_STATUS_MASK_FORCE_OFF_VBUS_INTERRUPT_STATUS_MASK_MSB 6
#define TCPC_FAULT_STATUS_MASK_FORCE_OFF_VBUS_INTERRUPT_STATUS_MASK_LSB 6
#define TCPC_FAULT_STATUS_MASK_FORCE_OFF_VBUS_INTERRUPT_STATUS_MASK_MASK 0x0040
#define TCPC_FAULT_STATUS_MASK_AUTO_DISCHARGE_FAILED_INTERRUPT_STATUS_MASK_MSB 5
#define TCPC_FAULT_STATUS_MASK_AUTO_DISCHARGE_FAILED_INTERRUPT_STATUS_MASK_LSB 5
#define TCPC_FAULT_STATUS_MASK_AUTO_DISCHARGE_FAILED_INTERRUPT_STATUS_MASK_MASK 0x0020
#define TCPC_FAULT_STATUS_MASK_FORCE_DISCHARGE_FAILED_INTERRUPT_STATUS_MASK_MSB 4
#define TCPC_FAULT_STATUS_MASK_FORCE_DISCHARGE_FAILED_INTERRUPT_STATUS_MASK_LSB 4
#define TCPC_FAULT_STATUS_MASK_FORCE_DISCHARGE_FAILED_INTERRUPT_STATUS_MASK_MASK 0x0010
#define TCPC_FAULT_STATUS_MASK_VBUS_OVER_CURRENT_PROTECTION_FAULT_INTERRUPT_STATUS_MASK_MSB 3
#define TCPC_FAULT_STATUS_MASK_VBUS_OVER_CURRENT_PROTECTION_FAULT_INTERRUPT_STATUS_MASK_LSB 3
#define TCPC_FAULT_STATUS_MASK_VBUS_OVER_CURRENT_PROTECTION_FAULT_INTERRUPT_STATUS_MASK_MASK 0x0008
#define TCPC_FAULT_STATUS_MASK_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_INTERRUPT_STATUS_MASK_MSB 2
#define TCPC_FAULT_STATUS_MASK_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_INTERRUPT_STATUS_MASK_LSB 2
#define TCPC_FAULT_STATUS_MASK_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_INTERRUPT_STATUS_MASK_MASK 0x0004
#define TCPC_FAULT_STATUS_MASK_VCONN_OVER_CURRENT_FAULT_INTERRUPT_STATUS_MASK_MSB 1
#define TCPC_FAULT_STATUS_MASK_VCONN_OVER_CURRENT_FAULT_INTERRUPT_STATUS_MASK_LSB 1
#define TCPC_FAULT_STATUS_MASK_VCONN_OVER_CURRENT_FAULT_INTERRUPT_STATUS_MASK_MASK 0x0002
#define TCPC_FAULT_STATUS_MASK_I2_C_INTERFACE_ERROR_INTERRUPT_STATUS_MASK_MSB 0
#define TCPC_FAULT_STATUS_MASK_I2_C_INTERFACE_ERROR_INTERRUPT_STATUS_MASK_LSB 0
#define TCPC_FAULT_STATUS_MASK_I2_C_INTERFACE_ERROR_INTERRUPT_STATUS_MASK_MASK 0x0001

/* EXTENDED_STATUS_MASK : */
#define TCPC_EXTENDED_STATUS_MASK_IDX 0x16
#define TCPC_EXTENDED_STATUS_MASK_POR 0xFF
#define TCPC_EXTENDED_STATUS_MASK_VSAFE0_STATUS_MASK_MSB 0
#define TCPC_EXTENDED_STATUS_MASK_VSAFE0_STATUS_MASK_LSB 0
#define TCPC_EXTENDED_STATUS_MASK_VSAFE0_STATUS_MASK_MASK 0x01

/* ALERT_EXTENDED_MASK : */
#define TCPC_ALERT_EXTENDED_MASK_IDX 0x17
#define TCPC_ALERT_EXTENDED_MASK_POR 0xFF
#define TCPC_ALERT_EXTENDED_MASK_TIMER_EXPIRED_MASK_MSB 2
#define TCPC_ALERT_EXTENDED_MASK_TIMER_EXPIRED_MASK_LSB 2
#define TCPC_ALERT_EXTENDED_MASK_TIMER_EXPIRED_MASK_MASK 0x04
#define TCPC_ALERT_EXTENDED_MASK_SOURCE_FAST_ROLE_SWAP_MASK_MSB 1
#define TCPC_ALERT_EXTENDED_MASK_SOURCE_FAST_ROLE_SWAP_MASK_LSB 1
#define TCPC_ALERT_EXTENDED_MASK_SOURCE_FAST_ROLE_SWAP_MASK_MASK 0x02
#define TCPC_ALERT_EXTENDED_MASK_SINK_FAST_ROLE_SWAP_MASK_MSB 0
#define TCPC_ALERT_EXTENDED_MASK_SINK_FAST_ROLE_SWAP_MASK_LSB 0
#define TCPC_ALERT_EXTENDED_MASK_SINK_FAST_ROLE_SWAP_MASK_MASK 0x01

/* CONFIGURE_STANDARD_OUTPUT : */
#define TCPC_CONFIGURE_STANDARD_OUTPUT_IDX 0x18
#define TCPC_CONFIGURE_STANDARD_OUTPUT_HIGH_IMPEDANCE_OUTPUTS_MSB 7
#define TCPC_CONFIGURE_STANDARD_OUTPUT_HIGH_IMPEDANCE_OUTPUTS_LSB 7
#define TCPC_CONFIGURE_STANDARD_OUTPUT_HIGH_IMPEDANCE_OUTPUTS_MASK 0x0080
#define TCPC_CONFIGURE_STANDARD_OUTPUT_DEBUG_ACCESSORY_CONNECTED_MSB 6
#define TCPC_CONFIGURE_STANDARD_OUTPUT_DEBUG_ACCESSORY_CONNECTED_LSB 6
#define TCPC_CONFIGURE_STANDARD_OUTPUT_DEBUG_ACCESSORY_CONNECTED_MASK 0x0040
#define TCPC_CONFIGURE_STANDARD_OUTPUT_AUDIO_ACCESSORY_CONNECTED_MSB 5
#define TCPC_CONFIGURE_STANDARD_OUTPUT_AUDIO_ACCESSORY_CONNECTED_LSB 5
#define TCPC_CONFIGURE_STANDARD_OUTPUT_AUDIO_ACCESSORY_CONNECTED_MASK 0x0020
#define TCPC_CONFIGURE_STANDARD_OUTPUT_ACTIVE_CABLE_CONNECTED_MSB 4
#define TCPC_CONFIGURE_STANDARD_OUTPUT_ACTIVE_CABLE_CONNECTED_LSB 4
#define TCPC_CONFIGURE_STANDARD_OUTPUT_ACTIVE_CABLE_CONNECTED_MASK 0x0010
#define TCPC_CONFIGURE_STANDARD_OUTPUT_MUX_CONTROL_MSB 3
#define TCPC_CONFIGURE_STANDARD_OUTPUT_MUX_CONTROL_LSB 2
#define TCPC_CONFIGURE_STANDARD_OUTPUT_MUX_CONTROL_MASK 0x000c
#define TCPC_CONFIGURE_STANDARD_OUTPUT_CONNECTION_PRESENT_MSB 1
#define TCPC_CONFIGURE_STANDARD_OUTPUT_CONNECTION_PRESENT_LSB 1
#define TCPC_CONFIGURE_STANDARD_OUTPUT_CONNECTION_PRESENT_MASK 0x0002
#define TCPC_CONFIGURE_STANDARD_OUTPUT_CONNECTOR_ORIENTATION_GPIO0_MSB 0
#define TCPC_CONFIGURE_STANDARD_OUTPUT_CONNECTOR_ORIENTATION_GPIO0_LSB 0
#define TCPC_CONFIGURE_STANDARD_OUTPUT_CONNECTOR_ORIENTATION_GPIO0_MASK 0x0001

/* TCPC_CONTROL : */
#define TCPC_TCPC_CONTROL_IDX 0x19
#define TCPC_TCPC_CONTROL_DEBUG_ACCESSORY_CONTROL_MSB 4
#define TCPC_TCPC_CONTROL_DEBUG_ACCESSORY_CONTROL_LSB 4
#define TCPC_TCPC_CONTROL_DEBUG_ACCESSORY_CONTROL_MASK 0x0010
#define TCPC_TCPC_CONTROL_I2_C_CLOCK_STRETCHING_CONTROL_MSB 3
#define TCPC_TCPC_CONTROL_I2_C_CLOCK_STRETCHING_CONTROL_LSB 2
#define TCPC_TCPC_CONTROL_I2_C_CLOCK_STRETCHING_CONTROL_MASK 0x000c
#define TCPC_TCPC_CONTROL_BIST_TEST_MODE_MSB 1
#define TCPC_TCPC_CONTROL_BIST_TEST_MODE_LSB 1
#define TCPC_TCPC_CONTROL_BIST_TEST_MODE_MASK 0x0002
#define TCPC_TCPC_CONTROL_PLUG_ORIENTATION_MSB 0
#define TCPC_TCPC_CONTROL_PLUG_ORIENTATION_LSB 0
#define TCPC_TCPC_CONTROL_PLUG_ORIENTATION_MASK 0x0001

/* ROLE_CONTROL : */
#define TCPC_ROLE_CONTROL_IDX 0x1a
#define TCPC_ROLE_CONTROL_DRP_MSB 6
#define TCPC_ROLE_CONTROL_DRP_LSB 6
#define TCPC_ROLE_CONTROL_DRP_MASK 0x0040
#define TCPC_ROLE_CONTROL_RP_VALUE_MSB 5
#define TCPC_ROLE_CONTROL_RP_VALUE_LSB 4
#define TCPC_ROLE_CONTROL_RP_VALUE_MASK 0x0030
#define TCPC_ROLE_CONTROL_CC2_MSB 3
#define TCPC_ROLE_CONTROL_CC2_LSB 2
#define TCPC_ROLE_CONTROL_CC2_MASK 0x000c
#define TCPC_ROLE_CONTROL_CC1_MSB 1
#define TCPC_ROLE_CONTROL_CC1_LSB 0
#define TCPC_ROLE_CONTROL_CC1_MASK 0x0003

/* FAULT_CONTROL : */
#define TCPC_FAULT_CONTROL_IDX 0x1b
#define TCPC_FAULT_CONTROL_FORCE_OFF_VBUS_ENABLE_MSB 4
#define TCPC_FAULT_CONTROL_FORCE_OFF_VBUS_ENABLE_LSB 4
#define TCPC_FAULT_CONTROL_FORCE_OFF_VBUS_ENABLE_MASK 0x0010
#define TCPC_FAULT_CONTROL_VBUS_DISCHARGE_TIMER_MSB 3
#define TCPC_FAULT_CONTROL_VBUS_DISCHARGE_TIMER_LSB 3
#define TCPC_FAULT_CONTROL_VBUS_DISCHARGE_TIMER_MASK 0x0008
#define TCPC_FAULT_CONTROL_VBUS_OVER_CURRENT_PROTECTION_FAULT_ENABLE_MSB 2
#define TCPC_FAULT_CONTROL_VBUS_OVER_CURRENT_PROTECTION_FAULT_ENABLE_LSB 2
#define TCPC_FAULT_CONTROL_VBUS_OVER_CURRENT_PROTECTION_FAULT_ENABLE_MASK 0x0004
#define TCPC_FAULT_CONTROL_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_ENABLE_MSB 1
#define TCPC_FAULT_CONTROL_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_ENABLE_LSB 1
#define TCPC_FAULT_CONTROL_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_ENABLE_MASK 0x0002
#define TCPC_FAULT_CONTROL_VCONN_OVER_CURRENT_FAULT_ENABLE_MSB 0
#define TCPC_FAULT_CONTROL_VCONN_OVER_CURRENT_FAULT_ENABLE_LSB 0
#define TCPC_FAULT_CONTROL_VCONN_OVER_CURRENT_FAULT_ENABLE_MASK 0x0001

/* POWER_CONTROL : */
#define TCPC_POWER_CONTROL_IDX 0x1c
#define TCPC_POWER_CONTROL_POR 0x60
#define TCPC_POWER_CONTROL_FAST_ROLE_SWAP_ENABLE_MSB 7
#define TCPC_POWER_CONTROL_FAST_ROLE_SWAP_ENABLE_LSB 7
#define TCPC_POWER_CONTROL_FAST_ROLE_SWAP_ENABLE_MASK 0x0080
#define TCPC_POWER_CONTROL_VBUS_VOLTAGE_MONITOR_MSB 6
#define TCPC_POWER_CONTROL_VBUS_VOLTAGE_MONITOR_LSB 6
#define TCPC_POWER_CONTROL_VBUS_VOLTAGE_MONITOR_MASK 0x0040
#define TCPC_POWER_CONTROL_DISABLE_VOLTAGE_ALARMS_MSB 5
#define TCPC_POWER_CONTROL_DISABLE_VOLTAGE_ALARMS_LSB 5
#define TCPC_POWER_CONTROL_DISABLE_VOLTAGE_ALARMS_MASK 0x0020
#define TCPC_POWER_CONTROL_AUTO_DISCHARGE_DISCONNECT_MSB 4
#define TCPC_POWER_CONTROL_AUTO_DISCHARGE_DISCONNECT_LSB 4
#define TCPC_POWER_CONTROL_AUTO_DISCHARGE_DISCONNECT_MASK 0x0010
#define TCPC_POWER_CONTROL_ENABLE_BLEED_DISCHARGE_MSB 3
#define TCPC_POWER_CONTROL_ENABLE_BLEED_DISCHARGE_LSB 3
#define TCPC_POWER_CONTROL_ENABLE_BLEED_DISCHARGE_MASK 0x0008
#define TCPC_POWER_CONTROL_FORCE_DISCHARGE_MSB 2
#define TCPC_POWER_CONTROL_FORCE_DISCHARGE_LSB 2
#define TCPC_POWER_CONTROL_FORCE_DISCHARGE_MASK 0x0004
#define TCPC_POWER_CONTROL_VCONN_POWER_SUPPORTED_MSB 1
#define TCPC_POWER_CONTROL_VCONN_POWER_SUPPORTED_LSB 1
#define TCPC_POWER_CONTROL_VCONN_POWER_SUPPORTED_MASK 0x0002
#define TCPC_POWER_CONTROL_ENABLE_VCONN_MSB 0
#define TCPC_POWER_CONTROL_ENABLE_VCONN_LSB 0
#define TCPC_POWER_CONTROL_ENABLE_VCONN_MASK 0x0001

/* CC_STATUS : */
#define TCPC_CC_STATUS_IDX 0x1d
#define TCPC_CC_STATUS_LOOKING4_CONNECTION_MSB 5
#define TCPC_CC_STATUS_LOOKING4_CONNECTION_LSB 5
#define TCPC_CC_STATUS_LOOKING4_CONNECTION_MASK 0x0020
#define TCPC_CC_STATUS_CONNECT_RESULT_MSB 4
#define TCPC_CC_STATUS_CONNECT_RESULT_LSB 4
#define TCPC_CC_STATUS_CONNECT_RESULT_MASK 0x0010
#define TCPC_CC_STATUS_CC2_STATE_MSB 3
#define TCPC_CC_STATUS_CC2_STATE_LSB 2
#define TCPC_CC_STATUS_CC2_STATE_MASK 0x000c
#define TCPC_CC_STATUS_CC1_STATE_MSB 1
#define TCPC_CC_STATUS_CC1_STATE_LSB 0
#define TCPC_CC_STATUS_CC1_STATE_MASK 0x0003

/* POWER_STATUS : */
#define TCPC_POWER_STATUS_IDX 0x1e
#define TCPC_POWER_STATUS_DEBUG_ACCESSORY_CONNECTED_MSB 7
#define TCPC_POWER_STATUS_DEBUG_ACCESSORY_CONNECTED_LSB 7
#define TCPC_POWER_STATUS_DEBUG_ACCESSORY_CONNECTED_MASK 0x0080
#define TCPC_POWER_STATUS_TCPC_INITIALIZATION_STATUS_MSB 6
#define TCPC_POWER_STATUS_TCPC_INITIALIZATION_STATUS_LSB 6
#define TCPC_POWER_STATUS_TCPC_INITIALIZATION_STATUS_MASK 0x0040
#define TCPC_POWER_STATUS_SOURCING_HIGH_VOLTAGE_MSB 5
#define TCPC_POWER_STATUS_SOURCING_HIGH_VOLTAGE_LSB 5
#define TCPC_POWER_STATUS_SOURCING_HIGH_VOLTAGE_MASK 0x0020
#define TCPC_POWER_STATUS_SOURCING_VBUS_MSB 4
#define TCPC_POWER_STATUS_SOURCING_VBUS_LSB 4
#define TCPC_POWER_STATUS_SOURCING_VBUS_MASK 0x0010
#define TCPC_POWER_STATUS_VBUS_PRESENT_DETECTION_ENABLED_MSB 3
#define TCPC_POWER_STATUS_VBUS_PRESENT_DETECTION_ENABLED_LSB 3
#define TCPC_POWER_STATUS_VBUS_PRESENT_DETECTION_ENABLED_MASK 0x0008
#define TCPC_POWER_STATUS_VBUS_PRESENT_MSB 2
#define TCPC_POWER_STATUS_VBUS_PRESENT_LSB 2
#define TCPC_POWER_STATUS_VBUS_PRESENT_MASK 0x0004
#define TCPC_POWER_STATUS_VCONN_PRESENT_MSB 1
#define TCPC_POWER_STATUS_VCONN_PRESENT_LSB 1
#define TCPC_POWER_STATUS_VCONN_PRESENT_MASK 0x0002
#define TCPC_POWER_STATUS_SINKING_VBUS_MSB 0
#define TCPC_POWER_STATUS_SINKING_VBUS_LSB 0
#define TCPC_POWER_STATUS_SINKING_VBUS_MASK 0x0001

/* FAULT_STATUS : */
#define TCPC_FAULT_STATUS_IDX 0x1f
#define TCPC_FAULT_STATUS_ALL_REGISTERS_RESET_TO_DEFAULT_INTERRUPT_STATUS_MSB 7
#define TCPC_FAULT_STATUS_ALL_REGISTERS_RESET_TO_DEFAULT_INTERRUPT_STATUS_LSB 7
#define TCPC_FAULT_STATUS_ALL_REGISTERS_RESET_TO_DEFAULT_INTERRUPT_STATUS_MASK 0x0080
#define TCPC_FAULT_STATUS_FORCE_OFF_VBUS_STATUS_MSB 6
#define TCPC_FAULT_STATUS_FORCE_OFF_VBUS_STATUS_LSB 6
#define TCPC_FAULT_STATUS_FORCE_OFF_VBUS_STATUS_MASK 0x0040
#define TCPC_FAULT_STATUS_AUTO_DISCHARGE_FAILED_MSB 5
#define TCPC_FAULT_STATUS_AUTO_DISCHARGE_FAILED_LSB 5
#define TCPC_FAULT_STATUS_AUTO_DISCHARGE_FAILED_MASK 0x0020
#define TCPC_FAULT_STATUS_FORCE_DISCHARGE_FAILED_MSB 4
#define TCPC_FAULT_STATUS_FORCE_DISCHARGE_FAILED_LSB 4
#define TCPC_FAULT_STATUS_FORCE_DISCHARGE_FAILED_MASK 0x0010
#define TCPC_FAULT_STATUS_INTERNAL_OR_EXTERNAL_VBUS_OVER_CURRENT_PROTECTION_FAULT_MSB 3
#define TCPC_FAULT_STATUS_INTERNAL_OR_EXTERNAL_VBUS_OVER_CURRENT_PROTECTION_FAULT_LSB 3
#define TCPC_FAULT_STATUS_INTERNAL_OR_EXTERNAL_VBUS_OVER_CURRENT_PROTECTION_FAULT_MASK 0x0008
#define TCPC_FAULT_STATUS_INTERNAL_OR_EXTERNAL_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_MSB 2
#define TCPC_FAULT_STATUS_INTERNAL_OR_EXTERNAL_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_LSB 2
#define TCPC_FAULT_STATUS_INTERNAL_OR_EXTERNAL_VBUS_OVER_VOLTAGE_PROTECTION_FAULT_MASK 0x0004
#define TCPC_FAULT_STATUS_VCONN_OVER_CURRENT_FAULT_MSB 1
#define TCPC_FAULT_STATUS_VCONN_OVER_CURRENT_FAULT_LSB 1
#define TCPC_FAULT_STATUS_VCONN_OVER_CURRENT_FAULT_MASK 0x0002
#define TCPC_FAULT_STATUS_I2_C_INTERFACE_ERROR_MSB 0
#define TCPC_FAULT_STATUS_I2_C_INTERFACE_ERROR_LSB 0
#define TCPC_FAULT_STATUS_I2_C_INTERFACE_ERROR_MASK 0x0001

/* EXTENDED_STATUS :*/
#define TCPC_EXTENDED_STATUS_IDX 0x20
#define TCPC_EXTENDED_STATUS_POR 0x00
#define TCPC_EXTENDED_STATUS_VSAFE0_MSB 0
#define TCPC_EXTENDED_STATUS_VSAFE0_LSB 0
#define TCPC_EXTENDED_STATUS_VSAFE0_MASK 0x01

/* ALERT_EXTENDED :*/
#define TCPC_ALERT_EXTENDED_IDX 0x21
#define TCPC_ALERT_EXTENDED_POR 0x00
#define TCPC_ALERT_EXTENDED_TIMER_EXPIRED_MSB 2
#define TCPC_ALERT_EXTENDED_TIMER_EXPIRED_LSB 2
#define TCPC_ALERT_EXTENDED_TIMER_EXPIRED_MASK 0x04
#define TCPC_ALERT_EXTENDED_SOURCE_FAST_ROLE_SWAP_MSB 1
#define TCPC_ALERT_EXTENDED_SOURCE_FAST_ROLE_SWAP_LSB 1
#define TCPC_ALERT_EXTENDED_SOURCE_FAST_ROLE_SWAP_MASK 0x02
#define TCPC_ALERT_EXTENDED_SINK_FAST_ROLE_SWAP_MSB 0
#define TCPC_ALERT_EXTENDED_SINK_FAST_ROLE_SWAP_LSB 0
#define TCPC_ALERT_EXTENDED_SINK_FAST_ROLE_SWAP_MASK 0x01

/* COMMAND : */
#define TCPC_COMMAND_IDX 0x23

/* DEVICE_CAPABILITIES_1 : */
#define TCPC_DEVICE_CAPABILITIES_1_IDX 0x24
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_HIGH_VOLTAGE_TARGET_MSB 15
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_HIGH_VOLTAGE_TARGET_LSB 15
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_HIGH_VOLTAGE_TARGET_MASK 0x8000
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_OCP_REPORTING_MSB 14
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_OCP_REPORTING_LSB 14
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_OCP_REPORTING_MASK 0x4000
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_OVP_REPORTING_MSB 13
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_OVP_REPORTING_LSB 13
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_OVP_REPORTING_MASK 0x2000
#define TCPC_DEVICE_CAPABILITIES_1_BLEED_DISCHARGE_MSB 12
#define TCPC_DEVICE_CAPABILITIES_1_BLEED_DISCHARGE_LSB 12
#define TCPC_DEVICE_CAPABILITIES_1_BLEED_DISCHARGE_MASK 0x1000
#define TCPC_DEVICE_CAPABILITIES_1_FORCE_DISCHARGE_MSB 11
#define TCPC_DEVICE_CAPABILITIES_1_FORCE_DISCHARGE_LSB 11
#define TCPC_DEVICE_CAPABILITIES_1_FORCE_DISCHARGE_MASK 0x0800
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_MEASUREMENT_AND_ALARM_CAPABLE_MSB 10
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_MEASUREMENT_AND_ALARM_CAPABLE_LSB 10
#define TCPC_DEVICE_CAPABILITIES_1_VBUS_MEASUREMENT_AND_ALARM_CAPABLE_MASK 0x0400
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_RESISTOR_SUPPORTED_MSB 9
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_RESISTOR_SUPPORTED_LSB 8
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_RESISTOR_SUPPORTED_MASK 0x0300
#define TCPC_DEVICE_CAPABILITIES_1_ROLES_SUPPORTED_MSB 7
#define TCPC_DEVICE_CAPABILITIES_1_ROLES_SUPPORTED_LSB 5
#define TCPC_DEVICE_CAPABILITIES_1_ROLES_SUPPORTED_MASK 0x00e0
#define TCPC_DEVICE_CAPABILITIES_1_SOP_DBGSOP_DBG_SUPPORT_MSB 4
#define TCPC_DEVICE_CAPABILITIES_1_SOP_DBGSOP_DBG_SUPPORT_LSB 4
#define TCPC_DEVICE_CAPABILITIES_1_SOP_DBGSOP_DBG_SUPPORT_MASK 0x0010
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_VCONN_MSB 3
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_VCONN_LSB 3
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_VCONN_MASK 0x0008
#define TCPC_DEVICE_CAPABILITIES_1_SINK_VBUS_MSB 2
#define TCPC_DEVICE_CAPABILITIES_1_SINK_VBUS_LSB 2
#define TCPC_DEVICE_CAPABILITIES_1_SINK_VBUS_MASK 0x0004
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_HIGH_VOLTAGE_VBUS_MSB 1
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_HIGH_VOLTAGE_VBUS_LSB 1
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_HIGH_VOLTAGE_VBUS_MASK 0x0002
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_VBUS_MSB 0
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_VBUS_LSB 0
#define TCPC_DEVICE_CAPABILITIES_1_SOURCE_VBUS_MASK 0x0001

/* DEVICE_CAPABILITIES_2 : */
#define TCPC_DEVICE_CAPABILITIES_2_IDX 0x26
#define TCPC_DEVICE_CAPABILITIES_2_GENERIC_TIMER_MSB 13
#define TCPC_DEVICE_CAPABILITIES_2_GENERIC_TIMER_LSB 13
#define TCPC_DEVICE_CAPABILITIES_2_GENERIC_TIMER_MASK 0x2000
#define TCPC_DEVICE_CAPABILITIES_2_LONG_MESSAGE_MSB 12
#define TCPC_DEVICE_CAPABILITIES_2_LONG_MESSAGE_LSB 12
#define TCPC_DEVICE_CAPABILITIES_2_LONG_MESSAGE_MASK 0x1000
#define TCPC_DEVICE_CAPABILITIES_2_SMBUS_PEC_MSB 11
#define TCPC_DEVICE_CAPABILITIES_2_SMBUS_PEC_LSB 11
#define TCPC_DEVICE_CAPABILITIES_2_SMBUS_PEC_MASK 0x0800
#define TCPC_DEVICE_CAPABILITIES_2_SOURCE_FR_SWAP_MSB 10
#define TCPC_DEVICE_CAPABILITIES_2_SOURCE_FR_SWAP_LSB 10
#define TCPC_DEVICE_CAPABILITIES_2_SOURCE_FR_SWAP_MASK 0x0400
#define TCPC_DEVICE_CAPABILITIES_2_SINK_FR_SWAP_MSB 9
#define TCPC_DEVICE_CAPABILITIES_2_SINK_FR_SWAP_LSB 9
#define TCPC_DEVICE_CAPABILITIES_2_SINK_FR_SWAP_MASK 0x0200
#define TCPC_DEVICE_CAPABILITIES_2_WATCHDOG_TIMER_MSB 8
#define TCPC_DEVICE_CAPABILITIES_2_WATCHDOG_TIMER_LSB 8
#define TCPC_DEVICE_CAPABILITIES_2_WATCHDOG_TIMER_MASK 0x0100
#define TCPC_DEVICE_CAPABILITIES_2_SINK_DISCONNECT_DETECTION_MSB 7
#define TCPC_DEVICE_CAPABILITIES_2_SINK_DISCONNECT_DETECTION_LSB 7
#define TCPC_DEVICE_CAPABILITIES_2_SINK_DISCONNECT_DETECTION_MASK 0x0080
#define TCPC_DEVICE_CAPABILITIES_2_STOP_DISCHARGE_THRESHOLD_MSB 6
#define TCPC_DEVICE_CAPABILITIES_2_STOP_DISCHARGE_THRESHOLD_LSB 6
#define TCPC_DEVICE_CAPABILITIES_2_STOP_DISCHARGE_THRESHOLD_MASK 0x0040
#define TCPC_DEVICE_CAPABILITIES_2_VBUS_VOLTAGE_ALARM_LSB_MSB 5
#define TCPC_DEVICE_CAPABILITIES_2_VBUS_VOLTAGE_ALARM_LSB_LSB 4
#define TCPC_DEVICE_CAPABILITIES_2_VBUS_VOLTAGE_ALARM_LSB_MASK 0x0030
#define TCPC_DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_MSB 3
#define TCPC_DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_LSB 1
#define TCPC_DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_MASK 0x000e
#define TCPC_DEVICE_CAPABILITIES_2_VCONN_OVERCURRENT_FAULT_CAPABLE_MSB 0
#define TCPC_DEVICE_CAPABILITIES_2_VCONN_OVERCURRENT_FAULT_CAPABLE_LSB 0
#define TCPC_DEVICE_CAPABILITIES_2_VCONN_OVERCURRENT_FAULT_CAPABLE_MASK 0x0001

/* STANDARD_INPUT_CAPABILITIES : */
#define TCPC_STANDARD_INPUT_CAPABILITIES_IDX 0x28
#define TCPC_STANDARD_INPUT_CAPABILITIES_SOURCE_FAST_ROLE_SWAP_MSB 4
#define TCPC_STANDARD_INPUT_CAPABILITIES_SOURCE_FAST_ROLE_SWAP_LSB 3
#define TCPC_STANDARD_INPUT_CAPABILITIES_SOURCE_FAST_ROLE_SWAP_MASK 0x0018
#define TCPC_STANDARD_INPUT_CAPABILITIES_VBUS_EXTERNAL_OVER_VOLTAGE_FAULT_CAPABLE_MSB 2
#define TCPC_STANDARD_INPUT_CAPABILITIES_VBUS_EXTERNAL_OVER_VOLTAGE_FAULT_CAPABLE_LSB 2
#define TCPC_STANDARD_INPUT_CAPABILITIES_VBUS_EXTERNAL_OVER_VOLTAGE_FAULT_CAPABLE_MASK 0x0004
#define TCPC_STANDARD_INPUT_CAPABILITIES_VBUS_EXTERNAL_OVER_CURRENT_FAULT_CAPABLE_MSB 1
#define TCPC_STANDARD_INPUT_CAPABILITIES_VBUS_EXTERNAL_OVER_CURRENT_FAULT_CAPABLE_LSB 1
#define TCPC_STANDARD_INPUT_CAPABILITIES_VBUS_EXTERNAL_OVER_CURRENT_FAULT_CAPABLE_MASK 0x0002
#define TCPC_STANDARD_INPUT_CAPABILITIES_FORCE_OFF_VBUS_CAPABLE_MSB 0
#define TCPC_STANDARD_INPUT_CAPABILITIES_FORCE_OFF_VBUS_CAPABLE_LSB 0
#define TCPC_STANDARD_INPUT_CAPABILITIES_FORCE_OFF_VBUS_CAPABLE_MASK 0x0001

/* STANDARD_OUTPUT_CAPABILITIES : */
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_IDX 0x29
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_VBUS_SINK_DISCONNECT_DETECT_INDICATOR_MSB 7
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_VBUS_SINK_DISCONNECT_DETECT_INDICATOR_LSB 7
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_VBUS_SINK_DISCONNECT_DETECT_INDICATOR_MASK 0x0080
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_DEBUG_ACCESSORY_INDICATOR_MSB 6
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_DEBUG_ACCESSORY_INDICATOR_LSB 6
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_DEBUG_ACCESSORY_INDICATOR_MASK 0x0040
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_VBUS_PRESENT_MONITOR_MSB 5
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_VBUS_PRESENT_MONITOR_LSB 5
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_VBUS_PRESENT_MONITOR_MASK 0x0020
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_AUDIO_ADAPTER_ACCESSORY_INDICATOR_MSB 4
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_AUDIO_ADAPTER_ACCESSORY_INDICATOR_LSB 4
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_AUDIO_ADAPTER_ACCESSORY_INDICATOR_MASK 0x0010
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_ACTIVE_CABLE_INDICATOR_MSB 3
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_ACTIVE_CABLE_INDICATOR_LSB 3
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_ACTIVE_CABLE_INDICATOR_MASK 0x0008
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_MUX_CONFIGURATION_CONTROL_MSB 2
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_MUX_CONFIGURATION_CONTROL_LSB 2
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_MUX_CONFIGURATION_CONTROL_MASK 0x0004
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_CONNECTION_PRESENT_INDICATOR_MSB 1
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_CONNECTION_PRESENT_INDICATOR_LSB 1
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_CONNECTION_PRESENT_INDICATOR_MASK 0x0002
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_CONNECTOR_ORIENTATION_MSB 0
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_CONNECTOR_ORIENTATION_LSB 0
#define TCPC_STANDARD_OUTPUT_CAPABILITIES_CONNECTOR_ORIENTATION_MASK 0x0001

/* CONFIGURE_ENTENDED1 */
#define TCPC_CONFIGURE_EXTENDED1_IDX 0x2a
#define TCPC_CONFIGURE_EXTENDED1_POR 0x00
#define TCPC_CONFIGURE_EXTENDED1_FR_SWAP_BIDIRECTIONAL_PIN_MSB 1
#define TCPC_CONFIGURE_EXTENDED1_FR_SWAP_BIDIRECTIONAL_PIN_LSB 1
#define TCPC_CONFIGURE_EXTENDED1_FR_SWAP_BIDIRECTIONAL_PIN_MASK 0x0002
#define TCPC_CONFIGURE_EXTENDED1_STANDARD_INPUT_SOURCE_FR_SWAP_MSB 0
#define TCPC_CONFIGURE_EXTENDED1_STANDARD_INPUT_SOURCE_FR_SWAP_LSB 0
#define TCPC_CONFIGURE_EXTENDED1_STANDARD_INPUT_SOURCE_FR_SWAP_MASK 0x0001

/* GENERIC_TIMER : */
#define TCPC_GENERIC_TIMER_IDX 0x2c

/* MESSAGE_HEADER_INFO : */
#define TCPC_MESSAGE_HEADER_INFO_IDX 0x2e
#define TCPC_MESSAGE_HEADER_INFO_CABLE_PLUG_MSB 4
#define TCPC_MESSAGE_HEADER_INFO_CABLE_PLUG_LSB 4
#define TCPC_MESSAGE_HEADER_INFO_CABLE_PLUG_MASK 0x0010
#define TCPC_MESSAGE_HEADER_INFO_DATA_ROLE_MSB 3
#define TCPC_MESSAGE_HEADER_INFO_DATA_ROLE_LSB 3
#define TCPC_MESSAGE_HEADER_INFO_DATA_ROLE_MASK 0x0008
#define TCPC_MESSAGE_HEADER_INFO_USB_PD_SPECIFICATION_REVISION_MSB 2
#define TCPC_MESSAGE_HEADER_INFO_USB_PD_SPECIFICATION_REVISION_LSB 1
#define TCPC_MESSAGE_HEADER_INFO_USB_PD_SPECIFICATION_REVISION_MASK 0x0006
#define TCPC_MESSAGE_HEADER_INFO_POWER_ROLE_MSB 0
#define TCPC_MESSAGE_HEADER_INFO_POWER_ROLE_LSB 0
#define TCPC_MESSAGE_HEADER_INFO_POWER_ROLE_MASK 0x0001

/* RECEIVE_DETECT : */
#define TCPC_RECEIVE_DETECT_IDX 0x2f
#define TCPC_RECEIVE_DETECT_ENABLE_CABLE_RESET_MSB 6
#define TCPC_RECEIVE_DETECT_ENABLE_CABLE_RESET_LSB 6
#define TCPC_RECEIVE_DETECT_ENABLE_CABLE_RESET_MASK 0x0040
#define TCPC_RECEIVE_DETECT_ENABLE_HARD_RESET_MSB 5
#define TCPC_RECEIVE_DETECT_ENABLE_HARD_RESET_LSB 5
#define TCPC_RECEIVE_DETECT_ENABLE_HARD_RESET_MASK 0x0020
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_DBG_PP_MESSAGE_MSB 4
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_DBG_PP_MESSAGE_LSB 4
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_DBG_PP_MESSAGE_MASK 0x0010
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_DBG_P_MESSAGE_MSB 3
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_DBG_P_MESSAGE_LSB 3
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_DBG_P_MESSAGE_MASK 0x0008
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_PP_MESSAGE_MSB 2
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_PP_MESSAGE_LSB 2
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_PP_MESSAGE_MASK 0x0004
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_P_MESSAGE_MSB 1
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_P_MESSAGE_LSB 1
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_P_MESSAGE_MASK 0x0002
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_MESSAGE_MSB 0
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_MESSAGE_LSB 0
#define TCPC_RECEIVE_DETECT_ENABLE_SOP_MESSAGE_MASK 0x0001

/* RECEIVE_BYTE_COUNT : */
#define TCPC_RECEIVE_BYTE_COUNT_IDX 0x30

/* RX_BUF_FRAME_TYPE : */
#define TCPC_RX_BUF_FRAME_TYPE_IDX 0x31
#define TCPC_RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_MSB 2
#define TCPC_RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_LSB 0
#define TCPC_RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_MASK 0x0007

/* RX_BUF_HEADER : */
#define TCPC_RX_BUF_HEADER_IDX 0x32
#define TCPC_RX_BUF_HEADER_RX_EXTENDED_MSB 15
#define TCPC_RX_BUF_HEADER_RX_EXTENDED_LSB 15
#define TCPC_RX_BUF_HEADER_RX_EXTENDED_MASK 0x8000
#define TCPC_RX_BUF_HEADER_RX_NUMBER_OF_DATA_OBJECT_MSB 14
#define TCPC_RX_BUF_HEADER_RX_NUMBER_OF_DATA_OBJECT_LSB 12
#define TCPC_RX_BUF_HEADER_RX_NUMBER_OF_DATA_OBJECT_MASK 0x7000
#define TCPC_RX_BUF_HEADER_RX_MESSAGE_ID_MSB 11
#define TCPC_RX_BUF_HEADER_RX_MESSAGE_ID_LSB 9
#define TCPC_RX_BUF_HEADER_RX_MESSAGE_ID_MASK 0x0e00
#define TCPC_RX_BUF_HEADER_RX_PORT_POWER_ROLE_MSB 8
#define TCPC_RX_BUF_HEADER_RX_PORT_POWER_ROLE_LSB 8
#define TCPC_RX_BUF_HEADER_RX_PORT_POWER_ROLE_MASK 0x0100
#define TCPC_RX_BUF_HEADER_RX_SPEC_REVISION_MSB 7
#define TCPC_RX_BUF_HEADER_RX_SPEC_REVISION_LSB 6
#define TCPC_RX_BUF_HEADER_RX_SPEC_REVISION_MASK 0x00c0
#define TCPC_RX_BUF_HEADER_RX_PORT_DATA_ROLE_MSB 5
#define TCPC_RX_BUF_HEADER_RX_PORT_DATA_ROLE_LSB 5
#define TCPC_RX_BUF_HEADER_RX_PORT_DATA_ROLE_MASK 0x0020
#define TCPC_RX_BUF_HEADER_RX_MESSAGE_TYPE_MSB 4
#define TCPC_RX_BUF_HEADER_RX_MESSAGE_TYPE_LSB 0
#define TCPC_RX_BUF_HEADER_RX_MESSAGE_TYPE_MASK 0x001f

/* RX_BUF_OBJ1 : */
#define TCPC_RX_BUF_OBJ1_IDX 0x34

#define TCPC_RX_BUF_EXT_HDR_IDX 0x34
#define TCPC_RX_BUF_EXT_HDR_RX_CHUNKED_MSB 15
#define TCPC_RX_BUF_EXT_HDR_RX_CHUNKED_LSB 15
#define TCPC_RX_BUF_EXT_HDR_RX_CHUNKED_MASK 0x8000

/* RX_BUF_OBJ2 : */
#define TCPC_RX_BUF_OBJ2_IDX 0x38

/* RX_BUF_OBJ3 : */
#define TCPC_RX_BUF_OBJ3_IDX 0x3c

/* RX_BUF_OBJ4 : */
#define TCPC_RX_BUF_OBJ4_IDX 0x40

/* RX_BUF_OBJ5 : */
#define TCPC_RX_BUF_OBJ5_IDX 0x44

/* RX_BUF_OBJ6 : */
#define TCPC_RX_BUF_OBJ6_IDX 0x48

/* RX_BUF_OBJ7 : */
#define TCPC_RX_BUF_OBJ7_IDX 0x4c

/* TRANSMIT : */
#define TCPC_TRANSMIT_IDX 0x50
#define TCPC_TRANSMIT_RETRY_COUNTER_MSB 5
#define TCPC_TRANSMIT_RETRY_COUNTER_LSB 4
#define TCPC_TRANSMIT_RETRY_COUNTER_MASK 0x0030
#define TCPC_TRANSMIT_TRANSMIT_SOP_MESSAGE_MSB 2
#define TCPC_TRANSMIT_TRANSMIT_SOP_MESSAGE_LSB 0
#define TCPC_TRANSMIT_TRANSMIT_SOP_MESSAGE_MASK 0x0007

/* TRANSMIT_BYTE_COUNT : */
#define TCPC_TRANSMIT_BYTE_COUNT_IDX 0x51

/* TX_BUF_HEADER : */
#define TCPC_TX_BUF_HEADER_IDX 0x52
#define TCPC_TX_BUF_HEADER_TX_EXTENDED_MSB 15
#define TCPC_TX_BUF_HEADER_TX_EXTENDED_LSB 15
#define TCPC_TX_BUF_HEADER_TX_EXTENDED_MASK 0x8000
#define TCPC_TX_BUF_HEADER_TX_NUMBER_OF_DATA_OBJECT_MSB 14
#define TCPC_TX_BUF_HEADER_TX_NUMBER_OF_DATA_OBJECT_LSB 12
#define TCPC_TX_BUF_HEADER_TX_NUMBER_OF_DATA_OBJECT_MASK 0x7000
#define TCPC_TX_BUF_HEADER_TX_MESSAGE_ID_MSB 11
#define TCPC_TX_BUF_HEADER_TX_MESSAGE_ID_LSB 9
#define TCPC_TX_BUF_HEADER_TX_MESSAGE_ID_MASK 0x0e00
#define TCPC_TX_BUF_HEADER_TX_PORT_POWER_ROLE_MSB 8
#define TCPC_TX_BUF_HEADER_TX_PORT_POWER_ROLE_LSB 8
#define TCPC_TX_BUF_HEADER_TX_PORT_POWER_ROLE_MASK 0x0100
#define TCPC_TX_BUF_HEADER_TX_SPEC_REVISION_MSB 7
#define TCPC_TX_BUF_HEADER_TX_SPEC_REVISION_LSB 6
#define TCPC_TX_BUF_HEADER_TX_SPEC_REVISION_MASK 0x00c0
#define TCPC_TX_BUF_HEADER_TX_PORT_DATA_ROLE_MSB 5
#define TCPC_TX_BUF_HEADER_TX_PORT_DATA_ROLE_LSB 5
#define TCPC_TX_BUF_HEADER_TX_PORT_DATA_ROLE_MASK 0x0020
#define TCPC_TX_BUF_HEADER_TX_MESSAGE_TYPE_MSB 4
#define TCPC_TX_BUF_HEADER_TX_MESSAGE_TYPE_LSB 0
#define TCPC_TX_BUF_HEADER_TX_MESSAGE_TYPE_MASK 0x001f

/* TX_BUF_OBJ1 : */
#define TCPC_TX_BUF_OBJ1_IDX 0x54

/* TX_BUF_OBJ2 : */
#define TCPC_TX_BUF_OBJ2_IDX 0x58

/* TX_BUF_OBJ3 : */
#define TCPC_TX_BUF_OBJ3_IDX 0x5c

/* TX_BUF_OBJ4 : */
#define TCPC_TX_BUF_OBJ4_IDX 0x60

/* TX_BUF_OBJ5 : */
#define TCPC_TX_BUF_OBJ5_IDX 0x64

/* TX_BUF_OBJ6 : */
#define TCPC_TX_BUF_OBJ6_IDX 0x68

/* TX_BUF_OBJ7 : */
#define TCPC_TX_BUF_OBJ7_IDX 0x6c

/* VBUS_VOLTAGE : */
#define TCPC_VBUS_VOLTAGE_IDX 0x70
#define TCPC_VBUS_VOLTAGE_VBUS_SCALE_FACTOR_MSB 11
#define TCPC_VBUS_VOLTAGE_VBUS_SCALE_FACTOR_LSB 10
#define TCPC_VBUS_VOLTAGE_VBUS_SCALE_FACTOR_MASK 0x0c00
#define TCPC_VBUS_VOLTAGE_VBUS_VOLTAGE_MEASUREMENT_MSB 9
#define TCPC_VBUS_VOLTAGE_VBUS_VOLTAGE_MEASUREMENT_LSB 0
#define TCPC_VBUS_VOLTAGE_VBUS_VOLTAGE_MEASUREMENT_MASK 0x03ff

/* VBUS_SINK_DISCONNECT_THRESHOLD : */
#define TCPC_VBUS_SINK_DISCONNECT_THRESHOLD_IDX 0x72
#define TCPC_VBUS_SINK_DISCONNECT_THRESHOLD_VBUS_SINK_DISCONNECT_TRIP_POINT_MSB 9
#define TCPC_VBUS_SINK_DISCONNECT_THRESHOLD_VBUS_SINK_DISCONNECT_TRIP_POINT_LSB 0
#define TCPC_VBUS_SINK_DISCONNECT_THRESHOLD_VBUS_SINK_DISCONNECT_TRIP_POINT_MASK 0x03ff

/* VBUS_STOP_DISCHARGE_THRESHOLD : */
#define TCPC_VBUS_STOP_DISCHARGE_THRESHOLD_IDX 0x74
#define TCPC_VBUS_STOP_DISCHARGE_THRESHOLD_VBUS_STOP_DISCHARGE_TRIP_POINT_MSB 9
#define TCPC_VBUS_STOP_DISCHARGE_THRESHOLD_VBUS_STOP_DISCHARGE_TRIP_POINT_LSB 0
#define TCPC_VBUS_STOP_DISCHARGE_THRESHOLD_VBUS_STOP_DISCHARGE_TRIP_POINT_MASK 0x03ff

/* VBUS_VOLTAGE_ALARM_HI_CFG : */
#define TCPC_VBUS_VOLTAGE_ALARM_HI_CFG_IDX 0x76
#define TCPC_VBUS_VOLTAGE_ALARM_HI_CFG_VBUS_LO_VOLTAGE_TRIP_POINT_MSB 9
#define TCPC_VBUS_VOLTAGE_ALARM_HI_CFG_VBUS_LO_VOLTAGE_TRIP_POINT_LSB 0
#define TCPC_VBUS_VOLTAGE_ALARM_HI_CFG_VBUS_LO_VOLTAGE_TRIP_POINT_MASK 0x03ff

/* VBUS_VOLTAGE_ALARM_LO_CFG : */
#define TCPC_VBUS_VOLTAGE_ALARM_LO_CFG_IDX 0x78
#define TCPC_VBUS_VOLTAGE_ALARM_LO_CFG_VBUS_HI_VOLTAGE_TRIP_POINT_MSB 9
#define TCPC_VBUS_VOLTAGE_ALARM_LO_CFG_VBUS_HI_VOLTAGE_TRIP_POINT_LSB 0
#define TCPC_VBUS_VOLTAGE_ALARM_LO_CFG_VBUS_HI_VOLTAGE_TRIP_POINT_MASK 0x03ff

/*/ PTN5110 */

/* EXT_ALERT : */
#define PTN5110_EXT_ALERT_IDX 0x82
#define PTN5110_EXT_ALERT_GPIO_STATUS_CHANGE_MSB 7
#define PTN5110_EXT_ALERT_GPIO_STATUS_CHANGE_LSB 7
#define PTN5110_EXT_ALERT_GPIO_STATUS_CHANGE_MASK 0x0080
#define PTN5110_EXT_ALERT_EXTENDED_TX_DATA_LOSS_MSB 6
#define PTN5110_EXT_ALERT_EXTENDED_TX_DATA_LOSS_LSB 6
#define PTN5110_EXT_ALERT_EXTENDED_TX_DATA_LOSS_MASK 0x0040
#define PTN5110_EXT_ALERT_FAST_ROLE_SWAP_VSAFE5V_BEING_SOURCED_MSB 5
#define PTN5110_EXT_ALERT_FAST_ROLE_SWAP_VSAFE5V_BEING_SOURCED_LSB 5
#define PTN5110_EXT_ALERT_FAST_ROLE_SWAP_VSAFE5V_BEING_SOURCED_MASK 0x0020
#define PTN5110_EXT_ALERT_FAST_ROLE_SWAP_REQUEST_RECEIVED_MSB 4
#define PTN5110_EXT_ALERT_FAST_ROLE_SWAP_REQUEST_RECEIVED_LSB 4
#define PTN5110_EXT_ALERT_FAST_ROLE_SWAP_REQUEST_RECEIVED_MASK 0x0010
#define PTN5110_EXT_ALERT_ATOMIC_MESSAGE_SEQUENCE_ALERT_MSB 3
#define PTN5110_EXT_ALERT_ATOMIC_MESSAGE_SEQUENCE_ALERT_LSB 3
#define PTN5110_EXT_ALERT_ATOMIC_MESSAGE_SEQUENCE_ALERT_MASK 0x0008
#define PTN5110_EXT_ALERT_USBC_STATE_CHANGE_MSB 2
#define PTN5110_EXT_ALERT_USBC_STATE_CHANGE_LSB 2
#define PTN5110_EXT_ALERT_USBC_STATE_CHANGE_MASK 0x0004
#define PTN5110_EXT_ALERT_USBC_OUTPUT_CHANGE_MSB 1
#define PTN5110_EXT_ALERT_USBC_OUTPUT_CHANGE_LSB 1
#define PTN5110_EXT_ALERT_USBC_OUTPUT_CHANGE_MASK 0x0002

/* EXT_ALERT_MASK : */
#define PTN5110_EXT_ALERT_MASK_IDX 0x84
#define PTN5110_EXT_ALERT_MASK_GPIO_STATUS_CHANGE_MSB 7
#define PTN5110_EXT_ALERT_MASK_GPIO_STATUS_CHANGE_LSB 7
#define PTN5110_EXT_ALERT_MASK_GPIO_STATUS_CHANGE_MASK 0x0080
#define PTN5110_EXT_ALERT_MASK_TRANSMIT_DATA_IN_EXTENDED_MESSAGE_BUFFER_CLEARED_BY_EXTENDED_MESSAGE_RECEIVE_MSB 6
#define PTN5110_EXT_ALERT_MASK_TRANSMIT_DATA_IN_EXTENDED_MESSAGE_BUFFER_CLEARED_BY_EXTENDED_MESSAGE_RECEIVE_LSB 6
#define PTN5110_EXT_ALERT_MASK_TRANSMIT_DATA_IN_EXTENDED_MESSAGE_BUFFER_CLEARED_BY_EXTENDED_MESSAGE_RECEIVE_MASK 0x0040
#define PTN5110_EXT_ALERT_MASK_FAST_ROLE_SWAP_VSAFE5V_BEING_SOURCED_MSB 5
#define PTN5110_EXT_ALERT_MASK_FAST_ROLE_SWAP_VSAFE5V_BEING_SOURCED_LSB 5
#define PTN5110_EXT_ALERT_MASK_FAST_ROLE_SWAP_VSAFE5V_BEING_SOURCED_MASK 0x0020
#define PTN5110_EXT_ALERT_MASK_FAST_ROLE_SWAP_REQUEST_RECEIVED_MSB 4
#define PTN5110_EXT_ALERT_MASK_FAST_ROLE_SWAP_REQUEST_RECEIVED_LSB 4
#define PTN5110_EXT_ALERT_MASK_FAST_ROLE_SWAP_REQUEST_RECEIVED_MASK 0x0010
#define PTN5110_EXT_ALERT_MASK_ATOMIC_MESSAGE_SEQUENCE_ALERT_MSB 3
#define PTN5110_EXT_ALERT_MASK_ATOMIC_MESSAGE_SEQUENCE_ALERT_LSB 3
#define PTN5110_EXT_ALERT_MASK_ATOMIC_MESSAGE_SEQUENCE_ALERT_MASK 0x0008
#define PTN5110_EXT_ALERT_MASK_USBC_STATE_CHANGE_MSB 2
#define PTN5110_EXT_ALERT_MASK_USBC_STATE_CHANGE_LSB 2
#define PTN5110_EXT_ALERT_MASK_USBC_STATE_CHANGE_MASK 0x0004
#define PTN5110_EXT_ALERT_MASK_USBC_OUTPUT_CHANGE_MSB 1
#define PTN5110_EXT_ALERT_MASK_USBC_OUTPUT_CHANGE_LSB 1
#define PTN5110_EXT_ALERT_MASK_USBC_OUTPUT_CHANGE_MASK 0x0002

/* EXT_CONFIG : */
#define PTN5110_EXT_CONFIG_IDX 0x86
#define PTN5110_EXT_CONFIG_USB_TYPE_C_FULL_STATE_MACHINE_ATTACHED_RP_VALUE_MSB 15
#define PTN5110_EXT_CONFIG_USB_TYPE_C_FULL_STATE_MACHINE_ATTACHED_RP_VALUE_LSB 14
#define PTN5110_EXT_CONFIG_USB_TYPE_C_FULL_STATE_MACHINE_ATTACHED_RP_VALUE_MASK 0xc000
#define PTN5110_EXT_CONFIG_USB_TYPE_C_FULL_STATE_MACHINE_UNATTACHED_RP_VALUE_MSB 13
#define PTN5110_EXT_CONFIG_USB_TYPE_C_FULL_STATE_MACHINE_UNATTACHED_RP_VALUE_LSB 12
#define PTN5110_EXT_CONFIG_USB_TYPE_C_FULL_STATE_MACHINE_UNATTACHED_RP_VALUE_MASK 0x3000
#define PTN5110_EXT_CONFIG_USB_TYPE_C_CONNECTION_STATE_MACHINE_MODE_MSB 10
#define PTN5110_EXT_CONFIG_USB_TYPE_C_CONNECTION_STATE_MACHINE_MODE_LSB 10
#define PTN5110_EXT_CONFIG_USB_TYPE_C_CONNECTION_STATE_MACHINE_MODE_MASK 0x0400
#define PTN5110_EXT_CONFIG_USB_FULL_TYPE_C_CONNECTION_DETECTION_MODE_MSB 9
#define PTN5110_EXT_CONFIG_USB_FULL_TYPE_C_CONNECTION_DETECTION_MODE_LSB 8
#define PTN5110_EXT_CONFIG_USB_FULL_TYPE_C_CONNECTION_DETECTION_MODE_MASK 0x0300
#define PTN5110_EXT_CONFIG_USB_FULL_TYPE_C_NORMAL_DRP_MSB 7
#define PTN5110_EXT_CONFIG_USB_FULL_TYPE_C_NORMAL_DRP_LSB 7
#define PTN5110_EXT_CONFIG_USB_FULL_TYPE_C_NORMAL_DRP_MASK 0x0080
#define PTN5110_EXT_CONFIG_DEBUG_CONTROL_MSB 6
#define PTN5110_EXT_CONFIG_DEBUG_CONTROL_LSB 4
#define PTN5110_EXT_CONFIG_DEBUG_CONTROL_MASK 0x0070
#define PTN5110_EXT_CONFIG_FAST_ROLE_SWAP_ENABLE_MSB 3
#define PTN5110_EXT_CONFIG_FAST_ROLE_SWAP_ENABLE_LSB 3
#define PTN5110_EXT_CONFIG_FAST_ROLE_SWAP_ENABLE_MASK 0x0008
#define PTN5110_EXT_CONFIG_ATOMIC_MESSAGE_SEQUENCE_ENABLE_MSB 2
#define PTN5110_EXT_CONFIG_ATOMIC_MESSAGE_SEQUENCE_ENABLE_LSB 2
#define PTN5110_EXT_CONFIG_ATOMIC_MESSAGE_SEQUENCE_ENABLE_MASK 0x0004
#define PTN5110_EXT_CONFIG_AUTOMATIC_DISCHARGE_FOR_NEGATIVE_TRANSITION_MSB 1
#define PTN5110_EXT_CONFIG_AUTOMATIC_DISCHARGE_FOR_NEGATIVE_TRANSITION_LSB 0
#define PTN5110_EXT_CONFIG_AUTOMATIC_DISCHARGE_FOR_NEGATIVE_TRANSITION_MASK 0x0003

/* EXT_FAULT_CONFIG : */
#define PTN5110_EXT_FAULT_CONFIG_IDX 0x88
#define PTN5110_EXT_FAULT_CONFIG_OPEN_FETS_ON_ADC_ALARM_MSB 4
#define PTN5110_EXT_FAULT_CONFIG_OPEN_FETS_ON_ADC_ALARM_LSB 4
#define PTN5110_EXT_FAULT_CONFIG_OPEN_FETS_ON_ADC_ALARM_MASK 0x0010
#define PTN5110_EXT_FAULT_CONFIG_VCONN_OVER_CURRENT_LIMIT_MSB 3
#define PTN5110_EXT_FAULT_CONFIG_VCONN_OVER_CURRENT_LIMIT_LSB 3
#define PTN5110_EXT_FAULT_CONFIG_VCONN_OVER_CURRENT_LIMIT_MASK 0x0008
#define PTN5110_EXT_FAULT_CONFIG_VCONN_OVER_TEMPERATURE_FAULT_MSB 2
#define PTN5110_EXT_FAULT_CONFIG_VCONN_OVER_TEMPERATURE_FAULT_LSB 2
#define PTN5110_EXT_FAULT_CONFIG_VCONN_OVER_TEMPERATURE_FAULT_MASK 0x0004
#define PTN5110_EXT_FAULT_CONFIG_VCONN_REVERSE_CURRENT_FAULT_MSB 0
#define PTN5110_EXT_FAULT_CONFIG_VCONN_REVERSE_CURRENT_FAULT_LSB 0
#define PTN5110_EXT_FAULT_CONFIG_VCONN_REVERSE_CURRENT_FAULT_MASK 0x0001

/* EXT_MSG_INDEX: */
#define PTN5110_EXT_MSG_INDEX_IDX 0x89

/* EXT_TRANSMIT_BYTE_COUNT : */
#define PTN5110_EXT_TRANSMIT_BYTE_COUNT_IDX 0x8a

/* EXT_RECEIVE_BYTE_COUNT : */
#define PTN5110_EXT_RECEIVE_BYTE_COUNT_IDX 0x8c

/* EXT_COMMAND : */
#define PTN5110_EXT_COMMAND_IDX 0x8f

/* EXT_STATUS : */
#define PTN5110_EXT_STATUS_IDX 0x90
#define PTN5110_EXT_STATUS_VCONN_OVER_CURRENT_LIMIT_FAULT_MSB 4
#define PTN5110_EXT_STATUS_VCONN_OVER_CURRENT_LIMIT_FAULT_LSB 4
#define PTN5110_EXT_STATUS_VCONN_OVER_CURRENT_LIMIT_FAULT_MASK 0x0010
#define PTN5110_EXT_STATUS_VCONN_OVER_TEMPERATURE_FAULT_MSB 3
#define PTN5110_EXT_STATUS_VCONN_OVER_TEMPERATURE_FAULT_LSB 3
#define PTN5110_EXT_STATUS_VCONN_OVER_TEMPERATURE_FAULT_MASK 0x0008
#define PTN5110_EXT_STATUS_VCONN_SHORT_CIRCUIT_FAULT_MSB 2
#define PTN5110_EXT_STATUS_VCONN_SHORT_CIRCUIT_FAULT_LSB 2
#define PTN5110_EXT_STATUS_VCONN_SHORT_CIRCUIT_FAULT_MASK 0x0004
#define PTN5110_EXT_STATUS_VCONN_REVERSE_CURRENT_FAULT_MSB 1
#define PTN5110_EXT_STATUS_VCONN_REVERSE_CURRENT_FAULT_LSB 1
#define PTN5110_EXT_STATUS_VCONN_REVERSE_CURRENT_FAULT_MASK 0x0002
#define PTN5110_EXT_STATUS_ATOMIC_MESSAGE_SEQUENCE_REQUEST_MSB 0
#define PTN5110_EXT_STATUS_ATOMIC_MESSAGE_SEQUENCE_REQUEST_LSB 0
#define PTN5110_EXT_STATUS_ATOMIC_MESSAGE_SEQUENCE_REQUEST_MASK 0x0001

/* EXT_CONTROL : */
#define PTN5110_EXT_CONTROL_IDX 0x8e
#define PTN5110_EXT_CONTROL_BLEED_DISCHARGE_STRENGTH_MSB 7
#define PTN5110_EXT_CONTROL_BLEED_DISCHARGE_STRENGTH_LSB 4
#define PTN5110_EXT_CONTROL_BLEED_DISCHARGE_STRENGTH_MASK 0x00f0
#define PTN5110_EXT_CONTROL_USBPD_VBUS_CONTROL_IN_PROGRESS_MSB 2
#define PTN5110_EXT_CONTROL_USBPD_VBUS_CONTROL_IN_PROGRESS_LSB 1
#define PTN5110_EXT_CONTROL_USBPD_VBUS_CONTROL_IN_PROGRESS_MASK 0x0006
#define PTN5110_EXT_CONTROL_VCONN_FORCE_DISCHARGE_MSB 0
#define PTN5110_EXT_CONTROL_VCONN_FORCE_DISCHARGE_LSB 0
#define PTN5110_EXT_CONTROL_VCONN_FORCE_DISCHARGE_MASK 0x0001

/* EXT_GPIO_CONFIG : */
#define PTN5110_EXT_GPIO_CONFIG_IDX 0x92
#define PTN5110_EXT_GPIO_CONFIG_ILIM_5V_VBUS_MSB 3
#define PTN5110_EXT_GPIO_CONFIG_ILIM_5V_VBUS_LSB 3
#define PTN5110_EXT_GPIO_CONFIG_ILIM_5V_VBUS_MASK 0x0008

/* EXT_GPIO_CONTROL : */
#define PTN5110_EXT_GPIO_CONTROL_IDX 0x93
#define PTN5110_EXT_GPIO_CONTROL_ILIM_5V_VBUS_MSB 3
#define PTN5110_EXT_GPIO_CONTROL_ILIM_5V_VBUS_LSB 3
#define PTN5110_EXT_GPIO_CONTROL_ILIM_5V_VBUS_MASK 0x0008

/* Register: CONFIGURE_STANDARD_OUTPUT
*/

/* Field: MUX_Control : MUX Control
00b: No connection.
01b: USB3.1 Connected
10b: DP Alternate Mode : 4 lanes
11b: USB3.1 + Display Port Lanes 0 & 1
Controlled by the TCPM
*/

typedef enum
{
    CONFIGURE_STANDARD_OUTPUT_MUX_CONTROL_NO_CONNECTION = 0x00,             /* No connection. */
    CONFIGURE_STANDARD_OUTPUT_MUX_CONTROL_USB3_ONLY = 0x08,                 /* USB3.1 Connected */
    CONFIGURE_STANDARD_OUTPUT_MUX_CONTROL_DP_ALTERNATE_MODE_4_LANES = 0x10, /* DP Alternate Mode : 4 lanes */
    CONFIGURE_STANDARD_OUTPUT_MUX_CONTROL_USB3_DP = 0x18                    /* USB3.1 + Display Port Lanes 0 & 1 */
} MUX_Control_t;

/* Register: TCPC_CONTROL
*/

/* Field: I2C_Clock_Stretching_Control : I2C Clock Stretching Control
Clock Stretching Control
00b: Disable clock stretching. TCPC shall not perform any clock stretching during I2C transfers.
01b: Reserved
10b: Enable clock stretching. TCPC is allowed limited clock stretching during each I2C Transfer.
11b: Enable clock stretching only if the Alert pin is not asserted. As soon as Alert is asserted, clock stretching is
disabled by the TCPC.
The TCPC datasheet should contain details as to the power consequences of clock stretching as well as the max duration
of clock stretching per I2C transaction. This is only necessary if clock stretching is implemented. The TCPC shall limit
total clock stretching as detailed in Section 4.10 I2C Physical Interface Specifications.
This feature is optional. The TCPC is allowed to ignore updates to this bit field if it has not implemented clock
stretching. The power on default value is such to disable clock stretching.
*/

typedef enum
{
    DISABLE_CLOCK_STRETCHING =
        0x00, /* Disable clock stretching. TCPC shall not perform any clock stretching during I2C transfers. */
    ENABLE_CLOCK_STRETCHING =
        0x08, /* Enable clock stretching. TCPC is allowed limited clock stretching during each I2C Transfer. */
    ENABLE_CLOCK_STRETCHING_ONLY_IF_THE_ALERT_PIN_IS_NOT_ASSERTED =
        0x0c  /* Enable clock stretching only if the Alert pin is not asserted. As soon as Alert is asserted, clock */
              /* stretching is disabled by the TCPC. */
} I2C_Clock_Stretching_Control_t;

/* Register: ROLE_CONTROL
*/

/* Field: Rp_Value : Rp Value
00b: Rp default
01b: Rp 1.5A
10b: Rp 3.0A
11b: Reserved
*/

typedef enum
{
    ROLE_CONTROL_RP_DEFAULT = 0x00,    /* Rp default */
    ROLE_CONTROL_RP_VALUE_RP_1 = 0x10, /* Rp 1.5A */
    ROLE_CONTROL_RP_VALUE_RP_3 = 0x20  /* Rp 3.0A */
} Rp_Value_t;

/* Field: CC2 : CC2
00b: Ra
01b: Rp (Use Rp definition in B5..4)
10b: Rd
11b: Open (Disconnect or don't care)
Set to 11b if enabling DRP in B7..6
*/

typedef enum
{
    ROLE_CONTROL_CC2_RA = 0x00,   /* Ra */
    ROLE_CONTROL_CC2_RP = 0x04,   /* Rp (Use Rp definition in B5..4) */
    ROLE_CONTROL_CC2_RD = 0x08,   /* Rd */
    ROLE_CONTROL_CC2_OPEN = 0x0c /* Open (Disconnect or don't care) */
} CC2_t;

/* Field: CC1 : CC1
00b: Ra
01b: Rp (Use Rp definition in B5..4)
10b: Rd
11b: Open (Disconnect or don't care)
Set to 11b if enabling DRP in B7..6
*/

typedef enum
{
    ROLE_CONTROL_CC1_RA = 0x00,   /* Ra */
    ROLE_CONTROL_CC1_RP = 0x01,   /* Rp (Use Rp definition in B5..4) */
    ROLE_CONTROL_CC1_RD = 0x02,   /* Rd */
    ROLE_CONTROL_CC1_OPEN = 0x03 /* Open (Disconnect or don't care) */
} CC1_t;

/* Register: CC_STATUS
*/

/* Field: CC2_State : CC2 State
If (ROLE_CONTROL.CC2=Rp) or (ConnectResult=0)
00b: SRC_Open (Open, Rp)
01b: SRC_Ra (below maximum vRa)
10b: SRC_Rd (within the vRd range)
11b: reserved

If (ROLE_CONTROL.CC2=Rd) or (ConnectResult=1)
00b: SNK_Open (Below maximum vRa)
01b: SNK_Default (Above minimum vRd-Connect)
10b: SNK_Power1_5 (Above minimum vRd-Connect) Detects Rp 1.5A
11b: SNK_Power3_0 (Above minimum vRd-Connect) Detects Rp 3.0A

If ROLE_CONTROL.CC2=Ra, this field is set to 00b
If ROLE_CONTROL.CC2=Open, this field is set to 00b
This field always returns 00b if (Look4Connection=1) or (POWER_CONTROL.EnableVconn=1 and
TCPC_CONTROL.PlugOrientation=1). Otherwise, the returned value depends upon ROLE_CONTROL.CC2.
*/

typedef enum
{
    CC_STATUS_CC2_STATE_SRC_OPEN = 0x00,     /* SRC_Open (Open, Rp) */
    CC_STATUS_CC2_STATE_SRC_RA = 0x04,       /* SRC_Ra (below maximum vRa) */
    CC_STATUS_CC2_STATE_SRC_RD = 0x08,       /* SRC_Rd (within the vRd range) */
    CC_STATUS_CC2_STATE_SNK_OPEN = 0x00,     /* SNK_Open (Below maximum vRa) */
    CC_STATUS_CC2_STATE_SNK_DEFAULT = 0x04,  /* SNK_Default (Above minimum vRd-Connect) */
    CC_STATUS_CC2_STATE_SNK_POWER1_5 = 0x08, /* SNK_Power1_5 (Above minimum vRd-Connect) Detects Rp 1.5A */
    CC_STATUS_CC2_STATE_SNK_POWER3_0 = 0x0c  /* SNK_Power3_0 (Above minimum vRd-Connect) Detects Rp 3.0A */
} CC2_State_t;

/* Field: CC1_State : CC1 State
If (ROLE_CONTROL.CC1 = Rp) or (ConnectResult=0)
00b: SRC_Open (Open, Rp)
01b: SRC_Ra (below maximum vRa)
10b: SRC_Rd (within the vRd range)
11b: reserved

If (ROLE_CONTROL.CC1 = Rd) or ConnectResult=1)
00b: SNK_Open (Below maximum vRa)
01b: SNK_Default (Above minimum vRd-Connect)
10b: SNK_Power1_5 (Above minimum vRd-Connect) Detects Rp-1.5A
11b: SNK_Power3_0 (Above minimum vRd-Connect) Detects Rp-3.0A

If ROLE_CONTROL.CC1=Ra, this field is set to 00b
If ROLE_CONTROL.CC1=Open, this field is set to 00b

This field always returns 00b if (Look4Connection=1) or (POWER_CONTROL.EnableVconn=1 and
TCPC_CONTROL.PlugOrientation=0). Otherwise, the returned value depends upon ROLE_CONTROL.CC1.
*/

typedef enum
{
    CC_STATUS_CC1_STATE_SRC_OPEN = 0x00,     /* SRC_Open (Open, Rp) */
    CC_STATUS_CC1_STATE_SRC_RA = 0x01,       /* SRC_Ra (below maximum vRa) */
    CC_STATUS_CC1_STATE_SRC_RD = 0x02,       /* SRC_Rd (within the vRd range) */
    CC_STATUS_CC1_STATE_SNK_OPEN = 0x00,     /* SNK_Open (Below maximum vRa) */
    CC_STATUS_CC1_STATE_SNK_DEFAULT = 0x01,  /* SNK_Default (Above minimum vRd-Connect) */
    CC_STATUS_CC1_STATE_SNK_POWER1_5 = 0x02, /* SNK_Power1_5 (Above minimum vRd-Connect) Detects Rp-1.5A */
    CC_STATUS_CC1_STATE_SNK_POWER3_0 = 0x03  /* SNK_Power3_0 (Above minimum vRd-Connect) Detects Rp-3.0A */
} CC1_State_t;

/* Register: COMMAND
*/

/* Field: Command : Command
0001 0001b:WakeI2C (no action is taken other than to wake the I2C interface).
0010 0010b:DisableVbusDetect. Disable Vbus present detection. The TCPC shall ignore this command and assert the
FAULT_STATUS.I2CInterfaceError if it has sourcing or sinking power over Vbus enabled.
0011 0011b:EnableVbusDetect. Enable Vbus present detection.
0100 0100b:DisableSinkVbus. Disable sinking power over Vbus. This COMMAND does not disable POWER_STATUS.VBUSPresent
detection.
0101 0101b:SinkVbus. Enable sinking power over Vbus and enable Vbus present detection. The TCPC shall ignore this
command and assert the FAULT_STATUS.I2CInterfaceError if it has sourcing power over Vbus enabled.
0110 0110b:DisableSourceVbus. Disable sourcing power over Vbus. The TCPC shall stop reporting FAULT_STATUS. Internal or
External OCP or OVP Faults. This COMMAND does not disable POWER_STATUS.VBUSPresent detection.
0111 0111b:SourceVbusDefaultVoltage. Enable sourcing vSafe5V over Vbus and enable Vbus present detection. Source shall
transition to vSafe5V if at a high voltage. The TCPC shall ignore this command and assert the
FAULT_STATUS.I2CInterfaceError if it has sinking power over Vbus enabled.
1000 1000b:SourceVbusHighVoltage. Execute sourcing high voltage over Vbus. The TCPC shall ignore this command and assert
the FAULT_STATUS.I2CInterfaceError if it is either does not have ability to source voltages higher than vSafe5V or is
already sourcing vSafe5V.  The actual voltage to be sourced may be set in a vendor defined manner. The TCPM may need to
send vendor defined commands before sending this COMMAND.
1001 1001b: Look4Connection. Start DRP Toggling if ROLE_CONTROL.DRP=1b. If ROLE_CONTROL.CC1/CC2 =  01b start with Rp, if
ROLE_CONTROL.CC1/CC2 =10b start with Rd. If ROLE_CONTROL.CC1/CC2 are not both 01b or 10b, then do not start toggling.
TCPC to MAINTAIN_STATE in Figure 4 11
1010 1010b:Reserved. No Action
1100 1100b:Reserved. No Action
1101 1101b:Reserved. No Action
1110 1110b:Reserved. No Action
1111 1111b:I2C Idle
*/

typedef enum
{
    TCPC_WAKEI2C = 0x11,           /* WakeI2C (no action is taken other than to wake the I2C interface). */
    TCPC_DISABLEVBUSDETECT = 0x22, /* DisableVbusDetect. Disable Vbus present detection. The TCPC shall ignore this */
                                   /* command and assert the FAULT_STATUS.I2CInterfaceError if it has sourcing or */
                                   /* sinking power over Vbus enabled. */
    TCPC_ENABLEVBUSDETECT = 0x33,  /* EnableVbusDetect. Enable Vbus present detection. */
    TCPC_DISABLESINKVBUS = 0x44,   /* DisableSinkVbus. Disable sinking power over Vbus. This COMMAND does not disable */
                                   /* POWER_STATUS.VBUSPresent detection. */
    TCPC_SINKVBUS =
        0x55, /* SinkVbus. Enable sinking power over Vbus and enable Vbus present detection. The TCPC shall */
              /* ignore this command and assert the FAULT_STATUS.I2CInterfaceError if it has sourcing power */
              /* over Vbus enabled. */
    TCPC_DISABLESOURCEVBUS =
        0x66, /* DisableSourceVbus. Disable sourcing power over Vbus. The TCPC shall stop reporting */
              /* FAULT_STATUS. Internal or External OCP or OVP Faults. This COMMAND does not */
              /* disable POWER_STATUS.VBUSPresent detection. */
    TCPC_SOURCEVBUSDEFAULTVOLTAGE =
        0x77, /* SourceVbusDefaultVoltage. Enable sourcing vSafe5V over Vbus and enable Vbus */
              /* present detection. Source shall transition to vSafe5V if at a high voltage. */
              /* The TCPC shall ignore this command and assert the */
              /* FAULT_STATUS.I2CInterfaceError if it has sinking power over Vbus enabled. */
    TCPC_SOURCEVBUSHIGHVOLTAGE =
        0x88, /* SourceVbusHighVoltage. Execute sourcing high voltage over Vbus. The TCPC shall ignore this command and
                 */
    /* assert the FAULT_STATUS.I2CInterfaceError if it is either does not have ability to source voltages */
    /* higher than vSafe5V or is already sourcing vSafe5V.  The actual voltage to be sourced may be set in a */
    /* vendor defined manner. The TCPM may need to send vendor defined commands before sending this COMMAND. */
    TCPC_LOOK4CONNECTION =
        0x99, /* Look4Connection. Start DRP Toggling if ROLE_CONTROL.DRP=1b. If ROLE_CONTROL.CC1/CC2 */
              /* =  01b start with Rp, if ROLE_CONTROL.CC1/CC2 =10b start with Rd. If */
              /* ROLE_CONTROL.CC1/CC2 are not both 01b or 10b, then do not start toggling. */
    TCPC_RXONEMORE =
        0xaa, /* RxOneMore. Configure the receiver to automatically clear the RECEIVE_DETECT register after */
              /* sending the next GoodCRC. This is used to shutdown reception of packets at a known point */
              /* regardless of packet separation or the depth of the receive FIFO in the TCPC. */
    TCPC_SENDFRSWAPSIGNAL = 0xcc, /* SendFRSwapSignal. Source TCPC sends Fast Role Swap signal within tTCPCSendFRSwap */
                                  /* after receiving this command if POWER_CONTROL.FastRoleSwapEnable = 1b. */
                                  /*  TCPC shall ignore this command and assert the FAULT_STATUS.I2CinterfaceError */
                                  /* if POWER_CONTROL.FastRoleSwapEnable = 0b. */
    TCPC_RESETTRASMITBUFFER =
        0xdd, /* ResetTransmitBuffer. The TCPC resets the pointer of the TRANSMIT_BUFFER register and */
              /* the contents of TRANSMIT_BUFFER becomes invalid when this command is issued by the TCPM. */
    /* This command shall be supported by TCPC compliant with USB Port Controller Specification Revision 2.0, */
    TCPC_RESETRECEIVEBUFFER =
        0xee, /* ResetReceiveBuffer. The TCPC resets the pointer of RX_BUFFER when this command is issued */
              /* by the TCPM. TCPC does not clear the content of the buffer upon receiving this command. */
              /* The TCPM issues this command in order to re-read the RECEIVE_BUFFER.RX_BUF_BYTE_x. */
    /* This command shall be supported by TCPC compliant with USB Port Controller Specification Revision 2.0,*/
    TCPC_I2C_IDLE = 0xff, /* I2C Idle */
    _N_COMMANDS = 11
} TcpcCommand_t;

/* Register: EXT_COMMAND
*/

typedef enum
{
    TCPC_SEND_FRS = 0x23,
    TCPC_START_AMS = 0x34,
    TCPC_END_AMS = 0x45,
    TCPC_LOOK4_FULL_CONNECTION = 0x56,
    TCPC_CONNECTION_SWAP_TO_SOURCE = 0x67,
    TCPC_CONNECTION_SWAP_TO_SINK = 0x78,
    TCPC_CONNECTION_ERROR_RECOVERY = 0x89,

    TCPC_CONNECTION_DISABLED = 0x9a,
    TCPC_CONNECTION_SOURCE_VCONN = 0xab,
    TCPC_CONNECTION_DISABLE_VCONN = 0xbc

    /*_N_EXT_COMMANDS=10, */
} TcpcExtCommand_t;

/* Register: DEVICE_CAPABILITIES_1
*/

/* Field: Source_Resistor_supported : Source Resistor supported
00b: Rp default only
01b: Rp 1.5A and default
10b: Rp 3.0A, 1.5A, and default
11b: Reserved
Rp values which may be configured by the TCPM via the ROLE_CONTROL register
*/

typedef enum
{
    DEVICE_CAPABILITIES_1_SOURCE_RESISTOR_SUPPORTED_RP_DEFAULT_ONLY = 0x0000, /* Rp default only */
    DEVICE_CAPABILITIES_1_SOURCE_RESISTOR_SUPPORTED_RP_1 = 0x0100,            /* Rp 1.5A and default */
    DEVICE_CAPABILITIES_1_SOURCE_RESISTOR_SUPPORTED_RP_3 = 0x0200             /* Rp 3.0A, 1.5A, and default */
} Source_Resistor_supported_t;

/* Field: Roles_Supported : Roles Supported
000b: Type-C Port Manager can configure the Port as Source only or Sink only (not DRP)
001b: Source only
010b: Sink only
011b: Sink with accessory support
100b: DRP only
101b: Source, Sink, DRP, Adapter/Cable all supported
110b: Source, Sink, DRP
111b: Not valid
*/

typedef enum
{
    TYPEC_PORT_MANAGER_CAN_CONFIGURE_THE_PORT_AS_SOURCE_ONLY_OR_SINK_ONLY =
        0x00,           /* Type-C Port Manager can configure the Port as Source only or Sink only (not DRP) */
    SOURCE_ONLY = 0x20, /* Source only */
    SINK_ONLY = 0x40,   /* Sink only */
    SINK_WITH_ACCESSORY_SUPPORT = 0x60,                /* Sink with accessory support */
    DRP_ONLY = 0x80,                                   /* DRP only */
    SOURCE_SINK_DRP_ADAPTERCABLE_ALL_SUPPORTED = 0xa0, /* Source, Sink, DRP, Adapter/Cable all supported */
    SOURCE_SINK_DRP = 0xc0,                            /* Source, Sink, DRP */
    NOT_VALID = 0xe0                                  /* Not valid */
} Roles_Supported_t;

/* Register: DEVICE_CAPABILITIES_2
*/

/* Field: VBUS_Voltage_Alarm_LSB : VBUS Voltage Alarm LSB
00b: TCPC has 25mV LSB for its voltage alarm and uses all 10 bits in VBUS_VOLTAGE_ALARM_HI_CFG and
VBUS_VOLTAGE_ALARM_LO_CFG.
01b: TCPC has 50mV LSB for its voltage alarm and uses only 9 bits. VBUS_VOLTAGE_ALARM_HI_CFG[0] and
VBUS_VOLTAGE_ALARM_LO_CFG[0] are ignored by TCPC.
10: TCPC has 100mV LSB for its voltage alarm and uses only 8 bits. VBUS_VOLTAGE_ALARM_HI_CFG[1:0] and
VBUS_VOLTAGE_ALARM_LO_CFG[1:0] are ignored by TCPC.
11: reserved
Support for VBUS_VOLTAGE_ALARM_LO_CFG and VBUS_VOLTAGE_ALARM_HI implemented
*/

typedef enum
{
    TCPC_HAS_25MV_LSB_FOR_ITS_VOLTAGE_ALARM_AND_USES_ALL_10_BITS_IN_VBUS_VOLTAGE_ALARM_HI_CFG_AND_VBUS_VOLTAGE_ALARM_LO_CFG =
        0x00, /* TCPC has 25mV LSB for its voltage alarm and uses all 10 bits in VBUS_VOLTAGE_ALARM_HI_CFG and */
              /* VBUS_VOLTAGE_ALARM_LO_CFG. */
    TCPC_HAS_50MV_LSB_FOR_ITS_VOLTAGE_ALARM_AND_USES_ONLY_9_BITS =
        0x10, /* TCPC has 50mV LSB for its voltage alarm and uses only 9 bits. VBUS_VOLTAGE_ALARM_HI_CFG[0] and */
              /* VBUS_VOLTAGE_ALARM_LO_CFG[0] are ignored by TCPC. */
    TCPC_HAS_100MV_LSB_FOR_ITS_VOLTAGE_ALARM_AND_USES_ONLY_8_BITS =
        0xa0  /* TCPC has 100mV LSB for its voltage alarm and uses only 8 bits. VBUS_VOLTAGE_ALARM_HI_CFG[1:0] and */
              /* VBUS_VOLTAGE_ALARM_LO_CFG[1:0] are ignored by TCPC. */
} VBUS_Voltage_Alarm_LSB_t;

/* Field: VCONN_Power_Supported : VCONN Power Supported
000b: 1.0W
001b: 1.5W
010b: 2.0W
011b: 3W
100b: 4W
101b: 5W
110b: 6W
111b: External
*/

typedef enum
{
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_0 = 0x00,        /* 1.0W */
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_1 = 0x02,        /* 1.5W */
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_2 = 0x04,        /* 2.0W */
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_3W = 0x06,       /* 3W */
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_4W = 0x08,       /* 4W */
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_5W = 0x0a,       /* 5W */
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_6W = 0x0c,       /* 6W */
    DEVICE_CAPABILITIES_2_VCONN_POWER_SUPPORTED_EXTERNAL = 0x0e  /* External */
} VCONN_Power_Supported_t;

/* Register: RX_BUF_FRAME_TYPE
*/

/* Field: Received_SOP_Message : Received SOP* Message
000b: Received SOP
001b: Received SOP'
010b: Received SOP''
011b: Received SOP_DBG'
100b: Received SOP_DBG''
110b: Received Cable Reset
All others are reserved.
*/

typedef enum
{
    RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_RECEIVED_SOP = 0x00,         /* Received SOP */
    RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_RECEIVED_SOP_P = 0x01,       /* Received SOP' */
    RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_RECEIVED_SOP_PP = 0x02,      /* Received SOP'' */
    RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_RECEIVED_SOP_DBG_P = 0x03,   /* Received SOP_DBG' */
    RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_RECEIVED_SOP_DBG_PP = 0x04,  /* Received SOP_DBG'' */
    RX_BUF_FRAME_TYPE_RECEIVED_SOP_MESSAGE_RECEIVED_CABLE_RESET = 0x06  /* Received Cable Reset */
} Received_SOP_Message_t;

/* Register: TRANSMIT
*/

/* Field: Retry_Counter : Retry Counter
00b: No message retry is required
01b: Automatically retry message transmission once
10b: Automatically retry message transmission twice
11b: Automatically retry message transmission three times
*/

typedef enum
{
    NO_MESSAGE_RETRY_IS_REQUIRED = 0x00,                   /* No message retry is required */
    AUTOMATICALLY_RETRY_MESSAGE_TRANSMISSION_ONCE = 0x10,  /* Automatically retry message transmission once */
    AUTOMATICALLY_RETRY_MESSAGE_TRANSMISSION_TWICE = 0x20, /* Automatically retry message transmission twice */
    AUTOMATICALLY_RETRY_MESSAGE_TRANSMISSION_THREE_TIMES =
        0x30  /* Automatically retry message transmission three times */
} Retry_Counter_t;

/* Field: Transmit_SOP_message : Transmit SOP* message
000b: Transmit SOP
001b: Transmit SOP'
010b: Transmit SOP''
011b: Transmit SOP_DBG'
100b: Transmit SOP_DBG''
101b: Transmit Hard Reset
110b: Transmit Cable Reset
111b: Transmit BIST Carrier Mode 2 (TCPC shall exit the BIST mode no later than tBISTContMode max)
*/

typedef enum
{
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_SOP = 0x00,         /* Transmit SOP */
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_SOP_P = 0x01,       /* Transmit SOP' */
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_SOP_PP = 0x02,      /* Transmit SOP'' */
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_SOP_DBG_P = 0x03,   /* Transmit SOP_DBG' */
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_SOP_DBG_PP = 0x04,  /* Transmit SOP_DBG'' */
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_HARD_RESET = 0x05,  /* Transmit Hard Reset */
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_CABLE_RESET = 0x06, /* Transmit Cable Reset */
    TRANSMIT_TRANSMIT_SOP_MESSAGE_TRANSMIT_BIST_CARRIER_MODE_2 =
        0x07  /* Transmit BIST Carrier Mode 2 (TCPC shall exit the BIST mode no later than tBISTContMode max) */
} Transmit_SOP_message_t;

/* Register: VBUS_VOLTAGE
*/

/* Field: Vbus_Scale_Factor : Vbus Scale Factor
00: VBUS measurement not scaled.
01: VBUS measurement divided by 2
10: VBUS measurement divided by 4
11: reserved
*/

typedef enum
{
    VBUS_MEASUREMENT_NOT_SCALED = 0x0000,   /* VBUS measurement not scaled. */
    VBUS_MEASUREMENT_DIVIDED_BY_2 = 0x0400, /* VBUS measurement divided by 2 */
    VBUS_MEASUREMENT_DIVIDED_BY_4 = 0x2800  /* VBUS measurement divided by 4 */
} Vbus_Scale_Factor_t;

/* Register: EXT_CONFIG
*/

/* Field: USB_Full_TypeC_Connection_Detection_Mode : USB Full Type-C Connection Detection Mode.
00b: Disabled (Default TCPC operation)
01b: SRC only
10b: DRP SRC preferred. (Use Try.SRC state)
11b: DRP SNK preferred. (use Try.SNK state)

Full connection state machine will perform perform source or sink fet transitions at connection. Vconn will be sourced
if Ra detected. CC_ORIENT and DBG_ACC pins will be updated according to connection. USB-C output register will be
updated on connection.
*/

typedef enum
{
    EXT_CONFIG_USB_FULL_TYPE_C_CONNECTION_DETECTION_MODE_DISABLED = 0x0000, /* Disabled (Default TCPC operation) */
    EXT_CONFIG_USB_FULL_TYPE_C_CONNECTION_DETECTION_MODE_SRC_ONLY = 0x0100, /* SRC only */
    EXT_CONFIG_USB_FULL_TYPE_C_CONNECTION_DETECTION_MODE_DRP_SRC_PREFERRED =
        0x0200, /* DRP SRC preferred. (Use Try.SRC state) */
    EXT_CONFIG_USB_FULL_TYPE_C_CONNECTION_DETECTION_MODE_DRP_SNK_PREFERRED =
        0x0300  /* DRP SNK preferred. (use Try.SNK state) */
} USB_Full_TypeC_Connection_Detection_Mode_t;

/* Field: Fast_Role_Swap_Enable : Fast Role Swap Enable
00b : Disable Detection of Fast Role Swap (For TCPM with no USBPD3.0 support, and during power role swap)
01b : Enable Detection, TCPM responsible for all actions
10b : Enable Detection, TCPC to open SNK fet
11b : Enable Detection, TCPC to open SNK fet, Close SRC fet when VBUS at Vsafe5V or less.

See also EXT_GPIO_CONFIG.DBG_ACC Mode
*/

typedef enum
{
    DISABLE_DETECTION_OF_FAST_ROLE_SWAP =
        0x00, /* Disable Detection of Fast Role Swap (For TCPM with no USBPD3.0 support, and during power role swap) */
    ENABLE_DETECTION_TCPM_RESPONSIBLE_FOR_ALL_ACTIONS = 0x08, /* Enable Detection, TCPM responsible for all actions */
    ENABLE_DETECTION_TCPC_TO_OPEN_SNK_FET = 0x10,             /* Enable Detection, TCPC to open SNK fet */
    ENABLE_DETECTION_TCPC_TO_OPEN_SNK_FET_CLOSE_SRC_FET_WHEN_VBUS_AT_VSAFE5V_OR_LESS =
        0x18  /* Enable Detection, TCPC to open SNK fet, Close SRC fet when VBUS at Vsafe5V or less. */
} Fast_Role_Swap_Enable_t;

/* Field: Automatic Discharge for Negative Transition
00b : Set EN_SNK1=0, Discharge to 5V, Set EN_SRC=1
01b : Set EN_SNK1=0, Discharge to VBUS_STOP_DISCHARGE_THRESHOLD, Set EN_SRC=1
10b : Set EN_SNK1=0, Automatic discharge disabled, Allow TCPM to use force discharge, when ADC monitors 5V set EN_SRC=1
*/

typedef enum
{
    EXT_CONFIG_NEGATIVE_TRANSITION_AUTO_DISCHARGE_TO_5V = 0x0000,
    EXT_CONFIG_NEGATIVE_TRANSITION_AUTO_DISCHARGE_TO_THRESHOLD = 0x0001,
    EXT_CONFIG_NEGATIVE_TRANSITION_AUTO_DISCHARGE_DISABLED = 0x0002
} Negative_Transition_Auto_Discharge_Mode_t;

/* Register: EXT_CONTROL
*/

/* Field: USBPD_VBUS_Control_In_Progress : USBPD VBUS Control In Progress (do we need this? Can just use
VBUS_SINK_DISCONNECT_THRESHOLD?)
00b : VBUS will be sourced or sinked with no expected change below sink connection threshold
01b : Hard reset in progress, SNK should not detect disconnect
10b : Power Role Swap in progress, SNK should not detect disconnect
11b : Reserved
*/

typedef enum
{
    VBUS_WILL_BE_SOURCED_OR_SINKED_WITH_NO_EXPECTED_CHANGE_BELOW_SINK_CONNECTION_THRESHOLD =
        0x00, /* VBUS will be sourced or sinked with no expected change below sink connection threshold */
    HARD_RESET_IN_PROGRESS_SNK_SHOULD_NOT_DETECT_DISCONNECT =
        0x02, /* Hard reset in progress, SNK should not detect disconnect */
    POWER_ROLE_SWAP_IN_PROGRESS_SNK_SHOULD_NOT_DETECT_DISCONNECT =
        0x04 /* Power Role Swap in progress, SNK should not detect disconnect */
} USBPD_VBUS_Control_In_Progress_t;

/* Register: FET_CONTROL
*/

/* Field: Force_FET_CONTROL : Force FET Control
00b : Controlled by TCPC, via COMMAND, in dead battery mode (EN_SNKDB controlled by HW at startup)
01b : Controlled by TCPC  via COMMAND. (Set EN_SNKDB=0)
11b : Controlled by TCPM via bits 3:0 of this register
*/

typedef enum
{
    FET_CONTROLLED_BY_TCPC_IN_DEAD_BATTERY_MODE = 0x00, /* Controlled by TCPC in dead battery mode */
    FET_CONTROLLED_BY_TCPC = 0x40,                      /* Controlled by TCPC */
    FET_CONTROLLED_BY_TCPM = 0xc0                       /* Controlled by TCPM */
} Force_FET_CONTROL_t;

/* Field: Force_EN_SNKDB : Force EN_SNKDB
0b : Force Open
1b : Force Closed
*/

typedef enum
{
    FET_CONTROL_FORCE_EN_SNKDB_FORCE_OPEN = 0x00,   /* Force Open */
    FET_CONTROL_FORCE_EN_SNKDB_FORCE_CLOSED = 0x08  /* Force Closed */
} Force_EN_SNKDB_t;

/* Field: Force_EN_SRC : Force EN_SRC
0b : Force Open
1b : Force Closed
*/

typedef enum
{
    FET_CONTROL_FORCE_EN_SRC_FORCE_OPEN = 0x00,   /* Force Open */
    FET_CONTROL_FORCE_EN_SRC_FORCE_CLOSED = 0x04  /* Force Closed */
} Force_EN_SRC_t;

/* Field: Force_EN_SNK1 : Force EN_SNK1
0b : Force Open
1b : Force Closed
*/

typedef enum
{
    FET_CONTROL_FORCE_EN_SNK1_FORCE_OPEN = 0x00,   /* Force Open */
    FET_CONTROL_FORCE_EN_SNK1_FORCE_CLOSED = 0x02  /* Force Closed */
} Force_EN_SNK1_t;

/* Field: Force_EN_SNK2 : Force EN_SNK2
0b : Force Open
1b : Force Closed
*/

typedef enum
{
    FET_CONTROL_FORCE_EN_SNK2_FORCE_OPEN = 0x00,   /* Force Open */
    FET_CONTROL_FORCE_EN_SNK2_FORCE_CLOSED = 0x01  /* Force Closed */
} Force_EN_SNK2_t;

/* Register: VOLTAGE_TRANSITION_CONTROL
*/

/* Field: VOLTAGE_TRANSITION_TYPE : Discharge for Negative Transition
0b : The next SourceVbusHighVoltage will be a positive voltage transition.
1b - The next SourceVbusHighVoltage will be a negative voltage transition, discharge of VBUS should be enabled.
When set VBUS_STOP_DISCHARGE_THRESHOLD must be set to the vbus target level.
*/

typedef enum
{
    VOLTAGE_TRANSITION_CONTROL_POSITIVE_TRANSITION = 0x00,
    VOLTAGE_TRANSITION_CONTROL_NEGATIVE_TRANSITION = 0x80
} VOLTAGE_TRANSITION_TYPE_t;

/* Field: EN_SNK1 Mode, EN_SRC Mode:
00b: Disabled
01b: Use as SinkVbus FET control
10b: Use as SourceVbusHighVoltage FET control

NOTE: This is only applied when the command register is written, so to switch from 2nd source to 3rd source rail change
this register before issuing SourceVbusHighVoltage
*/

typedef enum
{
    EN_DISABLED = 0x00, /* Disabled */
    EN_USE_AS_SNK = 0x01,
    EN_USE_AS_SRC = 0x02
} EN_SRC_SNK_Mode_t;

/*------------------------------------------ */
/* Registers for: identification */
/*------------------------------------------ */
#define ADDR_vendor_id TCPC_VENDOR_ID_IDX
#define ADDR_product_id TCPC_PRODUCT_ID_IDX
#define ADDR_device_id TCPC_DEVICE_ID_IDX
#define ADDR_usbtypec_rev TCPC_USBTYPEC_REV_IDX
#define ADDR_usbpd_rev_ver TCPC_USBPD_REV_VER_IDX
#define ADDR_pd_interface_rev TCPC_PD_INTERFACE_REV_IDX

/*------------------------------------------ */
/* Registers for: alert */
/*------------------------------------------ */
#define ADDR_alert TCPC_ALERT_IDX

/*------------------------------------------ */
/* Registers for: mask */
/*------------------------------------------ */
#define ADDR_alert_mask TCPC_ALERT_MASK_IDX
#define ADDR_power_status_mask TCPC_POWER_STATUS_MASK_IDX
#define ADDR_fault_status_mask TCPC_FAULT_STATUS_MASK_IDX
#define ADDR_extended_status_mask TCPC_EXTENDED_STATUS_MASK_IDX
#define ADDR_alert_extended_mask TCPC_ALERT_EXTENDED_MASK_IDX

/*------------------------------------------ */
/* Registers for: configure standard output */
/*------------------------------------------ */
#define ADDR_config_standard_output TCPC_CONFIGURE_STANDARD_OUTPUT_IDX

/*------------------------------------------ */
/* Registers for: control */
/*------------------------------------------ */
#define ADDR_tcpc_control TCPC_TCPC_CONTROL_IDX
#define ADDR_role_control TCPC_ROLE_CONTROL_IDX
#define ADDR_fault_control TCPC_FAULT_CONTROL_IDX
#define ADDR_power_control TCPC_POWER_CONTROL_IDX

/*------------------------------------------ */
/* Registers for: status */
/*------------------------------------------ */
#define ADDR_cc_status TCPC_CC_STATUS_IDX
#define ADDR_power_status TCPC_POWER_STATUS_IDX
#define ADDR_fault_status TCPC_FAULT_STATUS_IDX
#define ADDR_extended_status TCPC_EXTENDED_STATUS_IDX
#define ADDR_alert_extended TCPC_ALERT_EXTENDED_IDX

/*------------------------------------------ */
/* Registers for: command */
/*------------------------------------------ */
#define ADDR_command TCPC_COMMAND_IDX

/*------------------------------------------ */
/* Registers for: capability */
/*------------------------------------------ */
#define ADDR_device_capabilities_1 TCPC_DEVICE_CAPABILITIES_1_IDX
#define ADDR_device_capabilities_2 TCPC_DEVICE_CAPABILITIES_2_IDX
#define ADDR_standard_input_capabilities TCPC_STANDARD_INPUT_CAPABILITIES_IDX
#define ADDR_standard_output_capabilities TCPC_STANDARD_OUTPUT_CAPABILITIES_IDX

/*------------------------------------------ */
/* Registers for: message receive */
/*------------------------------------------ */
#define ADDR_message_header_info TCPC_MESSAGE_HEADER_INFO_IDX
#define ADDR_receive_detect TCPC_RECEIVE_DETECT_IDX
#define ADDR_receive_byte_count TCPC_RECEIVE_BYTE_COUNT_IDX
#define ADDR_rx_buf_frame_type TCPC_RX_BUF_FRAME_TYPE_IDX
#define ADDR_rx_buf_header TCPC_RX_BUF_HEADER_IDX
#define ADDR_rx_buf_obj1 TCPC_RX_BUF_OBJ1_IDX
#define ADDR_rx_buf_obj2 TCPC_RX_BUF_OBJ2_IDX
#define ADDR_rx_buf_obj3 TCPC_RX_BUF_OBJ3_IDX
#define ADDR_rx_buf_obj4 TCPC_RX_BUF_OBJ4_IDX
#define ADDR_rx_buf_obj5 TCPC_RX_BUF_OBJ5_IDX
#define ADDR_rx_buf_obj6 TCPC_RX_BUF_OBJ6_IDX
#define ADDR_rx_buf_obj7 TCPC_RX_BUF_OBJ7_IDX

#define POR_receive_detect 0x00

/*------------------------------------------ */
/* Registers for: message transmit */
/*------------------------------------------ */
#define ADDR_transmit TCPC_TRANSMIT_IDX
#define ADDR_transmit_byte_count TCPC_TRANSMIT_BYTE_COUNT_IDX
#define ADDR_tx_buf_header TCPC_TX_BUF_HEADER_IDX
#define ADDR_tx_buf_obj1 TCPC_TX_BUF_OBJ1_IDX
#define ADDR_tx_buf_obj2 TCPC_TX_BUF_OBJ2_IDX
#define ADDR_tx_buf_obj3 TCPC_TX_BUF_OBJ3_IDX
#define ADDR_tx_buf_obj4 TCPC_TX_BUF_OBJ4_IDX
#define ADDR_tx_buf_obj5 TCPC_TX_BUF_OBJ5_IDX
#define ADDR_tx_buf_obj6 TCPC_TX_BUF_OBJ6_IDX
#define ADDR_tx_buf_obj7 TCPC_TX_BUF_OBJ7_IDX

/*------------------------------------------ */
/* Registers for: voltage monitor/thresholds */
/*------------------------------------------ */
#define ADDR_vbus_voltage TCPC_VBUS_VOLTAGE_IDX
#define ADDR_vbus_sink_disconnect_threshold TCPC_VBUS_SINK_DISCONNECT_THRESHOLD_IDX
#define ADDR_vbus_stop_discharge_threshold TCPC_VBUS_STOP_DISCHARGE_THRESHOLD_IDX
#define ADDR_vbus_voltage_alarm_hi_cfg TCPC_VBUS_VOLTAGE_ALARM_HI_CFG_IDX
#define ADDR_vbus_voltage_alarm_lo_cfg TCPC_VBUS_VOLTAGE_ALARM_LO_CFG_IDX

/*------------------------------------------ */
/* Registers for: PTN5110 extended */
/*------------------------------------------ */
#define ADDR_ptn5110_ext_alert PTN5110_EXT_ALERT_IDX
#define ADDR_ptn5110_ext_alert_mask PTN5110_EXT_ALERT_MASK_IDX
#define ADDR_ptn5110_ext_config PTN5110_EXT_CONFIG_IDX
#define ADDR_ptn5110_ext_control PTN5110_EXT_CONTROL_IDX
#define ADDR_ptn5110_ext_command PTN5110_EXT_COMMAND_IDX
#define ADDR_ptn5110_ext_fault_config PTN5110_EXT_FAULT_CONFIG_IDX
#define ADDR_ptn5110_ext_status PTN5110_EXT_STATUS_IDX
#define ADDR_ptn5110_ext_msg_index PTN5110_EXT_MSG_INDEX_IDX
#define ADDR_ptn5110_ext_transmit_byte_count PTN5110_EXT_TRANSMIT_BYTE_COUNT_IDX
#define ADDR_ptn5110_ext_receive_byte_count PTN5110_EXT_RECEIVE_BYTE_COUNT_IDX
#define ADDR_ptn5110_ext_gpio_config PTN5110_EXT_GPIO_CONFIG_IDX
#define ADDR_ptn5110_ext_gpio_control PTN5110_EXT_GPIO_CONTROL_IDX

#endif
