/*******************************************************************************
*
* Copyright 2007-2015 Freescale Semiconductor, Inc.
*
* This software is owned or controlled by Freescale Semiconductor.
* Use of this software is governed by the Freescale License
* distributed with this Material.
* See the LICENSE file distributed for more details.
* 
*
****************************************************************************//*!
*
* @brief  Definition file for square root functions in assembler
* 
*******************************************************************************/
#ifndef _GFLIB_SQRT_F32_DEFASM_H_
#define _GFLIB_SQRT_F32_DEFASM_H_

#if defined(__cplusplus) 
extern "C" { 
#endif 
/******************************************************************************
* Includes
******************************************************************************/
#include "GFLIB_Sqrt_F32_Asm.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/
#define GFLIB_Sqrt_F16_Asm(f16Val) GFLIB_Sqrt_F16_FAsm(f16Val, &gsSqrtTable_F32)
#define GFLIB_Sqrt_F16l_Asm(f32Val) GFLIB_Sqrt_F16l_FAsm(f32Val, &gsSqrtTable_F32)

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Global constants
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/
extern GFLIB_SQRT_TABLE_T_F32 gsSqrtTable_F32;

/******************************************************************************
* Global functions
******************************************************************************/

/******************************************************************************
* Inline functions
******************************************************************************/
#if defined(__cplusplus) 
} 
#endif 

#endif /* _GFLIB_SQRT_F32_DEFASM_H_ */
