/*******************************************************************************
*
* Copyright 2007-2015 Freescale Semiconductor, Inc.
*
* This software is owned or controlled by Freescale Semiconductor.
* Use of this software is governed by the Freescale License
* distributed with this Material.
* See the LICENSE file distributed for more details.
* 
*
****************************************************************************//*!
*
* @brief  Definition file for arcus sine and arcus cosine functions
* 
*******************************************************************************/
#ifndef _GFLIB_ASINACOS_F32_ASMDEF_H_
#define _GFLIB_ASINACOS_F32_ASMDEF_H_

#if defined(__cplusplus) 
extern "C" { 
#endif 
/******************************************************************************
* Includes
******************************************************************************/
#include "GFLIB_AsinAcos_F32_Asm.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/
#define GFLIB_Asin_F16_Asm(f16Val) GFLIB_Asin_F16_FAsm(f16Val, &gsAsinCoef_F32)
#define GFLIB_Acos_F16_Asmi(f16Val) GFLIB_Acos_F16_FAsmi(f16Val, &gsAsinCoef_F32)

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/
extern GFLIB_CONST GFLIB_ASIN_T_F32 gsAsinCoef_F32;

/*****************************************************************************
* Global functions
******************************************************************************/

/******************************************************************************
* Inline functions
******************************************************************************/
#if defined(__cplusplus) 
} 
#endif 

#endif /* _GFLIB_ASINACOS_F32_ASMDEF_H_ */
