/*******************************************************************************
 * This software is provided AS IS and without warranty of any kind. 
 * Your right to use this software is subject to separate terms and conditions entered between you and NXP.
 * If you have not entered into such terms, you have no license rights to use the code.
 * Copyright 2007-2016 Freescale Semiconductor, Inc.
 * Copyright 2017~2019 NXP.
 * All rights reserved.
****************************************************************************//*!
*
* @brief  Definition file for sine and cosine functions
* 
*******************************************************************************/
#ifndef _GFLIB_SINCOS_F32_DEFASM_H_
#define _GFLIB_SINCOS_F32_DEFASM_H_

#if defined(__cplusplus) 
extern "C" { 
#endif 
/******************************************************************************
* Includes
******************************************************************************/
#include "GFLIB_SinCos_F32_Asm.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/
#define GFLIB_Sin_F16_Asm(f16Angle) GFLIB_Sin_F16_FAsm(f16Angle, &gsSinCoefTable_F32)
#define GFLIB_Cos_F16_Asm(f16Angle) GFLIB_Cos_F16_FAsmi(f16Angle, &gsSinCoefTable_F32)

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Global constants
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/
extern GFLIB_CONST GFLIB_SIN_T_F32 gsSinCoefTable_F32;

/******************************************************************************
* Global functions
******************************************************************************/

/******************************************************************************
* Inline functions
******************************************************************************/
#if defined(__cplusplus) 
} 
#endif 

#endif /* _GFLIB_SINCOS_F32_DEFASM_H_ */
