/* ###################################################################
**     Filename    : main.c
**     Project     : FRDM-MC36XSD-E14-Test
**     Processor   : MKL25Z128VLK4
**     Version     : Driver 01.01
**     Compiler    : GNU C Compiler
**     Date/Time   : 2016-05-30, 15:07, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.01
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "XSD1.h"
#include "SPI_Device1.h"
#include "CSpin1.h"
#include "RSTB1.h"
#include "SM1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
#include "FSL_Wait.h"
/*lint -save  -e970 Disable MISRA rule (6.3) checking. */
int main(void)
/*lint -restore Enable MISRA rule (6.3) checking. */
{
  /* Write your local variable definition here */

	uint16_t chain_data[XSD1_DAISY_CHAIN_LENGTH] = {0,255};		//table defining the duty cycle value for the 2 devices
	uint16_t chain_data1[XSD1_DAISY_CHAIN_LENGTH]= {255,0};
	
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
    
    PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  /* For example: for(;;) { } */
  for (;;)
   {
	XSD1_SetPWMDuty(0, chain_data);		//Sets channel 0 of both device with "chain_data" table values (0,255)
  	XSD1_SetPWMDuty(1, chain_data1);	//Sets channel 1 of both device with "chain_data1" table values (255,0)
   	
  	WaitMS(1000);
   	
  	XSD1_SetPWMDuty(0, chain_data1);	//Sets channel 0 of both device with "chain_data1" table values (255,0)
   	XSD1_SetPWMDuty(1, chain_data);		//Sets channel 1 of both device with "chain_data" table values (0,255)
   	
   	WaitMS(1000);
   }
  
  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
