/* ###################################################################
**     Filename    : main.c
**     Project     : G4XS_K64F_XSG_IncrementalPWM
**     Processor   : MK64FN1M0VLQ12
**     Version     : Driver 01.01
**     Compiler    : GNU C Compiler
**     Date/Time   : 2016-09-07, 15:38, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.01
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "Pins1.h"
#include "G4XS1.h"
#include "RSTBPin1.h"
#include "CLK1.h"
#include "SPI_Device1.h"
#include "CSpin1.h"
#include "TU1.h"
#include "SM1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "PDD_Includes.h"
#include "Init_Config.h"
/* User includes (#include below this line is not maintained by Processor Expert) */
#include "FSL_Wait.h"

/*lint -save  -e970 Disable MISRA rule (6.3) checking. */
int main(void)
/*lint -restore Enable MISRA rule (6.3) checking. */
{
  /* Write your local variable definition here */
  G4XS1_TError Error;
  uint8_t LSBStep[2] = {ids4LSB, ids4LSB};

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  for (;;) {
    while (1) { /* increments to maximum duty */
      Error = G4XS1_IncrementalPWMControl(0, idsPOSITIVE, LSBStep);
      if ((Error != ERR_OK) && (Error != ERR_MAX_DUTY)) {
        /* something went wrong */
      }
      for (uint8_t j = 0; j < 10; j++) { /* waits for 200 ms */
        WaitMS(20);
        G4XS1_FeedWatchdog();
      }
      if (Error == ERR_MAX_DUTY) {
        break;
      }
    }

    while (1) { /* decrements to minimum duty */
      Error = G4XS1_IncrementalPWMControl(0, idsNEGATIVE, LSBStep);
      if ((Error != ERR_OK) && (Error != ERR_MIN_DUTY)) {
        /* something went wrong */
      }
      for (uint8_t j = 0; j < 10; j++) { /* waits for 200 ms */
        WaitMS(20);
        G4XS1_FeedWatchdog();
      }
      if (Error == ERR_MIN_DUTY) {
        break;
      }
    }
  }

  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
