/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : XSD1.h
**     CDE edition : Community
**     Project     : FRDM-24XSMBEVB_KL25z-Demo
**     Processor   : MKL25Z128VLK4
**     Component   : 36VeXtremeSwitch
**     Version     : Component 01.000, Driver 01.00, CPU db: 3.00.000
**     Repository  : My Components
**     Compiler    : GNU C Compiler
**     Date/Time   : 2017-02-28, 16:43, # CodeGen: 0
**     Abstract    :
**
**     Settings    :
**          Component Name                                 : XSD1
**          SPI_Device                                     : SPI_Device
**          Use 8-bit SPI communication                    : yes
**          Automatic watchdog toggling                    : no
**          Reset Pin control                              : Enabled
**            RSTB Link                                    : BitIO_LDD
**            RSTB Pin                                     : PTC12/TPM_CLKIN0
**          Devices On Daisy Chain                         : 1
**            Configuration for device0                    : Configuration_0
**          Configurations                                 : 1
**            Configuration_0                              : 1
**              Global Configuration                       : 
**                PWM channel 0                            : Enabled
**                PWM channel 1                            : Enabled
**                Parallel Mode                            : Disabled
**                Track & Hold current sensing             : Disabled
**                Watchdog                                 : Disabled
**                VDD failure detection                    : Disabled
**                Overvoltage protection                   : Enabled
**                CSNS Pin Function                        : Current Sensing on Channel 1
**              Output                                     : 2
**                HS0                                      : 
**                  Direct control                         : Disabled
**                  PWM duty                               : 64
**                  PWM Switch-on Delay                    : No Delay
**                  PWM clocksource                        : Internal
**                  External PWM Clock Divider             : 256
**                  Overcurrent profile                    : DC Motor
**                  Short circuit detection                : Disabled
**                  OpenLoad Detection in ON state         : Disabled
**                  OpenLoad Detection in OFF state        : Disabled
**                  Slew rate                              : Medium SR
**                  Random Current Offset                  : Add random offset
**                  Max Auto-Retry Count                   : Infinite retries
**                  Auto-Retry Period                      : tAUTO_10
**                  Auto-Retry Function                    : Disabled
**                  Low Current Threshold                  : I_OCL1
**                  Medium Current Threshold               : I_OCM1
**                  High Current Threshold                 : I_OCH1
**                  Threshold Activation Times             : tOCH1 and tOCM1_L
**                  Current Sense Ratio                    : high-current
**                HS1                                      : 
**                  Direct control                         : Enabled
**                  PWM duty                               : 256
**                  PWM Switch-on Delay                    : No Delay
**                  PWM clocksource                        : Internal
**                  External PWM Clock Divider             : 256
**                  Overcurrent profile                    : DC Motor
**                  Short circuit detection                : Disabled
**                  OpenLoad Detection in ON state         : Disabled
**                  OpenLoad Detection in OFF state        : Disabled
**                  Slew rate                              : Medium SR
**                  Random Current Offset                  : Add random offset
**                  Max Auto-Retry Count                   : Infinite retries
**                  Auto-Retry Period                      : tAUTO_10
**                  Auto-Retry Function                    : Disabled
**                  Low Current Threshold                  : I_OCL1
**                  Medium Current Threshold               : I_OCM1
**                  High Current Threshold                 : I_OCH1
**                  Threshold Activation Times             : tOCH1 and tOCM1_L
**                  Current Sense Ratio                    : high-current
**          Auto Initialization                            : yes
**     Contents    :
**         Init                - result XSD1_Init();
**         ReadRegister        - result XSD1_ReadRegister(uint8_t regAddr, uint16_t* regVal);
**         WriteRegister       - result XSD1_WriteRegister(uint8_t regAddr, uint16_t* regVal);
**         GetStatus           - result XSD1_GetStatus(uint16_t* statusData);
**         GetFaultInfo        - result XSD1_GetFaultInfo(uint16_t channel, uint16_t* faultInfo);
**         SetPWMDuty          - result XSD1_SetPWMDuty(uint8_t channel, uint16_t* dutyValues);
**         SetPWMState         - result XSD1_SetPWMState(uint8_t* channelStates);
**         FeedWatchdog        - result XSD1_FeedWatchdog();
**         ConfigureWatchdog   - result XSD1_ConfigureWatchdog(bool state, uint32_t deviceMask);
**         Diagnosis           - result XSD1_Diagnosis(uint16_t* diagData);
**         ConfigureMonitoring - result XSD1_ConfigureMonitoring(uint16_t* selection);
**
**     (c) Copyright Freescale 2014
** ###################################################################*/
/*!
** @file XSD1.h
** @version 01.00
** @brief
**
*/         
/*!
**  @addtogroup XSD1_module XSD1 module documentation
**  @{
*/         

#ifndef __XSD1_H
#define __XSD1_H

/* MODULE XSD1. */

/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/* Include inherited components */
#include "SPI_Device1.h"
#include "RSTBPin1.h"
#include "MC06XSD200.h"

#include "Cpu.h"

#ifndef __CDEUserType_XSD1_result
#define __CDEUserType_XSD1_result
typedef uint16_t XSD1_result;          /*return type of methods*/
#endif

/* number of devices in the daisy chain */
#define XSD1_DAISY_CHAIN_LENGTH 1
/* number of communication words for the SPI_Device functions */
#define  XSD1_COMM_LENGTH (1 * 2)
/* value that can be used for omitting write to a register */

#define DO_NOT_WRITE 0xFFFFU
/* numeric array that can be used for identifying selected configuration indexes for individual devices in daisy chain */

#define  XSD1_CONFIG_INDEXES {0}

/* The following definitions contain register initialization values of the registers */

#define Configuration_0_GCR (PWM_CHANNEL_0_ENABLE \
                        | PWM_CHANNEL_1_ENABLE \
                        | PARALLEL_MODE_DISABLE \
                        | TRACK_AND_HOLD_CURRENT_DISABLE \
                        | WATCHDOG_DISABLE \
                        | VDD_FAILURE_DETECTION_DISABLE \
                        | CSNS_FUNCTION_CURRENT_CH1 \
                        | OVERVOLTAGE_PROTECTION_ENABLE)

#define Configuration_0_RETRY_0 (RANDOM_CURRENT_OFFSET_ADD \
                        | AUTO_RETRY_NUMBER_INFINITE \
                        | AUTO_RETRY_PERIOD_tAUTO_10 \
                        | AUTO_RETRY_DC_MOTOR_DISABLED)
#define Configuration_0_CONFR_0 (SHORT_CIRCUIT_DETECTION_DISABLE \
                        | OPEN_LOAD_DETECTION_ON_DISABLE \
                        | OPEN_LOAD_DETECTION_OFF_DISABLE \
                        | DIRECT_CONTROL_DISABLE \
                        | SWITCH_ON_DELAY_NO_DELAY \
                        | SLEW_RATE_MEDIUM)
#define Configuration_0_OCR_0 (PWM_EXTERNAL_CLOCK_DIVIDER_256 \
                        | PWM_CLOCK_SOURCE_INTERNAL \
                        | THRESHOLD_ACTIVATION_TIMES_tOCH1_tOCM1_L \
                        | MEDIUM_CURRENT_THRESHOLD_SELECT_IOCM1 \
                        | LOW_CURRENT_THRESHOLD_SELECT_IOCL1 \
                        | HIGH_CURRENT_THRESHOLD_SELECT_IOCH1 \
                        | CURRENT_SENSE_RATIO_HIGH)

#define Configuration_0_RETRY_1 (RANDOM_CURRENT_OFFSET_ADD \
                        | AUTO_RETRY_NUMBER_INFINITE \
                        | AUTO_RETRY_PERIOD_tAUTO_10 \
                        | AUTO_RETRY_DC_MOTOR_DISABLED)
#define Configuration_0_CONFR_1 (SHORT_CIRCUIT_DETECTION_DISABLE \
                        | OPEN_LOAD_DETECTION_ON_DISABLE \
                        | OPEN_LOAD_DETECTION_OFF_DISABLE \
                        | DIRECT_CONTROL_ENABLE \
                        | SWITCH_ON_DELAY_NO_DELAY \
                        | SLEW_RATE_MEDIUM)
#define Configuration_0_OCR_1 (PWM_EXTERNAL_CLOCK_DIVIDER_256 \
                        | PWM_CLOCK_SOURCE_INTERNAL \
                        | THRESHOLD_ACTIVATION_TIMES_tOCH1_tOCM1_L \
                        | MEDIUM_CURRENT_THRESHOLD_SELECT_IOCM1 \
                        | LOW_CURRENT_THRESHOLD_SELECT_IOCL1 \
                        | HIGH_CURRENT_THRESHOLD_SELECT_IOCH1 \
                        | CURRENT_SENSE_RATIO_HIGH)



/*
** ===================================================================
**     Method      :  XSD1_Init (component 36VeXtremeSwitch)
**     @brief
**         Initializes the device(s) according to the set properties. This 
**         method writes the data gathered from the component properties 
**         into registers via SPI. When auto initialization is enabled, 
**         this method will be called automatically within PE initialization 
**         function - PE_low_level_init(). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         result          - Return ES_ERR_OK if the operation was successful 
** ===================================================================
*/
XSD1_result XSD1_Init();

/*
** ===================================================================
**     Method      :  XSD1_ReadRegister (component 36VeXtremeSwitch)
**     @brief
**         Reads value of the given register via SPI. This method allows 
**         the user to read content from a register of the device(s). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t regAddr - Address of the register, these address already 
**                           defined in MC06XSD200.h file in project. 
**         @param
**         uint16_t regVal - Pointer to the variable for resulting data. 
**                           If there are more devices in a daisy chain, 
**                           all devices are read at once. The size of the 
**                           array must match the length of the daisy-chain 
**                           configured in component. In case there is only 
**                           single device, the size is 1. 
**         @return
**         result          - Return ES_ERR_OK if the operation was successful 
** ===================================================================
*/
XSD1_result XSD1_ReadRegister(uint8_t regAddr, uint16_t *regVal);

/*
** ===================================================================
**     Method      :  XSD1_WriteRegister (component 36VeXtremeSwitch)
**     @brief
**         Writes value to the given register via SPI. This method allows 
**         the user to set a custom value to a register of the device(s). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t regAddr - Register address 
**         @param
**         uint16_t regVal - Pointer to the value(s) to be written. If there 
**                           are more devices in a daisy chain, all devices 
**                           are written. The size of the array must match 
**                           the length of the daisy chain configured in 
**                           component. In case there is only single device, 
**                           the size is 1. 
**         @return
**         result          - Return ES_ERR_OK if the operation was successful 
** ===================================================================
*/
XSD1_result XSD1_WriteRegister(uint8_t regAddr, uint16_t *regVal);

/*
** ===================================================================
**     Method      :  XSD1_GetStatus (component 36VeXtremeSwitch)
**     @brief
**         Returns current general status information. It can be used for 
**         quick check of devices. Current status of all devices on daisy 
**         chain will be stored in an array. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t statusData - Pointer to array that will be filled with the 
**                           status information. The size of the array must 
**                           match the length of the daisy chain configured 
**                           in component. In case there is only single 
**                           device, the size is 1. Each item of the array 
**                           will be a combination of these values: 
**                           ES_STATUS_OVERVOLTAGE - overvoltage fault 
**                           ES_STATUS_UNDERVOLTAGE - undervoltage fault 
**                           ES_STATUS_POR - power-on reset (POR) has occurred 
**                           ES_STATUS_FAULT0 - faults are detected on channel 
**                           0 
**                           ES_STATUS_FAULT1 - faults are detected on channel 
**                           1 
**                           ES_STATUS_AUTORETRY0 - auto-retry counter is 
**                           full on channel 0 
**                           ES_STATUS_AUTORETRY1 - auto-retry counter is 
**                           full on channel 1 
**                           ES_STATUS_OUT0 - indicate the status of channel 
**                           0 is ON:1  OFF:0 
**                           ES_STATUS_OUT1 - indicate the status of channel 
**                           1 is ON:1  OFF:0 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_GetStatus(uint16_t *statusData);

/*
** ===================================================================
**     Method      :  XSD1_GetFaultInfo (component 36VeXtremeSwitch)
**     @brief
**         Gets fault status information. It can be used to check failure 
**         details when fault happens. The fault information will be stored 
**         to an array. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t channel - The number of the channel that we request information 
**                           for. 
**         @param
**         uint16_t faultInfo - Pointer to array of uint16_t that will be filled 
**                           with the fault information. The size of the 
**                           array must match the length of the daisy chain 
**                           configured in component. In case there is only 
**                           single device, the size is 1. Each item of 
**                           the array will be a combination of these values: 
**                           ES_ERR_OC - overcurrent fault on channel 
**                           ES_ERR_SC - severe short-circuit 
**                           ES_ERR_OS - output shorted to VPWR 
**                           ES_ERR_OLOFF - open load in OFF state 
**                           ES_ERR_OLON - open load in ON state 
**                           ES_ERR_OTW - overtemperature 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_GetFaultInfo(uint16_t channel, uint16_t *faultInfo);

/*
** ===================================================================
**     Method      :  XSD1_SetPWMDuty (component 36VeXtremeSwitch)
**     @brief
**         Sets PWM duty for specified channel. Calling this method will 
**         set PWM output immediately (if PWM is enabled). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t channel - Output channel number 
**         @param
**         uint16_t dutyValues - Pointer to array that contains the PWM duty 
**                           values. The size of the array must match the 
**                           length of the daisy chain configured in component. 
**                           In case there is only single device, the size 
**                           is 1. Input value must be in range 0 - 256 
**                           for the duty cycle 0 - 100 percent. 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_SetPWMDuty(uint8_t channel, uint16_t *dutyValues);

/*
** ===================================================================
**     Method      :  XSD1_SetPWMState (component 36VeXtremeSwitch)
**     @brief
**         Enables or disables the PWM module. Activates the internal PWM 
**         module of both channels simultaneously according to the values 
**         of duty cycle and turn-on delays set previously. When the device 
**         works in PARALLEL mode, the linked channel cannot be set differently. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint8_t channelStates - Pointer to array containing the PWM configuration 
**                           values. The size of the array must match the 
**                           length of the daisy chain configured in component. 
**                           In case there is only single device, the size 
**                           is 1. When a channel is set PWM disabled, direct 
**                           input pins are applied. The values in array 
**                           can be: 
**                           ES_PWM_DISABLE_ALL - PWM module is disabled 
**                           for both channels 
**                           ES_PWM_ENABLE_CH0_ONLY - only set channel 0 
**                           enabled 
**                           ES_PWM_ENABLE_CH1_ONLY - only set channel 1 
**                           enabled 
**                           ES_PWM_ENABLE_ALL - PWM module is enabled for 
**                           both channels 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_SetPWMState(uint8_t *channelStates);

/*
** ===================================================================
**     Method      :  XSD1_FeedWatchdog (component 36VeXtremeSwitch)
**     @brief
**         Feeds the watchdog to avoid watchdog timeout in case the watchdog 
**         is enabled. When automatic watchdog toggling in disabled or no 
**         SPI data is sent (when watchdog toggling is enabled), please 
**         make sure this method is called at least twice during the watchdog 
**         timeout period (typ. 310 ms). In case the watchdog timeout happens, 
**         the device will enter fail-safe mode. Calling this method again 
**         will turn the device from fail-safe mode back to normal mode 
**         (all registers are reset). 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_FeedWatchdog();

/*
** ===================================================================
**     Method      :  XSD1_ConfigureWatchdog (component 36VeXtremeSwitch)
**     @brief
**         Allows to configure (enable or disable) watchdog. After calling 
**         this method to enable watchdog, be sure SPI data are sent (when 
**         automatic watchdog toggling is enabled) or FeedWatchdog() is 
**         called (when watchdog toggling is disabled) periodically to avoid 
**         the watchdog timeout. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         bool state      - State of the watchdog. TRUE = watchdog enabled 
**         @param
**         uint32_t deviceMask - Each bit in this parameter represents one device 
**                           on the daisy chain. If a bit is '1' then the 
**                           configuration is applied to the device. '0' 
**                           means no change for the device with the index. 
**                           To apply value to all device, use the ES_ALL_DEVICES 
**                           constant. 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_ConfigureWatchdog(bool state, uint32_t deviceMask);

/*
** ===================================================================
**     Method      :  XSD1_Diagnosis (component 36VeXtremeSwitch)
**     @brief
**         Runs a diagnosis routine. It will get channel configuration, 
**         product identification, current logic status of direct inputs, 
**         report of external clock failure (if external clock is enabled) 
**         and report of calibration failure. These information will be 
**         stored to an array. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t diagData - Pointer to array of uint16_t elements that 
**                           will be filled with the diagnosis information. 
**                           The size of the array must match the length 
**                           of the daisy chain configured in component. 
**                           In case there is only single device, the size 
**                           is 1. Each element of the array will contain 
**                           a combination of these values: 
**                           ES_DIAG_CH1_DC_MOTOR - load is configured as 
**                           a DC motor type, if not present it's bulb type 
**                           ES_DIAG_CH0_DC_MOTOR - load is configured as 
**                           a DC motor type, if not present it's bulb type 
**                           ES_DIAG_PRODUCT_ID_BIT1 -  product identification 
**                           higher bit 
**                           ES_DIAG_PRODUCT_ID_BIT0 -  product identification 
**                           lower bit 
**                           ES_DIAG_IN1_ON - current logic state of the 
**                           direct input IN1 
**                           ES_DIAG_IN0_ON - current logic state of the 
**                           direct input IN0 
**                           ES_DIAG_CLOCKFAIL - external clock error occurred 
**                           ES_DIAG_CALIBFAIL - calibration failure occurred 
**                           during calibration of channel's internal clock 
**                           period 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_Diagnosis(uint16_t *diagData);

/*
** ===================================================================
**     Method      :  XSD1_ConfigureMonitoring (component 36VeXtremeSwitch)
**     @brief
**         Sets current/temperature monitoring option of CSNS pin. If several 
**         eSwitch devices share the same CSNS pin and MCU ADC input pin, 
**         please make sure no more than 1 channel monitor is enabled at 
**         one time. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         uint16_t selection - Pointer to array containing the monitoring 
**                           settings. The size of the array must match 
**                           the length of the daisy chain configured in 
**                           component. In case there is only single device, 
**                           the size is 1. Each item of the array contains 
**                           one of the following values: 
**                           ES_SENSE_DISABLE - sensing disabled 
**                           ES_CURRENTSENSE0  - current sensing for channel 
**                           0 (will not apply if highest overcurrent range 
**                           is not selected and the device works in Parallel 
**                           mode) 
**                           ES_CURRENTSENSE1  - current sensing for channel 
**                           1 
**                           ES_TEMPERATURESENSE - temperature sensing 
**                           ES_CURRENTSENSE_SUM - current sensing for summed 
**                           channels (this option will apply only if highest 
**                           overcurrent range is not selected and the device 
**                           works in Parallel mode) 
**         @return
**         result          - Returns ES_ERR_OK if operation was successful. 
** ===================================================================
*/
XSD1_result XSD1_ConfigureMonitoring(uint16_t *selection);

/* END XSD1. */

#endif
/* ifndef __XSD1_H */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
