; Based on CPU DB MC9S08LL16_64, version 3.00.000 (RegistersPrg V2.23)

; ###################################################################
;     Filename  : mc9s08ll16.inc
;     Processor : MC9S08LL16CLH
;     FileFormat: V2.23
;     DataSheet : MC9S08LL16RM Rev. 1 Draft G 8/2007
;     Compiler  : CodeWarrior compiler
;     Date/Time : 27.3.2008, 14:43
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     (c) Copyright UNIS, spol. s r.o. 1997-2008
;     UNIS, spol. s r.o.
;     Jundrovska 33
;     624 00 Brno
;     Czech Republic
;     http      : www.processorexpert.com
;     mail      : info@processorexpert.com
;
;     CPU Registers Revisions:
;               - none
;
;     File-Format-Revisions:
;      - 19.07.2007, V2.18 :
;               - Improved number of blanked lines inside register structures
;      - 06.08.2007, V2.19 :
;               - CPUDB revisions generated ahead of the file-format revisions.
;      - 11.09.2007, V2.20 :
;               - Added comment about initialization of unbonded pins.
;      - 02.01.2008, V2.21 :
;               -  Changes have not affected this file (because they are related to another family)
;      - 13.02.2008, V2.22 :
;               -  Changes have not affected this file (because they are related to another family)
;      - 20.02.2008, V2.23 :
;               -  Changes have not affected this file (because they are related to another family)
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
ROMStart:           equ   $0000C000
ROMEnd:             equ   $0000FFAD
Z_RAMStart:         equ   $00000060
Z_RAMEnd:           equ   $000000FF
RAMStart:           equ   $00000100
RAMEnd:             equ   $0000087F
ROM1Start:          equ   $0000FFC0
ROM1End:            equ   $0000FFD7
;
Vtod:               equ   $0000FFD8
Vacmp:              equ   $0000FFDA
Vadc:               equ   $0000FFDC
Vkeyboard:          equ   $0000FFDE
Viic:               equ   $0000FFE0
Vscitx:             equ   $0000FFE2
Vscirx:             equ   $0000FFE4
Vscierr:            equ   $0000FFE6
Vspi:               equ   $0000FFE8
Vlcd:               equ   $0000FFEA
Vtpm2ovf:           equ   $0000FFEC
Vtpm2ch1:           equ   $0000FFEE
Vtpm2ch0:           equ   $0000FFF0
Vtpm1ovf:           equ   $0000FFF2
Vtpm1ch1:           equ   $0000FFF4
Vtpm1ch0:           equ   $0000FFF6
Vlvd:               equ   $0000FFF8
Virq:               equ   $0000FFFA
Vswi:               equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PTAD - Port A Data Register; 0x00000000 ***
PTAD:               equ    $00000000                                ;*** PTAD - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port A Data Register Bit 0
PTAD_PTAD1:         equ    1                                         ; Port A Data Register Bit 1
PTAD_PTAD2:         equ    2                                         ; Port A Data Register Bit 2
PTAD_PTAD3:         equ    3                                         ; Port A Data Register Bit 3
PTAD_PTAD4:         equ    4                                         ; Port A Data Register Bit 4
PTAD_PTAD5:         equ    5                                         ; Port A Data Register Bit 5
PTAD_PTAD6:         equ    6                                         ; Port A Data Register Bit 6
PTAD_PTAD7:         equ    7                                         ; Port A Data Register Bit 7
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000
mPTAD_PTAD6:        equ    %01000000
mPTAD_PTAD7:        equ    %10000000


;*** PTADD - Port A Data Direction Register; 0x00000001 ***
PTADD:              equ    $00000001                                ;*** PTADD - Port A Data Direction Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADD_PTADD0:       equ    0                                         ; Data Direction for Port A Bit 0
PTADD_PTADD1:       equ    1                                         ; Data Direction for Port A Bit 1
PTADD_PTADD2:       equ    2                                         ; Data Direction for Port A Bit 2
PTADD_PTADD3:       equ    3                                         ; Data Direction for Port A Bit 3
PTADD_PTADD4:       equ    4                                         ; Data Direction for Port A Bit 4
PTADD_PTADD5:       equ    5                                         ; Data Direction for Port A Bit 5
PTADD_PTADD6:       equ    6                                         ; Data Direction for Port A Bit 6
PTADD_PTADD7:       equ    7                                         ; Data Direction for Port A Bit 7
; bit position masks
mPTADD_PTADD0:      equ    %00000001
mPTADD_PTADD1:      equ    %00000010
mPTADD_PTADD2:      equ    %00000100
mPTADD_PTADD3:      equ    %00001000
mPTADD_PTADD4:      equ    %00010000
mPTADD_PTADD5:      equ    %00100000
mPTADD_PTADD6:      equ    %01000000
mPTADD_PTADD7:      equ    %10000000


;*** PTBD - Port B Data Register; 0x00000002 ***
PTBD:               equ    $00000002                                ;*** PTBD - Port B Data Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBD_PTBD0:         equ    0                                         ; Port B Data Register Bit 0
PTBD_PTBD1:         equ    1                                         ; Port B Data Register Bit 1
PTBD_PTBD2:         equ    2                                         ; Port B Data Register Bit 2
PTBD_PTBD3:         equ    3                                         ; Port B Data Register Bit 3
PTBD_PTBD4:         equ    4                                         ; Port B Data Register Bit 4
PTBD_PTBD5:         equ    5                                         ; Port B Data Register Bit 5
PTBD_PTBD6:         equ    6                                         ; Port B Data Register Bit 6
PTBD_PTBD7:         equ    7                                         ; Port B Data Register Bit 7
; bit position masks
mPTBD_PTBD0:        equ    %00000001
mPTBD_PTBD1:        equ    %00000010
mPTBD_PTBD2:        equ    %00000100
mPTBD_PTBD3:        equ    %00001000
mPTBD_PTBD4:        equ    %00010000
mPTBD_PTBD5:        equ    %00100000
mPTBD_PTBD6:        equ    %01000000
mPTBD_PTBD7:        equ    %10000000


;*** PTBDD - Port B Data Direction Register; 0x00000003 ***
PTBDD:              equ    $00000003                                ;*** PTBDD - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDD_PTBDD0:       equ    0                                         ; Data Direction for Port B Bit 0
PTBDD_PTBDD1:       equ    1                                         ; Data Direction for Port B Bit 1
PTBDD_PTBDD2:       equ    2                                         ; Data Direction for Port B Bit 2
PTBDD_PTBDD3:       equ    3                                         ; Data Direction for Port B Bit 3
PTBDD_PTBDD4:       equ    4                                         ; Data Direction for Port B Bit 4
PTBDD_PTBDD5:       equ    5                                         ; Data Direction for Port B Bit 5
PTBDD_PTBDD6:       equ    6                                         ; Data Direction for Port B Bit 6
PTBDD_PTBDD7:       equ    7                                         ; Data Direction for Port B Bit 7
; bit position masks
mPTBDD_PTBDD0:      equ    %00000001
mPTBDD_PTBDD1:      equ    %00000010
mPTBDD_PTBDD2:      equ    %00000100
mPTBDD_PTBDD3:      equ    %00001000
mPTBDD_PTBDD4:      equ    %00010000
mPTBDD_PTBDD5:      equ    %00100000
mPTBDD_PTBDD6:      equ    %01000000
mPTBDD_PTBDD7:      equ    %10000000


;*** PTCD - Port C Data Register; 0x00000004 ***
PTCD:               equ    $00000004                                ;*** PTCD - Port C Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCD_PTCD0:         equ    0                                         ; Port C Data Register Bit 0
PTCD_PTCD1:         equ    1                                         ; Port C Data Register Bit 1
PTCD_PTCD2:         equ    2                                         ; Port C Data Register Bit 2
PTCD_PTCD3:         equ    3                                         ; Port C Data Register Bit 3
PTCD_PTCD4:         equ    4                                         ; Port C Data Register Bit 4
PTCD_PTCD5:         equ    5                                         ; Port C Data Register Bit 5
PTCD_PTCD6:         equ    6                                         ; Port C Data Register Bit 6
PTCD_PTCD7:         equ    7                                         ; Port C Data Register Bit 7
; bit position masks
mPTCD_PTCD0:        equ    %00000001
mPTCD_PTCD1:        equ    %00000010
mPTCD_PTCD2:        equ    %00000100
mPTCD_PTCD3:        equ    %00001000
mPTCD_PTCD4:        equ    %00010000
mPTCD_PTCD5:        equ    %00100000
mPTCD_PTCD6:        equ    %01000000
mPTCD_PTCD7:        equ    %10000000


;*** PTCDD - Port C Data Direction Register; 0x00000005 ***
PTCDD:              equ    $00000005                                ;*** PTCDD - Port C Data Direction Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCDD_PTCDD0:       equ    0                                         ; Data Direction for Port C Bit 0
PTCDD_PTCDD1:       equ    1                                         ; Data Direction for Port C Bit 1
PTCDD_PTCDD2:       equ    2                                         ; Data Direction for Port C Bit 2
PTCDD_PTCDD3:       equ    3                                         ; Data Direction for Port C Bit 3
PTCDD_PTCDD4:       equ    4                                         ; Data Direction for Port C Bit 4
PTCDD_PTCDD5:       equ    5                                         ; Data Direction for Port C Bit 5
PTCDD_PTCDD6:       equ    6                                         ; Data Direction for Port C Bit 6
PTCDD_PTCDD7:       equ    7                                         ; Data Direction for Port C Bit 7
; bit position masks
mPTCDD_PTCDD0:      equ    %00000001
mPTCDD_PTCDD1:      equ    %00000010
mPTCDD_PTCDD2:      equ    %00000100
mPTCDD_PTCDD3:      equ    %00001000
mPTCDD_PTCDD4:      equ    %00010000
mPTCDD_PTCDD5:      equ    %00100000
mPTCDD_PTCDD6:      equ    %01000000
mPTCDD_PTCDD7:      equ    %10000000


;*** PTDD - Port D Data Register; 0x00000006 ***
PTDD:               equ    $00000006                                ;*** PTDD - Port D Data Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDD_PTDD0:         equ    0                                         ; Port D Data Register Bit 0
PTDD_PTDD1:         equ    1                                         ; Port D Data Register Bit 1
PTDD_PTDD2:         equ    2                                         ; Port D Data Register Bit 2
PTDD_PTDD3:         equ    3                                         ; Port D Data Register Bit 3
PTDD_PTDD4:         equ    4                                         ; Port D Data Register Bit 4
PTDD_PTDD5:         equ    5                                         ; Port D Data Register Bit 5
PTDD_PTDD6:         equ    6                                         ; Port D Data Register Bit 6
PTDD_PTDD7:         equ    7                                         ; Port D Data Register Bit 7
; bit position masks
mPTDD_PTDD0:        equ    %00000001
mPTDD_PTDD1:        equ    %00000010
mPTDD_PTDD2:        equ    %00000100
mPTDD_PTDD3:        equ    %00001000
mPTDD_PTDD4:        equ    %00010000
mPTDD_PTDD5:        equ    %00100000
mPTDD_PTDD6:        equ    %01000000
mPTDD_PTDD7:        equ    %10000000


;*** PTDDD - Port D Data Direction Register; 0x00000007 ***
PTDDD:              equ    $00000007                                ;*** PTDDD - Port D Data Direction Register; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDDD_PTDDD0:       equ    0                                         ; Data Direction for Port D Bit 0
PTDDD_PTDDD1:       equ    1                                         ; Data Direction for Port D Bit 1
PTDDD_PTDDD2:       equ    2                                         ; Data Direction for Port D Bit 2
PTDDD_PTDDD3:       equ    3                                         ; Data Direction for Port D Bit 3
PTDDD_PTDDD4:       equ    4                                         ; Data Direction for Port D Bit 4
PTDDD_PTDDD5:       equ    5                                         ; Data Direction for Port D Bit 5
PTDDD_PTDDD6:       equ    6                                         ; Data Direction for Port D Bit 6
PTDDD_PTDDD7:       equ    7                                         ; Data Direction for Port D Bit 7
; bit position masks
mPTDDD_PTDDD0:      equ    %00000001
mPTDDD_PTDDD1:      equ    %00000010
mPTDDD_PTDDD2:      equ    %00000100
mPTDDD_PTDDD3:      equ    %00001000
mPTDDD_PTDDD4:      equ    %00010000
mPTDDD_PTDDD5:      equ    %00100000
mPTDDD_PTDDD6:      equ    %01000000
mPTDDD_PTDDD7:      equ    %10000000


;*** PTED - Port E Data Register; 0x00000008 ***
PTED:               equ    $00000008                                ;*** PTED - Port E Data Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTED_PTED0:         equ    0                                         ; Port E Data Register Bit 0
PTED_PTED1:         equ    1                                         ; Port E Data Register Bit 1
PTED_PTED2:         equ    2                                         ; Port E Data Register Bit 2
PTED_PTED3:         equ    3                                         ; Port E Data Register Bit 3
PTED_PTED4:         equ    4                                         ; Port E Data Register Bit 4
PTED_PTED5:         equ    5                                         ; Port E Data Register Bit 5
PTED_PTED6:         equ    6                                         ; Port E Data Register Bit 6
PTED_PTED7:         equ    7                                         ; Port E Data Register Bit 7
; bit position masks
mPTED_PTED0:        equ    %00000001
mPTED_PTED1:        equ    %00000010
mPTED_PTED2:        equ    %00000100
mPTED_PTED3:        equ    %00001000
mPTED_PTED4:        equ    %00010000
mPTED_PTED5:        equ    %00100000
mPTED_PTED6:        equ    %01000000
mPTED_PTED7:        equ    %10000000


;*** PTEDD - Port E Data Direction Register; 0x00000009 ***
PTEDD:              equ    $00000009                                ;*** PTEDD - Port E Data Direction Register; 0x00000009 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTEDD_PTEDD0:       equ    0                                         ; Data Direction for Port E Bit 0
PTEDD_PTEDD1:       equ    1                                         ; Data Direction for Port E Bit 1
PTEDD_PTEDD2:       equ    2                                         ; Data Direction for Port E Bit 2
PTEDD_PTEDD3:       equ    3                                         ; Data Direction for Port E Bit 3
PTEDD_PTEDD4:       equ    4                                         ; Data Direction for Port E Bit 4
PTEDD_PTEDD5:       equ    5                                         ; Data Direction for Port E Bit 5
PTEDD_PTEDD6:       equ    6                                         ; Data Direction for Port E Bit 6
PTEDD_PTEDD7:       equ    7                                         ; Data Direction for Port E Bit 7
; bit position masks
mPTEDD_PTEDD0:      equ    %00000001
mPTEDD_PTEDD1:      equ    %00000010
mPTEDD_PTEDD2:      equ    %00000100
mPTEDD_PTEDD3:      equ    %00001000
mPTEDD_PTEDD4:      equ    %00010000
mPTEDD_PTEDD5:      equ    %00100000
mPTEDD_PTEDD6:      equ    %01000000
mPTEDD_PTEDD7:      equ    %10000000


;*** KBISC - KBI Status and Control Register; 0x0000000C ***
KBISC:              equ    $0000000C                                ;*** KBISC - KBI Status and Control Register; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBISC_KBIMOD:       equ    0                                         ; Keyboard Detection Mode
KBISC_KBIE:         equ    1                                         ; Keyboard Interrupt Enable
KBISC_KBACK:        equ    2                                         ; Keyboard Interrupt Acknowledge
KBISC_KBF:          equ    3                                         ; Keyboard Interrupt Flag
; bit position masks
mKBISC_KBIMOD:      equ    %00000001
mKBISC_KBIE:        equ    %00000010
mKBISC_KBACK:       equ    %00000100
mKBISC_KBF:         equ    %00001000


;*** KBIPE - KBI Pin Enable Register; 0x0000000D ***
KBIPE:              equ    $0000000D                                ;*** KBIPE - KBI Pin Enable Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIPE_KBIPE0:       equ    0                                         ; Keyboard Pin Enable for KBI Port Bit 0
KBIPE_KBIPE1:       equ    1                                         ; Keyboard Pin Enable for KBI Port Bit 1
KBIPE_KBIPE2:       equ    2                                         ; Keyboard Pin Enable for KBI Port Bit 2
KBIPE_KBIPE3:       equ    3                                         ; Keyboard Pin Enable for KBI Port Bit 3
KBIPE_KBIPE4:       equ    4                                         ; Keyboard Pin Enable for KBI Port Bit 4
KBIPE_KBIPE5:       equ    5                                         ; Keyboard Pin Enable for KBI Port Bit 5
KBIPE_KBIPE6:       equ    6                                         ; Keyboard Pin Enable for KBI Port Bit 6
KBIPE_KBIPE7:       equ    7                                         ; Keyboard Pin Enable for KBI Port Bit 7
; bit position masks
mKBIPE_KBIPE0:      equ    %00000001
mKBIPE_KBIPE1:      equ    %00000010
mKBIPE_KBIPE2:      equ    %00000100
mKBIPE_KBIPE3:      equ    %00001000
mKBIPE_KBIPE4:      equ    %00010000
mKBIPE_KBIPE5:      equ    %00100000
mKBIPE_KBIPE6:      equ    %01000000
mKBIPE_KBIPE7:      equ    %10000000


;*** KBIES - KBI Edge Select Register; 0x0000000E ***
KBIES:              equ    $0000000E                                ;*** KBIES - KBI Edge Select Register; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIES_KBEDG0:       equ    0                                         ; Keyboard Edge Select Bit 0
KBIES_KBEDG1:       equ    1                                         ; Keyboard Edge Select Bit 1
KBIES_KBEDG2:       equ    2                                         ; Keyboard Edge Select Bit 2
KBIES_KBEDG3:       equ    3                                         ; Keyboard Edge Select Bit 3
KBIES_KBEDG4:       equ    4                                         ; Keyboard Edge Select Bit 4
KBIES_KBEDG5:       equ    5                                         ; Keyboard Edge Select Bit 5
KBIES_KBEDG6:       equ    6                                         ; Keyboard Edge Select Bit 6
KBIES_KBEDG7:       equ    7                                         ; Keyboard Edge Select Bit 7
; bit position masks
mKBIES_KBEDG0:      equ    %00000001
mKBIES_KBEDG1:      equ    %00000010
mKBIES_KBEDG2:      equ    %00000100
mKBIES_KBEDG3:      equ    %00001000
mKBIES_KBEDG4:      equ    %00010000
mKBIES_KBEDG5:      equ    %00100000
mKBIES_KBEDG6:      equ    %01000000
mKBIES_KBEDG7:      equ    %10000000


;*** IRQSC - Interrupt request status and control register; 0x0000000F ***
IRQSC:              equ    $0000000F                                ;*** IRQSC - Interrupt request status and control register; 0x0000000F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQSC_IRQMOD:       equ    0                                         ; IRQ Detection Mode
IRQSC_IRQIE:        equ    1                                         ; IRQ Interrupt Enable
IRQSC_IRQACK:       equ    2                                         ; IRQ Acknowledge
IRQSC_IRQF:         equ    3                                         ; IRQ Flag
IRQSC_IRQPE:        equ    4                                         ; IRQ Pin Enable
IRQSC_IRQEDG:       equ    5                                         ; IRQ Edge Select
IRQSC_IRQPDD:       equ    6                                         ; IRQ Pull Device Disable
; bit position masks
mIRQSC_IRQMOD:      equ    %00000001
mIRQSC_IRQIE:       equ    %00000010
mIRQSC_IRQACK:      equ    %00000100
mIRQSC_IRQF:        equ    %00001000
mIRQSC_IRQPE:       equ    %00010000
mIRQSC_IRQEDG:      equ    %00100000
mIRQSC_IRQPDD:      equ    %01000000


;*** ADCSC1 - Status and Control Register 1; 0x00000010 ***
ADCSC1:             equ    $00000010                                ;*** ADCSC1 - Status and Control Register 1; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCSC1_ADCH0:       equ    0                                         ; Input Channel Select Bit 0
ADCSC1_ADCH1:       equ    1                                         ; Input Channel Select Bit 1
ADCSC1_ADCH2:       equ    2                                         ; Input Channel Select Bit 2
ADCSC1_ADCH3:       equ    3                                         ; Input Channel Select Bit 3
ADCSC1_ADCH4:       equ    4                                         ; Input Channel Select Bit 4
ADCSC1_ADCO:        equ    5                                         ; Continuous Conversion Enable - ADCO is used to enable continuous conversions
ADCSC1_AIEN:        equ    6                                         ; Interrupt Enable - AIEN is used to enable conversion complete interrupts. When COCO becomes set while AIEN is high, an interrupt is asserted
ADCSC1_COCO:        equ    7                                         ; Conversion Complete Flag
; bit position masks
mADCSC1_ADCH0:      equ    %00000001
mADCSC1_ADCH1:      equ    %00000010
mADCSC1_ADCH2:      equ    %00000100
mADCSC1_ADCH3:      equ    %00001000
mADCSC1_ADCH4:      equ    %00010000
mADCSC1_ADCO:       equ    %00100000
mADCSC1_AIEN:       equ    %01000000
mADCSC1_COCO:       equ    %10000000


;*** ADCSC2 - Status and Control Register 2; 0x00000011 ***
ADCSC2:             equ    $00000011                                ;*** ADCSC2 - Status and Control Register 2; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCSC2_ACFGT:       equ    4                                         ; Compare Function Greater Than Enable
ADCSC2_ACFE:        equ    5                                         ; Compare Function Enable - ACFE is used to enable the compare function
ADCSC2_ADTRG:       equ    6                                         ; Conversion Trigger Select-ADTRG is used to select the type of trigger to be used for initiating a conversion
ADCSC2_ADACT:       equ    7                                         ; Conversion Active - ADACT indicates that a conversion is in progress. ADACT is set when a conversion is initiated and cleared when a conversion is completed or aborted
; bit position masks
mADCSC2_ACFGT:      equ    %00010000
mADCSC2_ACFE:       equ    %00100000
mADCSC2_ADTRG:      equ    %01000000
mADCSC2_ADACT:      equ    %10000000


;*** ADCR - Data Result Register; 0x00000012 ***
ADCR:               equ    $00000012                                ;*** ADCR - Data Result Register; 0x00000012 ***


;*** ADCRH - Data Result High Register; 0x00000012 ***
ADCRH:              equ    $00000012                                ;*** ADCRH - Data Result High Register; 0x00000012 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCRH_ADR8:         equ    0                                         ; ADC Result Data Bit 8
ADCRH_ADR9:         equ    1                                         ; ADC Result Data Bit 9
ADCRH_ADR10:        equ    2                                         ; ADC Result Data Bit 10
ADCRH_ADR11:        equ    3                                         ; ADC Result Data Bit 11
; bit position masks
mADCRH_ADR8:        equ    %00000001
mADCRH_ADR9:        equ    %00000010
mADCRH_ADR10:       equ    %00000100
mADCRH_ADR11:       equ    %00001000


;*** ADCRL - Data Result Low Register; 0x00000013 ***
ADCRL:              equ    $00000013                                ;*** ADCRL - Data Result Low Register; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCRL_ADR0:         equ    0                                         ; ADC Result Data Bit 0
ADCRL_ADR1:         equ    1                                         ; ADC Result Data Bit 1
ADCRL_ADR2:         equ    2                                         ; ADC Result Data Bit 2
ADCRL_ADR3:         equ    3                                         ; ADC Result Data Bit 3
ADCRL_ADR4:         equ    4                                         ; ADC Result Data Bit 4
ADCRL_ADR5:         equ    5                                         ; ADC Result Data Bit 5
ADCRL_ADR6:         equ    6                                         ; ADC Result Data Bit 6
ADCRL_ADR7:         equ    7                                         ; ADC Result Data Bit 7
; bit position masks
mADCRL_ADR0:        equ    %00000001
mADCRL_ADR1:        equ    %00000010
mADCRL_ADR2:        equ    %00000100
mADCRL_ADR3:        equ    %00001000
mADCRL_ADR4:        equ    %00010000
mADCRL_ADR5:        equ    %00100000
mADCRL_ADR6:        equ    %01000000
mADCRL_ADR7:        equ    %10000000


;*** ADCCV - Compare Value Register; 0x00000014 ***
ADCCV:              equ    $00000014                                ;*** ADCCV - Compare Value Register; 0x00000014 ***


;*** ADCCVH - Compare Value High Register; 0x00000014 ***
ADCCVH:             equ    $00000014                                ;*** ADCCVH - Compare Value High Register; 0x00000014 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCVH_ADCV8:       equ    0                                         ; Compare Function Value 8
ADCCVH_ADCV9:       equ    1                                         ; Compare Function Value 9
ADCCVH_ADCV10:      equ    2                                         ; Compare Function Value 10
ADCCVH_ADCV11:      equ    3                                         ; Compare Function Value 11
; bit position masks
mADCCVH_ADCV8:      equ    %00000001
mADCCVH_ADCV9:      equ    %00000010
mADCCVH_ADCV10:     equ    %00000100
mADCCVH_ADCV11:     equ    %00001000


;*** ADCCVL - Compare Value Low Register; 0x00000015 ***
ADCCVL:             equ    $00000015                                ;*** ADCCVL - Compare Value Low Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCVL_ADCV0:       equ    0                                         ; Compare Function Value 0
ADCCVL_ADCV1:       equ    1                                         ; Compare Function Value 1
ADCCVL_ADCV2:       equ    2                                         ; Compare Function Value 2
ADCCVL_ADCV3:       equ    3                                         ; Compare Function Value 3
ADCCVL_ADCV4:       equ    4                                         ; Compare Function Value 4
ADCCVL_ADCV5:       equ    5                                         ; Compare Function Value 5
ADCCVL_ADCV6:       equ    6                                         ; Compare Function Value 6
ADCCVL_ADCV7:       equ    7                                         ; Compare Function Value 7
; bit position masks
mADCCVL_ADCV0:      equ    %00000001
mADCCVL_ADCV1:      equ    %00000010
mADCCVL_ADCV2:      equ    %00000100
mADCCVL_ADCV3:      equ    %00001000
mADCCVL_ADCV4:      equ    %00010000
mADCCVL_ADCV5:      equ    %00100000
mADCCVL_ADCV6:      equ    %01000000
mADCCVL_ADCV7:      equ    %10000000


;*** ADCCFG - Configuration Register; 0x00000016 ***
ADCCFG:             equ    $00000016                                ;*** ADCCFG - Configuration Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCFG_ADICLK0:     equ    0                                         ; Input Clock Select Bit 0
ADCCFG_ADICLK1:     equ    1                                         ; Input Clock Select Bit 1
ADCCFG_MODE0:       equ    2                                         ; Conversion Mode Selection Bit 0
ADCCFG_MODE1:       equ    3                                         ; Conversion Mode Selection Bit 1
ADCCFG_ADLSMP:      equ    4                                         ; Long Sample Time Configuration
ADCCFG_ADIV0:       equ    5                                         ; Clock Divide Select Bit 0
ADCCFG_ADIV1:       equ    6                                         ; Clock Divide Select Bit 1
ADCCFG_ADLPC:       equ    7                                         ; Low Power Configuration
; bit position masks
mADCCFG_ADICLK0:    equ    %00000001
mADCCFG_ADICLK1:    equ    %00000010
mADCCFG_MODE0:      equ    %00000100
mADCCFG_MODE1:      equ    %00001000
mADCCFG_ADLSMP:     equ    %00010000
mADCCFG_ADIV0:      equ    %00100000
mADCCFG_ADIV1:      equ    %01000000
mADCCFG_ADLPC:      equ    %10000000


;*** APCTL1 - Pin Control 1 Register; 0x00000017 ***
APCTL1:             equ    $00000017                                ;*** APCTL1 - Pin Control 1 Register; 0x00000017 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
APCTL1_ADPC0:       equ    0                                         ; ADC Pin Control 0 - ADPC0 is used to control the pin associated with channel AD0
APCTL1_ADPC1:       equ    1                                         ; ADC Pin Control 1 - ADPC1 is used to control the pin associated with channel AD1
APCTL1_ADPC2:       equ    2                                         ; ADC Pin Control 2 - ADPC2 is used to control the pin associated with channel AD2
APCTL1_ADPC3:       equ    3                                         ; ADC Pin Control 3 - ADPC3 is used to control the pin associated with channel AD3
APCTL1_ADPC4:       equ    4                                         ; ADC Pin Control 4 - ADPC4 is used to control the pin associated with channel AD4
APCTL1_ADPC5:       equ    5                                         ; ADC Pin Control 5 - ADPC5 is used to control the pin associated with channel AD5
APCTL1_ADPC6:       equ    6                                         ; ADC Pin Control 6 - ADPC6 is used to control the pin associated with channel AD6
APCTL1_ADPC7:       equ    7                                         ; ADC Pin Control 7 - ADPC7 is used to control the pin associated with channel AD7
; bit position masks
mAPCTL1_ADPC0:      equ    %00000001
mAPCTL1_ADPC1:      equ    %00000010
mAPCTL1_ADPC2:      equ    %00000100
mAPCTL1_ADPC3:      equ    %00001000
mAPCTL1_ADPC4:      equ    %00010000
mAPCTL1_ADPC5:      equ    %00100000
mAPCTL1_ADPC6:      equ    %01000000
mAPCTL1_ADPC7:      equ    %10000000


;*** LCDC0 - LCD Control Register 0; 0x00000018 ***
LCDC0:              equ    $00000018                                ;*** LCDC0 - LCD Control Register 0; 0x00000018 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDC0_DUTY0:        equ    0                                         ; LCD Duty Select Bit 0
LCDC0_DUTY1:        equ    1                                         ; LCD Duty Select Bit 1
LCDC0_DUTY2:        equ    2                                         ; LCD Duty Select Bit 2
LCDC0_LCLK0:        equ    3                                         ; LCD Clock Prescaler Bit 0
LCDC0_LCLK1:        equ    4                                         ; LCD Clock Prescaler Bit 1
LCDC0_LCLK2:        equ    5                                         ; LCD Clock Prescaler Bit 2
LCDC0_SOURCE:       equ    6                                         ; LCD Clock Source Select
LCDC0_LCDEN:        equ    7                                         ; LCD Driver Enable
; bit position masks
mLCDC0_DUTY0:       equ    %00000001
mLCDC0_DUTY1:       equ    %00000010
mLCDC0_DUTY2:       equ    %00000100
mLCDC0_LCLK0:       equ    %00001000
mLCDC0_LCLK1:       equ    %00010000
mLCDC0_LCLK2:       equ    %00100000
mLCDC0_SOURCE:      equ    %01000000
mLCDC0_LCDEN:       equ    %10000000


;*** LCDC1 - LCD Control Register 1; 0x00000019 ***
LCDC1:              equ    $00000019                                ;*** LCDC1 - LCD Control Register 1; 0x00000019 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDC1_LCDSTP:       equ    0                                         ; LCD Module Driver and Charge Pump Stop While in Stop2 or Stop3 Mode
LCDC1_LCDWAI:       equ    1                                         ; LCD Module Driver and Charge Pump Stop While in Wait Mode
LCDC1_FCDEN:        equ    2                                         ; Full Complementary Drive Enable
LCDC1_LCDIEN:       equ    7                                         ; LCD Module Frame Frequency Interrupt Enable
; bit position masks
mLCDC1_LCDSTP:      equ    %00000001
mLCDC1_LCDWAI:      equ    %00000010
mLCDC1_FCDEN:       equ    %00000100
mLCDC1_LCDIEN:      equ    %10000000


;*** LCDSUPPLY - LCD Voltage Supply Register; 0x0000001A ***
LCDSUPPLY:          equ    $0000001A                                ;*** LCDSUPPLY - LCD Voltage Supply Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDSUPPLY_VSUPPLY0: equ    0                                         ; Voltage Supply Control Bit 0
LCDSUPPLY_VSUPPLY1: equ    1                                         ; Voltage Supply Control Bit 1
LCDSUPPLY_BBYPASS:  equ    2                                         ; Op Amp Control
LCDSUPPLY_LADJ0:    equ    4                                         ; LCD Module Load Adjust Bit 0
LCDSUPPLY_LADJ1:    equ    5                                         ; LCD Module Load Adjust Bit 1
LCDSUPPLY_HREFSEL:  equ    6                                         ; High Reference Select
LCDSUPPLY_CPSEL:    equ    7                                         ; Charge Pump or Resistor Bias Select
; bit position masks
mLCDSUPPLY_VSUPPLY0: equ    %00000001
mLCDSUPPLY_VSUPPLY1: equ    %00000010
mLCDSUPPLY_BBYPASS: equ    %00000100
mLCDSUPPLY_LADJ0:   equ    %00010000
mLCDSUPPLY_LADJ1:   equ    %00100000
mLCDSUPPLY_HREFSEL: equ    %01000000
mLCDSUPPLY_CPSEL:   equ    %10000000


;*** LCDRVC - LCD Regulated Voltage Control Register; 0x0000001B ***
LCDRVC:             equ    $0000001B                                ;*** LCDRVC - LCD Regulated Voltage Control Register; 0x0000001B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDRVC_RVTRIM0:     equ    0                                         ; Regulated Voltage Trim Bit 0
LCDRVC_RVTRIM1:     equ    1                                         ; Regulated Voltage Trim Bit 1
LCDRVC_RVTRIM2:     equ    2                                         ; Regulated Voltage Trim Bit 2
LCDRVC_RVTRIM3:     equ    3                                         ; Regulated Voltage Trim Bit 3
LCDRVC_RVEN:        equ    7                                         ; Regulated Voltage Enable
; bit position masks
mLCDRVC_RVTRIM0:    equ    %00000001
mLCDRVC_RVTRIM1:    equ    %00000010
mLCDRVC_RVTRIM2:    equ    %00000100
mLCDRVC_RVTRIM3:    equ    %00001000
mLCDRVC_RVEN:       equ    %10000000


;*** LCDBCTL - LCD Blink Control Register; 0x0000001C ***
LCDBCTL:            equ    $0000001C                                ;*** LCDBCTL - LCD Blink Control Register; 0x0000001C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDBCTL_BRATE0:     equ    0                                         ; Blink-Rate Configuration Bit 0
LCDBCTL_BRATE1:     equ    1                                         ; Blink-Rate Configuration Bit 1
LCDBCTL_BRATE2:     equ    2                                         ; Blink-Rate Configuration Bit 2
LCDBCTL_BMODE:      equ    3                                         ; Blink Mode
LCDBCTL_BLANK:      equ    5                                         ; Blank Display Mode
LCDBCTL_ALT:        equ    6                                         ; Alternate Display Mode
LCDBCTL_BLINK:      equ    7                                         ; Blink Command
; bit position masks
mLCDBCTL_BRATE0:    equ    %00000001
mLCDBCTL_BRATE1:    equ    %00000010
mLCDBCTL_BRATE2:    equ    %00000100
mLCDBCTL_BMODE:     equ    %00001000
mLCDBCTL_BLANK:     equ    %00100000
mLCDBCTL_ALT:       equ    %01000000
mLCDBCTL_BLINK:     equ    %10000000


;*** LCDS - LCD Status Register; 0x0000001D ***
LCDS:               equ    $0000001D                                ;*** LCDS - LCD Status Register; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDS_LCDIF:         equ    7                                         ; LCD Interrupt Flag
; bit position masks
mLCDS_LCDIF:        equ    %10000000


;*** ACMPSC - ACMP Status and Control Register; 0x0000001F ***
ACMPSC:             equ    $0000001F                                ;*** ACMPSC - ACMP Status and Control Register; 0x0000001F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ACMPSC_ACMOD0:      equ    0                                         ; Analog Comparator Mode Bit 0
ACMPSC_ACMOD1:      equ    1                                         ; Analog Comparator Mode Bit 1
ACMPSC_ACOPE:       equ    2                                         ; Analog Comparator Output Pin Enable
ACMPSC_ACO:         equ    3                                         ; Analog Comparator Output
ACMPSC_ACIE:        equ    4                                         ; Analog Comparator Interrupt Enable
ACMPSC_ACF:         equ    5                                         ; Analog Comparator Flag
ACMPSC_ACBGS:       equ    6                                         ; Analog Comparator Bandgap Select
ACMPSC_ACME:        equ    7                                         ; Analog Comparator Module Enable
; bit position masks
mACMPSC_ACMOD0:     equ    %00000001
mACMPSC_ACMOD1:     equ    %00000010
mACMPSC_ACOPE:      equ    %00000100
mACMPSC_ACO:        equ    %00001000
mACMPSC_ACIE:       equ    %00010000
mACMPSC_ACF:        equ    %00100000
mACMPSC_ACBGS:      equ    %01000000
mACMPSC_ACME:       equ    %10000000


;*** SCIBD - SCI Baud Rate Register; 0x00000020 ***
SCIBD:              equ    $00000020                                ;*** SCIBD - SCI Baud Rate Register; 0x00000020 ***


;*** SCIBDH - SCI Baud Rate Register High; 0x00000020 ***
SCIBDH:             equ    $00000020                                ;*** SCIBDH - SCI Baud Rate Register High; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDH_SBR8:        equ    0                                         ; Baud Rate Modulo Divisor Bit 8
SCIBDH_SBR9:        equ    1                                         ; Baud Rate Modulo Divisor Bit 9
SCIBDH_SBR10:       equ    2                                         ; Baud Rate Modulo Divisor Bit 10
SCIBDH_SBR11:       equ    3                                         ; Baud Rate Modulo Divisor Bit 11
SCIBDH_SBR12:       equ    4                                         ; Baud Rate Modulo Divisor Bit 12
SCIBDH_RXEDGIE:     equ    6                                         ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
SCIBDH_LBKDIE:      equ    7                                         ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mSCIBDH_SBR8:       equ    %00000001
mSCIBDH_SBR9:       equ    %00000010
mSCIBDH_SBR10:      equ    %00000100
mSCIBDH_SBR11:      equ    %00001000
mSCIBDH_SBR12:      equ    %00010000
mSCIBDH_RXEDGIE:    equ    %01000000
mSCIBDH_LBKDIE:     equ    %10000000


;*** SCIBDL - SCI Baud Rate Register Low; 0x00000021 ***
SCIBDL:             equ    $00000021                                ;*** SCIBDL - SCI Baud Rate Register Low; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDL_SBR0:        equ    0                                         ; Baud Rate Modulo Divisor Bit 0
SCIBDL_SBR1:        equ    1                                         ; Baud Rate Modulo Divisor Bit 1
SCIBDL_SBR2:        equ    2                                         ; Baud Rate Modulo Divisor Bit 2
SCIBDL_SBR3:        equ    3                                         ; Baud Rate Modulo Divisor Bit 3
SCIBDL_SBR4:        equ    4                                         ; Baud Rate Modulo Divisor Bit 4
SCIBDL_SBR5:        equ    5                                         ; Baud Rate Modulo Divisor Bit 5
SCIBDL_SBR6:        equ    6                                         ; Baud Rate Modulo Divisor Bit 6
SCIBDL_SBR7:        equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mSCIBDL_SBR0:       equ    %00000001
mSCIBDL_SBR1:       equ    %00000010
mSCIBDL_SBR2:       equ    %00000100
mSCIBDL_SBR3:       equ    %00001000
mSCIBDL_SBR4:       equ    %00010000
mSCIBDL_SBR5:       equ    %00100000
mSCIBDL_SBR6:       equ    %01000000
mSCIBDL_SBR7:       equ    %10000000


;*** SCIC1 - SCI Control Register 1; 0x00000022 ***
SCIC1:              equ    $00000022                                ;*** SCIC1 - SCI Control Register 1; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC1_PT:           equ    0                                         ; Parity Type
SCIC1_PE:           equ    1                                         ; Parity Enable
SCIC1_ILT:          equ    2                                         ; Idle Line Type Select
SCIC1_WAKE:         equ    3                                         ; Receiver Wakeup Method Select
SCIC1_M:            equ    4                                         ; 9-Bit or 8-Bit Mode Select
SCIC1_RSRC:         equ    5                                         ; Receiver Source Select
SCIC1_SCISWAI:      equ    6                                         ; SCI Stops in Wait Mode
SCIC1_LOOPS:        equ    7                                         ; Loop Mode Select
; bit position masks
mSCIC1_PT:          equ    %00000001
mSCIC1_PE:          equ    %00000010
mSCIC1_ILT:         equ    %00000100
mSCIC1_WAKE:        equ    %00001000
mSCIC1_M:           equ    %00010000
mSCIC1_RSRC:        equ    %00100000
mSCIC1_SCISWAI:     equ    %01000000
mSCIC1_LOOPS:       equ    %10000000


;*** SCIC2 - SCI Control Register 2; 0x00000023 ***
SCIC2:              equ    $00000023                                ;*** SCIC2 - SCI Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC2_SBK:          equ    0                                         ; Send Break
SCIC2_RWU:          equ    1                                         ; Receiver Wakeup Control
SCIC2_RE:           equ    2                                         ; Receiver Enable
SCIC2_TE:           equ    3                                         ; Transmitter Enable
SCIC2_ILIE:         equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
SCIC2_RIE:          equ    5                                         ; Receiver Interrupt Enable (for RDRF)
SCIC2_TCIE:         equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
SCIC2_TIE:          equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mSCIC2_SBK:         equ    %00000001
mSCIC2_RWU:         equ    %00000010
mSCIC2_RE:          equ    %00000100
mSCIC2_TE:          equ    %00001000
mSCIC2_ILIE:        equ    %00010000
mSCIC2_RIE:         equ    %00100000
mSCIC2_TCIE:        equ    %01000000
mSCIC2_TIE:         equ    %10000000


;*** SCIS1 - SCI Status Register 1; 0x00000024 ***
SCIS1:              equ    $00000024                                ;*** SCIS1 - SCI Status Register 1; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS1_PF:           equ    0                                         ; Parity Error Flag
SCIS1_FE:           equ    1                                         ; Framing Error Flag
SCIS1_NF:           equ    2                                         ; Noise Flag
SCIS1_OR:           equ    3                                         ; Receiver Overrun Flag
SCIS1_IDLE:         equ    4                                         ; Idle Line Flag
SCIS1_RDRF:         equ    5                                         ; Receive Data Register Full Flag
SCIS1_TC:           equ    6                                         ; Transmission Complete Flag
SCIS1_TDRE:         equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCIS1_PF:          equ    %00000001
mSCIS1_FE:          equ    %00000010
mSCIS1_NF:          equ    %00000100
mSCIS1_OR:          equ    %00001000
mSCIS1_IDLE:        equ    %00010000
mSCIS1_RDRF:        equ    %00100000
mSCIS1_TC:          equ    %01000000
mSCIS1_TDRE:        equ    %10000000


;*** SCIS2 - SCI Status Register 2; 0x00000025 ***
SCIS2:              equ    $00000025                                ;*** SCIS2 - SCI Status Register 2; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS2_RAF:          equ    0                                         ; Receiver Active Flag
SCIS2_LBKDE:        equ    1                                         ; LIN Break Detection Enable
SCIS2_BRK13:        equ    2                                         ; Break Character Generation Length
SCIS2_RWUID:        equ    3                                         ; Receive Wake Up Idle Detect
SCIS2_RXINV:        equ    4                                         ; Receive Data Inversion
SCIS2_RXEDGIF:      equ    6                                         ; RxD Pin Active Edge Interrupt Flag
SCIS2_LBKDIF:       equ    7                                         ; LIN Break Detect Interrupt Flag
; bit position masks
mSCIS2_RAF:         equ    %00000001
mSCIS2_LBKDE:       equ    %00000010
mSCIS2_BRK13:       equ    %00000100
mSCIS2_RWUID:       equ    %00001000
mSCIS2_RXINV:       equ    %00010000
mSCIS2_RXEDGIF:     equ    %01000000
mSCIS2_LBKDIF:      equ    %10000000


;*** SCIC3 - SCI Control Register 3; 0x00000026 ***
SCIC3:              equ    $00000026                                ;*** SCIC3 - SCI Control Register 3; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC3_PEIE:         equ    0                                         ; Parity Error Interrupt Enable
SCIC3_FEIE:         equ    1                                         ; Framing Error Interrupt Enable
SCIC3_NEIE:         equ    2                                         ; Noise Error Interrupt Enable
SCIC3_ORIE:         equ    3                                         ; Overrun Interrupt Enable
SCIC3_TXINV:        equ    4                                         ; Transmit Data Inversion
SCIC3_TXDIR:        equ    5                                         ; TxD Pin Direction in Single-Wire Mode
SCIC3_T8:           equ    6                                         ; Ninth Data Bit for Transmitter
SCIC3_R8:           equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mSCIC3_PEIE:        equ    %00000001
mSCIC3_FEIE:        equ    %00000010
mSCIC3_NEIE:        equ    %00000100
mSCIC3_ORIE:        equ    %00001000
mSCIC3_TXINV:       equ    %00010000
mSCIC3_TXDIR:       equ    %00100000
mSCIC3_T8:          equ    %01000000
mSCIC3_R8:          equ    %10000000


;*** SCID - SCI Data Register; 0x00000027 ***
SCID:               equ    $00000027                                ;*** SCID - SCI Data Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCID_R0_T0:         equ    0                                         ; Receive/Transmit Data Bit 0
SCID_R1_T1:         equ    1                                         ; Receive/Transmit Data Bit 1
SCID_R2_T2:         equ    2                                         ; Receive/Transmit Data Bit 2
SCID_R3_T3:         equ    3                                         ; Receive/Transmit Data Bit 3
SCID_R4_T4:         equ    4                                         ; Receive/Transmit Data Bit 4
SCID_R5_T5:         equ    5                                         ; Receive/Transmit Data Bit 5
SCID_R6_T6:         equ    6                                         ; Receive/Transmit Data Bit 6
SCID_R7_T7:         equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mSCID_R0_T0:        equ    %00000001
mSCID_R1_T1:        equ    %00000010
mSCID_R2_T2:        equ    %00000100
mSCID_R3_T3:        equ    %00001000
mSCID_R4_T4:        equ    %00010000
mSCID_R5_T5:        equ    %00100000
mSCID_R6_T6:        equ    %01000000
mSCID_R7_T7:        equ    %10000000


;*** SPIC1 - SPI Control Register 1; 0x00000028 ***
SPIC1:              equ    $00000028                                ;*** SPIC1 - SPI Control Register 1; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC1_LSBFE:        equ    0                                         ; LSB First (Shifter Direction)
SPIC1_SSOE:         equ    1                                         ; Slave Select Output Enable
SPIC1_CPHA:         equ    2                                         ; Clock Phase
SPIC1_CPOL:         equ    3                                         ; Clock Polarity
SPIC1_MSTR:         equ    4                                         ; Master/Slave Mode Select
SPIC1_SPTIE:        equ    5                                         ; SPI Transmit Interrupt Enable
SPIC1_SPE:          equ    6                                         ; SPI System Enable
SPIC1_SPIE:         equ    7                                         ; SPI Interrupt Enable (for SPRF and MODF)
; bit position masks
mSPIC1_LSBFE:       equ    %00000001
mSPIC1_SSOE:        equ    %00000010
mSPIC1_CPHA:        equ    %00000100
mSPIC1_CPOL:        equ    %00001000
mSPIC1_MSTR:        equ    %00010000
mSPIC1_SPTIE:       equ    %00100000
mSPIC1_SPE:         equ    %01000000
mSPIC1_SPIE:        equ    %10000000


;*** SPIC2 - SPI Control Register 2; 0x00000029 ***
SPIC2:              equ    $00000029                                ;*** SPIC2 - SPI Control Register 2; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC2_SPC0:         equ    0                                         ; SPI Pin Control 0
SPIC2_SPISWAI:      equ    1                                         ; SPI Stop in Wait Mode
SPIC2_BIDIROE:      equ    3                                         ; Bidirectional Mode Output Enable
SPIC2_MODFEN:       equ    4                                         ; Master Mode-Fault Function Enable
; bit position masks
mSPIC2_SPC0:        equ    %00000001
mSPIC2_SPISWAI:     equ    %00000010
mSPIC2_BIDIROE:     equ    %00001000
mSPIC2_MODFEN:      equ    %00010000


;*** SPIBR - SPI Baud Rate Register; 0x0000002A ***
SPIBR:              equ    $0000002A                                ;*** SPIBR - SPI Baud Rate Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Divisor Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Divisor Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Divisor Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Prescale Divisor Bit 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Prescale Divisor Bit 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Prescale Divisor Bit 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPIS - SPI Status Register; 0x0000002B ***
SPIS:               equ    $0000002B                                ;*** SPIS - SPI Status Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIS_MODF:          equ    4                                         ; Master Mode Fault Flag
SPIS_SPTEF:         equ    5                                         ; SPI Transmit Buffer Empty Flag
SPIS_SPRF:          equ    7                                         ; SPI Read Buffer Full Flag
; bit position masks
mSPIS_MODF:         equ    %00010000
mSPIS_SPTEF:        equ    %00100000
mSPIS_SPRF:         equ    %10000000


;*** SPID - SPI Data Register; 0x0000002D ***
SPID:               equ    $0000002D                                ;*** SPID - SPI Data Register; 0x0000002D ***


;*** IICA - IIC Address Register; 0x00000030 ***
IICA:               equ    $00000030                                ;*** IICA - IIC Address Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICA_AD1:           equ    1                                         ; Slave Address Bit 1
IICA_AD2:           equ    2                                         ; Slave Address Bit 2
IICA_AD3:           equ    3                                         ; Slave Address Bit 3
IICA_AD4:           equ    4                                         ; Slave Address Bit 4
IICA_AD5:           equ    5                                         ; Slave Address Bit 5
IICA_AD6:           equ    6                                         ; Slave Address Bit 6
IICA_AD7:           equ    7                                         ; Slave Address Bit 7
; bit position masks
mIICA_AD1:          equ    %00000010
mIICA_AD2:          equ    %00000100
mIICA_AD3:          equ    %00001000
mIICA_AD4:          equ    %00010000
mIICA_AD5:          equ    %00100000
mIICA_AD6:          equ    %01000000
mIICA_AD7:          equ    %10000000


;*** IICF - IIC Frequency Divider Register; 0x00000031 ***
IICF:               equ    $00000031                                ;*** IICF - IIC Frequency Divider Register; 0x00000031 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICF_ICR0:          equ    0                                         ; IIC Clock Rate Bit 0
IICF_ICR1:          equ    1                                         ; IIC Clock Rate Bit 1
IICF_ICR2:          equ    2                                         ; IIC Clock Rate Bit 2
IICF_ICR3:          equ    3                                         ; IIC Clock Rate Bit 3
IICF_ICR4:          equ    4                                         ; IIC Clock Rate Bit 4
IICF_ICR5:          equ    5                                         ; IIC Clock Rate Bit 5
IICF_MULT0:         equ    6                                         ; Multiplier Factor Bit 0
IICF_MULT1:         equ    7                                         ; Multiplier Factor Bit 1
; bit position masks
mIICF_ICR0:         equ    %00000001
mIICF_ICR1:         equ    %00000010
mIICF_ICR2:         equ    %00000100
mIICF_ICR3:         equ    %00001000
mIICF_ICR4:         equ    %00010000
mIICF_ICR5:         equ    %00100000
mIICF_MULT0:        equ    %01000000
mIICF_MULT1:        equ    %10000000


;*** IICC1 - IIC Control Register 1; 0x00000032 ***
IICC1:              equ    $00000032                                ;*** IICC1 - IIC Control Register 1; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC1_RSTA:         equ    2                                         ; Repeat START
IICC1_TXAK:         equ    3                                         ; Transmit Acknowledge Enable
IICC1_TX:           equ    4                                         ; Transmit Mode Select
IICC1_MST:          equ    5                                         ; Master Mode Select
IICC1_IICIE:        equ    6                                         ; IIC Interrupt Enable
IICC1_IICEN:        equ    7                                         ; IIC Enable
; bit position masks
mIICC1_RSTA:        equ    %00000100
mIICC1_TXAK:        equ    %00001000
mIICC1_TX:          equ    %00010000
mIICC1_MST:         equ    %00100000
mIICC1_IICIE:       equ    %01000000
mIICC1_IICEN:       equ    %10000000


;*** IICC - IIC Control Register; 0x00000032 ***
IICC:               equ    $00000032                                ;*** IICC - IIC Control Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC_RSTA:          equ    2                                         ; Repeat START
IICC_TXAK:          equ    3                                         ; Transmit Acknowledge Enable
IICC_TX:            equ    4                                         ; Transmit Mode Select
IICC_MST:           equ    5                                         ; Master Mode Select
IICC_IICIE:         equ    6                                         ; IIC Interrupt Enable
IICC_IICEN:         equ    7                                         ; IIC Enable
; bit position masks
mIICC_RSTA:         equ    %00000100
mIICC_TXAK:         equ    %00001000
mIICC_TX:           equ    %00010000
mIICC_MST:          equ    %00100000
mIICC_IICIE:        equ    %01000000
mIICC_IICEN:        equ    %10000000


;*** IICS - IIC Status Register; 0x00000033 ***
IICS:               equ    $00000033                                ;*** IICS - IIC Status Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICS_RXAK:          equ    0                                         ; Receive Acknowledge
IICS_IICIF:         equ    1                                         ; IIC Interrupt Flag
IICS_SRW:           equ    2                                         ; Slave Read/Write
IICS_ARBL:          equ    4                                         ; Arbitration Lost
IICS_BUSY:          equ    5                                         ; Bus Busy
IICS_IAAS:          equ    6                                         ; Addressed as a Slave
IICS_TCF:           equ    7                                         ; Transfer Complete Flag
; bit position masks
mIICS_RXAK:         equ    %00000001
mIICS_IICIF:        equ    %00000010
mIICS_SRW:          equ    %00000100
mIICS_ARBL:         equ    %00010000
mIICS_BUSY:         equ    %00100000
mIICS_IAAS:         equ    %01000000
mIICS_TCF:          equ    %10000000


;*** IICD - IIC Data I/O Register; 0x00000034 ***
IICD:               equ    $00000034                                ;*** IICD - IIC Data I/O Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICD_DATA0:         equ    0                                         ; IIC Data Bit 0
IICD_DATA1:         equ    1                                         ; IIC Data Bit 1
IICD_DATA2:         equ    2                                         ; IIC Data Bit 2
IICD_DATA3:         equ    3                                         ; IIC Data Bit 3
IICD_DATA4:         equ    4                                         ; IIC Data Bit 4
IICD_DATA5:         equ    5                                         ; IIC Data Bit 5
IICD_DATA6:         equ    6                                         ; IIC Data Bit 6
IICD_DATA7:         equ    7                                         ; IIC Data Bit 7
; bit position masks
mIICD_DATA0:        equ    %00000001
mIICD_DATA1:        equ    %00000010
mIICD_DATA2:        equ    %00000100
mIICD_DATA3:        equ    %00001000
mIICD_DATA4:        equ    %00010000
mIICD_DATA5:        equ    %00100000
mIICD_DATA6:        equ    %01000000
mIICD_DATA7:        equ    %10000000


;*** IICC2 - IIC Control Register 2; 0x00000035 ***
IICC2:              equ    $00000035                                ;*** IICC2 - IIC Control Register 2; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC2_AD8:          equ    0                                         ; Slave Address Bit 8
IICC2_AD9:          equ    1                                         ; Slave Address Bit 9
IICC2_AD10:         equ    2                                         ; Slave Address Bit 10
IICC2_ADEXT:        equ    6                                         ; Address Extension
IICC2_GCAEN:        equ    7                                         ; General Call Address Enable
; bit position masks
mIICC2_AD8:         equ    %00000001
mIICC2_AD9:         equ    %00000010
mIICC2_AD10:        equ    %00000100
mIICC2_ADEXT:       equ    %01000000
mIICC2_GCAEN:       equ    %10000000


;*** ICSC1 - ICS Control Register 1; 0x00000038 ***
ICSC1:              equ    $00000038                                ;*** ICSC1 - ICS Control Register 1; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC1_IREFSTEN:     equ    0                                         ; Internal Reference Stop Enable
ICSC1_IRCLKEN:      equ    1                                         ; Internal Reference Clock Enable
ICSC1_IREFS:        equ    2                                         ; Internal Reference Select
ICSC1_RDIV0:        equ    3                                         ; Reference Divider, bit 0
ICSC1_RDIV1:        equ    4                                         ; Reference Divider, bit 1
ICSC1_RDIV2:        equ    5                                         ; Reference Divider, bit 2
ICSC1_CLKS0:        equ    6                                         ; Clock Source Select, bit 0
ICSC1_CLKS1:        equ    7                                         ; Clock Source Select, bit 1
; bit position masks
mICSC1_IREFSTEN:    equ    %00000001
mICSC1_IRCLKEN:     equ    %00000010
mICSC1_IREFS:       equ    %00000100
mICSC1_RDIV0:       equ    %00001000
mICSC1_RDIV1:       equ    %00010000
mICSC1_RDIV2:       equ    %00100000
mICSC1_CLKS0:       equ    %01000000
mICSC1_CLKS1:       equ    %10000000


;*** ICSC2 - ICS Control Register 2; 0x00000039 ***
ICSC2:              equ    $00000039                                ;*** ICSC2 - ICS Control Register 2; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC2_EREFSTEN:     equ    0                                         ; External Reference Stop Enable
ICSC2_ERCLKEN:      equ    1                                         ; External Reference Enable
ICSC2_EREFS:        equ    2                                         ; External Reference Select
ICSC2_LP:           equ    3                                         ; Low Power Select
ICSC2_HGO:          equ    4                                         ; High Gain Oscillator Select
ICSC2_RANGE:        equ    5                                         ; Frequency Range Select
ICSC2_BDIV0:        equ    6                                         ; Bus Frequency Divider, bit 0
ICSC2_BDIV1:        equ    7                                         ; Bus Frequency Divider, bit 1
; bit position masks
mICSC2_EREFSTEN:    equ    %00000001
mICSC2_ERCLKEN:     equ    %00000010
mICSC2_EREFS:       equ    %00000100
mICSC2_LP:          equ    %00001000
mICSC2_HGO:         equ    %00010000
mICSC2_RANGE:       equ    %00100000
mICSC2_BDIV0:       equ    %01000000
mICSC2_BDIV1:       equ    %10000000


;*** ICSTRM - ICS Trim Register; 0x0000003A ***
ICSTRM:             equ    $0000003A                                ;*** ICSTRM - ICS Trim Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSTRM_TRIM0:       equ    0                                         ; ICS Trim Setting, bit 0
ICSTRM_TRIM1:       equ    1                                         ; ICS Trim Setting, bit 1
ICSTRM_TRIM2:       equ    2                                         ; ICS Trim Setting, bit 2
ICSTRM_TRIM3:       equ    3                                         ; ICS Trim Setting, bit 3
ICSTRM_TRIM4:       equ    4                                         ; ICS Trim Setting, bit 4
ICSTRM_TRIM5:       equ    5                                         ; ICS Trim Setting, bit 5
ICSTRM_TRIM6:       equ    6                                         ; ICS Trim Setting, bit 6
ICSTRM_TRIM7:       equ    7                                         ; ICS Trim Setting, bit 7
; bit position masks
mICSTRM_TRIM0:      equ    %00000001
mICSTRM_TRIM1:      equ    %00000010
mICSTRM_TRIM2:      equ    %00000100
mICSTRM_TRIM3:      equ    %00001000
mICSTRM_TRIM4:      equ    %00010000
mICSTRM_TRIM5:      equ    %00100000
mICSTRM_TRIM6:      equ    %01000000
mICSTRM_TRIM7:      equ    %10000000


;*** ICSSC - ICS Status and Control Register; 0x0000003B ***
ICSSC:              equ    $0000003B                                ;*** ICSSC - ICS Status and Control Register; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSSC_FTRIM:        equ    0                                         ; ICS Fine Trim
ICSSC_OSCINIT:      equ    1                                         ; OSC Initialization
ICSSC_CLKST0:       equ    2                                         ; Clock Mode Status, bit 0
ICSSC_CLKST1:       equ    3                                         ; Clock Mode Status, bit 1
ICSSC_IREFST:       equ    4                                         ; Internal Reference Status
ICSSC_DMX32:        equ    5                                         ; DCO Maximum frequency with 32.768 kHz reference
ICSSC_DRST_DRS0:    equ    6                                         ; DCO Range Status/Range Select, bit 0
ICSSC_DRST_DRS1:    equ    7                                         ; DCO Range Status/Range Select, bit 1
; bit position masks
mICSSC_FTRIM:       equ    %00000001
mICSSC_OSCINIT:     equ    %00000010
mICSSC_CLKST0:      equ    %00000100
mICSSC_CLKST1:      equ    %00001000
mICSSC_IREFST:      equ    %00010000
mICSSC_DMX32:       equ    %00100000
mICSSC_DRST_DRS0:   equ    %01000000
mICSSC_DRST_DRS1:   equ    %10000000


;*** TPM1SC - TPM1 Status and Control Register; 0x00000040 ***
TPM1SC:             equ    $00000040                                ;*** TPM1SC - TPM1 Status and Control Register; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM1SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM1SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM1SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM1SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM1SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM1SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM1SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM1SC_PS0:        equ    %00000001
mTPM1SC_PS1:        equ    %00000010
mTPM1SC_PS2:        equ    %00000100
mTPM1SC_CLKSA:      equ    %00001000
mTPM1SC_CLKSB:      equ    %00010000
mTPM1SC_CPWMS:      equ    %00100000
mTPM1SC_TOIE:       equ    %01000000
mTPM1SC_TOF:        equ    %10000000


;*** TPM1CNT - TPM1 Timer Counter Register; 0x00000041 ***
TPM1CNT:            equ    $00000041                                ;*** TPM1CNT - TPM1 Timer Counter Register; 0x00000041 ***


;*** TPM1CNTH - TPM1 Timer Counter Register High; 0x00000041 ***
TPM1CNTH:           equ    $00000041                                ;*** TPM1CNTH - TPM1 Timer Counter Register High; 0x00000041 ***


;*** TPM1CNTL - TPM1 Timer Counter Register Low; 0x00000042 ***
TPM1CNTL:           equ    $00000042                                ;*** TPM1CNTL - TPM1 Timer Counter Register Low; 0x00000042 ***


;*** TPM1MOD - TPM1 Timer Counter Modulo Register; 0x00000043 ***
TPM1MOD:            equ    $00000043                                ;*** TPM1MOD - TPM1 Timer Counter Modulo Register; 0x00000043 ***


;*** TPM1MODH - TPM1 Timer Counter Modulo Register High; 0x00000043 ***
TPM1MODH:           equ    $00000043                                ;*** TPM1MODH - TPM1 Timer Counter Modulo Register High; 0x00000043 ***


;*** TPM1MODL - TPM1 Timer Counter Modulo Register Low; 0x00000044 ***
TPM1MODL:           equ    $00000044                                ;*** TPM1MODL - TPM1 Timer Counter Modulo Register Low; 0x00000044 ***


;*** TPM1C0SC - TPM1 Timer Channel 0 Status and Control Register; 0x00000045 ***
TPM1C0SC:           equ    $00000045                                ;*** TPM1C0SC - TPM1 Timer Channel 0 Status and Control Register; 0x00000045 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM1C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM1C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM1C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM1C0SC_ELS0A:    equ    %00000100
mTPM1C0SC_ELS0B:    equ    %00001000
mTPM1C0SC_MS0A:     equ    %00010000
mTPM1C0SC_MS0B:     equ    %00100000
mTPM1C0SC_CH0IE:    equ    %01000000
mTPM1C0SC_CH0F:     equ    %10000000


;*** TPM1C0V - TPM1 Timer Channel 0 Value Register; 0x00000046 ***
TPM1C0V:            equ    $00000046                                ;*** TPM1C0V - TPM1 Timer Channel 0 Value Register; 0x00000046 ***


;*** TPM1C0VH - TPM1 Timer Channel 0 Value Register High; 0x00000046 ***
TPM1C0VH:           equ    $00000046                                ;*** TPM1C0VH - TPM1 Timer Channel 0 Value Register High; 0x00000046 ***


;*** TPM1C0VL - TPM1 Timer Channel 0 Value Register Low; 0x00000047 ***
TPM1C0VL:           equ    $00000047                                ;*** TPM1C0VL - TPM1 Timer Channel 0 Value Register Low; 0x00000047 ***


;*** TPM1C1SC - TPM1 Timer Channel 1 Status and Control Register; 0x00000048 ***
TPM1C1SC:           equ    $00000048                                ;*** TPM1C1SC - TPM1 Timer Channel 1 Status and Control Register; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C1SC_ELS1A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C1SC_ELS1B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C1SC_MS1A:      equ    4                                         ; Mode Select A for TPM Channel 1
TPM1C1SC_MS1B:      equ    5                                         ; Mode Select B for TPM Channel 1
TPM1C1SC_CH1IE:     equ    6                                         ; Channel 1 Interrupt Enable
TPM1C1SC_CH1F:      equ    7                                         ; Channel 1 Flag
; bit position masks
mTPM1C1SC_ELS1A:    equ    %00000100
mTPM1C1SC_ELS1B:    equ    %00001000
mTPM1C1SC_MS1A:     equ    %00010000
mTPM1C1SC_MS1B:     equ    %00100000
mTPM1C1SC_CH1IE:    equ    %01000000
mTPM1C1SC_CH1F:     equ    %10000000


;*** TPM1C1V - TPM1 Timer Channel 1 Value Register; 0x00000049 ***
TPM1C1V:            equ    $00000049                                ;*** TPM1C1V - TPM1 Timer Channel 1 Value Register; 0x00000049 ***


;*** TPM1C1VH - TPM1 Timer Channel 1 Value Register High; 0x00000049 ***
TPM1C1VH:           equ    $00000049                                ;*** TPM1C1VH - TPM1 Timer Channel 1 Value Register High; 0x00000049 ***


;*** TPM1C1VL - TPM1 Timer Channel 1 Value Register Low; 0x0000004A ***
TPM1C1VL:           equ    $0000004A                                ;*** TPM1C1VL - TPM1 Timer Channel 1 Value Register Low; 0x0000004A ***


;*** TPM2SC - TPM2 Status and Control Register; 0x00000050 ***
TPM2SC:             equ    $00000050                                ;*** TPM2SC - TPM2 Status and Control Register; 0x00000050 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM2SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM2SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM2SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM2SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM2SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM2SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM2SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM2SC_PS0:        equ    %00000001
mTPM2SC_PS1:        equ    %00000010
mTPM2SC_PS2:        equ    %00000100
mTPM2SC_CLKSA:      equ    %00001000
mTPM2SC_CLKSB:      equ    %00010000
mTPM2SC_CPWMS:      equ    %00100000
mTPM2SC_TOIE:       equ    %01000000
mTPM2SC_TOF:        equ    %10000000


;*** TPM2CNT - TPM2 Timer Counter Register; 0x00000051 ***
TPM2CNT:            equ    $00000051                                ;*** TPM2CNT - TPM2 Timer Counter Register; 0x00000051 ***


;*** TPM2CNTH - TPM2 Timer Counter Register High; 0x00000051 ***
TPM2CNTH:           equ    $00000051                                ;*** TPM2CNTH - TPM2 Timer Counter Register High; 0x00000051 ***


;*** TPM2CNTL - TPM2 Timer Counter Register Low; 0x00000052 ***
TPM2CNTL:           equ    $00000052                                ;*** TPM2CNTL - TPM2 Timer Counter Register Low; 0x00000052 ***


;*** TPM2MOD - TPM2 Timer Counter Modulo Register; 0x00000053 ***
TPM2MOD:            equ    $00000053                                ;*** TPM2MOD - TPM2 Timer Counter Modulo Register; 0x00000053 ***


;*** TPM2MODH - TPM2 Timer Counter Modulo Register High; 0x00000053 ***
TPM2MODH:           equ    $00000053                                ;*** TPM2MODH - TPM2 Timer Counter Modulo Register High; 0x00000053 ***


;*** TPM2MODL - TPM2 Timer Counter Modulo Register Low; 0x00000054 ***
TPM2MODL:           equ    $00000054                                ;*** TPM2MODL - TPM2 Timer Counter Modulo Register Low; 0x00000054 ***


;*** TPM2C0SC - TPM2 Timer Channel 0 Status and Control Register; 0x00000055 ***
TPM2C0SC:           equ    $00000055                                ;*** TPM2C0SC - TPM2 Timer Channel 0 Status and Control Register; 0x00000055 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM2C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM2C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM2C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM2C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM2C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM2C0SC_ELS0A:    equ    %00000100
mTPM2C0SC_ELS0B:    equ    %00001000
mTPM2C0SC_MS0A:     equ    %00010000
mTPM2C0SC_MS0B:     equ    %00100000
mTPM2C0SC_CH0IE:    equ    %01000000
mTPM2C0SC_CH0F:     equ    %10000000


;*** TPM2C0V - TPM2 Timer Channel 0 Value Register; 0x00000056 ***
TPM2C0V:            equ    $00000056                                ;*** TPM2C0V - TPM2 Timer Channel 0 Value Register; 0x00000056 ***


;*** TPM2C0VH - TPM2 Timer Channel 0 Value Register High; 0x00000056 ***
TPM2C0VH:           equ    $00000056                                ;*** TPM2C0VH - TPM2 Timer Channel 0 Value Register High; 0x00000056 ***


;*** TPM2C0VL - TPM2 Timer Channel 0 Value Register Low; 0x00000057 ***
TPM2C0VL:           equ    $00000057                                ;*** TPM2C0VL - TPM2 Timer Channel 0 Value Register Low; 0x00000057 ***


;*** TPM2C1SC - TPM2 Timer Channel 1 Status and Control Register; 0x00000058 ***
TPM2C1SC:           equ    $00000058                                ;*** TPM2C1SC - TPM2 Timer Channel 1 Status and Control Register; 0x00000058 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2C1SC_ELS1A:     equ    2                                         ; Edge/Level Select Bit A
TPM2C1SC_ELS1B:     equ    3                                         ; Edge/Level Select Bit B
TPM2C1SC_MS1A:      equ    4                                         ; Mode Select A for TPM Channel 1
TPM2C1SC_MS1B:      equ    5                                         ; Mode Select B for TPM Channel 1
TPM2C1SC_CH1IE:     equ    6                                         ; Channel 1 Interrupt Enable
TPM2C1SC_CH1F:      equ    7                                         ; Channel 1 Flag
; bit position masks
mTPM2C1SC_ELS1A:    equ    %00000100
mTPM2C1SC_ELS1B:    equ    %00001000
mTPM2C1SC_MS1A:     equ    %00010000
mTPM2C1SC_MS1B:     equ    %00100000
mTPM2C1SC_CH1IE:    equ    %01000000
mTPM2C1SC_CH1F:     equ    %10000000


;*** TPM2C1V - TPM2 Timer Channel 1 Value Register; 0x00000059 ***
TPM2C1V:            equ    $00000059                                ;*** TPM2C1V - TPM2 Timer Channel 1 Value Register; 0x00000059 ***


;*** TPM2C1VH - TPM2 Timer Channel 1 Value Register High; 0x00000059 ***
TPM2C1VH:           equ    $00000059                                ;*** TPM2C1VH - TPM2 Timer Channel 1 Value Register High; 0x00000059 ***


;*** TPM2C1VL - TPM2 Timer Channel 1 Value Register Low; 0x0000005A ***
TPM2C1VL:           equ    $0000005A                                ;*** TPM2C1VL - TPM2 Timer Channel 1 Value Register Low; 0x0000005A ***


;*** LCDPEN0 - LCD Pin Enable Register 0; 0x00000880 ***
LCDPEN0:            equ    $00000880                                ;*** LCDPEN0 - LCD Pin Enable Register 0; 0x00000880 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDPEN0_PEN0:       equ    0                                         ; Enable LCD pin 0 for LCD operation
LCDPEN0_PEN1:       equ    1                                         ; Enable LCD pin 1 for LCD operation
LCDPEN0_PEN2:       equ    2                                         ; Enable LCD pin 2 for LCD operation
LCDPEN0_PEN3:       equ    3                                         ; Enable LCD pin 3 for LCD operation
LCDPEN0_PEN4:       equ    4                                         ; Enable LCD pin 4 for LCD operation
LCDPEN0_PEN5:       equ    5                                         ; Enable LCD pin 5 for LCD operation
LCDPEN0_PEN6:       equ    6                                         ; Enable LCD pin 6 for LCD operation
LCDPEN0_PEN7:       equ    7                                         ; Enable LCD pin 7 for LCD operation
; bit position masks
mLCDPEN0_PEN0:      equ    %00000001
mLCDPEN0_PEN1:      equ    %00000010
mLCDPEN0_PEN2:      equ    %00000100
mLCDPEN0_PEN3:      equ    %00001000
mLCDPEN0_PEN4:      equ    %00010000
mLCDPEN0_PEN5:      equ    %00100000
mLCDPEN0_PEN6:      equ    %01000000
mLCDPEN0_PEN7:      equ    %10000000


;*** LCDPEN1 - LCD Pin Enable Register 1; 0x00000881 ***
LCDPEN1:            equ    $00000881                                ;*** LCDPEN1 - LCD Pin Enable Register 1; 0x00000881 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDPEN1_PEN8:       equ    0                                         ; Enable LCD pin 8 for LCD operation
LCDPEN1_PEN9:       equ    1                                         ; Enable LCD pin 9 for LCD operation
LCDPEN1_PEN10:      equ    2                                         ; Enable LCD pin 10 for LCD operation
LCDPEN1_PEN11:      equ    3                                         ; Enable LCD pin 11 for LCD operation
LCDPEN1_PEN12:      equ    4                                         ; Enable LCD pin 12 for LCD operation
LCDPEN1_PEN13:      equ    5                                         ; Enable LCD pin 13 for LCD operation
LCDPEN1_PEN14:      equ    6                                         ; Enable LCD pin 14 for LCD operation
LCDPEN1_PEN15:      equ    7                                         ; Enable LCD pin 15 for LCD operation
; bit position masks
mLCDPEN1_PEN8:      equ    %00000001
mLCDPEN1_PEN9:      equ    %00000010
mLCDPEN1_PEN10:     equ    %00000100
mLCDPEN1_PEN11:     equ    %00001000
mLCDPEN1_PEN12:     equ    %00010000
mLCDPEN1_PEN13:     equ    %00100000
mLCDPEN1_PEN14:     equ    %01000000
mLCDPEN1_PEN15:     equ    %10000000


;*** LCDPEN2 - LCD Pin Enable Register 2; 0x00000882 ***
LCDPEN2:            equ    $00000882                                ;*** LCDPEN2 - LCD Pin Enable Register 2; 0x00000882 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDPEN2_PEN16:      equ    0                                         ; Enable LCD pin 16 for LCD operation
LCDPEN2_PEN17:      equ    1                                         ; Enable LCD pin 17 for LCD operation
LCDPEN2_PEN18:      equ    2                                         ; Enable LCD pin 18 for LCD operation
LCDPEN2_PEN19:      equ    3                                         ; Enable LCD pin 19 for LCD operation
LCDPEN2_PEN20:      equ    4                                         ; Enable LCD pin 20 for LCD operation
LCDPEN2_PEN21:      equ    5                                         ; Enable LCD pin 21 for LCD operation
LCDPEN2_PEN22:      equ    6                                         ; Enable LCD pin 22 for LCD operation
LCDPEN2_PEN23:      equ    7                                         ; Enable LCD pin 23 for LCD operation
; bit position masks
mLCDPEN2_PEN16:     equ    %00000001
mLCDPEN2_PEN17:     equ    %00000010
mLCDPEN2_PEN18:     equ    %00000100
mLCDPEN2_PEN19:     equ    %00001000
mLCDPEN2_PEN20:     equ    %00010000
mLCDPEN2_PEN21:     equ    %00100000
mLCDPEN2_PEN22:     equ    %01000000
mLCDPEN2_PEN23:     equ    %10000000


;*** LCDPEN3 - LCD Pin Enable Register 3; 0x00000883 ***
LCDPEN3:            equ    $00000883                                ;*** LCDPEN3 - LCD Pin Enable Register 3; 0x00000883 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDPEN3_PEN24:      equ    0                                         ; Enable LCD pin 24 for LCD operation
LCDPEN3_PEN25:      equ    1                                         ; Enable LCD pin 25 for LCD operation
LCDPEN3_PEN26:      equ    2                                         ; Enable LCD pin 26 for LCD operation
LCDPEN3_PEN27:      equ    3                                         ; Enable LCD pin 27 for LCD operation
LCDPEN3_PEN28:      equ    4                                         ; Enable LCD pin 28 for LCD operation
LCDPEN3_PEN29:      equ    5                                         ; Enable LCD pin 29 for LCD operation
LCDPEN3_PEN30:      equ    6                                         ; Enable LCD pin 30 for LCD operation
LCDPEN3_PEN31:      equ    7                                         ; Enable LCD pin 31 for LCD operation
; bit position masks
mLCDPEN3_PEN24:     equ    %00000001
mLCDPEN3_PEN25:     equ    %00000010
mLCDPEN3_PEN26:     equ    %00000100
mLCDPEN3_PEN27:     equ    %00001000
mLCDPEN3_PEN28:     equ    %00010000
mLCDPEN3_PEN29:     equ    %00100000
mLCDPEN3_PEN30:     equ    %01000000
mLCDPEN3_PEN31:     equ    %10000000


;*** LCDBPEN0 - LCD Backplane Enable Register 0; 0x00000888 ***
LCDBPEN0:           equ    $00000888                                ;*** LCDBPEN0 - LCD Backplane Enable Register 0; 0x00000888 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDBPEN0_BPEN0:     equ    0                                         ; Enable LCD pin 0 to operate as an LCD backplane or an LCD frontplane
LCDBPEN0_BPEN1:     equ    1                                         ; Enable LCD pin 1 to operate as an LCD backplane or an LCD frontplane
LCDBPEN0_BPEN2:     equ    2                                         ; Enable LCD pin 2 to operate as an LCD backplane or an LCD frontplane
LCDBPEN0_BPEN3:     equ    3                                         ; Enable LCD pin 3 to operate as an LCD backplane or an LCD frontplane
LCDBPEN0_BPEN4:     equ    4                                         ; Enable LCD pin 4 to operate as an LCD backplane or an LCD frontplane
LCDBPEN0_BPEN5:     equ    5                                         ; Enable LCD pin 5 to operate as an LCD backplane or an LCD frontplane
LCDBPEN0_BPEN6:     equ    6                                         ; Enable LCD pin 6 to operate as an LCD backplane or an LCD frontplane
LCDBPEN0_BPEN7:     equ    7                                         ; Enable LCD pin 7 to operate as an LCD backplane or an LCD frontplane
; bit position masks
mLCDBPEN0_BPEN0:    equ    %00000001
mLCDBPEN0_BPEN1:    equ    %00000010
mLCDBPEN0_BPEN2:    equ    %00000100
mLCDBPEN0_BPEN3:    equ    %00001000
mLCDBPEN0_BPEN4:    equ    %00010000
mLCDBPEN0_BPEN5:    equ    %00100000
mLCDBPEN0_BPEN6:    equ    %01000000
mLCDBPEN0_BPEN7:    equ    %10000000


;*** LCDBPEN1 - LCD Backplane Enable Register 1; 0x00000889 ***
LCDBPEN1:           equ    $00000889                                ;*** LCDBPEN1 - LCD Backplane Enable Register 1; 0x00000889 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDBPEN1_BPEN8:     equ    0                                         ; Enable LCD pin 8 to operate as an LCD backplane or an LCD frontplane
LCDBPEN1_BPEN9:     equ    1                                         ; Enable LCD pin 9 to operate as an LCD backplane or an LCD frontplane
LCDBPEN1_BPEN10:    equ    2                                         ; Enable LCD pin 10 to operate as an LCD backplane or an LCD frontplane
LCDBPEN1_BPEN11:    equ    3                                         ; Enable LCD pin 11 to operate as an LCD backplane or an LCD frontplane
LCDBPEN1_BPEN12:    equ    4                                         ; Enable LCD pin 12 to operate as an LCD backplane or an LCD frontplane
LCDBPEN1_BPEN13:    equ    5                                         ; Enable LCD pin 13 to operate as an LCD backplane or an LCD frontplane
LCDBPEN1_BPEN14:    equ    6                                         ; Enable LCD pin 14 to operate as an LCD backplane or an LCD frontplane
LCDBPEN1_BPEN15:    equ    7                                         ; Enable LCD pin 15 to operate as an LCD backplane or an LCD frontplane
; bit position masks
mLCDBPEN1_BPEN8:    equ    %00000001
mLCDBPEN1_BPEN9:    equ    %00000010
mLCDBPEN1_BPEN10:   equ    %00000100
mLCDBPEN1_BPEN11:   equ    %00001000
mLCDBPEN1_BPEN12:   equ    %00010000
mLCDBPEN1_BPEN13:   equ    %00100000
mLCDBPEN1_BPEN14:   equ    %01000000
mLCDBPEN1_BPEN15:   equ    %10000000


;*** LCDBPEN2 - LCD Backplane Enable Register 2; 0x0000088A ***
LCDBPEN2:           equ    $0000088A                                ;*** LCDBPEN2 - LCD Backplane Enable Register 2; 0x0000088A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDBPEN2_BPEN16:    equ    0                                         ; Enable LCD pin 16 to operate as an LCD backplane or an LCD frontplane
LCDBPEN2_BPEN17:    equ    1                                         ; Enable LCD pin 17 to operate as an LCD backplane or an LCD frontplane
LCDBPEN2_BPEN18:    equ    2                                         ; Enable LCD pin 18 to operate as an LCD backplane or an LCD frontplane
LCDBPEN2_BPEN19:    equ    3                                         ; Enable LCD pin 19 to operate as an LCD backplane or an LCD frontplane
LCDBPEN2_BPEN20:    equ    4                                         ; Enable LCD pin 20 to operate as an LCD backplane or an LCD frontplane
LCDBPEN2_BPEN21:    equ    5                                         ; Enable LCD pin 21 to operate as an LCD backplane or an LCD frontplane
LCDBPEN2_BPEN22:    equ    6                                         ; Enable LCD pin 22 to operate as an LCD backplane or an LCD frontplane
LCDBPEN2_BPEN23:    equ    7                                         ; Enable LCD pin 23 to operate as an LCD backplane or an LCD frontplane
; bit position masks
mLCDBPEN2_BPEN16:   equ    %00000001
mLCDBPEN2_BPEN17:   equ    %00000010
mLCDBPEN2_BPEN18:   equ    %00000100
mLCDBPEN2_BPEN19:   equ    %00001000
mLCDBPEN2_BPEN20:   equ    %00010000
mLCDBPEN2_BPEN21:   equ    %00100000
mLCDBPEN2_BPEN22:   equ    %01000000
mLCDBPEN2_BPEN23:   equ    %10000000


;*** LCDBPEN3 - LCD Backplane Enable Register 3; 0x0000088B ***
LCDBPEN3:           equ    $0000088B                                ;*** LCDBPEN3 - LCD Backplane Enable Register 3; 0x0000088B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDBPEN3_BPEN24:    equ    0                                         ; Enable LCD pin 24 to operate as an LCD backplane or an LCD frontplane
LCDBPEN3_BPEN25:    equ    1                                         ; Enable LCD pin 25 to operate as an LCD backplane or an LCD frontplane
LCDBPEN3_BPEN26:    equ    2                                         ; Enable LCD pin 26 to operate as an LCD backplane or an LCD frontplane
LCDBPEN3_BPEN27:    equ    3                                         ; Enable LCD pin 27 to operate as an LCD backplane or an LCD frontplane
LCDBPEN3_BPEN28:    equ    4                                         ; Enable LCD pin 28 to operate as an LCD backplane or an LCD frontplane
LCDBPEN3_BPEN29:    equ    5                                         ; Enable LCD pin 29 to operate as an LCD backplane or an LCD frontplane
LCDBPEN3_BPEN30:    equ    6                                         ; Enable LCD pin 30 to operate as an LCD backplane or an LCD frontplane
LCDBPEN3_BPEN31:    equ    7                                         ; Enable LCD pin 31 to operate as an LCD backplane or an LCD frontplane
; bit position masks
mLCDBPEN3_BPEN24:   equ    %00000001
mLCDBPEN3_BPEN25:   equ    %00000010
mLCDBPEN3_BPEN26:   equ    %00000100
mLCDBPEN3_BPEN27:   equ    %00001000
mLCDBPEN3_BPEN28:   equ    %00010000
mLCDBPEN3_BPEN29:   equ    %00100000
mLCDBPEN3_BPEN30:   equ    %01000000
mLCDBPEN3_BPEN31:   equ    %10000000


;*** LCDWF0 - LCD Waveform Register 0; 0x00000890 ***
LCDWF0:             equ    $00000890                                ;*** LCDWF0 - LCD Waveform Register 0; 0x00000890 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF0_BPALCD0:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF0_BPBLCD0:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF0_BPCLCD0:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF0_BPDLCD0:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF0_BPELCD0:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF0_BPFLCD0:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF0_BPGLCD0:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF0_BPHLCD0:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF0_BPALCD0:    equ    %00000001
mLCDWF0_BPBLCD0:    equ    %00000010
mLCDWF0_BPCLCD0:    equ    %00000100
mLCDWF0_BPDLCD0:    equ    %00001000
mLCDWF0_BPELCD0:    equ    %00010000
mLCDWF0_BPFLCD0:    equ    %00100000
mLCDWF0_BPGLCD0:    equ    %01000000
mLCDWF0_BPHLCD0:    equ    %10000000


;*** LCDWF1 - LCD Waveform Register 1; 0x00000891 ***
LCDWF1:             equ    $00000891                                ;*** LCDWF1 - LCD Waveform Register 1; 0x00000891 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF1_BPALCD1:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF1_BPBLCD1:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF1_BPCLCD1:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF1_BPDLCD1:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF1_BPELCD1:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF1_BPFLCD1:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF1_BPGLCD1:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF1_BPHLCD1:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF1_BPALCD1:    equ    %00000001
mLCDWF1_BPBLCD1:    equ    %00000010
mLCDWF1_BPCLCD1:    equ    %00000100
mLCDWF1_BPDLCD1:    equ    %00001000
mLCDWF1_BPELCD1:    equ    %00010000
mLCDWF1_BPFLCD1:    equ    %00100000
mLCDWF1_BPGLCD1:    equ    %01000000
mLCDWF1_BPHLCD1:    equ    %10000000


;*** LCDWF2 - LCD Waveform Register 2; 0x00000892 ***
LCDWF2:             equ    $00000892                                ;*** LCDWF2 - LCD Waveform Register 2; 0x00000892 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF2_BPALCD2:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF2_BPBLCD2:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF2_BPCLCD2:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF2_BPDLCD2:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF2_BPELCD2:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF2_BPFLCD2:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF2_BPGLCD2:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF2_BPHLCD2:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF2_BPALCD2:    equ    %00000001
mLCDWF2_BPBLCD2:    equ    %00000010
mLCDWF2_BPCLCD2:    equ    %00000100
mLCDWF2_BPDLCD2:    equ    %00001000
mLCDWF2_BPELCD2:    equ    %00010000
mLCDWF2_BPFLCD2:    equ    %00100000
mLCDWF2_BPGLCD2:    equ    %01000000
mLCDWF2_BPHLCD2:    equ    %10000000


;*** LCDWF3 - LCD Waveform Register 3; 0x00000893 ***
LCDWF3:             equ    $00000893                                ;*** LCDWF3 - LCD Waveform Register 3; 0x00000893 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF3_BPALCD3:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF3_BPBLCD3:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF3_BPCLCD3:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF3_BPDLCD3:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF3_BPELCD3:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF3_BPFLCD3:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF3_BPGLCD3:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF3_BPHLCD3:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF3_BPALCD3:    equ    %00000001
mLCDWF3_BPBLCD3:    equ    %00000010
mLCDWF3_BPCLCD3:    equ    %00000100
mLCDWF3_BPDLCD3:    equ    %00001000
mLCDWF3_BPELCD3:    equ    %00010000
mLCDWF3_BPFLCD3:    equ    %00100000
mLCDWF3_BPGLCD3:    equ    %01000000
mLCDWF3_BPHLCD3:    equ    %10000000


;*** LCDWF4 - LCD Waveform Register 4; 0x00000894 ***
LCDWF4:             equ    $00000894                                ;*** LCDWF4 - LCD Waveform Register 4; 0x00000894 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF4_BPALCD4:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF4_BPBLCD4:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF4_BPCLCD4:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF4_BPDLCD4:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF4_BPELCD4:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF4_BPFLCD4:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF4_BPGLCD4:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF4_BPHLCD4:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF4_BPALCD4:    equ    %00000001
mLCDWF4_BPBLCD4:    equ    %00000010
mLCDWF4_BPCLCD4:    equ    %00000100
mLCDWF4_BPDLCD4:    equ    %00001000
mLCDWF4_BPELCD4:    equ    %00010000
mLCDWF4_BPFLCD4:    equ    %00100000
mLCDWF4_BPGLCD4:    equ    %01000000
mLCDWF4_BPHLCD4:    equ    %10000000


;*** LCDWF5 - LCD Waveform Register 5; 0x00000895 ***
LCDWF5:             equ    $00000895                                ;*** LCDWF5 - LCD Waveform Register 5; 0x00000895 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF5_BPALCD5:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF5_BPBLCD5:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF5_BPCLCD5:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF5_BPDLCD5:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF5_BPELCD5:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF5_BPFLCD5:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF5_BPGLCD5:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF5_BPHLCD5:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF5_BPALCD5:    equ    %00000001
mLCDWF5_BPBLCD5:    equ    %00000010
mLCDWF5_BPCLCD5:    equ    %00000100
mLCDWF5_BPDLCD5:    equ    %00001000
mLCDWF5_BPELCD5:    equ    %00010000
mLCDWF5_BPFLCD5:    equ    %00100000
mLCDWF5_BPGLCD5:    equ    %01000000
mLCDWF5_BPHLCD5:    equ    %10000000


;*** LCDWF6 - LCD Waveform Register 6; 0x00000896 ***
LCDWF6:             equ    $00000896                                ;*** LCDWF6 - LCD Waveform Register 6; 0x00000896 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF6_BPALCD6:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF6_BPBLCD6:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF6_BPCLCD6:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF6_BPDLCD6:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF6_BPELCD6:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF6_BPFLCD6:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF6_BPGLCD6:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF6_BPHLCD6:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF6_BPALCD6:    equ    %00000001
mLCDWF6_BPBLCD6:    equ    %00000010
mLCDWF6_BPCLCD6:    equ    %00000100
mLCDWF6_BPDLCD6:    equ    %00001000
mLCDWF6_BPELCD6:    equ    %00010000
mLCDWF6_BPFLCD6:    equ    %00100000
mLCDWF6_BPGLCD6:    equ    %01000000
mLCDWF6_BPHLCD6:    equ    %10000000


;*** LCDWF7 - LCD Waveform Register 7; 0x00000897 ***
LCDWF7:             equ    $00000897                                ;*** LCDWF7 - LCD Waveform Register 7; 0x00000897 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF7_BPALCD7:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF7_BPBLCD7:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF7_BPCLCD7:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF7_BPDLCD7:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF7_BPELCD7:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF7_BPFLCD7:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF7_BPGLCD7:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF7_BPHLCD7:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF7_BPALCD7:    equ    %00000001
mLCDWF7_BPBLCD7:    equ    %00000010
mLCDWF7_BPCLCD7:    equ    %00000100
mLCDWF7_BPDLCD7:    equ    %00001000
mLCDWF7_BPELCD7:    equ    %00010000
mLCDWF7_BPFLCD7:    equ    %00100000
mLCDWF7_BPGLCD7:    equ    %01000000
mLCDWF7_BPHLCD7:    equ    %10000000


;*** LCDWF8 - LCD Waveform Register 8; 0x00000898 ***
LCDWF8:             equ    $00000898                                ;*** LCDWF8 - LCD Waveform Register 8; 0x00000898 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF8_BPALCD8:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF8_BPBLCD8:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF8_BPCLCD8:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF8_BPDLCD8:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF8_BPELCD8:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF8_BPFLCD8:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF8_BPGLCD8:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF8_BPHLCD8:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF8_BPALCD8:    equ    %00000001
mLCDWF8_BPBLCD8:    equ    %00000010
mLCDWF8_BPCLCD8:    equ    %00000100
mLCDWF8_BPDLCD8:    equ    %00001000
mLCDWF8_BPELCD8:    equ    %00010000
mLCDWF8_BPFLCD8:    equ    %00100000
mLCDWF8_BPGLCD8:    equ    %01000000
mLCDWF8_BPHLCD8:    equ    %10000000


;*** LCDWF9 - LCD Waveform Register 9; 0x00000899 ***
LCDWF9:             equ    $00000899                                ;*** LCDWF9 - LCD Waveform Register 9; 0x00000899 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF9_BPALCD9:     equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF9_BPBLCD9:     equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF9_BPCLCD9:     equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF9_BPDLCD9:     equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF9_BPELCD9:     equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF9_BPFLCD9:     equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF9_BPGLCD9:     equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF9_BPHLCD9:     equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF9_BPALCD9:    equ    %00000001
mLCDWF9_BPBLCD9:    equ    %00000010
mLCDWF9_BPCLCD9:    equ    %00000100
mLCDWF9_BPDLCD9:    equ    %00001000
mLCDWF9_BPELCD9:    equ    %00010000
mLCDWF9_BPFLCD9:    equ    %00100000
mLCDWF9_BPGLCD9:    equ    %01000000
mLCDWF9_BPHLCD9:    equ    %10000000


;*** LCDWF10 - LCD Waveform Register 10; 0x0000089A ***
LCDWF10:            equ    $0000089A                                ;*** LCDWF10 - LCD Waveform Register 10; 0x0000089A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF10_BPALCD10:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF10_BPBLCD10:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF10_BPCLCD10:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF10_BPDLCD10:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF10_BPELCD10:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF10_BPFLCD10:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF10_BPGLCD10:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF10_BPHLCD10:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF10_BPALCD10:  equ    %00000001
mLCDWF10_BPBLCD10:  equ    %00000010
mLCDWF10_BPCLCD10:  equ    %00000100
mLCDWF10_BPDLCD10:  equ    %00001000
mLCDWF10_BPELCD10:  equ    %00010000
mLCDWF10_BPFLCD10:  equ    %00100000
mLCDWF10_BPGLCD10:  equ    %01000000
mLCDWF10_BPHLCD10:  equ    %10000000


;*** LCDWF11 - LCD Waveform Register 11; 0x0000089B ***
LCDWF11:            equ    $0000089B                                ;*** LCDWF11 - LCD Waveform Register 11; 0x0000089B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF11_BPALCD11:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF11_BPBLCD11:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF11_BPCLCD11:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF11_BPDLCD11:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF11_BPELCD11:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF11_BPFLCD11:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF11_BPGLCD11:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF11_BPHLCD11:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF11_BPALCD11:  equ    %00000001
mLCDWF11_BPBLCD11:  equ    %00000010
mLCDWF11_BPCLCD11:  equ    %00000100
mLCDWF11_BPDLCD11:  equ    %00001000
mLCDWF11_BPELCD11:  equ    %00010000
mLCDWF11_BPFLCD11:  equ    %00100000
mLCDWF11_BPGLCD11:  equ    %01000000
mLCDWF11_BPHLCD11:  equ    %10000000


;*** LCDWF12 - LCD Waveform Register 12; 0x0000089C ***
LCDWF12:            equ    $0000089C                                ;*** LCDWF12 - LCD Waveform Register 12; 0x0000089C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF12_BPALCD12:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF12_BPBLCD12:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF12_BPCLCD12:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF12_BPDLCD12:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF12_BPELCD12:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF12_BPFLCD12:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF12_BPGLCD12:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF12_BPHLCD12:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF12_BPALCD12:  equ    %00000001
mLCDWF12_BPBLCD12:  equ    %00000010
mLCDWF12_BPCLCD12:  equ    %00000100
mLCDWF12_BPDLCD12:  equ    %00001000
mLCDWF12_BPELCD12:  equ    %00010000
mLCDWF12_BPFLCD12:  equ    %00100000
mLCDWF12_BPGLCD12:  equ    %01000000
mLCDWF12_BPHLCD12:  equ    %10000000


;*** LCDWF13 - LCD Waveform Register 13; 0x0000089D ***
LCDWF13:            equ    $0000089D                                ;*** LCDWF13 - LCD Waveform Register 13; 0x0000089D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF13_BPALCD13:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF13_BPBLCD13:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF13_BPCLCD13:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF13_BPDLCD13:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF13_BPELCD13:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF13_BPFLCD13:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF13_BPGLCD13:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF13_BPHLCD13:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF13_BPALCD13:  equ    %00000001
mLCDWF13_BPBLCD13:  equ    %00000010
mLCDWF13_BPCLCD13:  equ    %00000100
mLCDWF13_BPDLCD13:  equ    %00001000
mLCDWF13_BPELCD13:  equ    %00010000
mLCDWF13_BPFLCD13:  equ    %00100000
mLCDWF13_BPGLCD13:  equ    %01000000
mLCDWF13_BPHLCD13:  equ    %10000000


;*** LCDWF14 - LCD Waveform Register 14; 0x0000089E ***
LCDWF14:            equ    $0000089E                                ;*** LCDWF14 - LCD Waveform Register 14; 0x0000089E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF14_BPALCD14:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF14_BPBLCD14:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF14_BPCLCD14:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF14_BPDLCD14:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF14_BPELCD14:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF14_BPFLCD14:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF14_BPGLCD14:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF14_BPHLCD14:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF14_BPALCD14:  equ    %00000001
mLCDWF14_BPBLCD14:  equ    %00000010
mLCDWF14_BPCLCD14:  equ    %00000100
mLCDWF14_BPDLCD14:  equ    %00001000
mLCDWF14_BPELCD14:  equ    %00010000
mLCDWF14_BPFLCD14:  equ    %00100000
mLCDWF14_BPGLCD14:  equ    %01000000
mLCDWF14_BPHLCD14:  equ    %10000000


;*** LCDWF15 - LCD Waveform Register 15; 0x0000089F ***
LCDWF15:            equ    $0000089F                                ;*** LCDWF15 - LCD Waveform Register 15; 0x0000089F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF15_BPALCD15:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF15_BPBLCD15:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF15_BPCLCD15:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF15_BPDLCD15:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF15_BPELCD15:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF15_BPFLCD15:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF15_BPGLCD15:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF15_BPHLCD15:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF15_BPALCD15:  equ    %00000001
mLCDWF15_BPBLCD15:  equ    %00000010
mLCDWF15_BPCLCD15:  equ    %00000100
mLCDWF15_BPDLCD15:  equ    %00001000
mLCDWF15_BPELCD15:  equ    %00010000
mLCDWF15_BPFLCD15:  equ    %00100000
mLCDWF15_BPGLCD15:  equ    %01000000
mLCDWF15_BPHLCD15:  equ    %10000000


;*** LCDWF16 - LCD Waveform Register 16; 0x000008A0 ***
LCDWF16:            equ    $000008A0                                ;*** LCDWF16 - LCD Waveform Register 16; 0x000008A0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF16_BPALCD16:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF16_BPBLCD16:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF16_BPCLCD16:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF16_BPDLCD16:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF16_BPELCD16:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF16_BPFLCD16:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF16_BPGLCD16:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF16_BPHLCD16:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF16_BPALCD16:  equ    %00000001
mLCDWF16_BPBLCD16:  equ    %00000010
mLCDWF16_BPCLCD16:  equ    %00000100
mLCDWF16_BPDLCD16:  equ    %00001000
mLCDWF16_BPELCD16:  equ    %00010000
mLCDWF16_BPFLCD16:  equ    %00100000
mLCDWF16_BPGLCD16:  equ    %01000000
mLCDWF16_BPHLCD16:  equ    %10000000


;*** LCDWF17 - LCD Waveform Register 17; 0x000008A1 ***
LCDWF17:            equ    $000008A1                                ;*** LCDWF17 - LCD Waveform Register 17; 0x000008A1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF17_BPALCD17:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF17_BPBLCD17:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF17_BPCLCD17:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF17_BPDLCD17:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF17_BPELCD17:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF17_BPFLCD17:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF17_BPGLCD17:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF17_BPHLCD17:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF17_BPALCD17:  equ    %00000001
mLCDWF17_BPBLCD17:  equ    %00000010
mLCDWF17_BPCLCD17:  equ    %00000100
mLCDWF17_BPDLCD17:  equ    %00001000
mLCDWF17_BPELCD17:  equ    %00010000
mLCDWF17_BPFLCD17:  equ    %00100000
mLCDWF17_BPGLCD17:  equ    %01000000
mLCDWF17_BPHLCD17:  equ    %10000000


;*** LCDWF18 - LCD Waveform Register 18; 0x000008A2 ***
LCDWF18:            equ    $000008A2                                ;*** LCDWF18 - LCD Waveform Register 18; 0x000008A2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF18_BPALCD18:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF18_BPBLCD18:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF18_BPCLCD18:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF18_BPDLCD18:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF18_BPELCD18:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF18_BPFLCD18:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF18_BPGLCD18:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF18_BPHLCD18:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF18_BPALCD18:  equ    %00000001
mLCDWF18_BPBLCD18:  equ    %00000010
mLCDWF18_BPCLCD18:  equ    %00000100
mLCDWF18_BPDLCD18:  equ    %00001000
mLCDWF18_BPELCD18:  equ    %00010000
mLCDWF18_BPFLCD18:  equ    %00100000
mLCDWF18_BPGLCD18:  equ    %01000000
mLCDWF18_BPHLCD18:  equ    %10000000


;*** LCDWF19 - LCD Waveform Register 19; 0x000008A3 ***
LCDWF19:            equ    $000008A3                                ;*** LCDWF19 - LCD Waveform Register 19; 0x000008A3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF19_BPALCD19:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF19_BPBLCD19:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF19_BPCLCD19:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF19_BPDLCD19:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF19_BPELCD19:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF19_BPFLCD19:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF19_BPGLCD19:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF19_BPHLCD19:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF19_BPALCD19:  equ    %00000001
mLCDWF19_BPBLCD19:  equ    %00000010
mLCDWF19_BPCLCD19:  equ    %00000100
mLCDWF19_BPDLCD19:  equ    %00001000
mLCDWF19_BPELCD19:  equ    %00010000
mLCDWF19_BPFLCD19:  equ    %00100000
mLCDWF19_BPGLCD19:  equ    %01000000
mLCDWF19_BPHLCD19:  equ    %10000000


;*** LCDWF20 - LCD Waveform Register 20; 0x000008A4 ***
LCDWF20:            equ    $000008A4                                ;*** LCDWF20 - LCD Waveform Register 20; 0x000008A4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF20_BPALCD20:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF20_BPBLCD20:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF20_BPCLCD20:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF20_BPDLCD20:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF20_BPELCD20:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF20_BPFLCD20:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF20_BPGLCD20:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF20_BPHLCD20:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF20_BPALCD20:  equ    %00000001
mLCDWF20_BPBLCD20:  equ    %00000010
mLCDWF20_BPCLCD20:  equ    %00000100
mLCDWF20_BPDLCD20:  equ    %00001000
mLCDWF20_BPELCD20:  equ    %00010000
mLCDWF20_BPFLCD20:  equ    %00100000
mLCDWF20_BPGLCD20:  equ    %01000000
mLCDWF20_BPHLCD20:  equ    %10000000


;*** LCDWF21 - LCD Waveform Register 21; 0x000008A5 ***
LCDWF21:            equ    $000008A5                                ;*** LCDWF21 - LCD Waveform Register 21; 0x000008A5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF21_BPALCD21:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF21_BPBLCD21:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF21_BPCLCD21:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF21_BPDLCD21:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF21_BPELCD21:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF21_BPFLCD21:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF21_BPGLCD21:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF21_BPHLCD21:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF21_BPALCD21:  equ    %00000001
mLCDWF21_BPBLCD21:  equ    %00000010
mLCDWF21_BPCLCD21:  equ    %00000100
mLCDWF21_BPDLCD21:  equ    %00001000
mLCDWF21_BPELCD21:  equ    %00010000
mLCDWF21_BPFLCD21:  equ    %00100000
mLCDWF21_BPGLCD21:  equ    %01000000
mLCDWF21_BPHLCD21:  equ    %10000000


;*** LCDWF22 - LCD Waveform Register 22; 0x000008A6 ***
LCDWF22:            equ    $000008A6                                ;*** LCDWF22 - LCD Waveform Register 22; 0x000008A6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF22_BPALCD22:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF22_BPBLCD22:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF22_BPCLCD22:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF22_BPDLCD22:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF22_BPELCD22:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF22_BPFLCD22:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF22_BPGLCD22:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF22_BPHLCD22:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF22_BPALCD22:  equ    %00000001
mLCDWF22_BPBLCD22:  equ    %00000010
mLCDWF22_BPCLCD22:  equ    %00000100
mLCDWF22_BPDLCD22:  equ    %00001000
mLCDWF22_BPELCD22:  equ    %00010000
mLCDWF22_BPFLCD22:  equ    %00100000
mLCDWF22_BPGLCD22:  equ    %01000000
mLCDWF22_BPHLCD22:  equ    %10000000


;*** LCDWF23 - LCD Waveform Register 23; 0x000008A7 ***
LCDWF23:            equ    $000008A7                                ;*** LCDWF23 - LCD Waveform Register 23; 0x000008A7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF23_BPALCD23:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF23_BPBLCD23:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF23_BPCLCD23:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF23_BPDLCD23:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF23_BPELCD23:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF23_BPFLCD23:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF23_BPGLCD23:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF23_BPHLCD23:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF23_BPALCD23:  equ    %00000001
mLCDWF23_BPBLCD23:  equ    %00000010
mLCDWF23_BPCLCD23:  equ    %00000100
mLCDWF23_BPDLCD23:  equ    %00001000
mLCDWF23_BPELCD23:  equ    %00010000
mLCDWF23_BPFLCD23:  equ    %00100000
mLCDWF23_BPGLCD23:  equ    %01000000
mLCDWF23_BPHLCD23:  equ    %10000000


;*** LCDWF24 - LCD Waveform Register 24; 0x000008A8 ***
LCDWF24:            equ    $000008A8                                ;*** LCDWF24 - LCD Waveform Register 24; 0x000008A8 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF24_BPALCD24:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF24_BPBLCD24:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF24_BPCLCD24:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF24_BPDLCD24:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF24_BPELCD24:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF24_BPFLCD24:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF24_BPGLCD24:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF24_BPHLCD24:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF24_BPALCD24:  equ    %00000001
mLCDWF24_BPBLCD24:  equ    %00000010
mLCDWF24_BPCLCD24:  equ    %00000100
mLCDWF24_BPDLCD24:  equ    %00001000
mLCDWF24_BPELCD24:  equ    %00010000
mLCDWF24_BPFLCD24:  equ    %00100000
mLCDWF24_BPGLCD24:  equ    %01000000
mLCDWF24_BPHLCD24:  equ    %10000000


;*** LCDWF25 - LCD Waveform Register 25; 0x000008A9 ***
LCDWF25:            equ    $000008A9                                ;*** LCDWF25 - LCD Waveform Register 25; 0x000008A9 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF25_BPALCD25:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF25_BPBLCD25:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF25_BPCLCD25:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF25_BPDLCD25:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF25_BPELCD25:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF25_BPFLCD25:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF25_BPGLCD25:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF25_BPHLCD25:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF25_BPALCD25:  equ    %00000001
mLCDWF25_BPBLCD25:  equ    %00000010
mLCDWF25_BPCLCD25:  equ    %00000100
mLCDWF25_BPDLCD25:  equ    %00001000
mLCDWF25_BPELCD25:  equ    %00010000
mLCDWF25_BPFLCD25:  equ    %00100000
mLCDWF25_BPGLCD25:  equ    %01000000
mLCDWF25_BPHLCD25:  equ    %10000000


;*** LCDWF26 - LCD Waveform Register 26; 0x000008AA ***
LCDWF26:            equ    $000008AA                                ;*** LCDWF26 - LCD Waveform Register 26; 0x000008AA ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF26_BPALCD26:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF26_BPBLCD26:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF26_BPCLCD26:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF26_BPDLCD26:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF26_BPELCD26:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF26_BPFLCD26:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF26_BPGLCD26:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF26_BPHLCD26:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF26_BPALCD26:  equ    %00000001
mLCDWF26_BPBLCD26:  equ    %00000010
mLCDWF26_BPCLCD26:  equ    %00000100
mLCDWF26_BPDLCD26:  equ    %00001000
mLCDWF26_BPELCD26:  equ    %00010000
mLCDWF26_BPFLCD26:  equ    %00100000
mLCDWF26_BPGLCD26:  equ    %01000000
mLCDWF26_BPHLCD26:  equ    %10000000


;*** LCDWF27 - LCD Waveform Register 27; 0x000008AB ***
LCDWF27:            equ    $000008AB                                ;*** LCDWF27 - LCD Waveform Register 27; 0x000008AB ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF27_BPALCD27:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF27_BPBLCD27:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF27_BPCLCD27:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF27_BPDLCD27:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF27_BPELCD27:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF27_BPFLCD27:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF27_BPGLCD27:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF27_BPHLCD27:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF27_BPALCD27:  equ    %00000001
mLCDWF27_BPBLCD27:  equ    %00000010
mLCDWF27_BPCLCD27:  equ    %00000100
mLCDWF27_BPDLCD27:  equ    %00001000
mLCDWF27_BPELCD27:  equ    %00010000
mLCDWF27_BPFLCD27:  equ    %00100000
mLCDWF27_BPGLCD27:  equ    %01000000
mLCDWF27_BPHLCD27:  equ    %10000000


;*** LCDWF28 - LCD Waveform Register 28; 0x000008AC ***
LCDWF28:            equ    $000008AC                                ;*** LCDWF28 - LCD Waveform Register 28; 0x000008AC ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF28_BPALCD28:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF28_BPBLCD28:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF28_BPCLCD28:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF28_BPDLCD28:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF28_BPELCD28:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF28_BPFLCD28:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF28_BPGLCD28:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF28_BPHLCD28:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF28_BPALCD28:  equ    %00000001
mLCDWF28_BPBLCD28:  equ    %00000010
mLCDWF28_BPCLCD28:  equ    %00000100
mLCDWF28_BPDLCD28:  equ    %00001000
mLCDWF28_BPELCD28:  equ    %00010000
mLCDWF28_BPFLCD28:  equ    %00100000
mLCDWF28_BPGLCD28:  equ    %01000000
mLCDWF28_BPHLCD28:  equ    %10000000


;*** LCDWF29 - LCD Waveform Register 29; 0x000008AD ***
LCDWF29:            equ    $000008AD                                ;*** LCDWF29 - LCD Waveform Register 29; 0x000008AD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF29_BPALCD29:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF29_BPBLCD29:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF29_BPCLCD29:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF29_BPDLCD29:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF29_BPELCD29:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF29_BPFLCD29:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF29_BPGLCD29:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF29_BPHLCD29:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF29_BPALCD29:  equ    %00000001
mLCDWF29_BPBLCD29:  equ    %00000010
mLCDWF29_BPCLCD29:  equ    %00000100
mLCDWF29_BPDLCD29:  equ    %00001000
mLCDWF29_BPELCD29:  equ    %00010000
mLCDWF29_BPFLCD29:  equ    %00100000
mLCDWF29_BPGLCD29:  equ    %01000000
mLCDWF29_BPHLCD29:  equ    %10000000


;*** LCDWF30 - LCD Waveform Register 30; 0x000008AE ***
LCDWF30:            equ    $000008AE                                ;*** LCDWF30 - LCD Waveform Register 30; 0x000008AE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF30_BPALCD30:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF30_BPBLCD30:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF30_BPCLCD30:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF30_BPDLCD30:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF30_BPELCD30:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF30_BPFLCD30:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF30_BPGLCD30:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF30_BPHLCD30:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF30_BPALCD30:  equ    %00000001
mLCDWF30_BPBLCD30:  equ    %00000010
mLCDWF30_BPCLCD30:  equ    %00000100
mLCDWF30_BPDLCD30:  equ    %00001000
mLCDWF30_BPELCD30:  equ    %00010000
mLCDWF30_BPFLCD30:  equ    %00100000
mLCDWF30_BPGLCD30:  equ    %01000000
mLCDWF30_BPHLCD30:  equ    %10000000


;*** LCDWF31 - LCD Waveform Register 31; 0x000008AF ***
LCDWF31:            equ    $000008AF                                ;*** LCDWF31 - LCD Waveform Register 31; 0x000008AF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LCDWF31_BPALCD31:   equ    0                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF31_BPBLCD31:   equ    1                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF31_BPCLCD31:   equ    2                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF31_BPDLCD31:   equ    3                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF31_BPELCD31:   equ    4                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF31_BPFLCD31:   equ    5                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF31_BPGLCD31:   equ    6                                         ; Segment on/off Frontplane/Backplane Operation
LCDWF31_BPHLCD31:   equ    7                                         ; Segment on/off Frontplane/Backplane Operation
; bit position masks
mLCDWF31_BPALCD31:  equ    %00000001
mLCDWF31_BPBLCD31:  equ    %00000010
mLCDWF31_BPCLCD31:  equ    %00000100
mLCDWF31_BPDLCD31:  equ    %00001000
mLCDWF31_BPELCD31:  equ    %00010000
mLCDWF31_BPFLCD31:  equ    %00100000
mLCDWF31_BPGLCD31:  equ    %01000000
mLCDWF31_BPHLCD31:  equ    %10000000


;*** SRS - System Reset Status Register; 0x00001800 ***
SRS:                equ    $00001800                                ;*** SRS - System Reset Status Register; 0x00001800 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRS_LVD:            equ    1                                         ; Low Voltage Detect
SRS_ILAD:           equ    3                                         ; Illegal Address
SRS_ILOP:           equ    4                                         ; Illegal Opcode
SRS_COP:            equ    5                                         ; Computer Operating Properly (COP) Watchdog
SRS_PIN:            equ    6                                         ; External Reset Pin
SRS_POR:            equ    7                                         ; Power-On Reset
; bit position masks
mSRS_LVD:           equ    %00000010
mSRS_ILAD:          equ    %00001000
mSRS_ILOP:          equ    %00010000
mSRS_COP:           equ    %00100000
mSRS_PIN:           equ    %01000000
mSRS_POR:           equ    %10000000


;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
SBDFR:              equ    $00001801                                ;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SBDFR_BDFR:         equ    0                                         ; Background Debug Force Reset
; bit position masks
mSBDFR_BDFR:        equ    %00000001


;*** SOPT1 - System Options Register 1; 0x00001802 ***
SOPT1:              equ    $00001802                                ;*** SOPT1 - System Options Register 1; 0x00001802 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT1_RSTPE:        equ    0                                         ; RESET Pin Enable
SOPT1_BKGDPE:       equ    1                                         ; Background Debug Mode Pin Enable
SOPT1_STOPE:        equ    5                                         ; Stop Mode Enable
SOPT1_COPT:         equ    6                                         ; COP Watchdog Timeout
SOPT1_COPE:         equ    7                                         ; COP Watchdog Enable
; bit position masks
mSOPT1_RSTPE:       equ    %00000001
mSOPT1_BKGDPE:      equ    %00000010
mSOPT1_STOPE:       equ    %00100000
mSOPT1_COPT:        equ    %01000000
mSOPT1_COPE:        equ    %10000000


;*** SOPT2 - System Options Register 2; 0x00001803 ***
SOPT2:              equ    $00001803                                ;*** SOPT2 - System Options Register 2; 0x00001803 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT2_ACIC:         equ    0                                         ; Analog Comparator to Input Capture Enable
SOPT2_IICPS:        equ    1                                         ; IIC Pin Select
SOPT2_SPIPS:        equ    2                                         ; SPI Pin Select
SOPT2_COPCLKS:      equ    7                                         ; COP Watchdog Clock Select
; bit position masks
mSOPT2_ACIC:        equ    %00000001
mSOPT2_IICPS:       equ    %00000010
mSOPT2_SPIPS:       equ    %00000100
mSOPT2_COPCLKS:     equ    %10000000


;*** SDID - System Device Identification Register; 0x00001806 ***
SDID:               equ    $00001806                                ;*** SDID - System Device Identification Register; 0x00001806 ***


;*** SDIDH - System Device Identification Register High; 0x00001806 ***
SDIDH:              equ    $00001806                                ;*** SDIDH - System Device Identification Register High; 0x00001806 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDH_ID8:          equ    0                                         ; Part Identification Number, bit 8
SDIDH_ID9:          equ    1                                         ; Part Identification Number, bit 9
SDIDH_ID10:         equ    2                                         ; Part Identification Number, bit 10
SDIDH_ID11:         equ    3                                         ; Part Identification Number, bit 11
; bit position masks
mSDIDH_ID8:         equ    %00000001
mSDIDH_ID9:         equ    %00000010
mSDIDH_ID10:        equ    %00000100
mSDIDH_ID11:        equ    %00001000


;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
SDIDL:              equ    $00001807                                ;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDL_ID0:          equ    0                                         ; Part Identification Number, bit 0
SDIDL_ID1:          equ    1                                         ; Part Identification Number, bit 1
SDIDL_ID2:          equ    2                                         ; Part Identification Number, bit 2
SDIDL_ID3:          equ    3                                         ; Part Identification Number, bit 3
SDIDL_ID4:          equ    4                                         ; Part Identification Number, bit 4
SDIDL_ID5:          equ    5                                         ; Part Identification Number, bit 5
SDIDL_ID6:          equ    6                                         ; Part Identification Number, bit 6
SDIDL_ID7:          equ    7                                         ; Part Identification Number, bit 7
; bit position masks
mSDIDL_ID0:         equ    %00000001
mSDIDL_ID1:         equ    %00000010
mSDIDL_ID2:         equ    %00000100
mSDIDL_ID3:         equ    %00001000
mSDIDL_ID4:         equ    %00010000
mSDIDL_ID5:         equ    %00100000
mSDIDL_ID6:         equ    %01000000
mSDIDL_ID7:         equ    %10000000


;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001808 ***
SPMSC1:             equ    $00001808                                ;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001808 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC1_BGBE:        equ    0                                         ; Bandgap Buffer Enable
SPMSC1_LVDE:        equ    2                                         ; Low-Voltage Detect Enable
SPMSC1_LVDSE:       equ    3                                         ; Low-Voltage Detect Stop Enable
SPMSC1_LVDRE:       equ    4                                         ; Low-Voltage Detect Reset Enable
SPMSC1_LVDIE:       equ    5                                         ; Low-Voltage Detect Interrupt Enable
SPMSC1_LVDACK:      equ    6                                         ; Low-Voltage Detect Acknowledge
SPMSC1_LVDF:        equ    7                                         ; Low-Voltage Detect Flag
; bit position masks
mSPMSC1_BGBE:       equ    %00000001
mSPMSC1_LVDE:       equ    %00000100
mSPMSC1_LVDSE:      equ    %00001000
mSPMSC1_LVDRE:      equ    %00010000
mSPMSC1_LVDIE:      equ    %00100000
mSPMSC1_LVDACK:     equ    %01000000
mSPMSC1_LVDF:       equ    %10000000


;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x00001809 ***
SPMSC2:             equ    $00001809                                ;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x00001809 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC2_PPDC:        equ    0                                         ; Partial Power Down Control
SPMSC2_PPDE:        equ    1                                         ; Partial Power-Down Enable
SPMSC2_PPDACK:      equ    2                                         ; Partial Power Down Acknowledge
SPMSC2_PPDF:        equ    3                                         ; Partial Power Down Flag
SPMSC2_LPWUI:       equ    5                                         ; Low Power Wake Up on Interrupt
SPMSC2_LPRS:        equ    6                                         ; Low Power Regulator Status
SPMSC2_LPR:         equ    7                                         ; Low Power Regulator Control
; bit position masks
mSPMSC2_PPDC:       equ    %00000001
mSPMSC2_PPDE:       equ    %00000010
mSPMSC2_PPDACK:     equ    %00000100
mSPMSC2_PPDF:       equ    %00001000
mSPMSC2_LPWUI:      equ    %00100000
mSPMSC2_LPRS:       equ    %01000000
mSPMSC2_LPR:        equ    %10000000


;*** SPMSC3 - System Power Management Status and Control 3 Register; 0x0000180B ***
SPMSC3:             equ    $0000180B                                ;*** SPMSC3 - System Power Management Status and Control 3 Register; 0x0000180B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC3_LVWIE:       equ    3                                         ; Low-Voltage Warning Interrupt Enable
SPMSC3_LVWACK:      equ    6                                         ; Low-Voltage Warning Acknowledge
SPMSC3_LVWF:        equ    7                                         ; Low-Voltage Warning Flag
; bit position masks
mSPMSC3_LVWIE:      equ    %00001000
mSPMSC3_LVWACK:     equ    %01000000
mSPMSC3_LVWF:       equ    %10000000


;*** SCGC1 - System Clock Gating Control 1 Register; 0x0000180E ***
SCGC1:              equ    $0000180E                                ;*** SCGC1 - System Clock Gating Control 1 Register; 0x0000180E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCGC1_SCI:          equ    0                                         ; SCI Clock Gate Control
SCGC1_IIC:          equ    2                                         ; IIC Clock Gate Control
SCGC1_ADC:          equ    4                                         ; ADC Clock Gate Control
SCGC1_TPM1:         equ    5                                         ; TPM1 Clock Gate Control
SCGC1_TPM2:         equ    6                                         ; TPM2 Clock Gate Control
; bit position masks
mSCGC1_SCI:         equ    %00000001
mSCGC1_IIC:         equ    %00000100
mSCGC1_ADC:         equ    %00010000
mSCGC1_TPM1:        equ    %00100000
mSCGC1_TPM2:        equ    %01000000


;*** SCGC2 - System Clock Gating Control 2 Register; 0x0000180F ***
SCGC2:              equ    $0000180F                                ;*** SCGC2 - System Clock Gating Control 2 Register; 0x0000180F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCGC2_SPI:          equ    0                                         ; SPI Clock Gate Control
SCGC2_LCD:          equ    1                                         ; LCDClockGateControl
SCGC2_TOD:          equ    2                                         ; TODClockGateControl
SCGC2_ACMP:         equ    3                                         ; ACMP Clock Gate Control
SCGC2_KBI:          equ    4                                         ; KBI Clock Gate Control
SCGC2_IRQ:          equ    5                                         ; IRQ Clock Gate Control
SCGC2_FLS:          equ    6                                         ; FLASH Register Clock Gate Control
SCGC2_DBG:          equ    7                                         ; DBG Clock Gate Control
; bit position masks
mSCGC2_SPI:         equ    %00000001
mSCGC2_LCD:         equ    %00000010
mSCGC2_TOD:         equ    %00000100
mSCGC2_ACMP:        equ    %00001000
mSCGC2_KBI:         equ    %00010000
mSCGC2_IRQ:         equ    %00100000
mSCGC2_FLS:         equ    %01000000
mSCGC2_DBG:         equ    %10000000


;*** DBGCA - Debug Comparator A Register; 0x00001810 ***
DBGCA:              equ    $00001810                                ;*** DBGCA - Debug Comparator A Register; 0x00001810 ***


;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
DBGCAH:             equ    $00001810                                ;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_Bit8:        equ    0                                         ; Comparator A High Compare Bit 8
DBGCAH_Bit9:        equ    1                                         ; Comparator A High Compare Bit 9
DBGCAH_Bit10:       equ    2                                         ; Comparator A High Compare Bit 10
DBGCAH_Bit11:       equ    3                                         ; Comparator A High Compare Bit 11
DBGCAH_Bit12:       equ    4                                         ; Comparator A High Compare Bit 12
DBGCAH_Bit13:       equ    5                                         ; Comparator A High Compare Bit 13
DBGCAH_Bit14:       equ    6                                         ; Comparator A High Compare Bit 14
DBGCAH_Bit15:       equ    7                                         ; Comparator A High Compare Bit 15
; bit position masks
mDBGCAH_Bit8:       equ    %00000001
mDBGCAH_Bit9:       equ    %00000010
mDBGCAH_Bit10:      equ    %00000100
mDBGCAH_Bit11:      equ    %00001000
mDBGCAH_Bit12:      equ    %00010000
mDBGCAH_Bit13:      equ    %00100000
mDBGCAH_Bit14:      equ    %01000000
mDBGCAH_Bit15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
DBGCAL:             equ    $00001811                                ;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_Bit0:        equ    0                                         ; Comparator A Low Compare Bit 0
DBGCAL_Bit1:        equ    1                                         ; Comparator A Low Compare Bit 1
DBGCAL_Bit2:        equ    2                                         ; Comparator A Low Compare Bit 2
DBGCAL_Bit3:        equ    3                                         ; Comparator A Low Compare Bit 3
DBGCAL_Bit4:        equ    4                                         ; Comparator A Low Compare Bit 4
DBGCAL_Bit5:        equ    5                                         ; Comparator A Low Compare Bit 5
DBGCAL_Bit6:        equ    6                                         ; Comparator A Low Compare Bit 6
DBGCAL_Bit7:        equ    7                                         ; Comparator A Low Compare Bit 7
; bit position masks
mDBGCAL_Bit0:       equ    %00000001
mDBGCAL_Bit1:       equ    %00000010
mDBGCAL_Bit2:       equ    %00000100
mDBGCAL_Bit3:       equ    %00001000
mDBGCAL_Bit4:       equ    %00010000
mDBGCAL_Bit5:       equ    %00100000
mDBGCAL_Bit6:       equ    %01000000
mDBGCAL_Bit7:       equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x00001812 ***
DBGCB:              equ    $00001812                                ;*** DBGCB - Debug Comparator B Register; 0x00001812 ***


;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
DBGCBH:             equ    $00001812                                ;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_Bit8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_Bit9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_Bit10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_Bit11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_Bit12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_Bit13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_Bit14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_Bit15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_Bit8:       equ    %00000001
mDBGCBH_Bit9:       equ    %00000010
mDBGCBH_Bit10:      equ    %00000100
mDBGCBH_Bit11:      equ    %00001000
mDBGCBH_Bit12:      equ    %00010000
mDBGCBH_Bit13:      equ    %00100000
mDBGCBH_Bit14:      equ    %01000000
mDBGCBH_Bit15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
DBGCBL:             equ    $00001813                                ;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_Bit0:        equ    0                                         ; Comparator B Low Compare Bit 0
DBGCBL_Bit1:        equ    1                                         ; Comparator B Low Compare Bit 1
DBGCBL_Bit2:        equ    2                                         ; Comparator B Low Compare Bit 2
DBGCBL_Bit3:        equ    3                                         ; Comparator B Low Compare Bit 3
DBGCBL_Bit4:        equ    4                                         ; Comparator B Low Compare Bit 4
DBGCBL_Bit5:        equ    5                                         ; Comparator B Low Compare Bit 5
DBGCBL_Bit6:        equ    6                                         ; Comparator B Low Compare Bit 6
DBGCBL_Bit7:        equ    7                                         ; Comparator B Low Compare Bit 7
; bit position masks
mDBGCBL_Bit0:       equ    %00000001
mDBGCBL_Bit1:       equ    %00000010
mDBGCBL_Bit2:       equ    %00000100
mDBGCBL_Bit3:       equ    %00001000
mDBGCBL_Bit4:       equ    %00010000
mDBGCBL_Bit5:       equ    %00100000
mDBGCBL_Bit6:       equ    %01000000
mDBGCBL_Bit7:       equ    %10000000


;*** DBGCC - Debug Comparator C Register; 0x00001814 ***
DBGCC:              equ    $00001814                                ;*** DBGCC - Debug Comparator C Register; 0x00001814 ***


;*** DBGCCH - Debug Comparator C High Register; 0x00001814 ***
DBGCCH:             equ    $00001814                                ;*** DBGCCH - Debug Comparator C High Register; 0x00001814 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCH_Bit8:        equ    0                                         ; Comparator C High Compare Bit 8
DBGCCH_Bit9:        equ    1                                         ; Comparator C High Compare Bit 9
DBGCCH_Bit10:       equ    2                                         ; Comparator C High Compare Bit 10
DBGCCH_Bit11:       equ    3                                         ; Comparator C High Compare Bit 11
DBGCCH_Bit12:       equ    4                                         ; Comparator C High Compare Bit 12
DBGCCH_Bit13:       equ    5                                         ; Comparator C High Compare Bit 13
DBGCCH_Bit14:       equ    6                                         ; Comparator C High Compare Bit 14
DBGCCH_Bit15:       equ    7                                         ; Comparator C High Compare Bit 15
; bit position masks
mDBGCCH_Bit8:       equ    %00000001
mDBGCCH_Bit9:       equ    %00000010
mDBGCCH_Bit10:      equ    %00000100
mDBGCCH_Bit11:      equ    %00001000
mDBGCCH_Bit12:      equ    %00010000
mDBGCCH_Bit13:      equ    %00100000
mDBGCCH_Bit14:      equ    %01000000
mDBGCCH_Bit15:      equ    %10000000


;*** DBGCCL - Debug Comparator C Low Register; 0x00001815 ***
DBGCCL:             equ    $00001815                                ;*** DBGCCL - Debug Comparator C Low Register; 0x00001815 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCL_Bit0:        equ    0                                         ; Comparator C Low Compare Bit 0
DBGCCL_Bit1:        equ    1                                         ; Comparator C Low Compare Bit 1
DBGCCL_Bit2:        equ    2                                         ; Comparator C Low Compare Bit 2
DBGCCL_Bit3:        equ    3                                         ; Comparator C Low Compare Bit 3
DBGCCL_Bit4:        equ    4                                         ; Comparator C Low Compare Bit 4
DBGCCL_Bit5:        equ    5                                         ; Comparator C Low Compare Bit 5
DBGCCL_Bit6:        equ    6                                         ; Comparator C Low Compare Bit 6
DBGCCL_Bit7:        equ    7                                         ; Comparator C Low Compare Bit 7
; bit position masks
mDBGCCL_Bit0:       equ    %00000001
mDBGCCL_Bit1:       equ    %00000010
mDBGCCL_Bit2:       equ    %00000100
mDBGCCL_Bit3:       equ    %00001000
mDBGCCL_Bit4:       equ    %00010000
mDBGCCL_Bit5:       equ    %00100000
mDBGCCL_Bit6:       equ    %01000000
mDBGCCL_Bit7:       equ    %10000000


;*** DBGF - Debug FIFO Register; 0x00001816 ***
DBGF:               equ    $00001816                                ;*** DBGF - Debug FIFO Register; 0x00001816 ***


;*** DBGFH - Debug FIFO High Register; 0x00001816 ***
DBGFH:              equ    $00001816                                ;*** DBGFH - Debug FIFO High Register; 0x00001816 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFH_Bit8:         equ    0                                         ; FIFO High Data Bit 8
DBGFH_Bit9:         equ    1                                         ; FIFO High Data Bit 9
DBGFH_Bit10:        equ    2                                         ; FIFO High Data Bit 10
DBGFH_Bit11:        equ    3                                         ; FIFO High Data Bit 11
DBGFH_Bit12:        equ    4                                         ; FIFO High Data Bit 12
DBGFH_Bit13:        equ    5                                         ; FIFO High Data Bit 13
DBGFH_Bit14:        equ    6                                         ; FIFO High Data Bit 14
DBGFH_Bit15:        equ    7                                         ; FIFO High Data Bit 15
; bit position masks
mDBGFH_Bit8:        equ    %00000001
mDBGFH_Bit9:        equ    %00000010
mDBGFH_Bit10:       equ    %00000100
mDBGFH_Bit11:       equ    %00001000
mDBGFH_Bit12:       equ    %00010000
mDBGFH_Bit13:       equ    %00100000
mDBGFH_Bit14:       equ    %01000000
mDBGFH_Bit15:       equ    %10000000


;*** DBGFL - Debug FIFO Low Register; 0x00001817 ***
DBGFL:              equ    $00001817                                ;*** DBGFL - Debug FIFO Low Register; 0x00001817 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFL_Bit0:         equ    0                                         ; FIFO Low Data Bit 0
DBGFL_Bit1:         equ    1                                         ; FIFO Low Data Bit 1
DBGFL_Bit2:         equ    2                                         ; FIFO Low Data Bit 2
DBGFL_Bit3:         equ    3                                         ; FIFO Low Data Bit 3
DBGFL_Bit4:         equ    4                                         ; FIFO Low Data Bit 4
DBGFL_Bit5:         equ    5                                         ; FIFO Low Data Bit 5
DBGFL_Bit6:         equ    6                                         ; FIFO Low Data Bit 6
DBGFL_Bit7:         equ    7                                         ; FIFO Low Data Bit 7
; bit position masks
mDBGFL_Bit0:        equ    %00000001
mDBGFL_Bit1:        equ    %00000010
mDBGFL_Bit2:        equ    %00000100
mDBGFL_Bit3:        equ    %00001000
mDBGFL_Bit4:        equ    %00010000
mDBGFL_Bit5:        equ    %00100000
mDBGFL_Bit6:        equ    %01000000
mDBGFL_Bit7:        equ    %10000000


;*** DBGCAX - Debug Comparator A Extension Register; 0x00001818 ***
DBGCAX:             equ    $00001818                                ;*** DBGCAX - Debug Comparator A Extension Register; 0x00001818 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAX_RWA:         equ    6                                         ; Read/Write Comparator A Value Bit
DBGCAX_RWAEN:       equ    7                                         ; Read/Write Comparator A Enable Bit
; bit position masks
mDBGCAX_RWA:        equ    %01000000
mDBGCAX_RWAEN:      equ    %10000000


;*** DBGCBX - Debug Comparator B Extension Register; 0x00001819 ***
DBGCBX:             equ    $00001819                                ;*** DBGCBX - Debug Comparator B Extension Register; 0x00001819 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBX_RWB:         equ    6                                         ; Read/Write Comparator B Value Bit
DBGCBX_RWBEN:       equ    7                                         ; Read/Write Comparator B Enable Bit
; bit position masks
mDBGCBX_RWB:        equ    %01000000
mDBGCBX_RWBEN:      equ    %10000000


;*** DBGCCX - Debug Comparator C Extension Register; 0x0000181A ***
DBGCCX:             equ    $0000181A                                ;*** DBGCCX - Debug Comparator C Extension Register; 0x0000181A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCX_RWC:         equ    6                                         ; Read/Write Comparator C Value Bit
DBGCCX_RWCEN:       equ    7                                         ; Read/Write Comparator C Enable Bit
; bit position masks
mDBGCCX_RWC:        equ    %01000000
mDBGCCX_RWCEN:      equ    %10000000


;*** DBGC - Debug Control Register; 0x0000181C ***
DBGC:               equ    $0000181C                                ;*** DBGC - Debug Control Register; 0x0000181C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC_LOOP1:         equ    0                                         ; Select LOOP1 Capture Mode
DBGC_BRKEN:         equ    4                                         ; Break Enable Bit
DBGC_TAG:           equ    5                                         ; Tag or Force Bit
DBGC_ARM:           equ    6                                         ; Arm Bit
DBGC_DBGEN:         equ    7                                         ; DBG Module Enable Bit
; bit position masks
mDBGC_LOOP1:        equ    %00000001
mDBGC_BRKEN:        equ    %00010000
mDBGC_TAG:          equ    %00100000
mDBGC_ARM:          equ    %01000000
mDBGC_DBGEN:        equ    %10000000


;*** DBGT - Debug Trigger Register; 0x0000181D ***
DBGT:               equ    $0000181D                                ;*** DBGT - Debug Trigger Register; 0x0000181D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGT_TRG0:          equ    0                                         ; Trigger Mode Bit 0
DBGT_TRG1:          equ    1                                         ; Trigger Mode Bit 1
DBGT_TRG2:          equ    2                                         ; Trigger Mode Bit 2
DBGT_TRG3:          equ    3                                         ; Trigger Mode Bit 3
DBGT_BEGIN:         equ    6                                         ; Begin/End Trigger Bit
DBGT_TRGSEL:        equ    7                                         ; Trigger Selection Bit
; bit position masks
mDBGT_TRG0:         equ    %00000001
mDBGT_TRG1:         equ    %00000010
mDBGT_TRG2:         equ    %00000100
mDBGT_TRG3:         equ    %00001000
mDBGT_BEGIN:        equ    %01000000
mDBGT_TRGSEL:       equ    %10000000


;*** DBGS - Debug Status Register; 0x0000181E ***
DBGS:               equ    $0000181E                                ;*** DBGS - Debug Status Register; 0x0000181E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGS_ARMF:          equ    0                                         ; Arm Flag Bit
DBGS_CF:            equ    5                                         ; Trigger C Match Bit
DBGS_BF:            equ    6                                         ; Trigger B Match Bit
DBGS_AF:            equ    7                                         ; Trigger A Match Bit
; bit position masks
mDBGS_ARMF:         equ    %00000001
mDBGS_CF:           equ    %00100000
mDBGS_BF:           equ    %01000000
mDBGS_AF:           equ    %10000000


;*** DBGCNT - Debug Count Status Register; 0x0000181F ***
DBGCNT:             equ    $0000181F                                ;*** DBGCNT - Debug Count Status Register; 0x0000181F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; FIFO Valid Count Bits, bit 0
DBGCNT_CNT1:        equ    1                                         ; FIFO Valid Count Bits, bit 1
DBGCNT_CNT2:        equ    2                                         ; FIFO Valid Count Bits, bit 2
DBGCNT_CNT3:        equ    3                                         ; FIFO Valid Count Bits, bit 3
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000


;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
FCDIV:              equ    $00001820                                ;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCDIV_DIV0:         equ    0                                         ; Divisor for FLASH Clock Divider, bit 0
FCDIV_DIV1:         equ    1                                         ; Divisor for FLASH Clock Divider, bit 1
FCDIV_DIV2:         equ    2                                         ; Divisor for FLASH Clock Divider, bit 2
FCDIV_DIV3:         equ    3                                         ; Divisor for FLASH Clock Divider, bit 3
FCDIV_DIV4:         equ    4                                         ; Divisor for FLASH Clock Divider, bit 4
FCDIV_DIV5:         equ    5                                         ; Divisor for FLASH Clock Divider, bit 5
FCDIV_PRDIV8:       equ    6                                         ; Prescale (Divide) FLASH Clock by 8
FCDIV_DIVLD:        equ    7                                         ; Divisor Loaded Status Flag
; bit position masks
mFCDIV_DIV0:        equ    %00000001
mFCDIV_DIV1:        equ    %00000010
mFCDIV_DIV2:        equ    %00000100
mFCDIV_DIV3:        equ    %00001000
mFCDIV_DIV4:        equ    %00010000
mFCDIV_DIV5:        equ    %00100000
mFCDIV_PRDIV8:      equ    %01000000
mFCDIV_DIVLD:       equ    %10000000


;*** FOPT - FLASH Options Register; 0x00001821 ***
FOPT:               equ    $00001821                                ;*** FOPT - FLASH Options Register; 0x00001821 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_SEC00:         equ    0                                         ; Security State Code, bit 0
FOPT_SEC01:         equ    1                                         ; Security State Code, bit 1
FOPT_FNORED:        equ    6                                         ; Vector Redirection Disable
FOPT_KEYEN:         equ    7                                         ; Backdoor Key Mechanism Enable
; bit position masks
mFOPT_SEC00:        equ    %00000001
mFOPT_SEC01:        equ    %00000010
mFOPT_FNORED:       equ    %01000000
mFOPT_KEYEN:        equ    %10000000


;*** FCNFG - FLASH Configuration Register; 0x00001823 ***
FCNFG:              equ    $00001823                                ;*** FCNFG - FLASH Configuration Register; 0x00001823 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Writing of Access Key
; bit position masks
mFCNFG_KEYACC:      equ    %00100000


;*** FPROT - FLASH Protection Register; 0x00001824 ***
FPROT:              equ    $00001824                                ;*** FPROT - FLASH Protection Register; 0x00001824 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPDIS:        equ    0                                         ; FLASH Protection Disable
FPROT_FPS1:         equ    1                                         ; FLASH Protect Select Bit 1
FPROT_FPS2:         equ    2                                         ; FLASH Protect Select Bit 2
FPROT_FPS3:         equ    3                                         ; FLASH Protect Select Bit 3
FPROT_FPS4:         equ    4                                         ; FLASH Protect Select Bit 4
FPROT_FPS5:         equ    5                                         ; FLASH Protect Select Bit 5
FPROT_FPS6:         equ    6                                         ; FLASH Protect Select Bit 6
FPROT_FPS7:         equ    7                                         ; FLASH Protect Select Bit 7
; bit position masks
mFPROT_FPDIS:       equ    %00000001
mFPROT_FPS1:        equ    %00000010
mFPROT_FPS2:        equ    %00000100
mFPROT_FPS3:        equ    %00001000
mFPROT_FPS4:        equ    %00010000
mFPROT_FPS5:        equ    %00100000
mFPROT_FPS6:        equ    %01000000
mFPROT_FPS7:        equ    %10000000


;*** FSTAT - Flash Status Register; 0x00001825 ***
FSTAT:              equ    $00001825                                ;*** FSTAT - Flash Status Register; 0x00001825 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_FBLANK:       equ    2                                         ; FLASH Flag Indicating the Erase Verify Operation Status
FSTAT_FACCERR:      equ    4                                         ; FLASH Access Error Flag
FSTAT_FPVIOL:       equ    5                                         ; FLASH Protection Violation Flag
FSTAT_FCCF:         equ    6                                         ; FLASH Command Complete Interrupt Flag
FSTAT_FCBEF:        equ    7                                         ; FLASH Command Buffer Empty Flag
; bit position masks
mFSTAT_FBLANK:      equ    %00000100
mFSTAT_FACCERR:     equ    %00010000
mFSTAT_FPVIOL:      equ    %00100000
mFSTAT_FCCF:        equ    %01000000
mFSTAT_FCBEF:       equ    %10000000


;*** FCMD - FLASH Command Register; 0x00001826 ***
FCMD:               equ    $00001826                                ;*** FCMD - FLASH Command Register; 0x00001826 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_FCMD0:         equ    0                                         ; FLASH Command Bit 0
FCMD_FCMD1:         equ    1                                         ; FLASH Command Bit 1
FCMD_FCMD2:         equ    2                                         ; FLASH Command Bit 2
FCMD_FCMD3:         equ    3                                         ; FLASH Command Bit 3
FCMD_FCMD4:         equ    4                                         ; FLASH Command Bit 4
FCMD_FCMD5:         equ    5                                         ; FLASH Command Bit 5
FCMD_FCMD6:         equ    6                                         ; FLASH Command Bit 6
FCMD_FCMD7:         equ    7                                         ; FLASH Command Bit 7
; bit position masks
mFCMD_FCMD0:        equ    %00000001
mFCMD_FCMD1:        equ    %00000010
mFCMD_FCMD2:        equ    %00000100
mFCMD_FCMD3:        equ    %00001000
mFCMD_FCMD4:        equ    %00010000
mFCMD_FCMD5:        equ    %00100000
mFCMD_FCMD6:        equ    %01000000
mFCMD_FCMD7:        equ    %10000000


;*** TODC - TOD Control Register; 0x00001830 ***
TODC:               equ    $00001830                                ;*** TODC - TOD Control Register; 0x00001830 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TODC_TODPS0:        equ    0                                         ; TOD Prescaler Bits, bit 0
TODC_TODPS1:        equ    1                                         ; TOD Prescaler Bits, bit 1
TODC_TODPS2:        equ    2                                         ; TOD Prescaler Bits, bit 2
TODC_TODCLKEN:      equ    3                                         ; TOD Clock Enable
TODC_TODR:          equ    4                                         ; TOD Reset
TODC_TODCLKS0:      equ    5                                         ; TOD Clock Source, bit 0
TODC_TODCLKS1:      equ    6                                         ; TOD Clock Source, bit 1
TODC_TODEN:         equ    7                                         ; Time of Day Enable
; bit position masks
mTODC_TODPS0:       equ    %00000001
mTODC_TODPS1:       equ    %00000010
mTODC_TODPS2:       equ    %00000100
mTODC_TODCLKEN:     equ    %00001000
mTODC_TODR:         equ    %00010000
mTODC_TODCLKS0:     equ    %00100000
mTODC_TODCLKS1:     equ    %01000000
mTODC_TODEN:        equ    %10000000


;*** TODSC - TOD Status and Control Register; 0x00001831 ***
TODSC:              equ    $00001831                                ;*** TODSC - TOD Status and Control Register; 0x00001831 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TODSC_MTCHWC:       equ    0                                         ; Match Write Complete
TODSC_MTCHEN:       equ    1                                         ; Match Function Enable
TODSC_MTCHIE:       equ    2                                         ; Match Interrupt Enable
TODSC_SECIE:        equ    3                                         ; Second Interrupt Enable
TODSC_QSECIE:       equ    4                                         ; Quarter-Second Interrupt Enable
TODSC_MTCHF:        equ    5                                         ; Match Interrupt Flag
TODSC_SECF:         equ    6                                         ; Second Interrupt Flag
TODSC_QSECF:        equ    7                                         ; Quarter-Second Interrupt Flag
; bit position masks
mTODSC_MTCHWC:      equ    %00000001
mTODSC_MTCHEN:      equ    %00000010
mTODSC_MTCHIE:      equ    %00000100
mTODSC_SECIE:       equ    %00001000
mTODSC_QSECIE:      equ    %00010000
mTODSC_MTCHF:       equ    %00100000
mTODSC_SECF:        equ    %01000000
mTODSC_QSECF:       equ    %10000000


;*** TODM - TOD Match Register; 0x00001832 ***
TODM:               equ    $00001832                                ;*** TODM - TOD Match Register; 0x00001832 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TODM_MQSEC0:        equ    0                                         ; Match Quarter-Second Bits, bit 0
TODM_MQSEC1:        equ    1                                         ; Match Quarter-Second Bits, bit 1
TODM_TODM0:         equ    2                                         ; TOD Match Value, bit 0
TODM_TODM1:         equ    3                                         ; TOD Match Value, bit 1
TODM_TODM2:         equ    4                                         ; TOD Match Value, bit 2
TODM_TODM3:         equ    5                                         ; TOD Match Value, bit 3
TODM_TODM4:         equ    6                                         ; TOD Match Value, bit 4
TODM_TODM5:         equ    7                                         ; TOD Match Value, bit 5
; bit position masks
mTODM_MQSEC0:       equ    %00000001
mTODM_MQSEC1:       equ    %00000010
mTODM_TODM0:        equ    %00000100
mTODM_TODM1:        equ    %00001000
mTODM_TODM2:        equ    %00010000
mTODM_TODM3:        equ    %00100000
mTODM_TODM4:        equ    %01000000
mTODM_TODM5:        equ    %10000000


;*** TODCNT - TOD Counter Register; 0x00001833 ***
TODCNT:             equ    $00001833                                ;*** TODCNT - TOD Counter Register; 0x00001833 ***


;*** PTAPE - Port A Pull Enable Register; 0x00001840 ***
PTAPE:              equ    $00001840                                ;*** PTAPE - Port A Pull Enable Register; 0x00001840 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAPE_PTAPE0:       equ    0                                         ; Internal Pull Enable for Port A Bit 0
PTAPE_PTAPE1:       equ    1                                         ; Internal Pull Enable for Port A Bit 1
PTAPE_PTAPE2:       equ    2                                         ; Internal Pull Enable for Port A Bit 2
PTAPE_PTAPE3:       equ    3                                         ; Internal Pull Enable for Port A Bit 3
PTAPE_PTAPE4:       equ    4                                         ; Internal Pull Enable for Port A Bit 4
PTAPE_PTAPE5:       equ    5                                         ; Internal Pull Enable for Port A Bit 5
PTAPE_PTAPE6:       equ    6                                         ; Internal Pull Enable for Port A Bit 6
PTAPE_PTAPE7:       equ    7                                         ; Internal Pull Enable for Port A Bit 7
; bit position masks
mPTAPE_PTAPE0:      equ    %00000001
mPTAPE_PTAPE1:      equ    %00000010
mPTAPE_PTAPE2:      equ    %00000100
mPTAPE_PTAPE3:      equ    %00001000
mPTAPE_PTAPE4:      equ    %00010000
mPTAPE_PTAPE5:      equ    %00100000
mPTAPE_PTAPE6:      equ    %01000000
mPTAPE_PTAPE7:      equ    %10000000


;*** PTASE - Port A Slew Rate Enable Register; 0x00001841 ***
PTASE:              equ    $00001841                                ;*** PTASE - Port A Slew Rate Enable Register; 0x00001841 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTASE_PTASE0:       equ    0                                         ; Output Slew Rate Enable for Port A Bit 0
PTASE_PTASE1:       equ    1                                         ; Output Slew Rate Enable for Port A Bit 1
PTASE_PTASE2:       equ    2                                         ; Output Slew Rate Enable for Port A Bit 2
PTASE_PTASE3:       equ    3                                         ; Output Slew Rate Enable for Port A Bit 3
PTASE_PTASE4:       equ    4                                         ; Output Slew Rate Enable for Port A Bit 4
PTASE_PTASE5:       equ    5                                         ; Output Slew Rate Enable for Port A Bit 5
PTASE_PTASE6:       equ    6                                         ; Output Slew Rate Enable for Port A Bit 6
PTASE_PTASE7:       equ    7                                         ; Output Slew Rate Enable for Port A Bit 7
; bit position masks
mPTASE_PTASE0:      equ    %00000001
mPTASE_PTASE1:      equ    %00000010
mPTASE_PTASE2:      equ    %00000100
mPTASE_PTASE3:      equ    %00001000
mPTASE_PTASE4:      equ    %00010000
mPTASE_PTASE5:      equ    %00100000
mPTASE_PTASE6:      equ    %01000000
mPTASE_PTASE7:      equ    %10000000


;*** PTADS - Port A Drive Strength Selection Register; 0x00001842 ***
PTADS:              equ    $00001842                                ;*** PTADS - Port A Drive Strength Selection Register; 0x00001842 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADS_PTADS0:       equ    0                                         ; Output Drive Strength Selection for Port A Bit 0
PTADS_PTADS1:       equ    1                                         ; Output Drive Strength Selection for Port A Bit 1
PTADS_PTADS2:       equ    2                                         ; Output Drive Strength Selection for Port A Bit 2
PTADS_PTADS3:       equ    3                                         ; Output Drive Strength Selection for Port A Bit 3
PTADS_PTADS4:       equ    4                                         ; Output Drive Strength Selection for Port A Bit 4
PTADS_PTADS5:       equ    5                                         ; Output Drive Strength Selection for Port A Bit 5
PTADS_PTADS6:       equ    6                                         ; Output Drive Strength Selection for Port A Bit 6
PTADS_PTADS7:       equ    7                                         ; Output Drive Strength Selection for Port A Bit 7
; bit position masks
mPTADS_PTADS0:      equ    %00000001
mPTADS_PTADS1:      equ    %00000010
mPTADS_PTADS2:      equ    %00000100
mPTADS_PTADS3:      equ    %00001000
mPTADS_PTADS4:      equ    %00010000
mPTADS_PTADS5:      equ    %00100000
mPTADS_PTADS6:      equ    %01000000
mPTADS_PTADS7:      equ    %10000000


;*** PTBPE - Port B Pull Enable Register; 0x00001844 ***
PTBPE:              equ    $00001844                                ;*** PTBPE - Port B Pull Enable Register; 0x00001844 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBPE_PTBPE0:       equ    0                                         ; Internal Pull Enable for Port B Bit 0
PTBPE_PTBPE1:       equ    1                                         ; Internal Pull Enable for Port B Bit 1
PTBPE_PTBPE2:       equ    2                                         ; Internal Pull Enable for Port B Bit 2
PTBPE_PTBPE3:       equ    3                                         ; Internal Pull Enable for Port B Bit 3
PTBPE_PTBPE4:       equ    4                                         ; Internal Pull Enable for Port B Bit 4
PTBPE_PTBPE5:       equ    5                                         ; Internal Pull Enable for Port B Bit 5
PTBPE_PTBPE6:       equ    6                                         ; Internal Pull Enable for Port B Bit 6
PTBPE_PTBPE7:       equ    7                                         ; Internal Pull Enable for Port B Bit 7
; bit position masks
mPTBPE_PTBPE0:      equ    %00000001
mPTBPE_PTBPE1:      equ    %00000010
mPTBPE_PTBPE2:      equ    %00000100
mPTBPE_PTBPE3:      equ    %00001000
mPTBPE_PTBPE4:      equ    %00010000
mPTBPE_PTBPE5:      equ    %00100000
mPTBPE_PTBPE6:      equ    %01000000
mPTBPE_PTBPE7:      equ    %10000000


;*** PTBSE - Port B Slew Rate Enable Register; 0x00001845 ***
PTBSE:              equ    $00001845                                ;*** PTBSE - Port B Slew Rate Enable Register; 0x00001845 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBSE_PTBSE0:       equ    0                                         ; Output Slew Rate Enable for Port B Bit 0
PTBSE_PTBSE1:       equ    1                                         ; Output Slew Rate Enable for Port B Bit 1
PTBSE_PTBSE2:       equ    2                                         ; Output Slew Rate Enable for Port B Bit 2
PTBSE_PTBSE3:       equ    3                                         ; Output Slew Rate Enable for Port B Bit 3
PTBSE_PTBSE4:       equ    4                                         ; Output Slew Rate Enable for Port B Bit 4
PTBSE_PTBSE5:       equ    5                                         ; Output Slew Rate Enable for Port B Bit 5
PTBSE_PTBSE6:       equ    6                                         ; Output Slew Rate Enable for Port B Bit 6
PTBSE_PTBSE7:       equ    7                                         ; Output Slew Rate Enable for Port B Bit 7
; bit position masks
mPTBSE_PTBSE0:      equ    %00000001
mPTBSE_PTBSE1:      equ    %00000010
mPTBSE_PTBSE2:      equ    %00000100
mPTBSE_PTBSE3:      equ    %00001000
mPTBSE_PTBSE4:      equ    %00010000
mPTBSE_PTBSE5:      equ    %00100000
mPTBSE_PTBSE6:      equ    %01000000
mPTBSE_PTBSE7:      equ    %10000000


;*** PTBDS - Port B Drive Strength Selection Register; 0x00001846 ***
PTBDS:              equ    $00001846                                ;*** PTBDS - Port B Drive Strength Selection Register; 0x00001846 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDS_PTBDS0:       equ    0                                         ; Output Drive Strength Selection for Port B Bit 0
PTBDS_PTBDS1:       equ    1                                         ; Output Drive Strength Selection for Port B Bit 1
PTBDS_PTBDS2:       equ    2                                         ; Output Drive Strength Selection for Port B Bit 2
PTBDS_PTBDS3:       equ    3                                         ; Output Drive Strength Selection for Port B Bit 3
PTBDS_PTBDS4:       equ    4                                         ; Output Drive Strength Selection for Port B Bit 4
PTBDS_PTBDS5:       equ    5                                         ; Output Drive Strength Selection for Port B Bit 5
PTBDS_PTBDS6:       equ    6                                         ; Output Drive Strength Selection for Port B Bit 6
PTBDS_PTBDS7:       equ    7                                         ; Output Drive Strength Selection for Port B Bit 7
; bit position masks
mPTBDS_PTBDS0:      equ    %00000001
mPTBDS_PTBDS1:      equ    %00000010
mPTBDS_PTBDS2:      equ    %00000100
mPTBDS_PTBDS3:      equ    %00001000
mPTBDS_PTBDS4:      equ    %00010000
mPTBDS_PTBDS5:      equ    %00100000
mPTBDS_PTBDS6:      equ    %01000000
mPTBDS_PTBDS7:      equ    %10000000


;*** PTCPE - Port C Pull Enable Register; 0x00001848 ***
PTCPE:              equ    $00001848                                ;*** PTCPE - Port C Pull Enable Register; 0x00001848 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCPE_PTCPE0:       equ    0                                         ; Internal Pull Enable for Port C Bit 0
PTCPE_PTCPE1:       equ    1                                         ; Internal Pull Enable for Port C Bit 1
PTCPE_PTCPE2:       equ    2                                         ; Internal Pull Enable for Port C Bit 2
PTCPE_PTCPE3:       equ    3                                         ; Internal Pull Enable for Port C Bit 3
PTCPE_PTCPE4:       equ    4                                         ; Internal Pull Enable for Port C Bit 4
PTCPE_PTCPE5:       equ    5                                         ; Internal Pull Enable for Port C Bit 5
PTCPE_PTCPE6:       equ    6                                         ; Internal Pull Enable for Port C Bit 6
PTCPE_PTCPE7:       equ    7                                         ; Internal Pull Enable for Port C Bit 7
; bit position masks
mPTCPE_PTCPE0:      equ    %00000001
mPTCPE_PTCPE1:      equ    %00000010
mPTCPE_PTCPE2:      equ    %00000100
mPTCPE_PTCPE3:      equ    %00001000
mPTCPE_PTCPE4:      equ    %00010000
mPTCPE_PTCPE5:      equ    %00100000
mPTCPE_PTCPE6:      equ    %01000000
mPTCPE_PTCPE7:      equ    %10000000


;*** PTCSE - Port C Slew Rate Enable Register; 0x00001849 ***
PTCSE:              equ    $00001849                                ;*** PTCSE - Port C Slew Rate Enable Register; 0x00001849 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCSE_PTCSE0:       equ    0                                         ; Output Slew Rate Enable for Port C Bit 0
PTCSE_PTCSE1:       equ    1                                         ; Output Slew Rate Enable for Port C Bit 1
PTCSE_PTCSE2:       equ    2                                         ; Output Slew Rate Enable for Port C Bit 2
PTCSE_PTCSE3:       equ    3                                         ; Output Slew Rate Enable for Port C Bit 3
PTCSE_PTCSE4:       equ    4                                         ; Output Slew Rate Enable for Port C Bit 4
PTCSE_PTCSE5:       equ    5                                         ; Output Slew Rate Enable for Port C Bit 5
PTCSE_PTCSE6:       equ    6                                         ; Output Slew Rate Enable for Port C Bit 6
PTCSE_PTCSE7:       equ    7                                         ; Output Slew Rate Enable for Port C Bit 7
; bit position masks
mPTCSE_PTCSE0:      equ    %00000001
mPTCSE_PTCSE1:      equ    %00000010
mPTCSE_PTCSE2:      equ    %00000100
mPTCSE_PTCSE3:      equ    %00001000
mPTCSE_PTCSE4:      equ    %00010000
mPTCSE_PTCSE5:      equ    %00100000
mPTCSE_PTCSE6:      equ    %01000000
mPTCSE_PTCSE7:      equ    %10000000


;*** PTCDS - Port C Drive Strength Selection Register; 0x0000184A ***
PTCDS:              equ    $0000184A                                ;*** PTCDS - Port C Drive Strength Selection Register; 0x0000184A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCDS_PTCDS0:       equ    0                                         ; Output Drive Strength Selection for Port C Bit 0
PTCDS_PTCDS1:       equ    1                                         ; Output Drive Strength Selection for Port C Bit 1
PTCDS_PTCDS2:       equ    2                                         ; Output Drive Strength Selection for Port C Bit 2
PTCDS_PTCDS3:       equ    3                                         ; Output Drive Strength Selection for Port C Bit 3
PTCDS_PTCDS4:       equ    4                                         ; Output Drive Strength Selection for Port C Bit 4
PTCDS_PTCDS5:       equ    5                                         ; Output Drive Strength Selection for Port C Bit 5
PTCDS_PTCDS6:       equ    6                                         ; Output Drive Strength Selection for Port C Bit 6
PTCDS_PTCDS7:       equ    7                                         ; Output Drive Strength Selection for Port C Bit 7
; bit position masks
mPTCDS_PTCDS0:      equ    %00000001
mPTCDS_PTCDS1:      equ    %00000010
mPTCDS_PTCDS2:      equ    %00000100
mPTCDS_PTCDS3:      equ    %00001000
mPTCDS_PTCDS4:      equ    %00010000
mPTCDS_PTCDS5:      equ    %00100000
mPTCDS_PTCDS6:      equ    %01000000
mPTCDS_PTCDS7:      equ    %10000000


;*** PTDPE - Port D Pull Enable Register; 0x0000184C ***
PTDPE:              equ    $0000184C                                ;*** PTDPE - Port D Pull Enable Register; 0x0000184C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDPE_PTDPE0:       equ    0                                         ; Internal Pull Enable for Port D Bit 0
PTDPE_PTDPE1:       equ    1                                         ; Internal Pull Enable for Port D Bit 1
PTDPE_PTDPE2:       equ    2                                         ; Internal Pull Enable for Port D Bit 2
PTDPE_PTDPE3:       equ    3                                         ; Internal Pull Enable for Port D Bit 3
PTDPE_PTDPE4:       equ    4                                         ; Internal Pull Enable for Port D Bit 4
PTDPE_PTDPE5:       equ    5                                         ; Internal Pull Enable for Port D Bit 5
PTDPE_PTDPE6:       equ    6                                         ; Internal Pull Enable for Port D Bit 6
PTDPE_PTDPE7:       equ    7                                         ; Internal Pull Enable for Port D Bit 7
; bit position masks
mPTDPE_PTDPE0:      equ    %00000001
mPTDPE_PTDPE1:      equ    %00000010
mPTDPE_PTDPE2:      equ    %00000100
mPTDPE_PTDPE3:      equ    %00001000
mPTDPE_PTDPE4:      equ    %00010000
mPTDPE_PTDPE5:      equ    %00100000
mPTDPE_PTDPE6:      equ    %01000000
mPTDPE_PTDPE7:      equ    %10000000


;*** PTDSE - Port D Slew Rate Enable Register; 0x0000184D ***
PTDSE:              equ    $0000184D                                ;*** PTDSE - Port D Slew Rate Enable Register; 0x0000184D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDSE_PTDSE0:       equ    0                                         ; Output Slew Rate Enable for Port D Bit 0
PTDSE_PTDSE1:       equ    1                                         ; Output Slew Rate Enable for Port D Bit 1
PTDSE_PTDSE2:       equ    2                                         ; Output Slew Rate Enable for Port D Bit 2
PTDSE_PTDSE3:       equ    3                                         ; Output Slew Rate Enable for Port D Bit 3
PTDSE_PTDSE4:       equ    4                                         ; Output Slew Rate Enable for Port D Bit 4
PTDSE_PTDSE5:       equ    5                                         ; Output Slew Rate Enable for Port D Bit 5
PTDSE_PTDSE6:       equ    6                                         ; Output Slew Rate Enable for Port D Bit 6
PTDSE_PTDSE7:       equ    7                                         ; Output Slew Rate Enable for Port D Bit 7
; bit position masks
mPTDSE_PTDSE0:      equ    %00000001
mPTDSE_PTDSE1:      equ    %00000010
mPTDSE_PTDSE2:      equ    %00000100
mPTDSE_PTDSE3:      equ    %00001000
mPTDSE_PTDSE4:      equ    %00010000
mPTDSE_PTDSE5:      equ    %00100000
mPTDSE_PTDSE6:      equ    %01000000
mPTDSE_PTDSE7:      equ    %10000000


;*** PTDDS - Port D Drive Strength Selection Register; 0x0000184E ***
PTDDS:              equ    $0000184E                                ;*** PTDDS - Port D Drive Strength Selection Register; 0x0000184E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDDS_PTDDS0:       equ    0                                         ; Output Drive Strength Selection for Port D Bit 0
PTDDS_PTDDS1:       equ    1                                         ; Output Drive Strength Selection for Port D Bit 1
PTDDS_PTDDS2:       equ    2                                         ; Output Drive Strength Selection for Port D Bit 2
PTDDS_PTDDS3:       equ    3                                         ; Output Drive Strength Selection for Port D Bit 3
PTDDS_PTDDS4:       equ    4                                         ; Output Drive Strength Selection for Port D Bit 4
PTDDS_PTDDS5:       equ    5                                         ; Output Drive Strength Selection for Port D Bit 5
PTDDS_PTDDS6:       equ    6                                         ; Output Drive Strength Selection for Port D Bit 6
PTDDS_PTDDS7:       equ    7                                         ; Output Drive Strength Selection for Port D Bit 7
; bit position masks
mPTDDS_PTDDS0:      equ    %00000001
mPTDDS_PTDDS1:      equ    %00000010
mPTDDS_PTDDS2:      equ    %00000100
mPTDDS_PTDDS3:      equ    %00001000
mPTDDS_PTDDS4:      equ    %00010000
mPTDDS_PTDDS5:      equ    %00100000
mPTDDS_PTDDS6:      equ    %01000000
mPTDDS_PTDDS7:      equ    %10000000


;*** PTEPE - Port E Pull Enable Register; 0x00001850 ***
PTEPE:              equ    $00001850                                ;*** PTEPE - Port E Pull Enable Register; 0x00001850 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTEPE_PTEPE0:       equ    0                                         ; Internal Pull Enable for Port E Bit 0
PTEPE_PTEPE1:       equ    1                                         ; Internal Pull Enable for Port E Bit 1
PTEPE_PTEPE2:       equ    2                                         ; Internal Pull Enable for Port E Bit 2
PTEPE_PTEPE3:       equ    3                                         ; Internal Pull Enable for Port E Bit 3
PTEPE_PTEPE4:       equ    4                                         ; Internal Pull Enable for Port E Bit 4
PTEPE_PTEPE5:       equ    5                                         ; Internal Pull Enable for Port E Bit 5
PTEPE_PTEPE6:       equ    6                                         ; Internal Pull Enable for Port E Bit 6
PTEPE_PTEPE7:       equ    7                                         ; Internal Pull Enable for Port E Bit 7
; bit position masks
mPTEPE_PTEPE0:      equ    %00000001
mPTEPE_PTEPE1:      equ    %00000010
mPTEPE_PTEPE2:      equ    %00000100
mPTEPE_PTEPE3:      equ    %00001000
mPTEPE_PTEPE4:      equ    %00010000
mPTEPE_PTEPE5:      equ    %00100000
mPTEPE_PTEPE6:      equ    %01000000
mPTEPE_PTEPE7:      equ    %10000000


;*** PTESE - Port E Slew Rate Enable Register; 0x00001851 ***
PTESE:              equ    $00001851                                ;*** PTESE - Port E Slew Rate Enable Register; 0x00001851 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTESE_PTESE0:       equ    0                                         ; Output Slew Rate Enable for Port E Bit 0
PTESE_PTESE1:       equ    1                                         ; Output Slew Rate Enable for Port E Bit 1
PTESE_PTESE2:       equ    2                                         ; Output Slew Rate Enable for Port E Bit 2
PTESE_PTESE3:       equ    3                                         ; Output Slew Rate Enable for Port E Bit 3
PTESE_PTESE4:       equ    4                                         ; Output Slew Rate Enable for Port E Bit 4
PTESE_PTESE5:       equ    5                                         ; Output Slew Rate Enable for Port E Bit 5
PTESE_PTESE6:       equ    6                                         ; Output Slew Rate Enable for Port E Bit 6
PTESE_PTESE7:       equ    7                                         ; Output Slew Rate Enable for Port E Bit 7
; bit position masks
mPTESE_PTESE0:      equ    %00000001
mPTESE_PTESE1:      equ    %00000010
mPTESE_PTESE2:      equ    %00000100
mPTESE_PTESE3:      equ    %00001000
mPTESE_PTESE4:      equ    %00010000
mPTESE_PTESE5:      equ    %00100000
mPTESE_PTESE6:      equ    %01000000
mPTESE_PTESE7:      equ    %10000000


;*** PTEDS - Port E Drive Strength Selection Register; 0x00001852 ***
PTEDS:              equ    $00001852                                ;*** PTEDS - Port E Drive Strength Selection Register; 0x00001852 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTEDS_PTEDS0:       equ    0                                         ; Output Drive Strength Selection for Port E Bit 0
PTEDS_PTEDS1:       equ    1                                         ; Output Drive Strength Selection for Port E Bit 1
PTEDS_PTEDS2:       equ    2                                         ; Output Drive Strength Selection for Port E Bit 2
PTEDS_PTEDS3:       equ    3                                         ; Output Drive Strength Selection for Port E Bit 3
PTEDS_PTEDS4:       equ    4                                         ; Output Drive Strength Selection for Port E Bit 4
PTEDS_PTEDS5:       equ    5                                         ; Output Drive Strength Selection for Port E Bit 5
PTEDS_PTEDS6:       equ    6                                         ; Output Drive Strength Selection for Port E Bit 6
PTEDS_PTEDS7:       equ    7                                         ; Output Drive Strength Selection for Port E Bit 7
; bit position masks
mPTEDS_PTEDS0:      equ    %00000001
mPTEDS_PTEDS1:      equ    %00000010
mPTEDS_PTEDS2:      equ    %00000100
mPTEDS_PTEDS3:      equ    %00001000
mPTEDS_PTEDS4:      equ    %00010000
mPTEDS_PTEDS5:      equ    %00100000
mPTEDS_PTEDS6:      equ    %01000000
mPTEDS_PTEDS7:      equ    %10000000


;*** NVFTRIM - Nonvolatile ICS Fine Trim; 0x0000FFAE ***
NVFTRIM:            equ    $0000FFAE                                ;*** NVFTRIM - Nonvolatile ICS Fine Trim; 0x0000FFAE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVFTRIM_FTRIM:      equ    0                                         ; ICS Fine Trim
; bit position masks
mNVFTRIM_FTRIM:     equ    %00000001


;*** NVICSTRM - Nonvolatile ICS Trim Register; 0x0000FFAF ***
NVICSTRM:           equ    $0000FFAF                                ;*** NVICSTRM - Nonvolatile ICS Trim Register; 0x0000FFAF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVICSTRM_TRIM0:     equ    0                                         ; ICS Trim Setting, bit 0
NVICSTRM_TRIM1:     equ    1                                         ; ICS Trim Setting, bit 1
NVICSTRM_TRIM2:     equ    2                                         ; ICS Trim Setting, bit 2
NVICSTRM_TRIM3:     equ    3                                         ; ICS Trim Setting, bit 3
NVICSTRM_TRIM4:     equ    4                                         ; ICS Trim Setting, bit 4
NVICSTRM_TRIM5:     equ    5                                         ; ICS Trim Setting, bit 5
NVICSTRM_TRIM6:     equ    6                                         ; ICS Trim Setting, bit 6
NVICSTRM_TRIM7:     equ    7                                         ; ICS Trim Setting, bit 7
; bit position masks
mNVICSTRM_TRIM0:    equ    %00000001
mNVICSTRM_TRIM1:    equ    %00000010
mNVICSTRM_TRIM2:    equ    %00000100
mNVICSTRM_TRIM3:    equ    %00001000
mNVICSTRM_TRIM4:    equ    %00010000
mNVICSTRM_TRIM5:    equ    %00100000
mNVICSTRM_TRIM6:    equ    %01000000
mNVICSTRM_TRIM7:    equ    %10000000


;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
NVBACKKEY0:         equ    $0000FFB0                                ;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY0_KEY0:    equ    0                                         ; Backdoor Comparison Key 0 Bits, bit 0
NVBACKKEY0_KEY1:    equ    1                                         ; Backdoor Comparison Key 0 Bits, bit 1
NVBACKKEY0_KEY2:    equ    2                                         ; Backdoor Comparison Key 0 Bits, bit 2
NVBACKKEY0_KEY3:    equ    3                                         ; Backdoor Comparison Key 0 Bits, bit 3
NVBACKKEY0_KEY4:    equ    4                                         ; Backdoor Comparison Key 0 Bits, bit 4
NVBACKKEY0_KEY5:    equ    5                                         ; Backdoor Comparison Key 0 Bits, bit 5
NVBACKKEY0_KEY6:    equ    6                                         ; Backdoor Comparison Key 0 Bits, bit 6
NVBACKKEY0_KEY7:    equ    7                                         ; Backdoor Comparison Key 0 Bits, bit 7
; bit position masks
mNVBACKKEY0_KEY0:   equ    %00000001
mNVBACKKEY0_KEY1:   equ    %00000010
mNVBACKKEY0_KEY2:   equ    %00000100
mNVBACKKEY0_KEY3:   equ    %00001000
mNVBACKKEY0_KEY4:   equ    %00010000
mNVBACKKEY0_KEY5:   equ    %00100000
mNVBACKKEY0_KEY6:   equ    %01000000
mNVBACKKEY0_KEY7:   equ    %10000000


;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
NVBACKKEY1:         equ    $0000FFB1                                ;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY1_KEY0:    equ    0                                         ; Backdoor Comparison Key 1 Bits, bit 0
NVBACKKEY1_KEY1:    equ    1                                         ; Backdoor Comparison Key 1 Bits, bit 1
NVBACKKEY1_KEY2:    equ    2                                         ; Backdoor Comparison Key 1 Bits, bit 2
NVBACKKEY1_KEY3:    equ    3                                         ; Backdoor Comparison Key 1 Bits, bit 3
NVBACKKEY1_KEY4:    equ    4                                         ; Backdoor Comparison Key 1 Bits, bit 4
NVBACKKEY1_KEY5:    equ    5                                         ; Backdoor Comparison Key 1 Bits, bit 5
NVBACKKEY1_KEY6:    equ    6                                         ; Backdoor Comparison Key 1 Bits, bit 6
NVBACKKEY1_KEY7:    equ    7                                         ; Backdoor Comparison Key 1 Bits, bit 7
; bit position masks
mNVBACKKEY1_KEY0:   equ    %00000001
mNVBACKKEY1_KEY1:   equ    %00000010
mNVBACKKEY1_KEY2:   equ    %00000100
mNVBACKKEY1_KEY3:   equ    %00001000
mNVBACKKEY1_KEY4:   equ    %00010000
mNVBACKKEY1_KEY5:   equ    %00100000
mNVBACKKEY1_KEY6:   equ    %01000000
mNVBACKKEY1_KEY7:   equ    %10000000


;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
NVBACKKEY2:         equ    $0000FFB2                                ;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY2_KEY0:    equ    0                                         ; Backdoor Comparison Key 2 Bits, bit 0
NVBACKKEY2_KEY1:    equ    1                                         ; Backdoor Comparison Key 2 Bits, bit 1
NVBACKKEY2_KEY2:    equ    2                                         ; Backdoor Comparison Key 2 Bits, bit 2
NVBACKKEY2_KEY3:    equ    3                                         ; Backdoor Comparison Key 2 Bits, bit 3
NVBACKKEY2_KEY4:    equ    4                                         ; Backdoor Comparison Key 2 Bits, bit 4
NVBACKKEY2_KEY5:    equ    5                                         ; Backdoor Comparison Key 2 Bits, bit 5
NVBACKKEY2_KEY6:    equ    6                                         ; Backdoor Comparison Key 2 Bits, bit 6
NVBACKKEY2_KEY7:    equ    7                                         ; Backdoor Comparison Key 2 Bits, bit 7
; bit position masks
mNVBACKKEY2_KEY0:   equ    %00000001
mNVBACKKEY2_KEY1:   equ    %00000010
mNVBACKKEY2_KEY2:   equ    %00000100
mNVBACKKEY2_KEY3:   equ    %00001000
mNVBACKKEY2_KEY4:   equ    %00010000
mNVBACKKEY2_KEY5:   equ    %00100000
mNVBACKKEY2_KEY6:   equ    %01000000
mNVBACKKEY2_KEY7:   equ    %10000000


;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
NVBACKKEY3:         equ    $0000FFB3                                ;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY3_KEY0:    equ    0                                         ; Backdoor Comparison Key 3 Bits, bit 0
NVBACKKEY3_KEY1:    equ    1                                         ; Backdoor Comparison Key 3 Bits, bit 1
NVBACKKEY3_KEY2:    equ    2                                         ; Backdoor Comparison Key 3 Bits, bit 2
NVBACKKEY3_KEY3:    equ    3                                         ; Backdoor Comparison Key 3 Bits, bit 3
NVBACKKEY3_KEY4:    equ    4                                         ; Backdoor Comparison Key 3 Bits, bit 4
NVBACKKEY3_KEY5:    equ    5                                         ; Backdoor Comparison Key 3 Bits, bit 5
NVBACKKEY3_KEY6:    equ    6                                         ; Backdoor Comparison Key 3 Bits, bit 6
NVBACKKEY3_KEY7:    equ    7                                         ; Backdoor Comparison Key 3 Bits, bit 7
; bit position masks
mNVBACKKEY3_KEY0:   equ    %00000001
mNVBACKKEY3_KEY1:   equ    %00000010
mNVBACKKEY3_KEY2:   equ    %00000100
mNVBACKKEY3_KEY3:   equ    %00001000
mNVBACKKEY3_KEY4:   equ    %00010000
mNVBACKKEY3_KEY5:   equ    %00100000
mNVBACKKEY3_KEY6:   equ    %01000000
mNVBACKKEY3_KEY7:   equ    %10000000


;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
NVBACKKEY4:         equ    $0000FFB4                                ;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY4_KEY0:    equ    0                                         ; Backdoor Comparison Key 4 Bits, bit 0
NVBACKKEY4_KEY1:    equ    1                                         ; Backdoor Comparison Key 4 Bits, bit 1
NVBACKKEY4_KEY2:    equ    2                                         ; Backdoor Comparison Key 4 Bits, bit 2
NVBACKKEY4_KEY3:    equ    3                                         ; Backdoor Comparison Key 4 Bits, bit 3
NVBACKKEY4_KEY4:    equ    4                                         ; Backdoor Comparison Key 4 Bits, bit 4
NVBACKKEY4_KEY5:    equ    5                                         ; Backdoor Comparison Key 4 Bits, bit 5
NVBACKKEY4_KEY6:    equ    6                                         ; Backdoor Comparison Key 4 Bits, bit 6
NVBACKKEY4_KEY7:    equ    7                                         ; Backdoor Comparison Key 4 Bits, bit 7
; bit position masks
mNVBACKKEY4_KEY0:   equ    %00000001
mNVBACKKEY4_KEY1:   equ    %00000010
mNVBACKKEY4_KEY2:   equ    %00000100
mNVBACKKEY4_KEY3:   equ    %00001000
mNVBACKKEY4_KEY4:   equ    %00010000
mNVBACKKEY4_KEY5:   equ    %00100000
mNVBACKKEY4_KEY6:   equ    %01000000
mNVBACKKEY4_KEY7:   equ    %10000000


;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
NVBACKKEY5:         equ    $0000FFB5                                ;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY5_KEY0:    equ    0                                         ; Backdoor Comparison Key 5 Bits, bit 0
NVBACKKEY5_KEY1:    equ    1                                         ; Backdoor Comparison Key 5 Bits, bit 1
NVBACKKEY5_KEY2:    equ    2                                         ; Backdoor Comparison Key 5 Bits, bit 2
NVBACKKEY5_KEY3:    equ    3                                         ; Backdoor Comparison Key 5 Bits, bit 3
NVBACKKEY5_KEY4:    equ    4                                         ; Backdoor Comparison Key 5 Bits, bit 4
NVBACKKEY5_KEY5:    equ    5                                         ; Backdoor Comparison Key 5 Bits, bit 5
NVBACKKEY5_KEY6:    equ    6                                         ; Backdoor Comparison Key 5 Bits, bit 6
NVBACKKEY5_KEY7:    equ    7                                         ; Backdoor Comparison Key 5 Bits, bit 7
; bit position masks
mNVBACKKEY5_KEY0:   equ    %00000001
mNVBACKKEY5_KEY1:   equ    %00000010
mNVBACKKEY5_KEY2:   equ    %00000100
mNVBACKKEY5_KEY3:   equ    %00001000
mNVBACKKEY5_KEY4:   equ    %00010000
mNVBACKKEY5_KEY5:   equ    %00100000
mNVBACKKEY5_KEY6:   equ    %01000000
mNVBACKKEY5_KEY7:   equ    %10000000


;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
NVBACKKEY6:         equ    $0000FFB6                                ;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY6_KEY0:    equ    0                                         ; Backdoor Comparison Key 6 Bits, bit 0
NVBACKKEY6_KEY1:    equ    1                                         ; Backdoor Comparison Key 6 Bits, bit 1
NVBACKKEY6_KEY2:    equ    2                                         ; Backdoor Comparison Key 6 Bits, bit 2
NVBACKKEY6_KEY3:    equ    3                                         ; Backdoor Comparison Key 6 Bits, bit 3
NVBACKKEY6_KEY4:    equ    4                                         ; Backdoor Comparison Key 6 Bits, bit 4
NVBACKKEY6_KEY5:    equ    5                                         ; Backdoor Comparison Key 6 Bits, bit 5
NVBACKKEY6_KEY6:    equ    6                                         ; Backdoor Comparison Key 6 Bits, bit 6
NVBACKKEY6_KEY7:    equ    7                                         ; Backdoor Comparison Key 6 Bits, bit 7
; bit position masks
mNVBACKKEY6_KEY0:   equ    %00000001
mNVBACKKEY6_KEY1:   equ    %00000010
mNVBACKKEY6_KEY2:   equ    %00000100
mNVBACKKEY6_KEY3:   equ    %00001000
mNVBACKKEY6_KEY4:   equ    %00010000
mNVBACKKEY6_KEY5:   equ    %00100000
mNVBACKKEY6_KEY6:   equ    %01000000
mNVBACKKEY6_KEY7:   equ    %10000000


;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
NVBACKKEY7:         equ    $0000FFB7                                ;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY7_KEY0:    equ    0                                         ; Backdoor Comparison Key 7 Bits, bit 0
NVBACKKEY7_KEY1:    equ    1                                         ; Backdoor Comparison Key 7 Bits, bit 1
NVBACKKEY7_KEY2:    equ    2                                         ; Backdoor Comparison Key 7 Bits, bit 2
NVBACKKEY7_KEY3:    equ    3                                         ; Backdoor Comparison Key 7 Bits, bit 3
NVBACKKEY7_KEY4:    equ    4                                         ; Backdoor Comparison Key 7 Bits, bit 4
NVBACKKEY7_KEY5:    equ    5                                         ; Backdoor Comparison Key 7 Bits, bit 5
NVBACKKEY7_KEY6:    equ    6                                         ; Backdoor Comparison Key 7 Bits, bit 6
NVBACKKEY7_KEY7:    equ    7                                         ; Backdoor Comparison Key 7 Bits, bit 7
; bit position masks
mNVBACKKEY7_KEY0:   equ    %00000001
mNVBACKKEY7_KEY1:   equ    %00000010
mNVBACKKEY7_KEY2:   equ    %00000100
mNVBACKKEY7_KEY3:   equ    %00001000
mNVBACKKEY7_KEY4:   equ    %00010000
mNVBACKKEY7_KEY5:   equ    %00100000
mNVBACKKEY7_KEY6:   equ    %01000000
mNVBACKKEY7_KEY7:   equ    %10000000


;*** NVPROT - Nonvolatile FLASH Protection Register; 0x0000FFBD ***
NVPROT:             equ    $0000FFBD                                ;*** NVPROT - Nonvolatile FLASH Protection Register; 0x0000FFBD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVPROT_FPDIS:       equ    0                                         ; FLASH Protection Disable
NVPROT_FPS1:        equ    1                                         ; FLASH Protect Select Bit 1
NVPROT_FPS2:        equ    2                                         ; FLASH Protect Select Bit 2
NVPROT_FPS3:        equ    3                                         ; FLASH Protect Select Bit 3
NVPROT_FPS4:        equ    4                                         ; FLASH Protect Select Bit 4
NVPROT_FPS5:        equ    5                                         ; FLASH Protect Select Bit 5
NVPROT_FPS6:        equ    6                                         ; FLASH Protect Select Bit 6
NVPROT_FPS7:        equ    7                                         ; FLASH Protect Select Bit 7
; bit position masks
mNVPROT_FPDIS:      equ    %00000001
mNVPROT_FPS1:       equ    %00000010
mNVPROT_FPS2:       equ    %00000100
mNVPROT_FPS3:       equ    %00001000
mNVPROT_FPS4:       equ    %00010000
mNVPROT_FPS5:       equ    %00100000
mNVPROT_FPS6:       equ    %01000000
mNVPROT_FPS7:       equ    %10000000


;*** NVOPT - Nonvolatile Flash Options Register; 0x0000FFBF ***
NVOPT:              equ    $0000FFBF                                ;*** NVOPT - Nonvolatile Flash Options Register; 0x0000FFBF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVOPT_SEC00:        equ    0                                         ; Security State Code, bit 0
NVOPT_SEC01:        equ    1                                         ; Security State Code, bit 1
NVOPT_FNORED:       equ    6                                         ; Vector Redirection Disable
NVOPT_KEYEN:        equ    7                                         ; Backdoor Key Mechanism Enable
; bit position masks
mNVOPT_SEC00:       equ    %00000001
mNVOPT_SEC01:       equ    %00000010
mNVOPT_FNORED:      equ    %01000000
mNVOPT_KEYEN:       equ    %10000000



; Flash commands
mBlank:             equ     $05
mBurstProg:         equ     $25
mByteProg:          equ     $20
mMassErase:         equ     $41
mPageErase:         equ     $40


;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF

; EOF
