/******************************************************************************
*                                             COPYRIGHT (c) MOTOROLA 2003   
* FILE NAME: tim.c     REVISION 1.0                                        
*                                                                           
* PURPOSE: TIM Source File
*                                                                           
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION: TIM Source File             
*                                                                           
* NOTE: 
*                                                                           
* AUTHOR: Eduardo Montanez    LOCATION: OHT     LAST EDIT DATE: 11/19/03  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe    	11/19/03	- Original coding 
*                                                                           
******************************************************************************/

#include "tim.h"

/* Local function prototypes */

void tim_init (void);
void tim_ch1_vector (void);
void tim_ch2_vector (void);
void tim_ch3_vector (void);

//***********************************************************************************
//
// Keyboard Wakeup Unit Initialization routine 
//
//***********************************************************************************

void tim_init (void)
{
	TIOS = 0x00;		// Tim[7:0] are set for input capture
								  // Tim[3:1] are used for switch detect
	TCTL3 = 0x00;	  // Input capture disabled for Tim[7:4]
	TCTL4 = 0xA8;	  // Input capture on falling edges of Tim[3:1]
	TIE = 0x0E;		  // Enable Tim[3:1] interrupts
	TSCR1 = 0x80;	  // Enable Timer module
}

//***********************************************************************************
//
// Timer Module Interrupt Service Routine for Ch. 1
//
//***********************************************************************************

interrupt 9 void tim_ch1_vector(void)
{
  switch_decoder ();    //execute switch decoder
}	

//***********************************************************************************
//
// Timer Module Interrupt Service Routine for Ch. 2
//
//***********************************************************************************

interrupt 10 void tim_ch2_vector(void)
{
  switch_decoder ();    //execute switch decoder
}	

//***********************************************************************************
//
// Timer Module Interrupt Service Routine for Ch. 3
//
//***********************************************************************************

interrupt 11 void tim_ch3_vector(void)
{
  switch_decoder ();    //execute switch decoder
}	
